/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NthValue;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.aggregate.First;
import org.apache.spark.sql.catalyst.optimizer.OptimizeWindowFunctionsSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0005\t4Aa\u0004\t\u0001;!)\u0001\u0006\u0001C\u0001S\u001d)A\u0006\u0001E\u0001[\u0019)q\u0006\u0001E\u0001a!)\u0001f\u0001C\u0001{!9ah\u0001b\u0001\n\u0003y\u0004B\u0002(\u0004A\u0003%\u0001\tC\u0004P\u0001\t\u0007I\u0011\u0001)\t\rQ\u0003\u0001\u0015!\u0003R\u0011\u001d)\u0006A1A\u0005\u0002YCa!\u0018\u0001!\u0002\u00139\u0006b\u00020\u0001\u0005\u0004%\tA\u0016\u0005\u0007?\u0002\u0001\u000b\u0011B,\t\u000f\u0001\u0004!\u0019!C\u0001-\"1\u0011\r\u0001Q\u0001\n]\u0013Ad\u00149uS6L'0Z,j]\u0012|wOR;oGRLwN\\:Tk&$XM\u0003\u0002\u0012%\u0005Iq\u000e\u001d;j[&TXM\u001d\u0006\u0003'Q\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003+Y\t1a]9m\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0004\u0001y\u0011\u0003CA\u0010!\u001b\u00051\u0012BA\u0011\u0017\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111EJ\u0007\u0002I)\u0011QEE\u0001\u0006a2\fgn]\u0005\u0003O\u0011\u0012\u0001\u0002\u00157b]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"a\u000b\u0001\u000e\u0003A\t\u0001b\u00149uS6L'0\u001a\t\u0003]\ri\u0011\u0001\u0001\u0002\t\u001fB$\u0018.\\5{KN\u00111!\r\t\u0004eU:T\"A\u001a\u000b\u0005Q\u0012\u0012!\u0002:vY\u0016\u001c\u0018B\u0001\u001c4\u00051\u0011V\u000f\\3Fq\u0016\u001cW\u000f^8s!\tA4(D\u0001:\u0015\tQD%A\u0004m_\u001eL7-\u00197\n\u0005qJ$a\u0003'pO&\u001c\u0017\r\u001c)mC:$\u0012!L\u0001\bE\u0006$8\r[3t+\u0005\u0001\u0005cA!I\u00156\t!I\u0003\u0002D\t\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u000b\u001a\u000b!bY8mY\u0016\u001cG/[8o\u0015\u00059\u0015!B:dC2\f\u0017BA%C\u0005\u0011a\u0015n\u001d;\u0011\u0005-cU\"A\u0002\n\u00055+$!\u0002\"bi\u000eD\u0017\u0001\u00032bi\u000eDWm\u001d\u0011\u0002\u0019Q,7\u000f\u001e*fY\u0006$\u0018n\u001c8\u0016\u0003E\u0003\"\u0001\u000f*\n\u0005MK$!\u0004'pG\u0006d'+\u001a7bi&|g.A\u0007uKN$(+\u001a7bi&|g\u000eI\u0001\u0002CV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[%\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\ta\u0016LA\u0005BiR\u0014\u0018NY;uK\u0006\u0011\u0011\rI\u0001\u0002E\u0006\u0011!\rI\u0001\u0002G\u0006\u00111\r\t")
public class OptimizeWindowFunctionsSuite
extends SparkFunSuite
implements PlanTest {
    private volatile OptimizeWindowFunctionsSuite$Optimize$ Optimize$module;
    private final LocalRelation testRelation;
    private final Attribute a;
    private final Attribute b;
    private final Attribute c;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public OptimizeWindowFunctionsSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    private String sparkHome$lzycompute() {
        OptimizeWindowFunctionsSuite optimizeWindowFunctionsSuite = this;
        synchronized (optimizeWindowFunctionsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    public Attribute a() {
        return this.a;
    }

    public Attribute b() {
        return this.b;
    }

    public Attribute c() {
        return this.c;
    }

    private final void Optimize$lzycompute$1() {
        OptimizeWindowFunctionsSuite optimizeWindowFunctionsSuite = this;
        synchronized (optimizeWindowFunctionsSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new OptimizeWindowFunctionsSuite$Optimize$(this);
            }
        }
    }

    public OptimizeWindowFunctionsSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).double(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).double(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).string()}));
        this.a = (Attribute)this.testRelation().output().apply(0);
        this.b = (Attribute)this.testRelation().output().apply(1);
        this.c = (Attribute)this.testRelation().output().apply(2);
        this.test("replace first by nth_value if frame is UNBOUNDED PRECEDING AND CURRENT ROW", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan optimized;
            Expression[] expressionArray = new Expression[1];
            Attribute attribute = this.b();
            SortOrder sortOrder = package.expressions$.MODULE$.DslExpression((Expression)this.c()).asc();
            expressionArray[0] = new WindowExpression((Expression)new First((Expression)this.a(), false).toAggregateExpression(), new WindowSpecDefinition((Seq)package$.MODULE$.Nil().$colon$colon((Object)attribute), (Seq)package$.MODULE$.Nil().$colon$colon((Object)sortOrder), (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, (Expression)UnboundedPreceding$.MODULE$, (Expression)CurrentRow$.MODULE$)));
            LogicalPlan inputPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])expressionArray));
            Expression[] expressionArray2 = new Expression[1];
            Attribute attribute2 = this.b();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslExpression((Expression)this.c()).asc();
            expressionArray2[0] = new WindowExpression((Expression)new NthValue((Expression)this.a(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), false), new WindowSpecDefinition((Seq)package$.MODULE$.Nil().$colon$colon((Object)attribute2), (Seq)package$.MODULE$.Nil().$colon$colon((Object)sortOrder2), (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, (Expression)UnboundedPreceding$.MODULE$, (Expression)CurrentRow$.MODULE$)));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])expressionArray2));
            LogicalPlan $org_scalatest_assert_macro_left = optimized = (LogicalPlan)this.Optimize().execute((TreeNode)inputPlan);
            LogicalPlan $org_scalatest_assert_macro_right = correctAnswer;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OptimizeWindowFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        }, new Position("OptimizeWindowFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("replace first by nth_value if frame is UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan optimized;
            Expression[] expressionArray = new Expression[1];
            Attribute attribute = this.b();
            SortOrder sortOrder = package.expressions$.MODULE$.DslExpression((Expression)this.c()).asc();
            expressionArray[0] = new WindowExpression((Expression)new First((Expression)this.a(), false).toAggregateExpression(), new WindowSpecDefinition((Seq)package$.MODULE$.Nil().$colon$colon((Object)attribute), (Seq)package$.MODULE$.Nil().$colon$colon((Object)sortOrder), (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, (Expression)UnboundedPreceding$.MODULE$, (Expression)UnboundedFollowing$.MODULE$)));
            LogicalPlan inputPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])expressionArray));
            Expression[] expressionArray2 = new Expression[1];
            Attribute attribute2 = this.b();
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslExpression((Expression)this.c()).asc();
            expressionArray2[0] = new WindowExpression((Expression)new NthValue((Expression)this.a(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), false), new WindowSpecDefinition((Seq)package$.MODULE$.Nil().$colon$colon((Object)attribute2), (Seq)package$.MODULE$.Nil().$colon$colon((Object)sortOrder2), (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, (Expression)UnboundedPreceding$.MODULE$, (Expression)UnboundedFollowing$.MODULE$)));
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])expressionArray2));
            LogicalPlan $org_scalatest_assert_macro_left = optimized = (LogicalPlan)this.Optimize().execute((TreeNode)inputPlan);
            LogicalPlan $org_scalatest_assert_macro_right = correctAnswer;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OptimizeWindowFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("OptimizeWindowFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("can't replace first by nth_value if frame is not suitable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan optimized;
            Expression[] expressionArray = new Expression[1];
            Attribute attribute = this.b();
            SortOrder sortOrder = package.expressions$.MODULE$.DslExpression((Expression)this.c()).asc();
            expressionArray[0] = new WindowExpression((Expression)new First((Expression)this.a(), false).toAggregateExpression(), new WindowSpecDefinition((Seq)package$.MODULE$.Nil().$colon$colon((Object)attribute), (Seq)package$.MODULE$.Nil().$colon$colon((Object)sortOrder), (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)CurrentRow$.MODULE$)));
            LogicalPlan inputPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])expressionArray));
            LogicalPlan $org_scalatest_assert_macro_left = optimized = (LogicalPlan)this.Optimize().execute((TreeNode)inputPlan);
            LogicalPlan $org_scalatest_assert_macro_right = inputPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OptimizeWindowFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        }, new Position("OptimizeWindowFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("can't replace first by nth_value if the window frame type is range", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan optimized;
            Expression[] expressionArray = new Expression[1];
            Attribute attribute = this.b();
            SortOrder sortOrder = package.expressions$.MODULE$.DslExpression((Expression)this.c()).asc();
            expressionArray[0] = new WindowExpression((Expression)new First((Expression)this.a(), false).toAggregateExpression(), new WindowSpecDefinition((Seq)package$.MODULE$.Nil().$colon$colon((Object)attribute), (Seq)package$.MODULE$.Nil().$colon$colon((Object)sortOrder), (WindowFrame)new SpecifiedWindowFrame((FrameType)RangeFrame$.MODULE$, (Expression)UnboundedPreceding$.MODULE$, (Expression)CurrentRow$.MODULE$)));
            LogicalPlan inputPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])expressionArray));
            LogicalPlan $org_scalatest_assert_macro_left = optimized = (LogicalPlan)this.Optimize().execute((TreeNode)inputPlan);
            LogicalPlan $org_scalatest_assert_macro_right = inputPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OptimizeWindowFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("OptimizeWindowFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("can't replace first by nth_value if the window frame isn't ordered", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan optimized;
            Expression[] expressionArray = new Expression[1];
            Attribute attribute = this.b();
            expressionArray[0] = new WindowExpression((Expression)new First((Expression)this.a(), false).toAggregateExpression(), new WindowSpecDefinition((Seq)package$.MODULE$.Nil().$colon$colon((Object)attribute), (Seq)package$.MODULE$.Nil(), (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, (Expression)UnboundedPreceding$.MODULE$, (Expression)CurrentRow$.MODULE$)));
            LogicalPlan inputPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])expressionArray));
            LogicalPlan $org_scalatest_assert_macro_left = optimized = (LogicalPlan)this.Optimize().execute((TreeNode)inputPlan);
            LogicalPlan $org_scalatest_assert_macro_right = inputPlan;
            LogicalPlan logicalPlan = $org_scalatest_assert_macro_left;
            LogicalPlan logicalPlan2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OptimizeWindowFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }, new Position("OptimizeWindowFunctionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }
}

