/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.NumberConverter$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.MatchError;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005%3A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!11\u0004\u0001Q\u0005\nqAQ!\u000f\u0001\u0005\u0002i\u0012ACT;nE\u0016\u00148i\u001c8wKJ$XM]*vSR,'B\u0001\u0004\b\u0003\u0011)H/\u001b7\u000b\u0005!I\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005)Y\u0011aA:rY*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005Y\u0011B\u0001\f\f\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011!B\u0001\nG\",7m[\"p]Z$R!H\u00121k]\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011A!\u00168ji\")AE\u0001a\u0001K\u0005\ta\u000e\u0005\u0002'[9\u0011qe\u000b\t\u0003Q}i\u0011!\u000b\u0006\u0003UE\ta\u0001\u0010:p_Rt\u0014B\u0001\u0017 \u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051z\u0002\"B\u0019\u0003\u0001\u0004\u0011\u0014\u0001\u00034s_6\u0014\u0015m]3\u0011\u0005y\u0019\u0014B\u0001\u001b \u0005\rIe\u000e\u001e\u0005\u0006m\t\u0001\rAM\u0001\u0007i>\u0014\u0015m]3\t\u000ba\u0012\u0001\u0019A\u0013\u0002\u0011\u0015D\b/Z2uK\u0012\fQb\u00195fG.$vNQ5oCJLXCA\u001eA)\tiB\bC\u0003>\u0007\u0001\u0007a(\u0001\u0002j]B\u0011q\b\u0011\u0007\u0001\t\u0015\t5A1\u0001C\u0005\u0005!\u0016CA\"G!\tqB)\u0003\u0002F?\t9aj\u001c;iS:<\u0007C\u0001\u0010H\u0013\tAuDA\u0002B]f\u0004")
public class NumberConverterSuite
extends SparkFunSuite {
    private void checkConv(String n, int fromBase, int toBase, String expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.convert(UTF8String.fromString((String)n).getBytes(), fromBase, toBase));
        UTF8String $org_scalatest_assert_macro_right = UTF8String.fromString((String)expected);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
    }

    public <T> void checkToBinary(T in) {
        T t = in;
        if (t instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.toBinary(by));
            byte[] $org_scalatest_assert_macro_right = ByteBuffer.allocate(1).order(ByteOrder.BIG_ENDIAN).put(by).array();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (t instanceof Short) {
            short s = BoxesRunTime.unboxToShort(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.toBinary(s));
            byte[] $org_scalatest_assert_macro_right = ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort(s).array();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (t instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.toBinary(n));
            byte[] $org_scalatest_assert_macro_right = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(n).array();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (t instanceof Long) {
            long l = BoxesRunTime.unboxToLong(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.toBinary(l));
            byte[] $org_scalatest_assert_macro_right = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(l).array();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(t);
        }
    }

    public NumberConverterSuite() {
        this.test("convert", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkConv("3", 10, 2, "11");
            this.checkConv("-15", 10, -16, "-F");
            this.checkConv("-15", 10, 16, "FFFFFFFFFFFFFFF1");
            this.checkConv("big", 36, 16, "3A48");
            this.checkConv("9223372036854775807", 36, 16, "FFFFFFFFFFFFFFFF");
            this.checkConv("11abc", 10, 16, "B");
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("SPARK-34909: convert negative to unsigned", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkConv("-10", 11, 7, "45012021522523134134555"), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("byte to binary", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkToBinary(BoxesRunTime.boxToByte((byte)((byte)0)));
            this.checkToBinary(BoxesRunTime.boxToByte((byte)((byte)1)));
            this.checkToBinary(BoxesRunTime.boxToByte((byte)((byte)-1)));
            this.checkToBinary(BoxesRunTime.boxToByte((byte)127));
            this.checkToBinary(BoxesRunTime.boxToByte((byte)-128));
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("short to binary", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkToBinary(BoxesRunTime.boxToShort((short)((short)0)));
            this.checkToBinary(BoxesRunTime.boxToShort((short)((short)1)));
            this.checkToBinary(BoxesRunTime.boxToShort((short)((short)-1)));
            this.checkToBinary(BoxesRunTime.boxToShort((short)Short.MAX_VALUE));
            this.checkToBinary(BoxesRunTime.boxToShort((short)Short.MIN_VALUE));
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("integer to binary", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkToBinary(BoxesRunTime.boxToInteger((int)0));
            this.checkToBinary(BoxesRunTime.boxToInteger((int)1));
            this.checkToBinary(BoxesRunTime.boxToInteger((int)-1));
            this.checkToBinary(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
            this.checkToBinary(BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE));
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("long to binary", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkToBinary(BoxesRunTime.boxToLong((long)0L));
            this.checkToBinary(BoxesRunTime.boxToLong((long)1L));
            this.checkToBinary(BoxesRunTime.boxToLong((long)-1L));
            this.checkToBinary(BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
            this.checkToBinary(BoxesRunTime.boxToLong((long)Long.MIN_VALUE));
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
    }
}

