/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.SQLOrderingUtil$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Double$;
import scala.Float$;
import scala.Function0;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\t!2+\u0015'Pe\u0012,'/\u001b8h+RLGnU;ji\u0016T!\u0001B\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\r\u001d\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0011%\t1a]9m\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0003\u0001E\u0001\"AE\n\u000e\u0003%I!\u0001F\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t1\u0001")
public class SQLOrderingUtilSuite
extends SparkFunSuite {
    private final void shouldMatchDefaultOrder$1(double a, double b) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareDoubles(a, b)));
        int $org_scalatest_assert_macro_right = Double.compare(a, b);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareDoubles(b, a)));
        int $org_scalatest_assert_macro_right2 = Double.compare(b, a);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
    }

    private final void shouldMatchDefaultOrder$2(float a, float b) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareFloats(a, b)));
        int $org_scalatest_assert_macro_right = Float.compare(a, b);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareFloats(b, a)));
        int $org_scalatest_assert_macro_right2 = Float.compare(b, a);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
    }

    public SQLOrderingUtilSuite() {
        this.test("compareDoublesSQL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.shouldMatchDefaultOrder$1(0.0, 0.0);
            this.shouldMatchDefaultOrder$1(0.0, 1.0);
            this.shouldMatchDefaultOrder$1(-1.0, 1.0);
            this.shouldMatchDefaultOrder$1(Double$.MODULE$.MinValue(), Double.MAX_VALUE);
            double specialNaN = Double.longBitsToDouble(9219188691769251448L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Double.isNaN(specialNaN), "java.lang.Double.isNaN(specialNaN)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            long $org_scalatest_assert_macro_left = Double.doubleToRawLongBits(Double.NaN);
            long $org_scalatest_assert_macro_right = Double.doubleToRawLongBits(specialNaN);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareDoubles(Double.NaN, Double.NaN)));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareDoubles(Double.NaN, specialNaN)));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            int $org_scalatest_assert_macro_left4 = SQLOrderingUtil$.MODULE$.compareDoubles(Double.NaN, Double.POSITIVE_INFINITY);
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            int $org_scalatest_assert_macro_left5 = SQLOrderingUtil$.MODULE$.compareDoubles(specialNaN, Double.POSITIVE_INFINITY);
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 > $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            int $org_scalatest_assert_macro_left6 = SQLOrderingUtil$.MODULE$.compareDoubles(Double.NaN, Double.NEGATIVE_INFINITY);
            int $org_scalatest_assert_macro_right6 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            int $org_scalatest_assert_macro_left7 = SQLOrderingUtil$.MODULE$.compareDoubles(Double.POSITIVE_INFINITY, Double.NaN);
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 < $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            int $org_scalatest_assert_macro_left8 = SQLOrderingUtil$.MODULE$.compareDoubles(Double.NEGATIVE_INFINITY, Double.NaN);
            int $org_scalatest_assert_macro_right8 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 < $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareDoubles(0.0, -0.0)));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareDoubles(-0.0, 0.0)));
            int $org_scalatest_assert_macro_right10 = 0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        }, new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("compareFloatsSQL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.shouldMatchDefaultOrder$2(0.0f, 0.0f);
            this.shouldMatchDefaultOrder$2(0.0f, 1.0f);
            this.shouldMatchDefaultOrder$2(-1.0f, 1.0f);
            this.shouldMatchDefaultOrder$2(Float$.MODULE$.MinValue(), Float.MAX_VALUE);
            float specialNaN = Float.intBitsToFloat(-6966608);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Float.isNaN(specialNaN), "java.lang.Float.isNaN(specialNaN)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            int $org_scalatest_assert_macro_left = Float.floatToRawIntBits(Float.NaN);
            int $org_scalatest_assert_macro_right = Float.floatToRawIntBits(specialNaN);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareDoubles(Double.NaN, Double.NaN)));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareDoubles(Double.NaN, (double)specialNaN)));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            int $org_scalatest_assert_macro_left4 = SQLOrderingUtil$.MODULE$.compareDoubles(Double.NaN, Double.POSITIVE_INFINITY);
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            int $org_scalatest_assert_macro_left5 = SQLOrderingUtil$.MODULE$.compareDoubles((double)specialNaN, Double.POSITIVE_INFINITY);
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 > $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            int $org_scalatest_assert_macro_left6 = SQLOrderingUtil$.MODULE$.compareDoubles(Double.NaN, Double.NEGATIVE_INFINITY);
            int $org_scalatest_assert_macro_right6 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            int $org_scalatest_assert_macro_left7 = SQLOrderingUtil$.MODULE$.compareDoubles(Double.POSITIVE_INFINITY, Double.NaN);
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 < $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            int $org_scalatest_assert_macro_left8 = SQLOrderingUtil$.MODULE$.compareDoubles(Double.NEGATIVE_INFINITY, Double.NaN);
            int $org_scalatest_assert_macro_right8 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 < $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareDoubles(0.0, -0.0)));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)SQLOrderingUtil$.MODULE$.compareDoubles(-0.0, 0.0)));
            int $org_scalatest_assert_macro_right10 = 0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("SQLOrderingUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }
}

