/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryTable;
import org.apache.spark.sql.connector.catalog.InMemoryTable$;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\r\u001b\u0001\u001dBQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001C\u0002\u0013E\u0001\b\u0003\u0004X\u0001\u0001\u0006I!\u000f\u0005\b1\u0002\u0011\r\u0011\"\u0005Z\u0011\u0019\t\u0007\u0001)A\u00055\"9!\r\u0001b\u0001\n\u0013\u0019\u0007BB4\u0001A\u0003%A\rC\u0004i\u0001\u0001\u0007I\u0011B5\t\u000f9\u0004\u0001\u0019!C\u0005_\"1Q\u000f\u0001Q!\n)DQA\u001e\u0001\u0005B]Da!\u001f\u0001\u0005B\u0005\r\u0001bBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\t)\u0002\u0001C!\u0003;Aq!!\u0006\u0001\t\u0003\n)\u0003C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!9\u0011\u0011\b\u0001\u0005\u0002\u0005\u001d\u0004bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003_\u0003A\u0011IAY\u0011\u001d\tY\f\u0001C!\u0003{Cq!a2\u0001\t\u0003\tI\rC\u0004\u0002N\u0002!\t!a4\u00033\t\u000b7/[2J]6+Wn\u001c:z)\u0006\u0014G.Z\"bi\u0006dwn\u001a\u0006\u00037q\tqaY1uC2|wM\u0003\u0002\u001e=\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003?\u0001\n1a]9m\u0015\t\t#%A\u0003ta\u0006\u00148N\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0004\u0001!\u0002\u0004CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0011a\u0017M\\4\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E\u0012T\"\u0001\u000e\n\u0005MR\"\u0001\u0004+bE2,7)\u0019;bY><\u0017A\u0002\u001fj]&$h\bF\u00017!\t\t\u0004!\u0001\u0006oC6,7\u000f]1dKN,\u0012!\u000f\t\u0005uuzT+D\u0001<\u0015\taD&\u0001\u0003vi&d\u0017B\u0001 <\u0005\ri\u0015\r\u001d\t\u0004\u0001*keBA!H\u001d\t\u0011U)D\u0001D\u0015\t!e%\u0001\u0004=e>|GOP\u0005\u0002\r\u0006)1oY1mC&\u0011\u0001*S\u0001\ba\u0006\u001c7.Y4f\u0015\u00051\u0015BA&M\u0005\u0011a\u0015n\u001d;\u000b\u0005!K\u0005C\u0001(S\u001d\ty\u0005\u000b\u0005\u0002C\u0013&\u0011\u0011+S\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002R\u0013B!aJV'N\u0013\tqD+A\u0006oC6,7\u000f]1dKN\u0004\u0013A\u0002;bE2,7/F\u0001[!\u0011QTh\u00170\u0011\u0005Eb\u0016BA/\u001b\u0005)IE-\u001a8uS\u001aLWM\u001d\t\u0003c}K!\u0001\u0019\u000e\u0003\u000bQ\u000b'\r\\3\u0002\u000fQ\f'\r\\3tA\u0005\t\u0012N\u001c<bY&$\u0017\r^3e)\u0006\u0014G.Z:\u0016\u0003\u0011\u00042AO3\\\u0013\t17HA\u0002TKR\f!#\u001b8wC2LG-\u0019;fIR\u000b'\r\\3tA\u0005)qL\\1nKV\t!\u000eE\u0002lY6k\u0011!S\u0005\u0003[&\u0013aa\u00149uS>t\u0017!C0oC6,w\fJ3r)\t\u00018\u000f\u0005\u0002lc&\u0011!/\u0013\u0002\u0005+:LG\u000fC\u0004u\u0013\u0005\u0005\t\u0019\u00016\u0002\u0007a$\u0013'\u0001\u0004`]\u0006lW\rI\u0001\u000bS:LG/[1mSj,Gc\u00019yu\")\u0011p\u0003a\u0001\u001b\u0006!a.Y7f\u0011\u0015Y8\u00021\u0001}\u0003\u001dy\u0007\u000f^5p]N\u0004\"!`@\u000e\u0003yT!\u0001\u0010\u0010\n\u0007\u0005\u0005aP\u0001\rDCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB$\u0012!T\u0001\u000bY&\u001cH\u000fV1cY\u0016\u001cH\u0003BA\u0005\u0003\u001f\u0001Ba[A\u00067&\u0019\u0011QB%\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005EQ\u00021\u0001\u0002\u0014\u0005Ia.Y7fgB\f7-\u001a\t\u0005W\u0006-Q*A\u0005m_\u0006$G+\u00192mKR\u0019a,!\u0007\t\r\u0005ma\u00021\u0001\\\u0003\u0015IG-\u001a8u)\u0015q\u0016qDA\u0011\u0011\u0019\tYb\u0004a\u00017\"1\u00111E\bA\u00025\u000bqA^3sg&|g\u000eF\u0003_\u0003O\tI\u0003\u0003\u0004\u0002\u001cA\u0001\ra\u0017\u0005\b\u0003W\u0001\u0002\u0019AA\u0017\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002l\u0003_I1!!\rJ\u0005\u0011auN\\4\u0002\u001f%tg/\u00197jI\u0006$X\rV1cY\u0016$2\u0001]A\u001c\u0011\u0019\tY\"\u0005a\u00017\u0006Y1M]3bi\u0016$\u0016M\u00197f)%q\u0016QHA \u0003\u001f\n\t\u0007\u0003\u0004\u0002\u001cI\u0001\ra\u0017\u0005\b\u0003\u0003\u0012\u0002\u0019AA\"\u0003\u0019\u00198\r[3nCB!\u0011QIA&\u001b\t\t9EC\u0002\u0002Jy\tQ\u0001^=qKNLA!!\u0014\u0002H\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005E#\u00031\u0001\u0002T\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000b-\fY!!\u0016\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017\u001d\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005}\u0013\u0011\f\u0002\n)J\fgn\u001d4pe6Dq!a\u0019\u0013\u0001\u0004\t)'\u0001\u0006qe>\u0004XM\u001d;jKN\u0004BAO\u001fN\u001bRya,!\u001b\u0002l\u00055\u0014qNA9\u0003\u0003\u000bi\t\u0003\u0004\u0002\u001cM\u0001\ra\u0017\u0005\b\u0003\u0003\u001a\u0002\u0019AA\"\u0011\u001d\t\tf\u0005a\u0001\u0003'Bq!a\u0019\u0014\u0001\u0004\t)\u0007C\u0004\u0002tM\u0001\r!!\u001e\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u0011\t\u0005]\u0014QP\u0007\u0003\u0003sR1!a\u001f\u001d\u00035!\u0017n\u001d;sS\n,H/[8og&!\u0011qPA=\u00051!\u0015n\u001d;sS\n,H/[8o\u0011\u001d\t\u0019i\u0005a\u0001\u0003\u000b\u000b\u0001b\u001c:eKJLgn\u001a\t\u0006W\u0006-\u0011q\u0011\t\u0005\u0003/\nI)\u0003\u0003\u0002\f\u0006e#!C*peR|%\u000fZ3s\u0011\u001d\tyi\u0005a\u0001\u0003#\u000bQC]3rk&\u0014X\r\u001a(v[B\u000b'\u000f^5uS>t7\u000f\u0005\u0003lY\u0006M\u0005cA6\u0002\u0016&\u0019\u0011qS%\u0003\u0007%sG/\u0001\u0006bYR,'\u000fV1cY\u0016$RAXAO\u0003?Ca!a\u0007\u0015\u0001\u0004Y\u0006bBAQ)\u0001\u0007\u00111U\u0001\bG\"\fgnZ3t!\u0015Y\u0017QUAU\u0013\r\t9+\u0013\u0002\u000byI,\u0007/Z1uK\u0012t\u0004cA\u0019\u0002,&\u0019\u0011Q\u0016\u000e\u0003\u0017Q\u000b'\r\\3DQ\u0006tw-Z\u0001\nIJ|\u0007\u000fV1cY\u0016$B!a-\u0002:B\u00191.!.\n\u0007\u0005]\u0016JA\u0004C_>dW-\u00198\t\r\u0005mQ\u00031\u0001\\\u0003-\u0011XM\\1nKR\u000b'\r\\3\u0015\u000bA\fy,a1\t\r\u0005\u0005g\u00031\u0001\\\u0003!yG\u000eZ%eK:$\bBBAc-\u0001\u00071,\u0001\u0005oK^LE-\u001a8u\u0003II7\u000fV1cY\u0016LeN^1mS\u0012\fG/\u001a3\u0015\t\u0005M\u00161\u001a\u0005\u0007\u000379\u0002\u0019A.\u0002\u0017\rdW-\u0019:UC\ndWm\u001d\u000b\u0002a\u0002")
public class BasicInMemoryTableCatalog
implements TableCatalog {
    private final java.util.Map<List<String>, Map<String, String>> namespaces = new ConcurrentHashMap<List<String>, Map<String, String>>();
    private final java.util.Map<Identifier, Table> tables = new ConcurrentHashMap<Identifier, Table>();
    private final Set<Identifier> invalidatedTables = ConcurrentHashMap.newKeySet();
    private Option<String> _name = None$.MODULE$;

    public boolean tableExists(Identifier x$1) {
        return super.tableExists(x$1);
    }

    public boolean purgeTable(Identifier x$1) throws UnsupportedOperationException {
        return super.purgeTable(x$1);
    }

    public java.util.Map<List<String>, Map<String, String>> namespaces() {
        return this.namespaces;
    }

    public java.util.Map<Identifier, Table> tables() {
        return this.tables;
    }

    private Set<Identifier> invalidatedTables() {
        return this.invalidatedTables;
    }

    private Option<String> _name() {
        return this._name;
    }

    private void _name_$eq(Option<String> x$1) {
        this._name = x$1;
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this._name_$eq((Option<String>)new Some((Object)name));
    }

    public String name() {
        return (String)this._name().get();
    }

    public Identifier[] listTables(String[] namespace) {
        return (Identifier[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(this.tables().keySet()).asScala()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BasicInMemoryTableCatalog.$anonfun$listTables$1(namespace, x$1)))).toArray(ClassTag$.MODULE$.apply(Identifier.class));
    }

    public Table loadTable(Identifier ident) {
        Table table;
        Option option = Option$.MODULE$.apply((Object)this.tables().get(ident));
        if (!(option instanceof Some)) {
            throw new NoSuchTableException(ident);
        }
        Some some = (Some)option;
        Table table2 = table = (Table)some.value();
        return table2;
    }

    public Table loadTable(Identifier ident, String version) {
        Table table;
        Identifier versionIdent = Identifier.of((String[])ident.namespace(), (String)new StringBuilder(0).append(ident.name()).append(version).toString());
        Option option = Option$.MODULE$.apply((Object)this.tables().get(versionIdent));
        if (!(option instanceof Some)) {
            throw new NoSuchTableException(ident);
        }
        Some some = (Some)option;
        Table table2 = table = (Table)some.value();
        return table2;
    }

    public Table loadTable(Identifier ident, long timestamp) {
        Table table;
        Identifier timestampIdent = Identifier.of((String[])ident.namespace(), (String)new StringBuilder(0).append(ident.name()).append(timestamp).toString());
        Option option = Option$.MODULE$.apply((Object)this.tables().get(timestampIdent));
        if (!(option instanceof Some)) {
            throw new NoSuchTableException(ident);
        }
        Some some = (Some)option;
        Table table2 = table = (Table)some.value();
        return table2;
    }

    public void invalidateTable(Identifier ident) {
        this.invalidatedTables().add(ident);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        return this.createTable(ident, schema, partitions, properties, (Distribution)Distributions.unspecified(), (SortOrder[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(SortOrder.class)), (Option<Object>)None$.MODULE$);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties, Distribution distribution, SortOrder[] ordering, Option<Object> requiredNumPartitions) {
        if (this.tables().containsKey(ident)) {
            throw new TableAlreadyExistsException(ident);
        }
        InMemoryTableCatalog$.MODULE$.maybeSimulateFailedTableCreation(properties);
        String tableName = new StringBuilder(1).append(this.name()).append(".").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString();
        InMemoryTable table = new InMemoryTable(tableName, schema, partitions, properties, distribution, ordering, requiredNumPartitions);
        this.tables().put(ident, (Table)table);
        this.namespaces().putIfAbsent((List<String>)Predef$.MODULE$.wrapRefArray((Object[])ident.namespace()).toList(), (Map<String, String>)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return table;
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        InMemoryTable table = (InMemoryTable)this.loadTable(ident);
        java.util.Map properties = CatalogV2Util$.MODULE$.applyPropertiesChanges(table.properties(), changes);
        StructType schema = CatalogV2Util$.MODULE$.applySchemaChanges(table.schema(), changes);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))) {
            throw new IllegalArgumentException("Cannot drop all fields");
        }
        InMemoryTable newTable = new InMemoryTable(table.name(), schema, table.partitioning(), properties, InMemoryTable$.MODULE$.$lessinit$greater$default$5(), InMemoryTable$.MODULE$.$lessinit$greater$default$6(), InMemoryTable$.MODULE$.$lessinit$greater$default$7()).withData(table.data());
        this.tables().put(ident, (Table)newTable);
        return newTable;
    }

    public boolean dropTable(Identifier ident) {
        return Option$.MODULE$.apply((Object)this.tables().remove(ident)).isDefined();
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        if (this.tables().containsKey(newIdent)) {
            throw new TableAlreadyExistsException(newIdent);
        }
        Option option = Option$.MODULE$.apply((Object)this.tables().remove(oldIdent));
        if (!(option instanceof Some)) {
            throw new NoSuchTableException(oldIdent);
        }
        Some some = (Some)option;
        Table table = (Table)some.value();
        this.tables().put(newIdent, table);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public boolean isTableInvalidated(Identifier ident) {
        return this.invalidatedTables().contains(ident);
    }

    public void clearTables() {
        this.tables().clear();
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])changes));
    }

    public static final /* synthetic */ boolean $anonfun$listTables$1(String[] namespace$1, Identifier x$1) {
        return Predef$.MODULE$.wrapRefArray((Object[])x$1.namespace()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])namespace$1));
    }
}

