/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeWriteCompatibilityBaseSuite;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005]2A\u0001B\u0003\u0001!!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C!3!)1\u0006\u0001C!Y\t)3\u000b\u001e:jGR$\u0015\r^1UsB,wK]5uK\u000e{W\u000e]1uS\nLG.\u001b;z'VLG/\u001a\u0006\u0003\r\u001d\tQ\u0001^=qKNT!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I\u0019R\"A\u0003\n\u0005Q)!a\t#bi\u0006$\u0016\u0010]3Xe&$XmQ8na\u0006$\u0018NY5mSRL()Y:f'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"A\u0005\u0001\u0002+M$xN]3BgNLwM\\7f]R\u0004v\u000e\\5dsV\t!\u0004\u0005\u0002\u001cK9\u0011AD\t\b\u0003;\u0001j\u0011A\b\u0006\u0003?\u001d\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Cy\tqaU)M\u0007>tg-\u0003\u0002$I\u0005)2\u000b^8sK\u0006\u001b8/[4o[\u0016tG\u000fU8mS\u000eL(BA\u0011\u001f\u0013\t1sEA\u0003WC2,X-\u0003\u0002)S\tYQI\\;nKJ\fG/[8o\u0015\u0005Q\u0013!B:dC2\f\u0017aB2b]\u000e\u000b7\u000f^\u000b\u0002[A)afL\u00192i5\t\u0011&\u0003\u00021S\tIa)\u001e8di&|gN\r\t\u0003%IJ!aM\u0003\u0003\u0011\u0011\u000bG/\u0019+za\u0016\u0004\"AL\u001b\n\u0005YJ#a\u0002\"p_2,\u0017M\u001c")
public class StrictDataTypeWriteCompatibilitySuite
extends DataTypeWriteCompatibilityBaseSuite {
    @Override
    public Enumeration.Value storeAssignmentPolicy() {
        return SQLConf.StoreAssignmentPolicy$.MODULE$.STRICT();
    }

    @Override
    public Function2<DataType, DataType, Object> canCast() {
        return (Function2 & Serializable)(from, to) -> BoxesRunTime.boxToBoolean((boolean)Cast$.MODULE$.canUpCast(from, to));
    }

    public static final /* synthetic */ void $anonfun$new$2(Seq errs) {
        String $org_scalatest_assert_macro_left = (String)errs.apply(0);
        String $org_scalatest_assert_macro_right = "'t.x'";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Should include the nested field name context", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        String $org_scalatest_assert_macro_left2 = (String)errs.apply(0);
        String $org_scalatest_assert_macro_right2 = "Cannot safely cast";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        String $org_scalatest_assert_macro_left3 = (String)errs.apply(1);
        String $org_scalatest_assert_macro_right3 = "'t.y'";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Should include the nested field name context", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        String $org_scalatest_assert_macro_left4 = (String)errs.apply(1);
        String $org_scalatest_assert_macro_right4 = "Cannot safely cast";
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
    }

    public static final /* synthetic */ void $anonfun$new$4(String err) {
        String $org_scalatest_assert_macro_left = err;
        String $org_scalatest_assert_macro_right = "'arr.element'";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Should identify problem with named array's element type", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        String $org_scalatest_assert_macro_left2 = err;
        String $org_scalatest_assert_macro_right2 = "Cannot safely cast";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
    }

    public static final /* synthetic */ void $anonfun$new$6(String err) {
        String $org_scalatest_assert_macro_left = err;
        String $org_scalatest_assert_macro_right = "'m.value'";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Should identify problem with named map's value type", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        String $org_scalatest_assert_macro_left2 = err;
        String $org_scalatest_assert_macro_right2 = "Cannot safely cast";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }

    public static final /* synthetic */ void $anonfun$new$8(String err) {
        String $org_scalatest_assert_macro_left = err;
        String $org_scalatest_assert_macro_right = "'m.key'";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Should identify problem with named map's key type", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        String $org_scalatest_assert_macro_left2 = err;
        String $org_scalatest_assert_macro_right2 = "Cannot safely cast";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
    }

    public static final /* synthetic */ void $anonfun$new$11(DataType t$1, String err) {
        String $org_scalatest_assert_macro_left = err;
        String $org_scalatest_assert_macro_right = new StringBuilder(18).append("incompatible with ").append(t$1.catalogString()).toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
    }

    public StrictDataTypeWriteCompatibilitySuite() {
        this.test("Check struct types: unsafe casts are not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertNumErrors((DataType)this.widerPoint2(), (DataType)this.point2(), "t", "Should fail because types require unsafe casts", 2, this.assertNumErrors$default$6(), (Function1<Seq<String>, BoxedUnit>)(Function1 & Serializable)errs -> {
            StrictDataTypeWriteCompatibilitySuite.$anonfun$new$2(errs);
            return BoxedUnit.UNIT;
        }), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("Check array types: unsafe casts are not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ArrayType arrayOfLong = ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$);
            ArrayType arrayOfInt = ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$);
            this.assertSingleError((DataType)arrayOfLong, (DataType)arrayOfInt, "arr", "Should not allow array of longs to array of ints", (Function1<String, BoxedUnit>)(Function1 & Serializable)err -> {
                StrictDataTypeWriteCompatibilitySuite.$anonfun$new$4(err);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("Check map value types: casting Long to Integer is not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MapType mapOfLong = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)LongType$.MODULE$);
            MapType mapOfInt = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
            this.assertSingleError((DataType)mapOfLong, (DataType)mapOfInt, "m", "Should not allow map of longs to map of ints", (Function1<String, BoxedUnit>)(Function1 & Serializable)err -> {
                StrictDataTypeWriteCompatibilitySuite.$anonfun$new$6(err);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("Check map key types: unsafe casts are not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MapType mapKeyLong = MapType$.MODULE$.apply((DataType)LongType$.MODULE$, (DataType)StringType$.MODULE$);
            MapType mapKeyInt = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$);
            this.assertSingleError((DataType)mapKeyLong, (DataType)mapKeyInt, "m", "Should not allow map of long keys to map of int keys", (Function1<String, BoxedUnit>)(Function1 & Serializable)err -> {
                StrictDataTypeWriteCompatibilitySuite.$anonfun$new$8(err);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("Check NullType is incompatible with all other types", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.allNonNullTypes().foreach((Function1 & Serializable)t -> {
            this.assertSingleError((DataType)NullType$.MODULE$, t, "nulls", new StringBuilder(38).append("Should not allow writing None to type ").append(t).toString(), (Function1<String, BoxedUnit>)(Function1 & Serializable)err -> {
                StrictDataTypeWriteCompatibilitySuite.$anonfun$new$11(t, err);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
    }
}

