/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Substring$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, pos[, len]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.\n\n    _FUNC_(str FROM pos[ FOR len]]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL', -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL', 5, 1);\n       k\n      > SELECT _FUNC_('Spark SQL' FROM 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL' FROM -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL' FROM 5 FOR 1);\n       k\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5a\u0001B\u0012%\u0001FB\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003T\u0011!I\u0006A!f\u0001\n\u0003\u0011\u0006\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011B*\t\u000bm\u0003A\u0011\u0001/\t\u000bm\u0003A\u0011A1\t\u000b\u0011\u0004A\u0011I3\t\u000b1\u0004A\u0011I7\t\u000bQ\u0004A\u0011\t*\t\u000bU\u0004A\u0011\t*\t\u000bY\u0004A\u0011\t*\t\u000b]\u0004A\u0011\t=\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011q\u0004\u0001\u0005R\u0005\u0005\u0002\"CA\u0018\u0001\u0005\u0005I\u0011AA\u0019\u0011%\tI\u0004AI\u0001\n\u0003\tY\u0004C\u0005\u0002R\u0001\t\n\u0011\"\u0001\u0002<!I\u00111\u000b\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003+\u0002\u0011\u0011!C!\u0003/B\u0011\"!\u001b\u0001\u0003\u0003%\t!a\u001b\t\u0013\u0005M\u0004!!A\u0005\u0002\u0005U\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u0011%\tY\tAA\u0001\n\u0003\ti\tC\u0005\u0002\u0018\u0002\t\t\u0011\"\u0011\u0002\u001a\"I\u0011Q\u0014\u0001\u0002\u0002\u0013\u0005\u0013qT\u0004\n\u0003\u0007$\u0013\u0011!E\u0001\u0003\u000b4\u0001b\t\u0013\u0002\u0002#\u0005\u0011q\u0019\u0005\u00077v!\t!a8\t\u0013\u0005\u0005X$!A\u0005F\u0005\r\b\"CAs;\u0005\u0005I\u0011QAt\u0011%\ty/HA\u0001\n\u0003\u000b\t\u0010C\u0005\u0003\u0004u\t\t\u0011\"\u0003\u0003\u0006\tI1+\u001e2tiJLgn\u001a\u0006\u0003K\u0019\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0005K\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001M1\u0001A\r\u001c:\u0001\u001a\u0003\"a\r\u001b\u000e\u0003\u0011J!!\u000e\u0013\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00024o%\u0011\u0001\b\n\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011!(\u0010\b\u0003gmJ!\u0001\u0010\u0013\u0002\u000fA\f7m[1hK&\u0011ah\u0010\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\taD\u0005\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%IA\u0004Qe>$Wo\u0019;\u0011\u0005\u001dseB\u0001%N\u001d\tIE*D\u0001K\u0015\tY\u0005'\u0001\u0004=e>|GOP\u0005\u0002\u0007&\u0011AHQ\u0005\u0003\u001fB\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0010\"\u0002\u0007M$(/F\u0001T!\t\u0019D+\u0003\u0002VI\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\tM$(\u000fI\u0001\u0004a>\u001c\u0018\u0001\u00029pg\u0002\n1\u0001\\3o\u0003\u0011aWM\u001c\u0011\u0002\rqJg.\u001b;?)\u0011ifl\u00181\u0011\u0005M\u0002\u0001\"B)\b\u0001\u0004\u0019\u0006\"B,\b\u0001\u0004\u0019\u0006\"B-\b\u0001\u0004\u0019FcA/cG\")\u0011\u000b\u0003a\u0001'\")q\u000b\u0003a\u0001'\u0006AA-\u0019;b)f\u0004X-F\u0001g!\t9'.D\u0001i\u0015\tI\u0007&A\u0003usB,7/\u0003\u0002lQ\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u001c\t\u0004\u000f>\f\u0018B\u00019Q\u0005\r\u0019V-\u001d\t\u0003OJL!a\u001d5\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003zyz|\bCA!{\u0013\tY(IA\u0002B]fDQ! \bA\u0002e\faa\u001d;sS:<\u0007\"B,\u000f\u0001\u0004I\b\"B-\u000f\u0001\u0004I\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t)!!\u0005\u0002\u001cA!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\u0011\nqaY8eK\u001e,g.\u0003\u0003\u0002\u0010\u0005%!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005Mq\u00021\u0001\u0002\u0016\u0005\u00191\r\u001e=\u0011\t\u0005\u001d\u0011qC\u0005\u0005\u00033\tIA\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005uq\u00021\u0001\u0002\u0006\u0005\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$r!XA\u0012\u0003O\tY\u0003\u0003\u0004\u0002&A\u0001\raU\u0001\t]\u0016<h)\u001b:ti\"1\u0011\u0011\u0006\tA\u0002M\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\r\u00055\u0002\u00031\u0001T\u0003!qWm\u001e+iSJ$\u0017\u0001B2paf$r!XA\u001a\u0003k\t9\u0004C\u0004R#A\u0005\t\u0019A*\t\u000f]\u000b\u0002\u0013!a\u0001'\"9\u0011,\u0005I\u0001\u0002\u0004\u0019\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003{Q3aUA W\t\t\t\u0005\u0005\u0003\u0002D\u00055SBAA#\u0015\u0011\t9%!\u0013\u0002\u0013Ut7\r[3dW\u0016$'bAA&\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0013Q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\f\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0014\u0001\u00026bm\u0006LA!a\u001a\u0002^\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001c\u0011\u0007\u0005\u000by'C\u0002\u0002r\t\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!_A<\u0011%\tIhFA\u0001\u0002\u0004\ti'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0002R!!!\u0002\bfl!!a!\u000b\u0007\u0005\u0015%)\u0001\u0006d_2dWm\u0019;j_:LA!!#\u0002\u0004\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty)!&\u0011\u0007\u0005\u000b\t*C\u0002\u0002\u0014\n\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002ze\t\t\u00111\u0001z\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005e\u00131\u0014\u0005\n\u0003sR\u0012\u0011!a\u0001\u0003[\na!Z9vC2\u001cH\u0003BAH\u0003CC\u0001\"!\u001f\u001c\u0003\u0003\u0005\r!\u001f\u0015\u0014\u0001\u0005\u0015\u00161VAW\u0003c\u000b\u0019,a.\u0002:\u0006u\u0016q\u0018\t\u0004g\u0005\u001d\u0016bAAUI\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAX\u0003\t\u0005(\u0002\t\u0011!A}3UKT\"`QM$(\u000f\f\u0011q_N\\F\u0006\t7f]vK\u0003%\f\u0011SKR,(O\\:!i\",\u0007e];cgR\u0014\u0018N\\4!_\u001a\u0004\u0003m\u001d;sA\u0002\"\b.\u0019;!gR\f'\u000f^:!CR\u0004\u0003\r]8tA\u0002\ng\u000e\u001a\u0011jg\u0002zg\r\t7f]\u001e$\b\u000e\t1mK:\u0004G\u0006I8sAQDW\rI:mS\u000e,\u0007e\u001c4!Ef$X\rI1se\u0006L\b\u0005\u001e5bi\u0002\u001aH/\u0019:ug\u0002\nG\u000f\t1q_N\u0004\u0007%\u00198eA%\u001c\be\u001c4!Y\u0016tw\r\u001e5!A2,g\u000e\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue\u00022%kT'!a>\u001c8\f\t$P%\u0002bWM\\/^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u001aXOY:ue&tw\rI8gA\u0001\u001cHO\u001d1!i\"\fG\u000fI:uCJ$8\u000fI1uA\u0001\u0004xn\u001d1!C:$\u0007%[:!_\u001a\u0004C.\u001a8hi\"\u0004\u0003\r\\3oA2\u0002sN\u001d\u0011uQ\u0016\u00043\u000f\\5dK\u0002zg\r\t2zi\u0016\u0004\u0013M\u001d:bs\u0002\"\b.\u0019;!gR\f'\u000f^:!CR\u0004\u0003\r]8tA\u0002\ng\u000e\u001a\u0011jg\u0002zg\r\t7f]\u001e$\b\u000e\t1mK:\u0004gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA[\u0003\t%&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001eb\u0003%N\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A-\u00043+\u0015'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001a\u0006/\u0019:lAM\u000bFj\n\u0017![MJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*R\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u00159be.\u00043+\u0015'(Y\u0001*D\u0006I\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001Z'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001e\u0002cIU(NAUJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I6!'Fc%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001e\u0002cIU(NA5\u001a\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO\u00012%kT'!k\u00012uJ\u0015\u00112SmR\u0001\u0005\t\u0011!A\u0001\u00023N\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY,A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0002B\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006I1+\u001e2tiJLgn\u001a\t\u0003gu\u0019R!HAe\u0003+\u0004\u0002\"a3\u0002RN\u001b6+X\u0007\u0003\u0003\u001bT1!a4C\u0003\u001d\u0011XO\u001c;j[\u0016LA!a5\u0002N\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033TA!a7\u0002b\u0005\u0011\u0011n\\\u0005\u0004\u001f\u0006eGCAAc\u0003!!xn\u0015;sS:<GCAA-\u0003\u0015\t\u0007\u000f\u001d7z)\u001di\u0016\u0011^Av\u0003[DQ!\u0015\u0011A\u0002MCQa\u0016\u0011A\u0002MCQ!\u0017\u0011A\u0002M\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002t\u0006}\b#B!\u0002v\u0006e\u0018bAA|\u0005\n1q\n\u001d;j_:\u0004b!QA~'N\u001b\u0016bAA\u007f\u0005\n1A+\u001e9mKNB\u0001B!\u0001\"\u0003\u0003\u0005\r!X\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0004!\u0011\tYF!\u0003\n\t\t-\u0011Q\f\u0002\u0007\u001f\nTWm\u0019;")
public class Substring
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression str;
    private final Expression pos;
    private final Expression len;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Substring x$0) {
        return Substring$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Substring> tupled() {
        return Substring$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Substring>>> curried() {
        return Substring$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression pos() {
        return this.pos;
    }

    public Expression len() {
        return this.len;
    }

    @Override
    public DataType dataType() {
        return this.str().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$})), IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.pos();
    }

    @Override
    public Expression third() {
        return this.len();
    }

    @Override
    public Object nullSafeEval(Object string, Object pos, Object len) {
        Object object;
        DataType dataType = this.str().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            object = ((UTF8String)string).substringSQL(BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)len));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            object = ByteArray.subStringSQL((byte[])((byte[])string), (int)BoxesRunTime.unboxToInt((Object)pos), (int)BoxesRunTime.unboxToInt((Object)len));
        } else {
            throw new MatchError((Object)dataType);
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(string, pos, len) -> {
            String string2;
            DataType dataType = this.str().dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                string2 = new StringBuilder(17).append((String)string).append(".substringSQL(").append((String)pos).append(", ").append((String)len).append(")").toString();
            } else if (BinaryType$.MODULE$.equals(dataType)) {
                string2 = new StringBuilder(19).append(ByteArray.class.getName()).append(".subStringSQL(").append((String)string).append(", ").append((String)pos).append(", ").append((String)len).append(")").toString();
            } else {
                throw new MatchError((Object)dataType);
            }
            return string2;
        });
    }

    @Override
    public Substring withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public Substring copy(Expression str, Expression pos, Expression len) {
        return new Substring(str, pos, len);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.pos();
    }

    public Expression copy$default$3() {
        return this.len();
    }

    @Override
    public String productPrefix() {
        return "Substring";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.str();
                break;
            }
            case 1: {
                object = this.pos();
                break;
            }
            case 2: {
                object = this.len();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Substring;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "str";
                break;
            }
            case 1: {
                string = "pos";
                break;
            }
            case 2: {
                string = "len";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Substring)) return false;
        boolean bl = true;
        if (!bl) return false;
        Substring substring = (Substring)x$1;
        Expression expression = this.str();
        Expression expression2 = substring.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pos();
        Expression expression4 = substring.pos();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.len();
        Expression expression6 = substring.len();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substring.canEqual(this)) return false;
        return true;
    }

    public Substring(Expression str, Expression pos, Expression len) {
        this.str = str;
        this.pos = pos;
        this.len = len;
        ExpectsInputTypes.$init$(this);
    }

    public Substring(Expression str, Expression pos) {
        this(str, pos, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
    }
}

