/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.internal.SQLConf;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005%3Aa\u0002\u0005\u0001+!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C\u0005E!)q\u0007\u0001C\u0005q!)1\b\u0001C\u0005y!)q\b\u0001C\u0005\u0001\")1\t\u0001C\u0005\t\nq\u0012I\\1msNL7/\u0012=dKB$\u0018n\u001c8Q_NLG/[8o'VLG/\u001a\u0006\u0003\u0013)\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u00171\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u001b9\t1a]9m\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0004\u0001YQ\u0002CA\f\u0019\u001b\u0005q\u0011BA\r\u000f\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111\u0004H\u0007\u0002\u0011%\u0011Q\u0004\u0003\u0002\r\u0003:\fG._:jgR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002'Y,'/\u001b4z)\u0006\u0014G.\u001a)pg&$\u0018n\u001c8\u0015\u0007\rJS\u0007\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0003V]&$\b\"B\u0007\u0003\u0001\u0004Q\u0003CA\u00163\u001d\ta\u0003\u0007\u0005\u0002.K5\taF\u0003\u00020)\u00051AH]8pizJ!!M\u0013\u0002\rA\u0013X\rZ3g\u0013\t\u0019DG\u0001\u0004TiJLgn\u001a\u0006\u0003c\u0015BQA\u000e\u0002A\u0002)\nQ\u0001^1cY\u0016\f!C^3sS\u001aLh+[3x!>\u001c\u0018\u000e^5p]R\u00191%\u000f\u001e\t\u000b5\u0019\u0001\u0019\u0001\u0016\t\u000bY\u001a\u0001\u0019\u0001\u0016\u00023Y,'/\u001b4z)\u0006\u0014G.Z(s-&,w\u000fU8tSRLwN\u001c\u000b\u0004Gur\u0004\"B\u0007\u0005\u0001\u0004Q\u0003\"\u0002\u001c\u0005\u0001\u0004Q\u0013A\t<fe&4\u0017\u0010V1cY\u0016|%\u000fU3s[\u0006tWM\u001c;WS\u0016<\bk\\:ji&|g\u000eF\u0002$\u0003\nCQ!D\u0003A\u0002)BQAN\u0003A\u0002)\naB^3sS\u001aL\bk\\:ji&|g\u000e\u0006\u0003$\u000b\u001a;\u0005\"B\u0007\u0007\u0001\u0004Q\u0003\"\u0002\u001c\u0007\u0001\u0004Q\u0003\"\u0002%\u0007\u0001\u0004Q\u0013!C7tOB\u0013XMZ5y\u0001")
public class AnalysisExceptionPositionSuite
extends SparkFunSuite
implements AnalysisTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public void createTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public void createGlobalTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createGlobalTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void checkAnalysisWithoutViewWrapper(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive, boolean inlineCTE) {
        AnalysisTest.checkAnalysisWithoutViewWrapper$(this, inputPlan, expectedPlan, caseSensitive, inlineCTE);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$3() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$3$(this);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$4() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$4$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void assertAnalysisErrorClass(LogicalPlan inputPlan, String expectedErrorClass, String[] expectedMessageParameters, boolean caseSensitive) {
        AnalysisTest.assertAnalysisErrorClass$(this, inputPlan, expectedErrorClass, expectedMessageParameters, caseSensitive);
    }

    @Override
    public boolean assertAnalysisErrorClass$default$4() {
        return AnalysisTest.assertAnalysisErrorClass$default$4$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages, Option<String> errorClass) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages, errorClass);
    }

    @Override
    public Option<String> interceptParseException$default$4(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        return AnalysisTest.interceptParseException$default$4$(this, parser, sqlCommand, messages);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        AnalysisExceptionPositionSuite analysisExceptionPositionSuite = this;
        synchronized (analysisExceptionPositionSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private void verifyTablePosition(String sql, String table) {
        this.verifyPosition(sql, table, "Table");
    }

    private void verifyViewPosition(String sql, String table) {
        this.verifyPosition(sql, table, "View");
    }

    private void verifyTableOrViewPosition(String sql, String table) {
        this.verifyPosition(sql, table, "Table or view");
    }

    private void verifyTableOrPermanentViewPosition(String sql, String table) {
        this.verifyPosition(sql, table, "Table or permanent view");
    }

    private void verifyPosition(String sql, String table, String msgPrefix) {
        int expectedPos;
        int $org_scalatest_assert_macro_left = expectedPos = sql.indexOf(table);
        int $org_scalatest_assert_macro_right = -1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalysisExceptionPositionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.assertAnalysisError(CatalystSqlParser$.MODULE$.parsePlan(sql), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(25).append(msgPrefix).append(" not found: ").append(table).append("; line 1 pos ").append(expectedPos).toString()}))), this.assertAnalysisError$default$3());
    }

    public AnalysisExceptionPositionSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.test("SPARK-33886: UnresolvedTable should retain sql text position", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.verifyTablePosition("MSCK REPAIR TABLE unknown", "unknown");
            this.verifyTablePosition("LOAD DATA LOCAL INPATH 'filepath' INTO TABLE unknown", "unknown");
            this.verifyTablePosition("TRUNCATE TABLE unknown", "unknown");
            this.verifyTablePosition("SHOW PARTITIONS unknown", "unknown");
            this.verifyTablePosition("ALTER TABLE unknown RECOVER PARTITIONS", "unknown");
            this.verifyTablePosition("ALTER TABLE unknown ADD PARTITION (p=1)", "unknown");
            this.verifyTablePosition("ALTER TABLE unknown PARTITION (p=1) RENAME TO PARTITION (p=2)", "unknown");
            this.verifyTablePosition("ALTER TABLE unknown DROP PARTITION (p=1)", "unknown");
            this.verifyTablePosition("ALTER TABLE unknown SET SERDEPROPERTIES ('a'='b')", "unknown");
            this.verifyTablePosition("COMMENT ON TABLE unknown IS 'hello'", "unknown");
        }, new Position("AnalysisExceptionPositionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 23));
        this.test("SPARK-33918: UnresolvedView should retain sql text position", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.verifyViewPosition("DROP VIEW unknown", "unknown");
            this.verifyViewPosition("ALTER VIEW unknown SET TBLPROPERTIES ('k'='v')", "unknown");
            this.verifyViewPosition("ALTER VIEW unknown UNSET TBLPROPERTIES ('k')", "unknown");
            this.verifyViewPosition("ALTER VIEW unknown AS SELECT 1", "unknown");
        }, new Position("AnalysisExceptionPositionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("SPARK-34057: UnresolvedTableOrView should retain sql text position", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.verifyTableOrViewPosition("DROP TABLE unknown", "unknown");
            this.verifyTableOrViewPosition("DESCRIBE TABLE unknown", "unknown");
            this.verifyTableOrPermanentViewPosition("ANALYZE TABLE unknown COMPUTE STATISTICS", "unknown");
            this.verifyTableOrViewPosition("ANALYZE TABLE unknown COMPUTE STATISTICS FOR COLUMNS col", "unknown");
            this.verifyTableOrViewPosition("ANALYZE TABLE unknown COMPUTE STATISTICS FOR ALL COLUMNS", "unknown");
            this.verifyTableOrPermanentViewPosition("SHOW CREATE TABLE unknown", "unknown");
            this.verifyTableOrViewPosition("REFRESH TABLE unknown", "unknown");
            this.verifyTableOrViewPosition("SHOW COLUMNS FROM unknown", "unknown");
            this.assertAnalysisError(CatalystSqlParser$.MODULE$.parsePlan("SHOW COLUMNS FROM unknown IN db"), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Table or view not found: db.unknown; line 1 pos 18"}))), this.assertAnalysisError$default$3());
            this.verifyTableOrViewPosition("ALTER TABLE unknown RENAME TO t", "unknown");
            this.verifyTableOrViewPosition("ALTER VIEW unknown RENAME TO v", "unknown");
        }, new Position("AnalysisExceptionPositionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("SPARK-34139: UnresolvedRelation should retain sql text position", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.verifyTableOrViewPosition("CACHE TABLE unknown", "unknown");
            this.verifyTableOrViewPosition("UNCACHE TABLE unknown", "unknown");
            this.verifyTableOrViewPosition("DELETE FROM unknown", "unknown");
            this.verifyTableOrViewPosition("UPDATE unknown SET name='abc'", "unknown");
            this.verifyTableOrViewPosition("MERGE INTO unknownTarget AS target USING TaBlE AS source ON target.col = source.col WHEN MATCHED THEN DELETE", "unknownTarget");
            this.verifyTableOrViewPosition("MERGE INTO TaBlE AS target USING unknownSource AS source ON target.col = source.col WHEN MATCHED THEN DELETE", "unknownSource");
            this.verifyTablePosition("INSERT INTO TABLE unknown SELECT 1", "unknown");
            this.verifyTablePosition("INSERT OVERWRITE TABLE unknown VALUES (1, 'a')", "unknown");
        }, new Position("AnalysisExceptionPositionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
    }
}

