/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.InSubquery;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.ListQuery$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.Round;
import org.apache.spark.sql.catalyst.optimizer.OptimizeIn$;
import org.apache.spark.sql.catalyst.optimizer.OptimizeInSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005=3A!\u0003\u0006\u0001/!)!\u0005\u0001C\u0001G\u001d)a\u0005\u0001E\u0001O\u0019)\u0011\u0006\u0001E\u0001U!)!e\u0001C\u0001o!9\u0001h\u0001b\u0001\n\u0003I\u0004B\u0002%\u0004A\u0003%!\bC\u0004J\u0001\t\u0007I\u0011\u0001&\t\r9\u0003\u0001\u0015!\u0003L\u0005=y\u0005\u000f^5nSj,\u0017J\\*vSR,'BA\u0006\r\u0003%y\u0007\u000f^5nSj,'O\u0003\u0002\u000e\u001d\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0010!\u0005\u00191/\u001d7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001aE\u0002\u00011q\u0001\"!\u0007\u000e\u000e\u0003AI!a\u0007\t\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\ti\u0002%D\u0001\u001f\u0015\tyB\"A\u0003qY\u0006t7/\u0003\u0002\"=\tA\u0001\u000b\\1o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002\u0015\u0005Aq\n\u001d;j[&TX\r\u0005\u0002)\u00075\t\u0001A\u0001\u0005PaRLW.\u001b>f'\t\u00191\u0006E\u0002-_Ej\u0011!\f\u0006\u0003]1\tQA];mKNL!\u0001M\u0017\u0003\u0019I+H.Z#yK\u000e,Ho\u001c:\u0011\u0005I*T\"A\u001a\u000b\u0005Qr\u0012a\u00027pO&\u001c\u0017\r\\\u0005\u0003mM\u00121\u0002T8hS\u000e\fG\u000e\u00157b]R\tq%A\u0004cCR\u001c\u0007.Z:\u0016\u0003i\u00022a\u000f\"E\u001b\u0005a$BA\u001f?\u0003%IW.\\;uC\ndWM\u0003\u0002@\u0001\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011\u001f\u0003\t1K7\u000f\u001e\t\u0003\u000b\u001ak\u0011aA\u0005\u0003\u000f>\u0012QAQ1uG\"\f\u0001BY1uG\",7\u000fI\u0001\ri\u0016\u001cHOU3mCRLwN\\\u000b\u0002\u0017B\u0011!\u0007T\u0005\u0003\u001bN\u0012Q\u0002T8dC2\u0014V\r\\1uS>t\u0017!\u0004;fgR\u0014V\r\\1uS>t\u0007\u0005")
public class OptimizeInSuite
extends SparkFunSuite
implements PlanTest {
    private volatile OptimizeInSuite$Optimize$ Optimize$module;
    private final LocalRelation testRelation;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public OptimizeInSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    private String sparkHome$lzycompute() {
        OptimizeInSuite optimizeInSuite = this;
        synchronized (optimizeInSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    private final void Optimize$lzycompute$1() {
        OptimizeInSuite optimizeInSuite = this;
        synchronized (optimizeInSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new OptimizeInSuite$Optimize$(this);
            }
        }
    }

    public OptimizeInSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()}));
        this.test("OptimizedIn test: Remove deterministic repetitions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))}))))).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("b"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{UnresolvedAttribute$.MODULE$.apply("a"), UnresolvedAttribute$.MODULE$.apply("a"), new Round((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Expression)package.expressions$.MODULE$.intToLiteral(0)), new Round((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Expression)package.expressions$.MODULE$.intToLiteral(0)), Rand$.MODULE$.apply(0L), Rand$.MODULE$.apply(0L)}))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))}))))).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("b"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{UnresolvedAttribute$.MODULE$.apply("a"), UnresolvedAttribute$.MODULE$.apply("a"), new Round((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Expression)package.expressions$.MODULE$.intToLiteral(0)), new Round((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Expression)package.expressions$.MODULE$.intToLiteral(0)), Rand$.MODULE$.apply(0L), Rand$.MODULE$.apply(0L)}))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("OptimizedIn test: In clause not optimized to InSet when less than 10 items", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))}))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            this.comparePlans(optimized, originalQuery, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("OptimizedIn test: In clause optimized to InSet when more than 10 items", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 11).map((Function1 & Serializable)x$1 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$1))))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new InSet((Expression)UnresolvedAttribute$.MODULE$.apply("a"), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 11).toSet()))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("OptimizedIn test: In clause not optimized in case filter has attributes", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), UnresolvedAttribute$.MODULE$.apply("b")}))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), UnresolvedAttribute$.MODULE$.apply("b")}))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("OptimizedIn test: NULL IN (expr1, ..., exprN) gets transformed to Filter(null)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))}))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("OptimizedIn test: NULL IN (subquery) gets transformed to Filter(null)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ListQuery subquery = new ListQuery(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{UnresolvedAttribute$.MODULE$.apply("a")})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5());
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new InSubquery((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$)})), subquery))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("OptimizedIn test: Inset optimization disabled as list expression contains attribute)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), UnresolvedAttribute$.MODULE$.apply("b")}))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("OptimizedIn test: Inset optimization disabled as list expression contains attribute - select)", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)new In((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), UnresolvedAttribute$.MODULE$.apply("b")})))).as("a")}))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(originalQuery).analyze());
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$)).as("a")}))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("OptimizedIn test: Setting the threshold for turning Set into InSet.", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))}))))).analyze();
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.OPTIMIZER_INSET_CONVERSION_THRESHOLD().key()), (Object)"10")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                LogicalPlan notOptimizedPlan = OptimizeIn$.MODULE$.apply(plan);
                this.comparePlans(notOptimizedPlan, plan, this.comparePlans$default$3());
            });
            LogicalPlan plan2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))}))))).analyze();
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.OPTIMIZER_INSET_CONVERSION_THRESHOLD().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Filter filter;
                Expression cond;
                LogicalPlan optimizedPlan = OptimizeIn$.MODULE$.apply(plan2);
                LogicalPlan logicalPlan = optimizedPlan;
                if (!(logicalPlan instanceof Filter) || !((cond = (filter = (Filter)logicalPlan).condition()) instanceof InSet) || ((InSet)cond).set().size() != 3) {
                    throw this.fail("Unexpected result for OptimizedIn", new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("OptimizedIn test: one element in list gets transformed to EqualTo.", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))}))))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new EqualTo((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        this.test("OptimizedIn test: In empty list gets transformed to FalseLiteral when value is not nullable", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)Literal$.MODULE$.apply((Object)"a"), (Seq)package$.MODULE$.Nil()))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("OptimizedIn test: In empty list gets transformed to `If` expression when value is nullable", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            LogicalPlan originalQuery = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new In((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Seq)package$.MODULE$.Nil()))).analyze();
            LogicalPlan optimized = (LogicalPlan)this.Optimize().execute((TreeNode)originalQuery);
            LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).where((Expression)new If((Expression)new IsNotNull((Expression)UnresolvedAttribute$.MODULE$.apply("a")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$)))).analyze();
            this.comparePlans(optimized, correctAnswer, this.comparePlans$default$3());
        }, new Position("OptimizeInSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
    }
}

