/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000513AAB\u0004\u0001)!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0001I!)\u0011\b\u0001C\u0001u!)1\t\u0001C\u0001\t\")\u0011\n\u0001C\u0001\u0015\n\u0019B)\u0019;b)f\u0004X\rU1sg\u0016\u00148+^5uK*\u0011\u0001\"C\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005)Y\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)\u0012\u0004\u0005\u0002\u0017/5\tQ\"\u0003\u0002\u0019\u001b\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AG\u000f\u000e\u0003mQ!\u0001H\u0005\u0002\u000bAd\u0017M\\:\n\u0005yY\"!C*R\u0019\"+G\u000e]3s\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\tq!A\u0003qCJ\u001cX\r\u0006\u0002&WA\u0011a%K\u0007\u0002O)\u0011\u0001fC\u0001\u0006if\u0004Xm]\u0005\u0003U\u001d\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\u0006\u0019\t\u0001\r\u0001\f\t\u0003[Yr!A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\u001a\u0012A\u0002\u001fs_>$hHC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$'\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b3\u00035\u0019\u0007.Z2l\t\u0006$\u0018\rV=qKR\u00191hP!\u0011\u0005qjT\"\u0001\u001a\n\u0005y\u0012$\u0001B+oSRDQ\u0001Q\u0002A\u00021\na\u0002Z1uCRK\b/Z*ue&tw\rC\u0003C\u0007\u0001\u0007Q%\u0001\tfqB,7\r^3e\t\u0006$\u0018\rV=qK\u0006I\u0011N\u001c;fe\u000e,\u0007\u000f\u001e\u000b\u0003\u000b\"\u0003\"A\t$\n\u0005\u001d;!A\u0004)beN,W\t_2faRLwN\u001c\u0005\u0006\u0019\u0011\u0001\r\u0001L\u0001\fk:\u001cX\u000f\u001d9peR,G\r\u0006\u0002<\u0017\")\u0001)\u0002a\u0001Y\u0001")
public class DataTypeParserSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        DataTypeParserSuite dataTypeParserSuite = this;
        synchronized (dataTypeParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public DataType parse(String sql) {
        return CatalystSqlParser$.MODULE$.parseDataType(sql);
    }

    public void checkDataType(String dataTypeString, DataType expectedDataType) {
        this.test(new StringBuilder(6).append("parse ").append(dataTypeString.replace("\n", "")).toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.parse(dataTypeString));
            DataType $org_scalatest_assert_macro_right = expectedDataType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        }, new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
    }

    public ParseException intercept(String sql) {
        return (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseDataType(sql), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
    }

    public void unsupported(String dataTypeString) {
        this.test(new StringBuilder(17).append(dataTypeString).append(" is not supported").toString(), (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.intercept(dataTypeString), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
    }

    public DataTypeParserSuite() {
        SQLHelper.$init$(this);
        this.checkDataType("int", (DataType)IntegerType$.MODULE$);
        this.checkDataType("integer", (DataType)IntegerType$.MODULE$);
        this.checkDataType("BooLean", (DataType)BooleanType$.MODULE$);
        this.checkDataType("tinYint", (DataType)ByteType$.MODULE$);
        this.checkDataType("smallINT", (DataType)ShortType$.MODULE$);
        this.checkDataType("INT", (DataType)IntegerType$.MODULE$);
        this.checkDataType("INTEGER", (DataType)IntegerType$.MODULE$);
        this.checkDataType("bigint", (DataType)LongType$.MODULE$);
        this.checkDataType("float", (DataType)FloatType$.MODULE$);
        this.checkDataType("dOUBle", (DataType)DoubleType$.MODULE$);
        this.checkDataType("decimal(10, 5)", (DataType)new DecimalType(10, 5));
        this.checkDataType("decimal", (DataType)DecimalType$.MODULE$.USER_DEFAULT());
        this.checkDataType("Dec(10, 5)", (DataType)new DecimalType(10, 5));
        this.checkDataType("deC", (DataType)DecimalType$.MODULE$.USER_DEFAULT());
        this.checkDataType("DATE", (DataType)DateType$.MODULE$);
        this.checkDataType("timestamp", (DataType)TimestampType$.MODULE$);
        this.checkDataType("timestamp_ntz", (DataType)TimestampNTZType$.MODULE$);
        this.checkDataType("timestamp_ltz", (DataType)TimestampType$.MODULE$);
        this.checkDataType("string", (DataType)StringType$.MODULE$);
        this.checkDataType("ChaR(5)", (DataType)new CharType(5));
        this.checkDataType("ChaRacter(5)", (DataType)new CharType(5));
        this.checkDataType("varchAr(20)", (DataType)new VarcharType(20));
        this.checkDataType("cHaR(27)", (DataType)new CharType(27));
        this.checkDataType("BINARY", (DataType)BinaryType$.MODULE$);
        this.checkDataType("void", (DataType)NullType$.MODULE$);
        this.checkDataType("interval", (DataType)CalendarIntervalType$.MODULE$);
        this.checkDataType("INTERVAL YEAR TO MONTH", (DataType)YearMonthIntervalType$.MODULE$.apply());
        this.checkDataType("interval day to second", (DataType)DayTimeIntervalType$.MODULE$.apply());
        this.checkDataType("array<doublE>", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataType("Array<map<int, tinYint>>", (DataType)new ArrayType((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ByteType$.MODULE$, true), true));
        StructField structField = new StructField("tinYint", (DataType)ByteType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("array<struct<tinYint:tinyint>>", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField)), true));
        this.checkDataType("MAP<int, STRING>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataType("MAp<int, ARRAY<double>>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), true));
        StructField structField2 = new StructField("varchar", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("MAP<int, struct<varchar:string>>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField2)), true));
        StructField structField3 = new StructField("intType", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("ts", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("struct<intType: int, ts:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField4).$colon$colon((Object)structField3)));
        StructField structField5 = new StructField("int", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("timestamp", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("Struct<int: int, timestamp:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField6).$colon$colon((Object)structField5)));
        StructField structField7 = new StructField("deciMal", (DataType)DecimalType$.MODULE$.USER_DEFAULT(), true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("anotherDecimal", (DataType)new DecimalType(5, 2), true, StructField$.MODULE$.apply$default$4());
        StructField structField9 = new StructField("struct", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField8).$colon$colon((Object)structField7)), true, StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("MAP", (DataType)MapType$.MODULE$.apply((DataType)TimestampType$.MODULE$, (DataType)new VarcharType(10)), true, StructField$.MODULE$.apply$default$4());
        StructField structField11 = new StructField("arrAy", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("anotherArray", (DataType)new ArrayType((DataType)new CharType(9), true), true, StructField$.MODULE$.apply$default$4());
        this.checkDataType(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |struct<\n      |  struct:struct<deciMal:DECimal, anotherDecimal:decimAL(5,2)>,\n      |  MAP:Map<timestamp, varchar(10)>,\n      |  arrAy:Array<double>,\n      |  anotherArray:Array<char(9)>>\n    ")), (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField12).$colon$colon((Object)structField11).$colon$colon((Object)structField10).$colon$colon((Object)structField9)));
        StructField structField13 = new StructField("x+y", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField14 = new StructField("!@#$%^&*()", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField15 = new StructField("1_2.345<>:\"", (DataType)new VarcharType(20), true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("struct<`x+y`:int, `!@#$%^&*()`:string, `1_2.345<>:\"`:varchar(20)>", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField15).$colon$colon((Object)structField14).$colon$colon((Object)structField13)));
        this.checkDataType("strUCt<>", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil()));
        StructField structField16 = new StructField("x", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField17 = new StructField("y", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("struct<x int, y string>", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField17).$colon$colon((Object)structField16)));
        this.unsupported("it is not a data type");
        this.unsupported("struct<x+y: int, 1.1:timestamp>");
        this.unsupported("struct<x: int");
        this.test("Do not print empty parentheses for no params", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String $org_scalatest_assert_macro_left = this.intercept("unknown").getMessage();
            String $org_scalatest_assert_macro_right = "unknown is not supported";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            String $org_scalatest_assert_macro_left2 = this.intercept("unknown(1,2,3)").getMessage();
            String $org_scalatest_assert_macro_right2 = "unknown(1,2,3) is not supported";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("Set default timestamp type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.TIMESTAMP_TYPE().key()), (Object)SQLConf.TimestampTypes$.MODULE$.TIMESTAMP_NTZ().toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.parse("timestamp"));
                TimestampNTZType$ $org_scalatest_assert_macro_right = TimestampNTZType$.MODULE$;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.TIMESTAMP_TYPE().key()), (Object)SQLConf.TimestampTypes$.MODULE$.TIMESTAMP_LTZ().toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.parse("timestamp"));
                TimestampType$ $org_scalatest_assert_macro_right = TimestampType$.MODULE$;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            });
        }, new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        StructField structField18 = new StructField("TABLE", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField19 = new StructField("DATE", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("Struct<TABLE: string, DATE:boolean>", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil().$colon$colon((Object)structField19).$colon$colon((Object)structField18)));
        this.checkDataType("struct<end: long, select: int, from: string>", (DataType)new StructType().add("end", (DataType)LongType$.MODULE$).add("select", (DataType)IntegerType$.MODULE$).add("from", (DataType)StringType$.MODULE$));
        this.checkDataType("Struct<x: INT, y: STRING COMMENT 'test'>", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)StringType$.MODULE$, true, "test"));
    }
}

