/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.connector.catalog.BufferedRows;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryAtomicPartitionTable;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.SupportsPartitionManagement;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.expressions.LogicalExpressions$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000513A\u0001C\u0005\u0001-!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003B\u0002\u0013\u0001A\u0003%\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0004\u000b\u0001\t\u0007I\u0011\u0002\u001f\t\r\u0001\u0003\u0001\u0015!\u0003>\u0011\u0015\t\u0005\u0001\"\u0003C\u0005\u0019\u001aV\u000f\u001d9peR\u001c\u0018\t^8nS\u000e\u0004\u0016M\u001d;ji&|g.T1oC\u001e,W.\u001a8u'VLG/\u001a\u0006\u0003\u0015-\tqaY1uC2|wM\u0003\u0002\r\u001b\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0003\u0001]\u0001\"\u0001G\r\u000e\u0003=I!AG\b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t\u0011\"A\u0003jI\u0016tG/F\u0001\"!\tq\"%\u0003\u0002$\u0013\tQ\u0011\nZ3oi&4\u0017.\u001a:\u0002\r%$WM\u001c;!\u0003\r\u0011XM\u001a\u000b\u0003O5\u0002\"\u0001K\u0016\u000e\u0003%R!AK\u0006\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003Y%\u0012aBT1nK\u0012\u0014VMZ3sK:\u001cW\rC\u0003/\t\u0001\u0007q&\u0001\u0003oC6,\u0007C\u0001\u0019:\u001d\t\tt\u0007\u0005\u00023k5\t1G\u0003\u00025+\u00051AH]8pizR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\na\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001(N\u000b\u0002{A\u0011aDP\u0005\u0003\u007f%\u0011A#\u00138NK6|'/\u001f+bE2,7)\u0019;bY><\u0017\u0001C2bi\u0006dwn\u001a\u0011\u0002\u001b!\f7\u000fU1si&$\u0018n\u001c8t)\t\u0019u\t\u0005\u0002E\u000b6\tQ'\u0003\u0002Gk\t9!i\\8mK\u0006t\u0007\"\u0002%\b\u0001\u0004I\u0015!\u0002;bE2,\u0007C\u0001\u0010K\u0013\tY\u0015BA\u000eTkB\u0004xN\u001d;t!\u0006\u0014H/\u001b;j_:l\u0015M\\1hK6,g\u000e\u001e")
public class SupportsAtomicPartitionManagementSuite
extends SparkFunSuite {
    private final Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table");
    private final InMemoryTableCatalog catalog;

    private Identifier ident() {
        return this.ident;
    }

    public NamedReference ref(String name) {
        return LogicalExpressions$.MODULE$.parseReference(name);
    }

    private InMemoryTableCatalog catalog() {
        return this.catalog;
    }

    private boolean hasPartitions(SupportsPartitionManagement table) {
        return !ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])table.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty())));
    }

    public static final /* synthetic */ HashMap $anonfun$new$9(int x$1) {
        return new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    public SupportsAtomicPartitionManagementSuite() {
        void var1_1;
        InMemoryTableCatalog newCatalog = new InMemoryTableCatalog();
        newCatalog.initialize("test", CaseInsensitiveStringMap.empty());
        newCatalog.createTable(this.ident(), new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$).add("dt", (DataType)StringType$.MODULE$), (Transform[])((Object[])new Transform[]{LogicalExpressions$.MODULE$.identity(this.ref("dt"))}), Collections.emptyMap());
        this.catalog = var1_1;
        this.test("createPartitions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryAtomicPartitionTable partTable = new InMemoryAtomicPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            InternalRow[] partIdents = (InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))});
            partTable.createPartitions(partIdents, (Map[])((Object[])new Map[]{new HashMap(), new HashMap()}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"3\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"4\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            partTable.dropPartition(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"})));
            partTable.dropPartition(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"})));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }, new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("createPartitions failed if partition already exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryAtomicPartitionTable partTable = new InMemoryAtomicPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(partIdent), "partTable.partitionExists(partIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            InternalRow[] partIdents = (InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))});
            this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> partTable.createPartitions(partIdents, (Map[])((Object[])new Map[]{new HashMap(), new HashMap()})), ClassTag$.MODULE$.apply(PartitionsAlreadyExistException.class), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"3\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            partTable.dropPartition(partIdent);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }, new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("dropPartitions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryAtomicPartitionTable partTable = new InMemoryAtomicPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            InternalRow[] partIdents = (InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))});
            partTable.createPartitions(partIdents, (Map[])((Object[])new Map[]{new HashMap(), new HashMap()}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"3\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))), "partTable.partitionExists(org.apache.spark.sql.catalyst.InternalRow.apply(\"4\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            partTable.dropPartitions(partIdents);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        }, new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("purgePartitions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String errMsg;
            Table table = this.catalog().loadTable(this.ident());
            InMemoryAtomicPartitionTable partTable = new InMemoryAtomicPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            InternalRow[] partIdents = (InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))});
            partTable.createPartitions(partIdents, (Map[])((Object[])new Map[]{new HashMap(), new HashMap()}));
            String $org_scalatest_assert_macro_left = errMsg = ((Throwable)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> partTable.purgePartitions(partIdents), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120))).getMessage();
            String $org_scalatest_assert_macro_right = "purge is not supported";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        }, new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("dropPartitions failed if partition not exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Table table = this.catalog().loadTable(this.ident());
            InMemoryAtomicPartitionTable partTable = new InMemoryAtomicPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            InternalRow[] $org_scalatest_assert_macro_left = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            InternalRow[] partIdents = (InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partTable.dropPartitions(partIdents), "partTable.dropPartitions(partIdents)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(partIdent), "partTable.partitionExists(partIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            partTable.dropPartition(partIdent);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        }, new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("truncatePartitions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String errMsg;
            Table table = this.catalog().loadTable(this.ident());
            InMemoryAtomicPartitionTable partTable = new InMemoryAtomicPartitionTable(table.name(), table.schema(), table.partitioning(), table.properties());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hasPartitions(partTable), "SupportsAtomicPartitionManagementSuite.this.hasPartitions(partTable)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            partTable.createPartitions((InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"})), InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"5"}))}), (Map[])Array$.MODULE$.tabulate(3, (Function1 & Serializable)x$1 -> SupportsAtomicPartitionManagementSuite.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)x$1)), ClassTag$.MODULE$.apply(Map.class)));
            InternalRow[] $org_scalatest_assert_macro_left = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            partTable.withData((BufferedRows[])((Object[])new BufferedRows[]{new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("3")).withRow(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "abc", "3"}))), new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("4")).withRow(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "def", "4"}))), new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("5")).withRow(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "zyx", "5"})))}));
            partTable.truncatePartitions((InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"3"})), InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"4"}))}));
            InternalRow[] $org_scalatest_assert_macro_left2 = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(partTable.rows());
            InternalRow internalRow = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "zyx", "5"}));
            List $org_scalatest_assert_macro_right3 = package$.MODULE$.Nil().$colon$colon((Object)internalRow);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            String $org_scalatest_assert_macro_left4 = errMsg = ((AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> partTable.truncatePartitions((InternalRow[])((Object[])new InternalRow[]{InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"5"})), InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"6"}))})), ClassTag$.MODULE$.apply(NoSuchPartitionException.class), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166))))).getMessage();
            String $org_scalatest_assert_macro_right4 = "Partition not found in table test.ns.test_table: 6 -> dt";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(partTable.rows());
            InternalRow internalRow2 = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "zyx", "5"}));
            List $org_scalatest_assert_macro_right5 = package$.MODULE$.Nil().$colon$colon((Object)internalRow2);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }, new Position("SupportsAtomicPartitionManagementSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }
}

