/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\u000e\u001d\u0001%B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005}!)1\t\u0001C\u0001\t\"9q\t\u0001b\u0001\n\u0013A\u0005BB(\u0001A\u0003%\u0011\nC\u0004Q\u0001\t\u0007I\u0011\u0002%\t\rE\u0003\u0001\u0015!\u0003J\u0011\u001d\u0011\u0006A1A\u0005\nMCaa\u001a\u0001!\u0002\u0013!\u0006\"\u00025\u0001\t\u0003I\u0007\"B?\u0001\t\u0003q\bbBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!!\u001b\u0001\t\u0013\tY\u0007C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!I\u0011Q\u0011\u0001C\u0002\u0013%\u0011q\u0011\u0005\t\u0003\u001f\u0003\u0001\u0015!\u0003\u0002\n\nq1i\u0015,J]\u001a,'oU2iK6\f'BA\u000f\u001f\u0003\r\u00197O\u001e\u0006\u0003?\u0001\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0004\u0001)\u0002\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g\r\u0005\u00022s9\u0011!g\u000e\b\u0003gYj\u0011\u0001\u000e\u0006\u0003k!\na\u0001\u0010:p_Rt\u0014\"A\u0017\n\u0005ab\u0013a\u00029bG.\fw-Z\u0005\u0003um\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u000f\u0017\u0002\u000f=\u0004H/[8ogV\ta\b\u0005\u0002@\u00016\tA$\u0003\u0002B9\tQ1i\u0015,PaRLwN\\:\u0002\u0011=\u0004H/[8og\u0002\na\u0001P5oSRtDCA#G!\ty\u0004\u0001C\u0003=\u0007\u0001\u0007a(A\buS6,7\u000f^1naB\u000b'o]3s+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u001f\u0003\u0011)H/\u001b7\n\u00059[%A\u0005+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\f\u0001\u0003^5nKN$\u0018-\u001c9QCJ\u001cXM\u001d\u0011\u0002+QLW.Z:uC6\u0004h\n\u0016.G_Jl\u0017\r\u001e;fe\u00061B/[7fgR\fW\u000e\u001d(U5\u001a{'/\\1ui\u0016\u0014\b%A\u0007eK\u000eLW.\u00197QCJ\u001cXM]\u000b\u0002)B!1&V,`\u0013\t1FFA\u0005Gk:\u001cG/[8ocA\u0011\u0001\f\u0018\b\u00033j\u0003\"a\r\u0017\n\u0005mc\u0013A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!a\u0017\u0017\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001B7bi\"T\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002gC\nQ!)[4EK\u000eLW.\u00197\u0002\u001d\u0011,7-[7bYB\u000b'o]3sA\u0005)\u0011N\u001c4feR\u0019!\u000e]>\u0011\u0005-tW\"\u00017\u000b\u00055\u0004\u0013!\u0002;za\u0016\u001c\u0018BA8m\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006c*\u0001\rA]\u0001\ti>\\WM\u001c*E\tB\u00191O\u001e=\u000e\u0003QT!!\u001e\u0012\u0002\u0007I$G-\u0003\u0002xi\n\u0019!\u000b\u0012#\u0011\u0007-Jx+\u0003\u0002{Y\t)\u0011I\u001d:bs\")AP\u0003a\u0001q\u00061\u0001.Z1eKJ\fa\u0002^8TiJ,8\r\u001e$jK2$7\u000fF\u0003\u0000\u0003\u000f\t\u0019\u0002\u0005\u0003,s\u0006\u0005\u0001cA6\u0002\u0004%\u0019\u0011Q\u00017\u0003\u0017M#(/^2u\r&,G\u000e\u001a\u0005\b\u0003\u0013Y\u0001\u0019AA\u0006\u0003)1\u0017.\u001a7e)f\u0004Xm\u001d\t\u0005We\fi\u0001E\u0002l\u0003\u001fI1!!\u0005m\u0005!!\u0015\r^1UsB,\u0007\"\u0002?\f\u0001\u0004A\u0018\u0001D5oM\u0016\u0014(k\\<UsB,GCBA\u0006\u00033\ti\u0002C\u0004\u0002\u001c1\u0001\r!a\u0003\u0002\u0011I|woU8GCJDa!a\b\r\u0001\u0004A\u0018\u0001\u00028fqR\fQ\"\\3sO\u0016\u0014vn\u001e+za\u0016\u001cHCBA\u0006\u0003K\tI\u0003C\u0004\u0002(5\u0001\r!a\u0003\u0002\u000b\u0019L'o\u001d;\t\u000f\u0005-R\u00021\u0001\u0002\f\u000511/Z2p]\u0012\f!\"\u001b8gKJ4\u0015.\u001a7e)\u0019\ti!!\r\u00026!9\u00111\u0007\bA\u0002\u00055\u0011!\u0003;za\u0016\u001cvNR1s\u0011\u0019\t9D\u0004a\u0001/\u0006)a-[3mI\u0006Q\u0011n]%oM>\u0013h*\u00198\u0015\t\u0005u\u00121\t\t\u0004W\u0005}\u0012bAA!Y\t9!i\\8mK\u0006t\u0007BBA\u001c\u001f\u0001\u0007q+A\buef\u0004\u0016M]:f\u0013:$XmZ3s)\u0011\ti!!\u0013\t\r\u0005]\u0002\u00031\u0001X\u00031!(/\u001f)beN,Gj\u001c8h)\u0011\ti!a\u0014\t\r\u0005]\u0012\u00031\u0001X\u0003=!(/\u001f)beN,G)Z2j[\u0006dG\u0003BA\u0007\u0003+Ba!a\u000e\u0013\u0001\u00049\u0016A\u0004;ssB\u000b'o]3E_V\u0014G.\u001a\u000b\u0005\u0003\u001b\tY\u0006\u0003\u0004\u00028M\u0001\raV\u0001\u0015iJL\b+\u0019:tKRKW.Z:uC6\u0004h\n\u0016.\u0015\t\u00055\u0011\u0011\r\u0005\u0007\u0003o!\u0002\u0019A,\u0002#Q\u0014\u0018\u0010U1sg\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0003\u0002\u000e\u0005\u001d\u0004BBA\u001c+\u0001\u0007q+A\buef\u0004\u0016M]:f\u0005>|G.Z1o)\u0011\ti!!\u001c\t\r\u0005]b\u00031\u0001X\u0003)\u0019HO]5oORK\b/\u001a\u000b\u0003\u0003\u001b\tabY8na\u0006$\u0018N\u00197f)f\u0004X\r\u0006\u0004\u0002x\u0005u\u0014\u0011\u0011\t\u0006W\u0005e\u0014QB\u0005\u0004\u0003wb#AB(qi&|g\u000eC\u0004\u0002\u0000a\u0001\r!!\u0004\u0002\u0005Q\f\u0004bBAB1\u0001\u0007\u0011QB\u0001\u0003iJ\n\u0001DZ5oI\u000e{W\u000e]1uS\ndW\rV=qK\u001a{'oQ*W+\t\tI\tE\u0005,\u0003\u0017\u000bi!!\u0004\u0002x%\u0019\u0011Q\u0012\u0017\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0014!\u00074j]\u0012\u001cu.\u001c9bi&\u0014G.\u001a+za\u00164uN]\"T-\u0002\u0002")
public class CSVInferSchema
implements Serializable {
    private final CSVOptions options;
    private final TimestampFormatter timestampParser;
    private final TimestampFormatter timestampNTZFormatter;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV;

    public CSVOptions options() {
        return this.options;
    }

    private TimestampFormatter timestampParser() {
        return this.timestampParser;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    public StructType infer(RDD<String[]> tokenRDD, String[] header) {
        StructField[] structFieldArray;
        if (this.options().inferSchemaFlag()) {
            DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
            DataType[] rootTypes = (DataType[])tokenRDD.aggregate((Object)startType, (Function2 & Serializable)(rowSoFar, next) -> this.inferRowType((DataType[])rowSoFar, (String[])next), (Function2 & Serializable)(first, second) -> this.mergeRowTypes((DataType[])first, (DataType[])second), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class)));
            structFieldArray = this.toStructFields(rootTypes, header);
        } else {
            structFieldArray = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])header), (Function1 & Serializable)fieldName -> new StructField((String)fieldName, StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), ClassTag$.MODULE$.apply(StructField.class));
        }
        StructField[] fields = structFieldArray;
        return new StructType(fields);
    }

    public StructField[] toStructFields(DataType[] fieldTypes, String[] header) {
        return (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])header), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String thisHeader = (String)tuple2._1();
            DataType rootType = (DataType)tuple2._2();
            DataType dataType = rootType;
            DataType dataType2 = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
            DataType dType = dataType2;
            StructField structField = new StructField(thisHeader, dType, true, StructField$.MODULE$.apply$default$4());
            return structField;
        }, ClassTag$.MODULE$.apply(StructField.class));
    }

    public DataType[] inferRowType(DataType[] rowSoFar, String[] next) {
        for (int i = 0; i < package$.MODULE$.min(rowSoFar.length, next.length); ++i) {
            rowSoFar[i] = this.inferField(rowSoFar[i], next[i]);
        }
        return rowSoFar;
    }

    public DataType[] mergeRowTypes(DataType[] first, DataType[] second) {
        return (DataType[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipAll$extension(Predef$.MODULE$.refArrayOps((Object[])first), (Iterable)Predef$.MODULE$.wrapRefArray((Object[])second), (Object)NullType$.MODULE$, (Object)NullType$.MODULE$)), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType a = (DataType)tuple2._1();
            DataType b = (DataType)tuple2._2();
            DataType dataType = (DataType)this.compatibleType(a, b).getOrElse((Function0 & Serializable)() -> NullType$.MODULE$);
            return dataType;
        }, ClassTag$.MODULE$.apply(DataType.class));
    }

    /*
     * Enabled aggressive block sorting
     */
    public DataType inferField(DataType typeSoFar, String field) {
        DataType dataType;
        DataType dataType2;
        block21: {
            block20: {
                if (field == null || field.isEmpty()) break block20;
                String string = field;
                String string2 = this.options().nullValue();
                if (string != null ? !string.equals(string2) : string2 != null) break block21;
            }
            dataType2 = typeSoFar;
            return dataType2;
        }
        DataType dataType3 = typeSoFar;
        if (NullType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseInteger(field);
        } else if (IntegerType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseInteger(field);
        } else if (LongType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseLong(field);
        } else if (dataType3 instanceof DecimalType) {
            dataType = this.tryParseDecimal(field);
        } else if (DoubleType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseDouble(field);
        } else if (TimestampNTZType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseTimestampNTZ(field);
        } else if (TimestampType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseTimestamp(field);
        } else if (BooleanType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseBoolean(field);
        } else {
            if (!StringType$.MODULE$.equals(dataType3)) {
                if (dataType3 == null) throw new MatchError((Object)dataType3);
                DataType dataType4 = dataType3;
                throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType4);
            }
            dataType = StringType$.MODULE$;
        }
        DataType typeElemInfer = dataType;
        dataType2 = (DataType)this.compatibleType(typeSoFar, typeElemInfer).getOrElse((Function0 & Serializable)() -> StringType$.MODULE$);
        return dataType2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field) {
        String string = field;
        String string2 = this.options().nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field;
        String string4 = this.options().negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field;
        String string6 = this.options().positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(field))).isDefined() ? IntegerType$.MODULE$ : this.tryParseLong(field);
    }

    private DataType tryParseLong(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(field))).isDefined() ? LongType$.MODULE$ : this.tryParseDecimal(field);
    }

    private DataType tryParseDecimal(String field) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
            BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field);
            return bigDecimal.scale() <= 0 ? new DecimalType(bigDecimal.precision(), bigDecimal.scale()) : this.tryParseDouble(field);
        });
        return (DataType)decimalTry.getOrElse((Function0 & Serializable)() -> this.tryParseDouble(field));
    }

    private DataType tryParseDouble(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(field))).isDefined() || this.isInfOrNan(field) ? DoubleType$.MODULE$ : this.tryParseTimestampNTZ(field);
    }

    private DataType tryParseTimestampNTZ(String field) {
        return this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined() ? SQLConf$.MODULE$.get().timestampType() : this.tryParseTimestamp(field);
    }

    private DataType tryParseTimestamp(String field) {
        return this.timestampParser().parseOptional(field).isDefined() ? TimestampType$.MODULE$ : this.tryParseBoolean(field);
    }

    private DataType tryParseBoolean(String field) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(field))).isDefined() ? BooleanType$.MODULE$ : this.stringType();
    }

    private DataType stringType() {
        return StringType$.MODULE$;
    }

    private Option<DataType> compatibleType(DataType t1, DataType t2) {
        return ((Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)t1, (Object)t2)).orElse((Function0 & Serializable)() -> (Option)this.findCompatibleTypeForCSV().apply((Object)t1, (Object)t2));
    }

    private Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV() {
        return this.findCompatibleTypeForCSV;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Option $anonfun$findCompatibleTypeForCSV$1(CSVInferSchema $this, DataType x0$1, DataType x1$1) {
        block5: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block4: {
                                                    var6_3 = new Tuple2((Object)x0$1, (Object)x1$1);
                                                    if (var6_3 == null || !StringType$.MODULE$.equals(var7_4 = (DataType)var6_3._1())) break block4;
                                                    var3_5 /* !! */  = new Some((Object)StringType$.MODULE$);
                                                    break block5;
                                                }
                                                if (var6_3 == null || !StringType$.MODULE$.equals(var8_6 = (DataType)var6_3._2())) break block6;
                                                var3_5 /* !! */  = new Some((Object)StringType$.MODULE$);
                                                break block5;
                                            }
                                            if (var6_3 == null) break block7;
                                            t1 = (DataType)var6_3._1();
                                            t2 = (DataType)var6_3._2();
                                            if (!(t1 instanceof IntegralType)) break block7;
                                            var11_9 = (IntegralType)t1;
                                            if (!(t2 instanceof DecimalType)) break block7;
                                            var12_10 = (DecimalType)t2;
                                            var3_5 /* !! */  = $this.compatibleType(DecimalType$.MODULE$.forType(var11_9), var12_10);
                                            break block5;
                                        }
                                        if (var6_3 == null) break block8;
                                        t1 = (DataType)var6_3._1();
                                        t2 = (DataType)var6_3._2();
                                        if (!(t1 instanceof DecimalType)) break block8;
                                        var15_13 = (DecimalType)t1;
                                        if (!(t2 instanceof IntegralType)) break block8;
                                        var16_14 = (IntegralType)t2;
                                        var3_5 /* !! */  = $this.compatibleType(var15_13, DecimalType$.MODULE$.forType(var16_14));
                                        break block5;
                                    }
                                    if (var6_3 == null || !DoubleType$.MODULE$.equals(var17_15 = (DataType)var6_3._1()) || !(var6_3._2() instanceof DecimalType)) break block9;
                                    var5_16 = true;
                                    break block10;
                                }
                                if (var6_3 == null) ** GOTO lbl-1000
                                var18_17 = (DataType)var6_3._2();
                                if (var6_3._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var18_17)) {
                                    var5_16 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var5_16 = false;
                                }
                            }
                            if (!var5_16) break block11;
                            var3_5 /* !! */  = new Some((Object)DoubleType$.MODULE$);
                            break block5;
                        }
                        if (var6_3 == null) break block12;
                        t1 = (DataType)var6_3._1();
                        t2 = (DataType)var6_3._2();
                        if (!(t1 instanceof DecimalType)) break block12;
                        var21_20 = (DecimalType)t1;
                        if (!(t2 instanceof DecimalType)) break block12;
                        var22_21 = (DecimalType)t2;
                        scale = package$.MODULE$.max(var21_20.scale(), var22_21.scale());
                        range = package$.MODULE$.max(var21_20.precision() - var21_20.scale(), var22_21.precision() - var22_21.scale());
                        var3_5 /* !! */  = range + scale > 38 ? new Some((Object)DoubleType$.MODULE$) : new Some((Object)new DecimalType(range + scale, scale));
                        break block5;
                    }
                    if (var6_3 == null) break block13;
                    var25_24 = (DataType)var6_3._1();
                    var26_25 = (DataType)var6_3._2();
                    if (!TimestampNTZType$.MODULE$.equals(var25_24) || !TimestampType$.MODULE$.equals(var26_25)) break block13;
                    var4_26 = true;
                    break block14;
                }
                if (var6_3 == null) ** GOTO lbl-1000
                var27_27 = (DataType)var6_3._1();
                var28_28 = (DataType)var6_3._2();
                if (TimestampType$.MODULE$.equals(var27_27) && TimestampNTZType$.MODULE$.equals(var28_28)) {
                    var4_26 = true;
                } else lbl-1000:
                // 2 sources

                {
                    var4_26 = false;
                }
            }
            var3_5 /* !! */  = var4_26 ? new Some((Object)TimestampType$.MODULE$) : None$.MODULE$;
        }
        return var3_5 /* !! */ ;
    }

    public CSVInferSchema(CSVOptions options) {
        this.options = options;
        this.timestampParser = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
        Locale locale = options.locale();
        Locale locale2 = Locale.US;
        this.decimalParser = !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null) ? s -> new BigDecimal((String)s) : ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.findCompatibleTypeForCSV = (arg_0, arg_1) -> CSVInferSchema.$anonfun$findCompatibleTypeForCSV$1(this, arg_0, arg_1);
    }
}

