/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StringBinaryPredicateExpressionBuilderBase;
import scala.collection.immutable.Seq;

@ExpressionDescription(usage="\n    _FUNC_(left, right) - Returns a boolean. The value is True if right is found inside left.\n    Returns NULL if either input expression is NULL. Otherwise, returns False.\n    Both left or right must be of STRING or BINARY type.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 'Spark');\n       true\n      > SELECT _FUNC_('Spark SQL', 'SPARK');\n       false\n      > SELECT _FUNC_('Spark SQL', null);\n       NULL\n      > SELECT _FUNC_(x'537061726b2053514c', x'537061726b');\n       true\n  ", since="3.3.0", group="string_funcs")
public final class ContainsExpressionBuilder$
implements StringBinaryPredicateExpressionBuilderBase {
    public static final ContainsExpressionBuilder$ MODULE$ = new ContainsExpressionBuilder$();

    static {
        StringBinaryPredicateExpressionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        return StringBinaryPredicateExpressionBuilderBase.build$(this, funcName, expressions);
    }

    @Override
    public Expression createStringPredicate(Expression left, Expression right) {
        return new Contains(left, right);
    }

    private ContainsExpressionBuilder$() {
    }
}

