/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Flatten$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(arrayOfArrays) - Transforms an array of arrays into a single array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(array(1, 2), array(3, 4)));\n       [1,2,3,4]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001B\u0010!\u00016B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\")\u0001\u000b\u0001C\u0001#\")A\u000b\u0001C\u0005+\")A\f\u0001C!;\"A\u0011\r\u0001EC\u0002\u0013\u0005#\r\u0003\u0005k\u0001!\u0015\r\u0011\"\u0003c\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015!\b\u0001\"\u0011v\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\t\u0019\u0002\u0001C\u0005\u0003+Aq!a\r\u0001\t\u0013\t)\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005\r\u0003\u0001\"\u0015\u0002F!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003#\u0002\u0011\u0013!C\u0001\u0003'B\u0011\"!\u001b\u0001\u0003\u0003%\t%a\u001b\t\u0013\u0005m\u0004!!A\u0005\u0002\u0005u\u0004\"CAC\u0001\u0005\u0005I\u0011AAD\u0011%\ti\tAA\u0001\n\u0003\ny\tC\u0005\u0002\u001e\u0002\t\t\u0011\"\u0001\u0002 \"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0013Q\u0015\u0005\n\u0003S\u0003\u0011\u0011!C!\u0003W;\u0011\"a4!\u0003\u0003E\t!!5\u0007\u0011}\u0001\u0013\u0011!E\u0001\u0003'Da\u0001U\r\u0005\u0002\u0005-\b\"CAw3\u0005\u0005IQIAx\u0011%\t\t0GA\u0001\n\u0003\u000b\u0019\u0010C\u0005\u0002xf\t\t\u0011\"!\u0002z\"I!QA\r\u0002\u0002\u0013%!q\u0001\u0002\b\r2\fG\u000f^3o\u0015\t\t#%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0012%\u0003!\u0019\u0017\r^1msN$(BA\u0013'\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003O!\nQa\u001d9be.T!!\u000b\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0013aA8sO\u000e\u00011#\u0002\u0001/eez\u0004CA\u00181\u001b\u0005\u0001\u0013BA\u0019!\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001a7\u001d\tyC'\u0003\u00026A\u00059\u0001/Y2lC\u001e,\u0017BA\u001c9\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!!\u000e\u0011\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001i\u0012\b\u0003\u0003\u001as!AQ#\u000e\u0003\rS!\u0001\u0012\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014BA\u001b<\u0013\tA\u0015J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00026w\u0005)1\r[5mIV\tA\n\u0005\u00020\u001b&\u0011a\n\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003%N\u0003\"a\f\u0001\t\u000b)\u001b\u0001\u0019\u0001'\u0002\u001b\rD\u0017\u000e\u001c3ECR\fG+\u001f9f+\u00051\u0006CA,[\u001b\u0005A&BA-%\u0003\u0015!\u0018\u0010]3t\u0013\tY\u0006LA\u0005BeJ\f\u0017\u0010V=qK\u0006Aa.\u001e7mC\ndW-F\u0001_!\tQt,\u0003\u0002aw\t9!i\\8mK\u0006t\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\r\u0004\"a\u00163\n\u0005\u0015D&\u0001\u0003#bi\u0006$\u0016\u0010]3)\u0005\u00199\u0007C\u0001\u001ei\u0013\tI7HA\u0005ue\u0006t7/[3oi\u0006YQ\r\\3nK:$H+\u001f9fQ\t9q-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001o!\ty'/D\u0001q\u0015\t\t(%\u0001\u0005b]\u0006d\u0017p]5t\u0013\t\u0019\bOA\bUsB,7\t[3dWJ+7/\u001e7u\u00031qW\u000f\u001c7TC\u001a,WI^1m)\t1\u0018\u0010\u0005\u0002;o&\u0011\u0001p\u000f\u0002\u0004\u0003:L\b\"\u0002&\n\u0001\u00041\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0015a\u0018QAA\b!\ri\u0018\u0011A\u0007\u0002}*\u0011q\u0010I\u0001\bG>$WmZ3o\u0013\r\t\u0019A \u0002\t\u000bb\u0004(oQ8eK\"9\u0011q\u0001\u0006A\u0002\u0005%\u0011aA2uqB\u0019Q0a\u0003\n\u0007\u00055aP\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005E!\u00021\u0001}\u0003\t)g/\u0001\u000ehK:\u001cu\u000eZ3G_JtU/\u001c2fe>3W\t\\3nK:$8\u000f\u0006\u0004\u0002\u0018\u00055\u0012q\u0006\t\bu\u0005e\u0011QDA\u000f\u0013\r\tYb\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005}\u0011q\u0005\b\u0005\u0003C\t\u0019\u0003\u0005\u0002Cw%\u0019\u0011QE\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\r\t)c\u000f\u0005\b\u0003\u000fY\u0001\u0019AA\u0005\u0011\u001d\t\td\u0003a\u0001\u0003;\t\u0011c\u00195jY\u00124\u0016M]5bE2,g*Y7f\u0003E9WM\\\"pI\u00164uN\u001d$mCR$XM\u001c\u000b\t\u0003;\t9$!\u000f\u0002<!9\u0011q\u0001\u0007A\u0002\u0005%\u0001bBA\u0019\u0019\u0001\u0007\u0011Q\u0004\u0005\b\u0003{a\u0001\u0019AA\u000f\u00035\t'O]1z\t\u0006$\u0018MT1nK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005u\u0011\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002S\u0003\u000fBa!!\u0013\u000f\u0001\u0004a\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0004%\u0006=\u0003b\u0002&\u0010!\u0003\u0005\r\u0001T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)FK\u0002M\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003GZ\u0014AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u00055\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u0005Y\u0006twM\u0003\u0002\u0002x\u0005!!.\u0019<b\u0013\u0011\tI#!\u001d\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005}\u0004c\u0001\u001e\u0002\u0002&\u0019\u00111Q\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007Y\fI\tC\u0005\u0002\fN\t\t\u00111\u0001\u0002\u0000\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!%\u0011\u000b\u0005M\u0015\u0011\u0014<\u000e\u0005\u0005U%bAALw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0015Q\u0013\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002_\u0003CC\u0001\"a#\u0016\u0003\u0003\u0005\rA^\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002n\u0005\u001d\u0006\"CAF-\u0005\u0005\t\u0019AA@\u0003\u0019)\u0017/^1mgR\u0019a,!,\t\u0011\u0005-u#!AA\u0002YD3\u0003AAY\u0003o\u000bI,!0\u0002@\u0006\r\u0017QYAe\u0003\u0017\u00042aLAZ\u0013\r\t)\f\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tY,\u0001&`\rVs5i\u0018\u0015beJ\f\u0017p\u00144BeJ\f\u0017p]\u0015![\u0001\"&/\u00198tM>\u0014Xn\u001d\u0011b]\u0002\n'O]1zA=4\u0007%\u0019:sCf\u001c\b%\u001b8u_\u0002\n\u0007e]5oO2,\u0007%\u0019:sCft\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0005\u0017A\u0017\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015beJ\f\u0017\u0010K\u0019-AIJC\u0006I1se\u0006L\bf\r\u0017!i%J\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012Df\r\u00175;*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002H\u0006Y\u0011M\u001d:bs~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\ti-A\u00033]Qr\u0003'A\u0004GY\u0006$H/\u001a8\u0011\u0005=J2#B\r\u0002V\u0006\u0005\bCBAl\u0003;d%+\u0004\u0002\u0002Z*\u0019\u00111\\\u001e\u0002\u000fI,h\u000e^5nK&!\u0011q\\Am\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0003G\fI/\u0004\u0002\u0002f*!\u0011q]A;\u0003\tIw.C\u0002I\u0003K$\"!!5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001c\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007I\u000b)\u0010C\u0003K9\u0001\u0007A*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005m(\u0011\u0001\t\u0005u\u0005uH*C\u0002\u0002\u0000n\u0012aa\u00149uS>t\u0007\u0002\u0003B\u0002;\u0005\u0005\t\u0019\u0001*\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\nA!\u0011q\u000eB\u0006\u0013\u0011\u0011i!!\u001d\u0003\r=\u0013'.Z2u\u0001")
public class Flatten
extends UnaryExpression
implements package.NullIntolerant,
Serializable {
    private transient DataType dataType;
    private transient DataType elementType;
    private final Expression child;
    private volatile transient byte bitmap$trans$0;

    public static Option<Expression> unapply(Flatten x$0) {
        return Flatten$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Flatten, A> g) {
        return Flatten$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Flatten> compose(Function1<A$, Expression> g) {
        return Flatten$.MODULE$.compose(g);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    private ArrayType childDataType() {
        return (ArrayType)this.child().dataType();
    }

    @Override
    public boolean nullable() {
        return this.child().nullable() || this.childDataType().containsNull();
    }

    private DataType dataType$lzycompute() {
        Flatten flatten = this;
        synchronized (flatten) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.dataType = this.childDataType().elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    private DataType elementType$lzycompute() {
        Flatten flatten = this;
        synchronized (flatten) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType;
        DataType dataType = this.child().dataType();
        TypeCheckResult typeCheckResult = dataType instanceof ArrayType && (arrayType = (ArrayType)dataType).elementType() instanceof ArrayType ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append("The argument should be an array of arrays, ").append(new StringBuilder(19).append("but '").append(this.child().sql()).append("' is of ").append(this.child().dataType().catalogString()).append(" type.").toString()).toString());
        return typeCheckResult;
    }

    @Override
    public Object nullSafeEval(Object child) {
        GenericArrayData genericArrayData;
        Object[] elements = ((ArrayData)child).toObjectArray(this.dataType());
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(elements), null)) {
            genericArrayData = null;
        } else {
            ArrayData[] arrayData = (ArrayData[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(elements), (Function1 & Serializable)x$51 -> (ArrayData)x$51, ClassTag$.MODULE$.apply(ArrayData.class));
            long numberOfElements = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])arrayData), (Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(sum, e) -> BoxesRunTime.boxToLong((long)Flatten.$anonfun$nullSafeEval$6(BoxesRunTime.unboxToLong((Object)sum), e))));
            if (numberOfElements > 0x7FFFFFF0L) {
                throw QueryExecutionErrors$.MODULE$.flattenArraysWithElementsExceedLimitError(numberOfElements);
            }
            Object[] flattenedData = (Object[])ClassTag$.MODULE$.Nothing().newArray((int)numberOfElements);
            IntRef position = IntRef.create((int)0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])arrayData), (Function1 & Serializable)ad -> {
                Flatten.$anonfun$nullSafeEval$7(this, flattenedData, position, ad);
                return BoxedUnit.UNIT;
            });
            genericArrayData = new GenericArrayData((Object)flattenedData);
        }
        return genericArrayData;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> {
            String code = this.genCodeForFlatten(ctx, (String)c, ExprValue$.MODULE$.exprValueToString(ev.value()));
            return ctx.nullArrayElementsSaveExec(this.childDataType().containsNull(), ExprValue$.MODULE$.exprValueToString(ev.isNull()), (String)c, code);
        });
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx, String childVariableName) {
        String variableName = ctx.freshName("numElements");
        String code = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(125).append("\n      |long ").append(variableName).append(" = 0;\n      |for (int z = 0; z < ").append(childVariableName).append(".numElements(); z++) {\n      |  ").append(variableName).append(" += ").append(childVariableName).append(".getArray(z).numElements();\n      |}\n      ").toString()));
        return new Tuple2((Object)code, (Object)variableName);
    }

    private String genCodeForFlatten(CodegenContext ctx, String childVariableName, String arrayDataName) {
        String counter = ctx.freshName("counter");
        String tempArrayDataName = ctx.freshName("tempArrayData");
        String k = ctx.freshName("k");
        String l = ctx.freshName("l");
        String arr = ctx.freshName("arr");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx, childVariableName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemCode = (String)tuple2._1();
        String numElemName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemCode, (Object)numElemName);
        Tuple2 tuple23 = tuple22;
        String numElemCode2 = (String)tuple23._1();
        String numElemName2 = (String)tuple23._2();
        String allocation = CodeGenerator$.MODULE$.createArrayData(tempArrayDataName, this.elementType(), numElemName2, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(tempArrayDataName, this.elementType(), arr, counter, l, ((ArrayType)this.dataType()).containsNull());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n    |").append(numElemCode2).append("\n    |").append(allocation).append("\n    |int ").append(counter).append(" = 0;\n    |for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(childVariableName).append(".numElements(); ").append(k).append("++) {\n    |  ArrayData ").append(arr).append(" = ").append(childVariableName).append(".getArray(").append(k).append(");\n    |  for (int ").append(l).append(" = 0; ").append(l).append(" < ").append(arr).append(".numElements(); ").append(l).append("++) {\n    |   ").append(assignment).append("\n    |   ").append(counter).append("++;\n    | }\n    |}\n    |").append(arrayDataName).append(" = ").append(tempArrayDataName).append(";\n    ").toString()));
    }

    @Override
    public String prettyName() {
        return "flatten";
    }

    @Override
    public Flatten withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Flatten copy(Expression child) {
        return new Flatten(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Flatten";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Flatten;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Flatten)) return false;
        boolean bl = true;
        if (!bl) return false;
        Flatten flatten = (Flatten)x$1;
        Expression expression = this.child();
        Expression expression2 = flatten.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!flatten.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$nullSafeEval$6(long sum, ArrayData e) {
        return sum + (long)e.numElements();
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$7(Flatten $this, Object[] flattenedData$1, IntRef position$2, ArrayData ad) {
        Object[] arr = ad.toObjectArray($this.elementType());
        Array$.MODULE$.copy((Object)arr, 0, (Object)flattenedData$1, position$2.elem, arr.length);
        position$2.elem += arr.length;
    }

    public Flatten(Expression child) {
        this.child = child;
    }
}

