/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Formatter;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FormatString$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(strfmt, obj, ...) - Returns a formatted string from printf-style format strings.", examples="\n    Examples:\n      > SELECT _FUNC_(\"Hello World %d %s\", 100, \"days\");\n       Hello World 100 days\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001B\u000e\u001d\u0001&B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\")Q\n\u0001C!\u001d\")!\u000b\u0001C!\u001d\")1\u000b\u0001C!)\")1\f\u0001C!9\")1\r\u0001C!I\")a\u000e\u0001C!_\")Q\u0010\u0001C!}\"9\u0011q\u0002\u0001\u0005R\u0005E\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0005\n\u0003W\u0001\u0011\u0011!C!\u0003[A\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\t\u0013\u0005\u001d\u0003!!A\u0005\u0002\u0005%\u0003\"CA(\u0001\u0005\u0005I\u0011IA)\u0011%\ty\u0006AA\u0001\n\u0003\t\t\u0007C\u0005\u0002f\u0001\t\t\u0011\"\u0011\u0002h!I\u00111\u000e\u0001\u0002\u0002\u0013\u0005\u0013QN\u0004\n\u0003#c\u0012\u0011!E\u0001\u0003'3\u0001b\u0007\u000f\u0002\u0002#\u0005\u0011Q\u0013\u0005\u0007\u0013V!\t!!,\t\u0013\u0005=V#!A\u0005F\u0005E\u0006\"CAZ+\u0005\u0005I\u0011QA[\u0011%\tI,FA\u0001\n\u0003\u000bY\fC\u0005\u0002JV\t\t\u0011\"\u0003\u0002L\naai\u001c:nCR\u001cFO]5oO*\u0011QDH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002 A\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001U9\nt\u0007\u0005\u0002,Y5\tA$\u0003\u0002.9\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005-z\u0013B\u0001\u0019\u001d\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$a\u0002)s_\u0012,8\r\u001e\t\u0003q\u0001s!!\u000f \u000f\u0005ijT\"A\u001e\u000b\u0005qB\u0013A\u0002\u001fs_>$h(C\u00015\u0013\ty4'A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0013%\u0001D*fe&\fG.\u001b>bE2,'BA 4\u0003!\u0019\u0007.\u001b7ee\u0016tW#A#\u0011\u0007I2%&\u0003\u0002Hg\tQAH]3qK\u0006$X\r\u001a \u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002L\u0019B\u00111\u0006\u0001\u0005\u0006\u0007\u000e\u0001\r!R\u0001\tM>dG-\u00192mKV\tq\n\u0005\u00023!&\u0011\u0011k\r\u0002\b\u0005>|G.Z1o\u0003!qW\u000f\u001c7bE2,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001\u0017\u0011\u0002\u000bQL\b/Z:\n\u0005i;&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001^!\rAd\fY\u0005\u0003?\n\u00131aU3r!\t1\u0016-\u0003\u0002c/\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0005KZ\fG\u000e\u0006\u0002fQB\u0011!GZ\u0005\u0003ON\u00121!\u00118z\u0011\u001dI\u0007\u0002%AA\u0002)\fQ!\u001b8qkR\u0004\"a\u001b7\u000e\u0003yI!!\u001c\u0010\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$2\u0001\u001d<|!\t\tH/D\u0001s\u0015\t\u0019H$A\u0004d_\u0012,w-\u001a8\n\u0005U\u0014(\u0001C#yaJ\u001cu\u000eZ3\t\u000b]L\u0001\u0019\u0001=\u0002\u0007\r$\b\u0010\u0005\u0002rs&\u0011!P\u001d\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015a\u0018\u00021\u0001q\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012a \t\u0005\u0003\u0003\tIA\u0004\u0003\u0002\u0004\u0005\u0015\u0001C\u0001\u001e4\u0013\r\t9aM\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0011Q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d1'A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u00191*a\u0005\t\u000f\u0005U1\u00021\u0001\u0002\u0018\u0005Ya.Z<DQ&dGM]3o!\u0011A\u0014\u0011\u0004\u0016\n\u0007\u0005m!I\u0001\u0006J]\u0012,\u00070\u001a3TKF\f\u0011d\u00195fG.\f%oZ;nK:$\u0018J\u001c3fq:{GOW3s_R!\u0011\u0011EA\u0014!\r\u0011\u00141E\u0005\u0004\u0003K\u0019$\u0001B+oSRDa!!\u000b\r\u0001\u0004Q\u0013AC3yaJ,7o]5p]\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005!A.\u00198h\u0015\t\tI$\u0001\u0003kCZ\f\u0017\u0002BA\u0006\u0003g\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0011\u0011\u0007I\n\u0019%C\u0002\u0002FM\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!ZA&\u0011%\tieDA\u0001\u0002\u0004\t\t%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0002R!!\u0016\u0002\\\u0015l!!a\u0016\u000b\u0007\u0005e3'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0018\u0002X\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ry\u00151\r\u0005\t\u0003\u001b\n\u0012\u0011!a\u0001K\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ty#!\u001b\t\u0013\u00055##!AA\u0002\u0005\u0005\u0013AB3rk\u0006d7\u000fF\u0002P\u0003_B\u0001\"!\u0014\u0014\u0003\u0003\u0005\r!\u001a\u0015\u0014\u0001\u0005M\u0014\u0011PA>\u0003\u007f\n\t)!\"\u0002\b\u0006-\u0015Q\u0012\t\u0004W\u0005U\u0014bAA<9\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA?\u0003]{f)\u0016(D?\"\u001aHO\u001d4ni2\u0002sN\u00196-A9rc&\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007EZ8s[\u0006$H/\u001a3!gR\u0014\u0018N\\4!MJ|W\u000e\t9sS:$h-L:us2,\u0007EZ8s[\u0006$\be\u001d;sS:<7OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111Q\u0001g\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0003*\u001a7m_\u0002:vN\u001d7eA\u0015\"\u0007%J:#Y\u0001\n\u0004\u0007\r\u0017!E\u0011\f\u0017p\u001d\u0012*w)\u0001\u0003\u0005\t\u0011!A\u0001BU\r\u001c7pA]{'\u000f\u001c3!cA\u0002\u0004\u0005Z1zg*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002\n\u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u0011qR\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\r\r>\u0014X.\u0019;TiJLgn\u001a\t\u0003WU\u0019R!FAL\u0003G\u0003b!!'\u0002 \u0016[UBAAN\u0015\r\tijM\u0001\beVtG/[7f\u0013\u0011\t\t+a'\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002&\u0006-VBAAT\u0015\u0011\tI+a\u000e\u0002\u0005%|\u0017bA!\u0002(R\u0011\u00111S\u0001\ti>\u001cFO]5oOR\u0011\u0011qF\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0017\u0006]\u0006\"B\"\u0019\u0001\u0004)\u0015AC;oCB\u0004H._*fcR!\u0011QXAc!\u0015\u0011\u0014qXAb\u0013\r\t\tm\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007ar&\u0006\u0003\u0005\u0002Hf\t\t\u00111\u0001L\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003\u001b\u0004B!!\r\u0002P&!\u0011\u0011[A\u001a\u0005\u0019y%M[3di\u0002")
public class FormatString
extends Expression
implements ImplicitCastInputTypes,
Serializable {
    private final Seq<Expression> children;

    public static Option<Seq<Expression>> unapplySeq(FormatString x$0) {
        return FormatString$.MODULE$.unapplySeq(x$0);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<FormatString, A> g) {
        return FormatString$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, FormatString> compose(Function1<A$, Seq<Expression>> g) {
        return FormatString$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.foldable()));
    }

    @Override
    public boolean nullable() {
        return ((Expression)this.children().apply(0)).nullable();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return ((List)package$.MODULE$.List().fill(this.children().size() - 1, (Function0 & Serializable)() -> AnyDataType$.MODULE$)).$colon$colon((Object)stringType$);
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Object pattern = ((Expression)this.children().apply(0)).eval(input);
        if (pattern == null) {
            uTF8String = null;
        } else {
            StringBuffer sb = new StringBuffer();
            Formatter formatter = new Formatter(sb, Locale.US);
            Seq arglist = (Seq)((IterableOps)this.children().tail()).map((Function1 & Serializable)x$30 -> x$30.eval(input));
            formatter.format(((UTF8String)pattern).toString(), (Object[])arglist.toArray(ClassTag$.MODULE$.AnyRef()));
            uTF8String = UTF8String.fromString((String)sb.toString());
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode pattern = ((Expression)this.children().head()).genCode(ctx);
        Seq argListGen = (Seq)((IterableOps)this.children().tail()).map((Function1 & Serializable)x -> new Tuple2((Object)x.dataType(), (Object)x.genCode(ctx)));
        String argList = ctx.freshName("argLists");
        int numArgLists = argListGen.length();
        Seq argListCode = (Seq)((IterableOps)argListGen.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 v = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = CodeGenerator$.MODULE$.boxedType((DataType)v._1());
            String string2 = CodeGenerator$.MODULE$.javaType((DataType)v._1());
            String value = (string == null ? string2 != null : !string.equals(string2)) ? new StringBuilder(0).append(new StringBuilder(15).append("(").append(((ExprCode)v._2()).isNull()).append(") ? (").append(CodeGenerator$.MODULE$.boxedType((DataType)v._1())).append(") null : ").toString()).append(new StringBuilder(6).append("new ").append(CodeGenerator$.MODULE$.boxedType((DataType)v._1())).append("(").append(((ExprCode)v._2()).value()).append(")").toString()).toString() : new StringBuilder(12).append("(").append(((ExprCode)v._2()).isNull()).append(") ? null : ").append(((ExprCode)v._2()).value()).toString();
            String string3 = new StringBuilder(34).append("\n         ").append(((ExprCode)v._2()).code()).append("\n         ").append(argList).append("[").append(index).append("] = ").append(value).append(";\n       ").toString();
            return string3;
        });
        Tuple2 tuple2 = new Tuple2((Object)"Object[]", (Object)argList);
        String argListCodes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)argListCode, "valueFormatString", (Seq<Tuple2<String, String>>)package$.MODULE$.Nil().$colon$colon((Object)tuple2), ctx.splitExpressionsWithCurrentInputs$default$4(), ctx.splitExpressionsWithCurrentInputs$default$5(), ctx.splitExpressionsWithCurrentInputs$default$6());
        String form = ctx.freshName("formatter");
        String formatter = Formatter.class.getName();
        String sb = ctx.freshName("sb");
        String stringBuffer = StringBuffer.class.getName();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      boolean ", " = ", ";\n      ", " ", " = ", ";\n      if (!", ") {\n        ", " ", " = new ", "();\n        ", " ", " = new ", "(", ", ", ".US);\n        Object[] ", " = new Object[", "];\n        ", "\n        ", ".format(", ".toString(), ", ");\n        ", " = UTF8String.fromString(", ".toString());\n      }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{pattern.code(), ev.isNull(), pattern.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), stringBuffer, sb, stringBuffer, formatter, form, formatter, sb, Locale.class.getName(), argList, BoxesRunTime.boxToInteger((int)numArgLists), argListCodes, form, pattern.value(), argList, ev.value(), sb})), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "format_string");
    }

    @Override
    public FormatString withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return new FormatString((Seq<Expression>)newChildren);
    }

    private void checkArgumentIndexNotZero(Expression expression) {
        String pattern;
        Option<String> option;
        Expression expression2 = expression;
        if (expression2 != null && !(option = StringLiteral$.MODULE$.unapply(expression2)).isEmpty() && (pattern = (String)option.get()).contains("%0$")) {
            throw QueryCompilationErrors$.MODULE$.zeroArgumentIndexError();
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public String productPrefix() {
        return "FormatString";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FormatString;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FormatString)) return false;
        boolean bl = true;
        if (!bl) return false;
        FormatString formatString = (FormatString)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = formatString.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!formatString.canEqual(this)) return false;
        return true;
    }

    public FormatString(Seq<Expression> children2) {
        block0: {
            this.children = children2;
            ExpectsInputTypes.$init$(this);
            Predef$.MODULE$.require(children2.nonEmpty(), (Function0 & Serializable)() -> new StringBuilder(34).append(this.prettyName()).append("() should take at least 1 argument").toString());
            if (BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.ALLOW_ZERO_INDEX_IN_FORMAT_STRING()))) break block0;
            this.checkArgumentIndexNotZero((Expression)children2.apply(0));
        }
    }
}

