/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted. The result data type is consistent with the value of\n      configuration `spark.sql.timestampType`.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\tmc\u0001\u0002\u0015*\u0001ZB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005o!A\u0011\f\u0001BK\u0002\u0013\u0005!\f\u0003\u0005_\u0001\tE\t\u0015!\u0003\\\u0011!y\u0006A!f\u0001\n\u0003\u0002\u0007\u0002C4\u0001\u0005#\u0005\u000b\u0011B1\t\u0011!\u0004!Q3A\u0005\u0002%D\u0001b\u001d\u0001\u0003\u0012\u0003\u0006IA\u001b\u0005\u0006i\u0002!\t!\u001e\u0005\tw\u0002A)\u0019!C!/\")A\u000f\u0001C\u0001y\")A\u000f\u0001C\u0001\u007f\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001bBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002T\u0001!\t&!\u0016\t\u0013\u0005\u0005\u0004!!A\u0005\u0002\u0005\r\u0004\"CA7\u0001E\u0005I\u0011AA8\u0011%\t)\tAI\u0001\n\u0003\t9\tC\u0005\u0002\f\u0002\t\n\u0011\"\u0001\u0002\u000e\"I\u0011\u0011\u0013\u0001\u0012\u0002\u0013\u0005\u00111\u0013\u0005\n\u0003/\u0003\u0011\u0011!C!\u00033C\u0011\"!+\u0001\u0003\u0003%\t!a+\t\u0013\u0005M\u0006!!A\u0005\u0002\u0005U\u0006\"CAa\u0001\u0005\u0005I\u0011IAb\u0011%\t\t\u000eAA\u0001\n\u0003\t\u0019\u000eC\u0005\u0002^\u0002\t\t\u0011\"\u0011\u0002`\"I\u00111\u001d\u0001\u0002\u0002\u0013\u0005\u0013Q]\u0004\n\u0005\u001fI\u0013\u0011!E\u0001\u0005#1\u0001\u0002K\u0015\u0002\u0002#\u0005!1\u0003\u0005\u0007i\u0002\"\tAa\u000b\t\u0013\t5\u0002%!A\u0005F\t=\u0002\"\u0003B\u0019A\u0005\u0005I\u0011\u0011B\u001a\u0011%\u0011i\u0004II\u0001\n\u0003\t\u0019\nC\u0005\u0003@\u0001\n\t\u0011\"!\u0003B!I!q\n\u0011\u0012\u0002\u0013\u0005\u00111\u0013\u0005\n\u0005#\u0002\u0013\u0011!C\u0005\u0005'\u0012\u0001\u0003U1sg\u0016$v\u000eV5nKN$\u0018-\u001c9\u000b\u0005)Z\u0013aC3yaJ,7o]5p]NT!\u0001L\u0017\u0002\u0011\r\fG/\u00197zgRT!AL\u0018\u0002\u0007M\fHN\u0003\u00021c\u0005)1\u000f]1sW*\u0011!gM\u0001\u0007CB\f7\r[3\u000b\u0003Q\n1a\u001c:h\u0007\u0001\u0019r\u0001A\u001c<}\u0005#%\n\u0005\u00029s5\t\u0011&\u0003\u0002;S\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ab\u0014BA\u001f*\u0005I\u0011VO\u001c;j[\u0016\u0014V\r\u001d7bG\u0016\f'\r\\3\u0011\u0005az\u0014B\u0001!*\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001dC\u0013\t\u0019\u0015FA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n9\u0001K]8ek\u000e$\bCA&T\u001d\ta\u0015K\u0004\u0002N!6\taJ\u0003\u0002Pk\u00051AH]8pizJ\u0011aR\u0005\u0003%\u001a\u000bq\u0001]1dW\u0006<W-\u0003\u0002U+\na1+\u001a:jC2L'0\u00192mK*\u0011!KR\u0001\u0005Y\u00164G/F\u00018\u0003\u0015aWM\u001a;!\u0003\u00191wN]7biV\t1\fE\u0002F9^J!!\u0018$\u0003\r=\u0003H/[8o\u0003\u001d1wN]7bi\u0002\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011A-L\u0001\u0006if\u0004Xm]\u0005\u0003M\u000e\u0014\u0001\u0002R1uCRK\b/Z\u0001\nI\u0006$\u0018\rV=qK\u0002\n!\u0002^5nKj{g.Z%e+\u0005Q\u0007cA#]WB\u0011A\u000e\u001d\b\u0003[:\u0004\"!\u0014$\n\u0005=4\u0015A\u0002)sK\u0012,g-\u0003\u0002re\n11\u000b\u001e:j]\u001eT!a\u001c$\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bY<\b0\u001f>\u0011\u0005a\u0002\u0001\"\u0002,\n\u0001\u00049\u0004\"B-\n\u0001\u0004Y\u0006\"B0\n\u0001\u0004\t\u0007b\u00025\n!\u0003\u0005\rA[\u0001\fe\u0016\u0004H.Y2f[\u0016tG\u000fF\u0002w{zDQAV\u0006A\u0002]BQ!W\u0006A\u0002]\"2A^A\u0001\u0011\u00151F\u00021\u00018\u0003!qw\u000eZ3OC6,W#A6\u0002)9|G-\u001a)biR,'O\\:J]R,'O\\1m)\t\tY\u0001E\u0003L\u0003\u001b\t\t\"C\u0002\u0002\u0010U\u00131aU3r!\u0011\t\u0019\"!\u000e\u000f\t\u0005U\u0011q\u0006\b\u0005\u0003/\tYC\u0004\u0003\u0002\u001a\u0005%b\u0002BA\u000e\u0003OqA!!\b\u0002&9!\u0011qDA\u0012\u001d\ri\u0015\u0011E\u0005\u0002i%\u0011!gM\u0005\u0003aEJ!AL\u0018\n\u00051j\u0013bAA\u0017W\u0005)AO]3fg&!\u0011\u0011GA\u001a\u0003-!&/Z3QCR$XM\u001d8\u000b\u0007\u000552&\u0003\u0003\u00028\u0005e\"a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:TA!!\r\u00024\u0005aq/\u001b;i)&lWMW8oKR\u0019\u0011)a\u0010\t\u000b!|\u0001\u0019A6\u0002\u0011\rD\u0017\u000e\u001c3sK:,\"!!\u0012\u0011\t-\u000biaN\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA&!\u0015Y\u0015QBA'!\r\u0011\u0017qJ\u0005\u0004\u0003#\u001a'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u00028\u0003/Bq!!\u0017\u0013\u0001\u0004\tY&A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007\u0003B&\u0002^]J1!a\u0018V\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u0005G>\u0004\u0018\u0010F\u0005w\u0003K\n9'!\u001b\u0002l!9ak\u0005I\u0001\u0002\u00049\u0004bB-\u0014!\u0003\u0005\ra\u0017\u0005\b?N\u0001\n\u00111\u0001b\u0011\u001dA7\u0003%AA\u0002)\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002r)\u001aq'a\u001d,\u0005\u0005U\u0004\u0003BA<\u0003\u0003k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a G\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0007\u000bIHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\n*\u001a1,a\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0012\u0016\u0004C\u0006M\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003+S3A[A:\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0014\t\u0005\u0003;\u000b9+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0016\u0001\u00026bm\u0006L1!]AP\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u000bE\u0002F\u0003_K1!!-G\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9,!0\u0011\u0007\u0015\u000bI,C\u0002\u0002<\u001a\u00131!\u00118z\u0011%\tyLGA\u0001\u0002\u0004\ti+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000b\u0004b!a2\u0002N\u0006]VBAAe\u0015\r\tYMR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAh\u0003\u0013\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011Q[An!\r)\u0015q[\u0005\u0004\u000334%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u007fc\u0012\u0011!a\u0001\u0003o\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u00111TAq\u0011%\ty,HA\u0001\u0002\u0004\ti+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003+\f9\u000fC\u0005\u0002@z\t\t\u00111\u0001\u00028\":\u0002!a;\u0002r\u0006M\u0018q_A}\u0003{\fyPa\u0001\u0003\u0006\t%!1\u0002\t\u0004q\u00055\u0018bAAxS\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA{\u0003\t%&\u0002\t\u0011!A}3UKT\"`QQLW.Z:uC6\u0004xl\u001d;s72\u0002c-\u001c;^S\u0001j\u0003\u0005U1sg\u0016\u001c\b\u0005\u001e5fA\u0001$\u0018.\\3ti\u0006l\u0007oX:ue\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!o&$\b\u000e\t;iK\u0002\u0002g-\u001c;aA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003\u0005^8!C\u0002\"\u0018.\\3ti\u0006l\u0007O\f\u0011SKR,(O\\:!]VdG\u000eI<ji\"\u0004\u0013N\u001c<bY&$\u0007%\u001b8qkRt\u0003EQ=!I\u00164\u0017-\u001e7uY\u0001JG\u000f\t4pY2|wo\u001d\u0011dCN$\u0018N\\4!eVdWm\u001d\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0005\u0004C/[7fgR\fW\u000e\u001d\u0011jM\u0002\"\b.\u001a\u0011aM6$\b\rI5tA=l\u0017\u000e\u001e;fI:\u0002C\u000b[3!e\u0016\u001cX\u000f\u001c;!I\u0006$\u0018\r\t;za\u0016\u0004\u0013n\u001d\u0011d_:\u001c\u0018n\u001d;f]R\u0004s/\u001b;iAQDW\r\t<bYV,\u0007e\u001c4\u000bA\u0001\u0002\u0003\u0005\t\u0011d_:4\u0017nZ;sCRLwN\u001c\u0011agB\f'o\u001b\u0018tc2tC/[7fgR\fW\u000e\u001d+za\u0016\u0004gF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002|\u0006\u0011iD\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lWm\u001d;b[B|6\u000f\u001e:![\u0001\n\u0005e\u001d;sS:<\u0007\u0005^8!E\u0016\u0004\u0003/\u0019:tK\u0012\u0004Co\u001c\u0011uS6,7\u000f^1na:R\u0001\u0005\t\u0011!A\u0001R\u0003EZ7uA5\u0002C+[7fgR\fW\u000e\u001d\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8!i>\u0004cm\u001c7m_^t\u0003eU3fAq\n\u0007\u0005\u001b:fMv\u0012\u0003\u000e\u001e;qgjzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40I>\u001c7o\f7bi\u0016\u001cHoL:rY6\u0012XMZ\u0017eCR,G/[7f[A\fG\u000f^3s]:BG/\u001c7#}\u0011\u000bG/\u001a;j[\u0016\u0004\u0003+\u0019;uKJt7\u000fP\u0018b}\u00012wN\u001d\u0011wC2LGM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t3bi\u0016\u0004\u0013M\u001c3!i&lW\r\t4pe6\fG\u000f\t9biR,'O\\:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t\u0005\u0011!!\u0015\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'\r\u001c.cIj3'\r\u00111ai\n$G\u000f\u00191O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\n$'L\u001a2AA\u0002$(\r\u001a;aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0013GM\u00174c\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0013GM\u00174c\u0001\u0002\u0004G\u000f\u00191uA\u0002$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\u001d\u0011A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005\u001b\tQA\r\u00183]A\n\u0001\u0003U1sg\u0016$v\u000eV5nKN$\u0018-\u001c9\u0011\u0005a\u00023#\u0002\u0011\u0003\u0016\t\u0005\u0002#\u0003B\f\u0005;94,\u00196w\u001b\t\u0011IBC\u0002\u0003\u001c\u0019\u000bqA];oi&lW-\u0003\u0003\u0003 \te!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!!1\u0005B\u0015\u001b\t\u0011)C\u0003\u0003\u0003(\u0005\r\u0016AA5p\u0013\r!&Q\u0005\u000b\u0003\u0005#\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\u000bQ!\u00199qYf$\u0012B\u001eB\u001b\u0005o\u0011IDa\u000f\t\u000bY\u001b\u0003\u0019A\u001c\t\u000be\u001b\u0003\u0019A.\t\u000b}\u001b\u0003\u0019A1\t\u000f!\u001c\u0003\u0013!a\u0001U\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r#1\n\t\u0005\u000br\u0013)\u0005E\u0004F\u0005\u000f:4,\u00196\n\u0007\t%cI\u0001\u0004UkBdW\r\u000e\u0005\t\u0005\u001b*\u0013\u0011!a\u0001m\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011)\u0006\u0005\u0003\u0002\u001e\n]\u0013\u0002\u0002B-\u0003?\u0013aa\u00142kK\u000e$\b")
public class ParseToTimestamp
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeZoneAwareExpression,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Option<Expression> format;
    private final DataType dataType;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private Expression canonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return ParseToTimestamp$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Option<Expression>, DataType, Option<String>>> unapply(ParseToTimestamp x$0) {
        return ParseToTimestamp$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return ParseToTimestamp$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Option<Expression>, DataType, Option<String>>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<DataType, Function1<Option<String>, ParseToTimestamp>>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    private Expression replacement$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)this.format().map((Function1 & Serializable)f -> new GetTimestamp(this.left(), (Expression)f, this.dataType(), this.timeZoneId(), GetTimestamp$.MODULE$.apply$default$5())).getOrElse((Function0 & Serializable)() -> new Cast(this.left(), this.dataType(), this.timeZoneId(), Cast$.MODULE$.apply$default$4()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String nodeName() {
        return "to_timestamp";
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.RUNTIME_REPLACEABLE()}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        DataType x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq types = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$}));
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)(this.dataType() instanceof TimestampType ? (Seq)types.$colon$plus((Object)NumericType$.MODULE$) : types));
        return (Seq)Option$.MODULE$.option2Iterable(this.format().map((Function1 & Serializable)x$7 -> StringType$.MODULE$)).toSeq().$plus$colon((Object)typeCollection);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.format().isDefined() ? this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3(), this.copy$default$4()) : this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, DataType dataType, Option<String> timeZoneId) {
        return new ParseToTimestamp(left, format, dataType, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public DataType copy$default$3() {
        return this.dataType();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.dataType();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            case 2: {
                string = "dataType";
                break;
            }
            case 3: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        DataType dataType = this.dataType();
        DataType dataType2 = parseToTimestamp.dataType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = parseToTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, DataType dataType, Option<String> timeZoneId) {
        this.left = left;
        this.format = format;
        this.dataType = dataType;
        this.timeZoneId = timeZoneId;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), SQLConf$.MODULE$.get().timestampType(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$4());
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, SQLConf$.MODULE$.get().timestampType(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$4());
    }
}

