/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.aggregate.HistogramNumeric$;
import org.apache.spark.sql.catalyst.expressions.aggregate.NumericHistogramSerializer$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.util.NumericHistogram;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, nb) - Computes a histogram on numeric 'expr' using nb bins.\n      The return value is an array of (x,y) pairs representing the centers of the\n      histogram's bins. As the value of 'nb' is increased, the histogram approximation\n      gets finer-grained, but may yield artifacts around outliers. In practice, 20-40\n      histogram bins appear to work well, with more bins being required for skewed or\n      smaller datasets. Note that this function creates a histogram with non-uniform\n      bin widths. It offers no guarantees in terms of the mean-squared-error of the\n      histogram, but in practice is comparable to the histograms produced by the R/S-Plus\n      statistical computing packages. Note: the output type of the 'x' field in the return value is\n      propagated from the input value consumed in the aggregate function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(col, 5) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [{\"x\":0,\"y\":1.0},{\"x\":1,\"y\":1.0},{\"x\":2,\"y\":1.0},{\"x\":10,\"y\":1.0}]\n  ", group="agg_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0005\t]e\u0001\u0002\u00192\u0001\u0002C\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\tY\u0002\u0011\t\u0012)A\u0005+\"AQ\u000e\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005o\u0001\tE\t\u0015!\u0003V\u0011!y\u0007A!f\u0001\n\u0003\u0002\b\u0002\u0003;\u0001\u0005#\u0005\u000b\u0011B9\t\u0011U\u0004!Q3A\u0005BAD\u0001B\u001e\u0001\u0003\u0012\u0003\u0006I!\u001d\u0005\u0006o\u0002!\t\u0001\u001f\u0005\u0006o\u0002!\tA \u0005\u000b\u0003\u0007\u0001\u0001R1A\u0005\n\u0005\u0015\u0001BCA\u0007\u0001!\u0015\r\u0011\"\u0003\u0002\u0010!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!!\u0016\u0001\t\u0003\n9\u0006C\u0004\u0002`\u0001!\t%!\u0019\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004BBAA\u0001\u0011\u00053\u000e\u0003\u0004\u0002\u0004\u0002!\te\u001b\u0005\b\u0003\u000b\u0003A\u0011KAD\u0011\u001d\t\t\n\u0001C!\u0003'Cq!!'\u0001\t\u0003\nY\nC\u0004\u0002 \u0002!\t%a\u0004\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u00111\u0016\u0001\u0005B\u00055\u0006\"CA`\u0001\u0005\u0005I\u0011AAa\u0011%\tY\rAI\u0001\n\u0003\ti\rC\u0005\u0002d\u0002\t\n\u0011\"\u0001\u0002N\"I\u0011Q\u001d\u0001\u0012\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0003W\u0004\u0011\u0013!C\u0001\u0003OD\u0011\"!<\u0001\u0003\u0003%\t%a<\t\u0011\u0005}\b!!A\u0005\u0002AD\u0011B!\u0001\u0001\u0003\u0003%\tAa\u0001\t\u0013\t%\u0001!!A\u0005B\t-\u0001\"\u0003B\r\u0001\u0005\u0005I\u0011\u0001B\u000e\u0011%\u0011y\u0002AA\u0001\n\u0003\u0012\t\u0003C\u0005\u0003&\u0001\t\t\u0011\"\u0011\u0003(\u001dI!1J\u0019\u0002\u0002#\u0005!Q\n\u0004\taE\n\t\u0011#\u0001\u0003P!1qO\u000bC\u0001\u0005OB\u0011B!\u001b+\u0003\u0003%)Ea\u001b\t\u0013\t5$&!A\u0005\u0002\n=\u0004\"\u0003B=U\u0005\u0005I\u0011\u0011B>\u0011%\u0011iIKA\u0001\n\u0013\u0011yI\u0001\tISN$xn\u001a:b[:+X.\u001a:jG*\u0011!gM\u0001\nC\u001e<'/Z4bi\u0016T!\u0001N\u001b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003m]\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003qe\n1a]9m\u0015\tQ4(A\u0003ta\u0006\u00148N\u0003\u0002={\u00051\u0011\r]1dQ\u0016T\u0011AP\u0001\u0004_J<7\u0001A\n\u0007\u0001\u0005[u\n\u00170\u0011\u0007\t\u001bU)D\u00012\u0013\t!\u0015G\u0001\rUsB,G-S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"AR%\u000e\u0003\u001dS!\u0001S\u001c\u0002\tU$\u0018\u000e\\\u0005\u0003\u0015\u001e\u0013\u0001CT;nKJL7\rS5ti><'/Y7\u0011\u00051kU\"A\u001a\n\u00059\u001b$AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0007A\u001bV+D\u0001R\u0015\t\u0011V'A\u0003ue\u0016,7/\u0003\u0002U#\nQ!)\u001b8befd\u0015n[3\u0011\u000513\u0016BA,4\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u00033rk\u0011A\u0017\u0006\u00027\u0006)1oY1mC&\u0011QL\u0017\u0002\b!J|G-^2u!\tyvM\u0004\u0002aK:\u0011\u0011\rZ\u0007\u0002E*\u00111mP\u0001\u0007yI|w\u000e\u001e \n\u0003mK!A\u001a.\u0002\u000fA\f7m[1hK&\u0011\u0001.\u001b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003Mj\u000bQa\u00195jY\u0012,\u0012!V\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u000b9\u0014\u0015N\\:\u0002\r9\u0014\u0015N\\:!\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$X#A9\u0011\u0005e\u0013\u0018BA:[\u0005\rIe\u000e^\u0001\u0018[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\nA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018!F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000beT8\u0010`?\u0011\u0005\t\u0003\u0001\"\u00026\n\u0001\u0004)\u0006\"B7\n\u0001\u0004)\u0006\"B8\n\u0001\u0004\t\b\"B;\n\u0001\u0004\tH\u0003B=\u0000\u0003\u0003AQA\u001b\u0006A\u0002UCQ!\u001c\u0006A\u0002U\u000b!A\u001c2\u0016\u0005\u0005\u001d\u0001cA-\u0002\n%\u0019\u00111\u0002.\u0003\u0007\u0005s\u00170\u0001\nqe>\u0004\u0018mZ1uK&s\u0007/\u001e;UsB,WCAA\t!\rI\u00161C\u0005\u0004\u0003+Q&a\u0002\"p_2,\u0017M\\\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA\u000e!\u0015y\u0016QDA\u0011\u0013\r\ty\"\u001b\u0002\u0004'\u0016\f\b\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001dr'A\u0003usB,7/\u0003\u0003\u0002,\u0005\u0015\"\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\t\u0004\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9$N\u0001\tC:\fG._:jg&!\u00111HA\u001b\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018aF2sK\u0006$X-Q4he\u0016<\u0017\r^5p]\n+hMZ3s)\u0005)\u0015AB;qI\u0006$X\rF\u0003F\u0003\u000b\nI\u0005\u0003\u0004\u0002HA\u0001\r!R\u0001\u0007EV4g-\u001a:\t\u000f\u0005-\u0003\u00031\u0001\u0002N\u0005A\u0011N\u001c9viJ{w\u000f\u0005\u0003\u0002P\u0005ES\"A\u001b\n\u0007\u0005MSGA\u0006J]R,'O\\1m%><\u0018!B7fe\u001e,G#B#\u0002Z\u0005m\u0003BBA$#\u0001\u0007Q\t\u0003\u0004\u0002^E\u0001\r!R\u0001\u0006_RDWM]\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002\b\u0005\r\u0004BBA$%\u0001\u0007Q)A\u0005tKJL\u0017\r\\5{KR!\u0011\u0011NA;!\u0015I\u00161NA8\u0013\r\tiG\u0017\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00043\u0006E\u0014bAA:5\n!!)\u001f;f\u0011\u0019\t9h\u0005a\u0001\u000b\u0006\u0019qN\u00196\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004\u000b\u0006u\u0004bBA@)\u0001\u0007\u0011\u0011N\u0001\u0006Ef$Xm]\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)\u00110!#\u0002\u000e\"1\u00111R\fA\u0002U\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\u0010^\u0001\r!V\u0001\t]\u0016<(+[4ii\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fF\u0002z\u0003+Ca!a&\u0019\u0001\u0004\t\u0018!\u00038fo>3gm]3u\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0019\u00110!(\t\r\u0005]\u0015\u00041\u0001r\u0003!qW\u000f\u001c7bE2,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u0015\u0006\u0003BA\u0012\u0003OKA!!+\u0002&\tAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a,\u0011\t\u0005E\u0016\u0011\u0018\b\u0005\u0003g\u000b)\f\u0005\u0002b5&\u0019\u0011q\u0017.\u0002\rA\u0013X\rZ3g\u0013\u0011\tY,!0\u0003\rM#(/\u001b8h\u0015\r\t9LW\u0001\u0005G>\u0004\u0018\u0010F\u0005z\u0003\u0007\f)-a2\u0002J\"9!.\bI\u0001\u0002\u0004)\u0006bB7\u001e!\u0003\u0005\r!\u0016\u0005\b_v\u0001\n\u00111\u0001r\u0011\u001d)X\u0004%AA\u0002E\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002P*\u001aQ+!5,\u0005\u0005M\u0007\u0003BAk\u0003?l!!a6\u000b\t\u0005e\u00171\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!8[\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\f9NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005%(fA9\u0002R\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002rB!\u00111_A\u007f\u001b\t\t)P\u0003\u0003\u0002x\u0006e\u0018\u0001\u00027b]\u001eT!!a?\u0002\t)\fg/Y\u0005\u0005\u0003w\u000b)0\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d!Q\u0001\u0005\t\u0005\u000f!\u0013\u0011!a\u0001c\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0004\u0011\r\t=!QCA\u0004\u001b\t\u0011\tBC\u0002\u0003\u0014i\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119B!\u0005\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003#\u0011i\u0002C\u0005\u0003\b\u0019\n\t\u00111\u0001\u0002\b\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\tPa\t\t\u0011\t\u001dq%!AA\u0002E\fa!Z9vC2\u001cH\u0003BA\t\u0005SA\u0011Ba\u0002)\u0003\u0003\u0005\r!a\u0002)'\u0001\u0011iCa\r\u00036\te\"1\bB \u0005\u0003\u0012)Ea\u0012\u0011\u00071\u0013y#C\u0002\u00032M\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00038\u00051\tL\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:-A9\u0014\u0017\u0006I\u0017!\u0007>l\u0007/\u001e;fg\u0002\n\u0007\u0005[5ti><'/Y7!_:\u0004c.^7fe&\u001c\u0007eJ3yaJ<\u0003%^:j]\u001e\u0004cN\u0019\u0011cS:\u001chF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fAI,G/\u001e:oAY\fG.^3!SN\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I8gA!BH&_\u0015!a\u0006L'o\u001d\u0011sKB\u0014Xm]3oi&tw\r\t;iK\u0002\u001aWM\u001c;feN\u0004sN\u001a\u0011uQ\u0016T\u0001\u0005\t\u0011!A\u0001B\u0017n\u001d;pOJ\fWnJ:!E&t7O\f\u0011Bg\u0002\"\b.\u001a\u0011wC2,X\rI8gA\u001dr'm\n\u0011jg\u0002Jgn\u0019:fCN,G\r\f\u0011uQ\u0016\u0004\u0003.[:u_\u001e\u0014\u0018-\u001c\u0011baB\u0014x\u000e_5nCRLwN\u001c\u0006!A\u0001\u0002\u0003\u0005I4fiN\u0004c-\u001b8fe6:'/Y5oK\u0012d\u0003EY;uA5\f\u0017\u0010I=jK2$\u0007%\u0019:uS\u001a\f7\r^:!CJ|WO\u001c3!_V$H.[3sg:\u0002\u0013J\u001c\u0011qe\u0006\u001cG/[2fY\u0001\u0012\u0004'\f\u001b1\u0015\u0001\u0002\u0003\u0005\t\u0011!Q&\u001cHo\\4sC6\u0004#-\u001b8tA\u0005\u0004\b/Z1sAQ|\u0007e^8sW\u0002:X\r\u001c7-A]LG\u000f\u001b\u0011n_J,\u0007EY5og\u0002\u0012W-\u001b8hAI,\u0017/^5sK\u0012\u0004cm\u001c:!g.,w/\u001a3!_JT\u0001\u0005\t\u0011!A\u0001\u001aX.\u00197mKJ\u0004C-\u0019;bg\u0016$8O\f\u0011O_R,\u0007\u0005\u001e5bi\u0002\"\b.[:!MVt7\r^5p]\u0002\u001a'/Z1uKN\u0004\u0013\r\t5jgR|wM]1nA]LG\u000f\u001b\u0011o_:lSO\\5g_Jl'\u0002\t\u0011!A\u0001\u0002#-\u001b8!o&$G\u000f[:/A%#\be\u001c4gKJ\u001c\bE\\8!OV\f'/\u00198uK\u0016\u001c\b%\u001b8!i\u0016\u0014Xn\u001d\u0011pM\u0002\"\b.\u001a\u0011nK\u0006tWf]9vCJ,G-L3se>\u0014\be\u001c4!i\",'\u0002\t\u0011!A\u0001\u0002\u0003.[:u_\u001e\u0014\u0018-\u001c\u0017!EV$\b%\u001b8!aJ\f7\r^5dK\u0002J7\u000fI2p[B\f'/\u00192mK\u0002\"x\u000e\t;iK\u0002B\u0017n\u001d;pOJ\fWn\u001d\u0011qe>$WoY3eA\tL\b\u0005\u001e5fAI{3+\f)mkNT\u0001\u0005\t\u0011!A\u0001\u001aH/\u0019;jgRL7-\u00197!G>l\u0007/\u001e;j]\u001e\u0004\u0003/Y2lC\u001e,7O\f\u0011O_R,'\b\t;iK\u0002zW\u000f\u001e9vi\u0002\"\u0018\u0010]3!_\u001a\u0004C\u000f[3!Oa<\u0003EZ5fY\u0012\u0004\u0013N\u001c\u0011uQ\u0016\u0004#/\u001a;ve:\u0004c/\u00197vK\u0002J7O\u0003\u0011!A\u0001\u0002\u0003\u0005\u001d:pa\u0006<\u0017\r^3eA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u00022\u0018\r\\;fA\r|gn];nK\u0012\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013mZ4sK\u001e\fG/\u001a\u0011gk:\u001cG/[8o])\u0001\u0003\u0005\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!\u0010\u0002\u0003\u001bR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mY\u0001*\u0014\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003\u0006M\u0015-A!\n\u0014\u0006\f\u0011)e%b\u0003\u0005K\u00191S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[(\u0005\u001f\u0012;a1\u0012\u0013P\t\u001e2]AjHf\u001f\u0012yEi\nDFI=#uEr\u0003' \u0017|Ea\u0014#H\r\u0017#s\nR\u0014G\f\u0019~Ym\u0014\u0003P\t\u001e2a1\u0012\u0013P\t\u001e2]AjXL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011\u0019%A\u0005bO\u001e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!\u0011J\u0001\u0006g9\u001ad\u0006M\u0001\u0011\u0011&\u001cHo\\4sC6tU/\\3sS\u000e\u0004\"A\u0011\u0016\u0014\u000b)\u0012\tF!\u0018\u0011\u0013\tM#\u0011L+VcFLXB\u0001B+\u0015\r\u00119FW\u0001\beVtG/[7f\u0013\u0011\u0011YF!\u0016\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0005\u0003\u0003`\t\u0015TB\u0001B1\u0015\u0011\u0011\u0019'!?\u0002\u0005%|\u0017b\u00015\u0003bQ\u0011!QJ\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011_\u0001\u0006CB\u0004H.\u001f\u000b\ns\nE$1\u000fB;\u0005oBQA[\u0017A\u0002UCQ!\\\u0017A\u0002UCQa\\\u0017A\u0002EDQ!^\u0017A\u0002E\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003~\t%\u0005#B-\u0003\u0000\t\r\u0015b\u0001BA5\n1q\n\u001d;j_:\u0004r!\u0017BC+V\u000b\u0018/C\u0002\u0003\bj\u0013a\u0001V;qY\u0016$\u0004\u0002\u0003BF]\u0005\u0005\t\u0019A=\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u0012B!\u00111\u001fBJ\u0013\u0011\u0011)*!>\u0003\r=\u0013'.Z2u\u0001")
public class HistogramNumeric
extends TypedImperativeAggregate<NumericHistogram>
implements ImplicitCastInputTypes,
BinaryLike<Expression>,
Serializable {
    private Object nb;
    private boolean propagateInputType;
    private final Expression child;
    private final Expression nBins;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient scala.collection.immutable.Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(HistogramNumeric x$0) {
        return HistogramNumeric$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, HistogramNumeric> tupled() {
        return HistogramNumeric$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, HistogramNumeric>>>> curried() {
        return HistogramNumeric$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private scala.collection.immutable.Seq<Expression> children$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final scala.collection.immutable.Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression nBins() {
        return this.nBins;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private Object nb$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Integer n;
                Object object = this.nBins().eval(this.nBins().eval$default$1());
                if (object == null) {
                    n = null;
                } else if (object instanceof Integer) {
                    int n2 = BoxesRunTime.unboxToInt((Object)object);
                    n = BoxesRunTime.boxToInteger((int)n2);
                } else {
                    throw new MatchError(object);
                }
                this.nb = n;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.nb;
    }

    private Object nb() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.nb$lzycompute() : this.nb;
    }

    private boolean propagateInputType$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.propagateInputType = SQLConf$.MODULE$.get().histogramNumericPropagateInputType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.propagateInputType;
    }

    private boolean propagateInputType() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.propagateInputType$lzycompute() : this.propagateInputType;
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((scala.collection.immutable.Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), IntegerType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.nBins().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(53).append(this.prettyName()).append(" needs the nBins provided must be a constant literal.").toString()) : (this.nb() == null ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(36).append(this.prettyName()).append(" needs nBins value must not be null.").toString()) : (BoxesRunTime.unboxToInt((Object)this.nb()) < 2 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(49).append(this.prettyName()).append(" needs nBins to be at least 2, but you supplied ").append(this.nb()).append(".").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NumericHistogram createAggregationBuffer() {
        void var1_1;
        NumericHistogram buffer = new NumericHistogram();
        buffer.allocate(BoxesRunTime.unboxToInt((Object)this.nb()));
        return var1_1;
    }

    @Override
    public NumericHistogram update(NumericHistogram buffer, InternalRow inputRow) {
        block0: {
            Object value = this.child().eval(inputRow);
            if (value == null) break block0;
            double doubleValue = ((Number)value).doubleValue();
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public NumericHistogram merge(NumericHistogram buffer, NumericHistogram other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(NumericHistogram buffer) {
        GenericArrayData genericArrayData;
        if (buffer.getUsedBins() < 1) {
            genericArrayData = null;
        } else {
            IndexedSeq result = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), buffer.getUsedBins()).map((Function1 & Serializable)index -> HistogramNumeric.$anonfun$eval$1(this, buffer, BoxesRunTime.unboxToInt((Object)index)));
            genericArrayData = new GenericArrayData((Seq<Object>)result);
        }
        return genericArrayData;
    }

    @Override
    public byte[] serialize(NumericHistogram obj) {
        return NumericHistogramSerializer$.MODULE$.serialize(obj);
    }

    @Override
    public NumericHistogram deserialize(byte[] bytes) {
        return NumericHistogramSerializer$.MODULE$.deserialize(bytes);
    }

    @Override
    public Expression left() {
        return this.child();
    }

    @Override
    public Expression right() {
        return this.nBins();
    }

    @Override
    public HistogramNumeric withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public HistogramNumeric withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public HistogramNumeric withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType(new StructType((StructField[])((Object[])new StructField[]{new StructField("x", this.propagateInputType() ? this.left().dataType() : DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("y", DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})), true);
    }

    @Override
    public String prettyName() {
        return "histogram_numeric";
    }

    public HistogramNumeric copy(Expression child, Expression nBins, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HistogramNumeric(child, nBins, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.nBins();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HistogramNumeric";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.nBins();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HistogramNumeric;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "nBins";
                break;
            }
            case 2: {
                string = "mutableAggBufferOffset";
                break;
            }
            case 3: {
                string = "inputAggBufferOffset";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HistogramNumeric)) return false;
        boolean bl = true;
        if (!bl) return false;
        HistogramNumeric histogramNumeric = (HistogramNumeric)x$1;
        if (this.mutableAggBufferOffset() != histogramNumeric.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != histogramNumeric.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = histogramNumeric.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.nBins();
        Expression expression4 = histogramNumeric.nBins();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!histogramNumeric.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ InternalRow $anonfun$eval$1(HistogramNumeric $this, NumericHistogram buffer$1, int index) {
        InternalRow internalRow;
        NumericHistogram.Coord coord = buffer$1.getBin(index);
        if ($this.propagateInputType()) {
            Number number;
            DataType dataType = $this.left().dataType();
            if (ByteType$.MODULE$.equals(dataType)) {
                number = BoxesRunTime.boxToByte((byte)((byte)coord.x));
            } else {
                boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType);
                if (bl) {
                    number = BoxesRunTime.boxToInteger((int)((int)coord.x));
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    number = BoxesRunTime.boxToFloat((float)((float)coord.x));
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    number = BoxesRunTime.boxToShort((short)((short)coord.x));
                } else {
                    boolean bl2 = dataType instanceof DayTimeIntervalType ? true : (LongType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)));
                    number = bl2 ? (Number)BoxesRunTime.boxToLong((long)((long)coord.x)) : (Number)BoxesRunTime.boxToDouble((double)coord.x);
                }
            }
            Byte result = number;
            internalRow = InternalRow$.MODULE$.apply((scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{result, BoxesRunTime.boxToDouble((double)coord.y)}));
        } else {
            internalRow = InternalRow$.MODULE$.apply((scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)coord.x), BoxesRunTime.boxToDouble((double)coord.y)}));
        }
        return internalRow;
    }

    public HistogramNumeric(Expression child, Expression nBins, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.nBins = nBins;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
    }

    public HistogramNumeric(Expression child, Expression nBins) {
        this(child, nBins, 0, 0);
    }
}

