/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import java.io.Serializable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParseException$;
import org.apache.spark.sql.catalyst.parser.SqlBaseParser;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;

public final class QueryParsingErrors$
implements QueryErrorsBase {
    public static final QueryParsingErrors$ MODULE$ = new QueryParsingErrors$();

    static {
        QueryErrorsBase.$init$(MODULE$);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(DataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    public Throwable invalidInsertIntoError(SqlBaseParser.InsertIntoContext ctx) {
        return new ParseException("Invalid InsertIntoContext", ctx);
    }

    public Throwable insertOverwriteDirectoryUnsupportedError(SqlBaseParser.InsertIntoContext ctx) {
        return new ParseException("INSERT OVERWRITE DIRECTORY is not supported", ctx);
    }

    public Throwable columnAliasInOperationNotAllowedError(String op, SqlBaseParser.TableAliasContext ctx) {
        return new ParseException(new StringBuilder(36).append("Columns aliases are not allowed in ").append(op).append(".").toString(), ctx.identifierList());
    }

    public Throwable emptySourceForMergeError(SqlBaseParser.MergeIntoTableContext ctx) {
        return new ParseException("Empty source for merge: you should specify a source table/subquery in merge.", ctx.source);
    }

    public Throwable unrecognizedMatchedActionError(SqlBaseParser.MatchedClauseContext ctx) {
        return new ParseException(new StringBuilder(29).append("Unrecognized matched action: ").append(ctx.matchedAction().getText()).toString(), ctx.matchedAction());
    }

    public Throwable insertedValueNumberNotMatchFieldNumberError(SqlBaseParser.NotMatchedClauseContext ctx) {
        return new ParseException("The number of inserted values cannot match the fields.", ctx.notMatchedAction());
    }

    public Throwable unrecognizedNotMatchedActionError(SqlBaseParser.NotMatchedClauseContext ctx) {
        return new ParseException(new StringBuilder(33).append("Unrecognized not matched action: ").append(ctx.notMatchedAction().getText()).toString(), ctx.notMatchedAction());
    }

    public Throwable mergeStatementWithoutWhenClauseError(SqlBaseParser.MergeIntoTableContext ctx) {
        return new ParseException("There must be at least one WHEN clause in a MERGE statement", ctx);
    }

    public Throwable nonLastMatchedClauseOmitConditionError(SqlBaseParser.MergeIntoTableContext ctx) {
        return new ParseException("When there are more than one MATCHED clauses in a MERGE statement, only the last MATCHED clause can omit the condition.", ctx);
    }

    public Throwable nonLastNotMatchedClauseOmitConditionError(SqlBaseParser.MergeIntoTableContext ctx) {
        return new ParseException("When there are more than one NOT MATCHED clauses in a MERGE statement, only the last NOT MATCHED clause can omit the condition.", ctx);
    }

    public Throwable emptyPartitionKeyError(String key, SqlBaseParser.PartitionSpecContext ctx) {
        return new ParseException(new StringBuilder(32).append("Found an empty partition key '").append(key).append("'.").toString(), ctx);
    }

    public Throwable combinationQueryResultClausesUnsupportedError(SqlBaseParser.QueryOrganizationContext ctx) {
        return new ParseException("Combination of ORDER BY/SORT BY/DISTRIBUTE BY/CLUSTER BY is not supported", ctx);
    }

    public Throwable distributeByUnsupportedError(SqlBaseParser.QueryOrganizationContext ctx) {
        return new ParseException("DISTRIBUTE BY is not supported", ctx);
    }

    public Throwable transformNotSupportQuantifierError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(0).append(new StringBuilder(17).append(this.toSQLStmt("TRANSFORM")).append(" does not support").toString()).append(new StringBuilder(12).append(" ").append(this.toSQLStmt("DISTINCT")).append("/").append(this.toSQLStmt("ALL")).append(" in inputs").toString()).toString()}), ctx);
    }

    public Throwable transformWithSerdeUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(42).append(this.toSQLStmt("TRANSFORM")).append(" with serde is only supported in hive mode").toString()}), ctx);
    }

    public Throwable lateralWithPivotInFromClauseNotAllowedError(SqlBaseParser.FromClauseContext ctx) {
        return new ParseException("LATERAL cannot be used together with PIVOT in FROM clause", ctx);
    }

    public Throwable lateralJoinWithNaturalJoinUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(17).append(this.toSQLStmt("LATERAL")).append(" join with ").append(this.toSQLStmt("NATURAL")).append(" join.").toString()}), ctx);
    }

    public Throwable lateralJoinWithUsingJoinUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(17).append(this.toSQLStmt("LATERAL")).append(" join with ").append(this.toSQLStmt("USING")).append(" join.").toString()}), ctx);
    }

    public Throwable unsupportedLateralJoinTypeError(ParserRuleContext ctx, String joinType) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(12).append(this.toSQLStmt("LATERAL")).append(" join type ").append(this.toSQLStmt(joinType)).append(".").toString()}), ctx);
    }

    public Throwable invalidLateralJoinRelationError(SqlBaseParser.RelationPrimaryContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(32).append(this.toSQLStmt("LATERAL")).append(" can only be used with subquery.").toString()}), ctx);
    }

    public Throwable repetitiveWindowDefinitionError(String name, SqlBaseParser.WindowClauseContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(40).append("The definition of window ").append(this.toSQLId(name)).append(" is repetitive.").toString()}), ctx);
    }

    public Throwable invalidWindowReferenceError(String name, SqlBaseParser.WindowClauseContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(48).append("Window reference ").append(this.toSQLId(name)).append(" is not a window specification.").toString()}), ctx);
    }

    public Throwable cannotResolveWindowReferenceError(String name, SqlBaseParser.WindowClauseContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(33).append("Cannot resolve window reference ").append(this.toSQLId(name)).append(".").toString()}), ctx);
    }

    public Throwable naturalCrossJoinUnsupportedError(SqlBaseParser.RelationContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(1).append(this.toSQLStmt("NATURAL CROSS JOIN")).append(".").toString()}), ctx);
    }

    public Throwable emptyInputForTableSampleError(ParserRuleContext ctx) {
        return new ParseException("TABLESAMPLE does not accept empty inputs.", ctx);
    }

    public Throwable tableSampleByBytesUnsupportedError(String msg, SqlBaseParser.SampleMethodContext ctx) {
        return new ParseException(new StringBuilder(30).append("TABLESAMPLE(").append(msg).append(") is not supported").toString(), ctx);
    }

    public Throwable invalidByteLengthLiteralError(String bytesStr, SqlBaseParser.SampleByBytesContext ctx) {
        return new ParseException(new StringBuilder(47).append(new StringBuilder(37).append(bytesStr).append(" is not a valid byte length literal, ").toString()).append("expected syntax: DIGIT+ ('B' | 'K' | 'M' | 'G')").toString(), ctx);
    }

    public Throwable invalidEscapeStringError(SqlBaseParser.PredicateContext ctx) {
        return new ParseException("Invalid escape string. Escape string must contain only one character.", ctx);
    }

    public Throwable trimOptionUnsupportedError(int trimOption, SqlBaseParser.TrimContext ctx) {
        return new ParseException(new StringBuilder(35).append("Function trim doesn't support with ").append(new StringBuilder(56).append("type ").append(trimOption).append(". Please use BOTH, LEADING or TRAILING as trim type").toString()).toString(), ctx);
    }

    public Throwable functionNameUnsupportedError(String functionName, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(28).append("Unsupported function name '").append(functionName).append("'").toString(), ctx);
    }

    public Throwable cannotParseValueTypeError(String valueType, String value, SqlBaseParser.TypeConstructorContext ctx) {
        return new ParseException(new StringBuilder(25).append("Cannot parse the ").append(valueType).append(" value: ").append(value).toString(), ctx);
    }

    public Throwable cannotParseIntervalValueError(String value, SqlBaseParser.TypeConstructorContext ctx) {
        return new ParseException(new StringBuilder(33).append("Cannot parse the INTERVAL value: ").append(value).toString(), ctx);
    }

    public Throwable literalValueTypeUnsupportedError(String valueType, SqlBaseParser.TypeConstructorContext ctx) {
        return new ParseException(new StringBuilder(48).append("Literals of type '").append(valueType).append("' are currently not supported.").toString(), ctx);
    }

    public Throwable parsingValueTypeError(IllegalArgumentException e, String valueType, SqlBaseParser.TypeConstructorContext ctx) {
        String message = (String)Option$.MODULE$.apply((Object)e.getMessage()).getOrElse((Function0 & Serializable)() -> new StringBuilder(18).append("Exception parsing ").append(valueType).toString());
        return new ParseException(message, ctx);
    }

    public Throwable invalidNumericLiteralRangeError(String rawStrippedQualifier, BigDecimal minValue, BigDecimal maxValue, String typeName, SqlBaseParser.NumberContext ctx) {
        return new ParseException(new StringBuilder(0).append(new StringBuilder(26).append("Numeric literal ").append(rawStrippedQualifier).append(" does not ").toString()).append(new StringBuilder(27).append("fit in range [").append(minValue).append(", ").append(maxValue).append("] for type ").append(typeName).toString()).toString(), ctx);
    }

    public Throwable moreThanOneFromToUnitInIntervalLiteralError(ParserRuleContext ctx) {
        return new ParseException("Can only have a single from-to unit in the interval literal syntax", ctx);
    }

    public Throwable invalidIntervalLiteralError(SqlBaseParser.IntervalContext ctx) {
        return new ParseException("at least one time unit should be given for interval literal", ctx);
    }

    public Throwable invalidIntervalFormError(String value, SqlBaseParser.MultiUnitsIntervalContext ctx) {
        return new ParseException(new StringBuilder(51).append("Can only use numbers in the interval value part for").append(new StringBuilder(65).append(" multiple unit value pairs interval form, but got invalid value: ").append(value).toString()).toString(), ctx);
    }

    public Throwable invalidFromToUnitValueError(SqlBaseParser.IntervalValueContext ctx) {
        return new ParseException("The value of from-to unit must be a string", ctx);
    }

    public Throwable fromToIntervalUnsupportedError(String from, String to, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(38).append("Intervals FROM ").append(from).append(" TO ").append(to).append(" are not supported.").toString(), ctx);
    }

    public Throwable mixedIntervalUnitsError(String literal, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(43).append("Cannot mix year-month and day-time fields: ").append(literal).toString(), ctx);
    }

    public Throwable dataTypeUnsupportedError(String dataType, SqlBaseParser.PrimitiveDataTypeContext ctx) {
        return new ParseException(new StringBuilder(27).append("DataType ").append(dataType).append(" is not supported.").toString(), ctx);
    }

    public Throwable charTypeMissingLengthError(String dataType, SqlBaseParser.PrimitiveDataTypeContext ctx) {
        return new ParseException("PARSE_CHAR_MISSING_LENGTH", (String[])((Object[])new String[]{dataType, dataType}), ctx);
    }

    public Throwable partitionTransformNotExpectedError(String name, String describe, SqlBaseParser.ApplyTransformContext ctx) {
        return new ParseException(new StringBuilder(44).append("Expected a column reference for transform ").append(name).append(": ").append(describe).toString(), ctx);
    }

    public Throwable tooManyArgumentsForTransformError(String name, SqlBaseParser.ApplyTransformContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(33).append("Too many arguments for transform ").append(this.toSQLId(name)).toString()}), ctx);
    }

    public Throwable invalidBucketsNumberError(String describe, SqlBaseParser.ApplyTransformContext ctx) {
        return new ParseException(new StringBuilder(27).append("Invalid number of buckets: ").append(describe).toString(), ctx);
    }

    public ParseException cannotCleanReservedNamespacePropertyError(String property, ParserRuleContext ctx, String msg) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(36).append(property).append(" is a reserved namespace property, ").append(msg).append(".").toString()}), ctx);
    }

    public ParseException propertiesAndDbPropertiesBothSpecifiedError(SqlBaseParser.CreateNamespaceContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{"set PROPERTIES and DBPROPERTIES at the same time."}), ctx);
    }

    public ParseException cannotCleanReservedTablePropertyError(String property, ParserRuleContext ctx, String msg) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(32).append(property).append(" is a reserved table property, ").append(msg).append(".").toString()}), ctx);
    }

    public Throwable duplicatedTablePathsFoundError(String pathOne, String pathTwo, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(0).append(new StringBuilder(49).append("Duplicated table paths found: '").append(pathOne).append("' and '").append(pathTwo).append("'. LOCATION").toString()).append(" and the case insensitive key 'path' in OPTIONS are all used to indicate the custom").append(" table path, you can only specify one of them.").toString(), ctx);
    }

    public Throwable storedAsAndStoredByBothSpecifiedError(SqlBaseParser.CreateFileFormatContext ctx) {
        return new ParseException("Expected either STORED AS or STORED BY, not both", ctx);
    }

    public Throwable operationInHiveStyleCommandUnsupportedError(String operation, String command, SqlBaseParser.StatementContext ctx, Option<String> msgOpt) {
        String basicError = new StringBuilder(32).append(operation).append(" is not supported in Hive-style ").append(command).toString();
        String msg = msgOpt.isDefined() ? new StringBuilder(3).append(basicError).append(", ").append(msgOpt.get()).append(".").toString() : basicError;
        return new ParseException(msg, ctx);
    }

    public Option<String> operationInHiveStyleCommandUnsupportedError$default$4() {
        return None$.MODULE$;
    }

    public Throwable operationNotAllowedError(String message, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(23).append("Operation not allowed: ").append(message).toString(), ctx);
    }

    public Throwable descColumnForPartitionUnsupportedError(SqlBaseParser.DescribeRelationContext ctx) {
        return new ParseException("DESC TABLE COLUMN for a specific partition is not supported", ctx);
    }

    public Throwable incompletePartitionSpecificationError(String key, SqlBaseParser.DescribeRelationContext ctx) {
        return new ParseException(new StringBuilder(41).append("PARTITION specification is incomplete: `").append(key).append("`").toString(), ctx);
    }

    public Throwable computeStatisticsNotExpectedError(SqlBaseParser.IdentifierContext ctx) {
        return new ParseException(new StringBuilder(31).append("Expected `NOSCAN` instead of `").append(ctx.getText()).append("`").toString(), ctx);
    }

    public Throwable addCatalogInCacheTableAsSelectNotAllowedError(String quoted, SqlBaseParser.CacheTableContext ctx) {
        return new ParseException(new StringBuilder(39).append(new StringBuilder(54).append("It is not allowed to add catalog/namespace prefix ").append(quoted).append(" to ").toString()).append("the table name in CACHE TABLE AS SELECT").toString(), ctx);
    }

    public Throwable showFunctionsUnsupportedError(String identifier, SqlBaseParser.IdentifierContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(16).append(this.toSQLStmt("SHOW")).append(" ").append(identifier).append(" ").append(this.toSQLStmt("FUNCTIONS")).append(" not supported").toString()}), ctx);
    }

    public Throwable showFunctionsInvalidPatternError(String pattern, ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(0).append(new StringBuilder(23).append("Invalid pattern in ").append(this.toSQLStmt("SHOW FUNCTIONS")).append(": ").append(this.toSQLId(pattern)).append(". ").toString()).append(new StringBuilder(22).append("It must be a ").append(this.toSQLType(StringType$.MODULE$)).append(" literal.").toString()).toString()}), ctx);
    }

    public Throwable duplicateCteDefinitionNamesError(String duplicateNames, SqlBaseParser.CtesContext ctx) {
        return new ParseException(new StringBuilder(44).append("CTE definition can't have duplicate names: ").append(duplicateNames).append(".").toString(), ctx);
    }

    public Throwable sqlStatementUnsupportedError(String sqlText, Origin position) {
        return new ParseException((Option<String>)Option$.MODULE$.apply((Object)sqlText), "Unsupported SQL statement", position, position, ParseException$.MODULE$.$lessinit$greater$default$5(), ParseException$.MODULE$.$lessinit$greater$default$6());
    }

    public Throwable unquotedIdentifierError(String ident, SqlBaseParser.ErrorIdentContext ctx) {
        return new ParseException(new StringBuilder(0).append(new StringBuilder(40).append("Possibly unquoted identifier ").append(ident).append(" detected. ").toString()).append(new StringBuilder(49).append("Please consider quoting it with back-quotes as `").append(ident).append("`").toString()).toString(), ctx);
    }

    public Throwable duplicateClausesError(String clauseName, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(25).append("Found duplicate clauses: ").append(clauseName).toString(), ctx);
    }

    public Throwable duplicateKeysError(String key, ParserRuleContext ctx) {
        return new ParseException("DUPLICATE_KEY", (String[])((Object[])new String[]{this.toSQLId(key)}), ctx);
    }

    public Throwable unexpectedFomatForSetConfigurationError(ParserRuleContext ctx) {
        return new ParseException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |Expected format is 'SET', 'SET key', or 'SET key=value'. If you want to include\n         |special characters in key, or include semicolon in value, please use quotes,\n         |e.g., SET `ke y`=`v;alue`.\n       ")).replaceAll("\n", " "), ctx);
    }

    public ParseException invalidPropertyKeyForSetQuotedConfigurationError(String keyCandidate, String valueStr, ParserRuleContext ctx) {
        return new ParseException("INVALID_PROPERTY_KEY", (String[])((Object[])new String[]{this.toSQLConf(keyCandidate), this.toSQLConf(keyCandidate), this.toSQLConf(valueStr)}), ctx);
    }

    public ParseException invalidPropertyValueForSetQuotedConfigurationError(String valueCandidate, String keyStr, ParserRuleContext ctx) {
        return new ParseException("INVALID_PROPERTY_VALUE", (String[])((Object[])new String[]{this.toSQLConf(valueCandidate), this.toSQLConf(keyStr), this.toSQLConf(valueCandidate)}), ctx);
    }

    public Throwable unexpectedFormatForResetConfigurationError(SqlBaseParser.ResetConfigurationContext ctx) {
        return new ParseException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |Expected format is 'RESET' or 'RESET key'. If you want to include special characters\n         |in key, please use quotes, e.g., RESET `ke y`.\n       ")).replaceAll("\n", " "), ctx);
    }

    public Throwable intervalValueOutOfRangeError(SqlBaseParser.IntervalContext ctx) {
        return new ParseException("The interval value must be in the range of [-18, +18] hours with second precision", ctx);
    }

    public Throwable invalidTimeZoneDisplacementValueError(SqlBaseParser.SetTimeZoneContext ctx) {
        return new ParseException("Invalid time zone displacement value", ctx);
    }

    public Throwable createTempTableNotSpecifyProviderError(SqlBaseParser.CreateTableContext ctx) {
        return new ParseException("CREATE TEMPORARY TABLE without a provider is not allowed.", ctx);
    }

    public Throwable rowFormatNotUsedWithStoredAsError(SqlBaseParser.CreateTableLikeContext ctx) {
        return new ParseException("'ROW FORMAT' must be used with 'STORED AS'", ctx);
    }

    public Throwable useDefinedRecordReaderOrWriterClassesError(ParserRuleContext ctx) {
        return new ParseException("Unsupported operation: Used defined record reader/writer classes.", ctx);
    }

    public Throwable directoryPathAndOptionsPathBothSpecifiedError(SqlBaseParser.InsertOverwriteDirContext ctx) {
        return new ParseException("Directory path and 'path' in OPTIONS should be specified one, but not both", ctx);
    }

    public Throwable unsupportedLocalFileSchemeError(SqlBaseParser.InsertOverwriteDirContext ctx) {
        return new ParseException("LOCAL is supported only with file: scheme", ctx);
    }

    public Throwable invalidGroupingSetError(String element, SqlBaseParser.GroupingAnalyticsContext ctx) {
        return new ParseException(new StringBuilder(45).append("Empty set in ").append(element).append(" grouping sets is not supported.").toString(), ctx);
    }

    public Throwable createViewWithBothIfNotExistsAndReplaceError(SqlBaseParser.CreateViewContext ctx) {
        return new ParseException("CREATE VIEW with both IF NOT EXISTS and REPLACE is not allowed.", ctx);
    }

    public Throwable defineTempViewWithIfNotExistsError(SqlBaseParser.CreateViewContext ctx) {
        return new ParseException("It is not allowed to define a TEMPORARY view with IF NOT EXISTS.", ctx);
    }

    public Throwable notAllowedToAddDBPrefixForTempViewError(String database, SqlBaseParser.CreateViewContext ctx) {
        return new ParseException(new StringBuilder(72).append("It is not allowed to add database prefix `").append(database).append("` for the TEMPORARY view name.").toString(), ctx);
    }

    public Throwable createFuncWithBothIfNotExistsAndReplaceError(SqlBaseParser.CreateFunctionContext ctx) {
        return new ParseException("CREATE FUNCTION with both IF NOT EXISTS and REPLACE is not allowed.", ctx);
    }

    public Throwable defineTempFuncWithIfNotExistsError(SqlBaseParser.CreateFunctionContext ctx) {
        return new ParseException("It is not allowed to define a TEMPORARY function with IF NOT EXISTS.", ctx);
    }

    public Throwable unsupportedFunctionNameError(String quoted, SqlBaseParser.CreateFunctionContext ctx) {
        return new ParseException(new StringBuilder(28).append("Unsupported function name '").append(quoted).append("'").toString(), ctx);
    }

    public Throwable specifyingDBInCreateTempFuncError(String databaseName, SqlBaseParser.CreateFunctionContext ctx) {
        return new ParseException(new StringBuilder(69).append("Specifying a database in CREATE TEMPORARY FUNCTION is not allowed: '").append(databaseName).append("'").toString(), ctx);
    }

    public Throwable invalidTableValuedFunctionNameError(Seq<String> name, SqlBaseParser.TableValuedFunctionContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{"table valued function cannot specify database name ", this.toSQLId(name)}), ctx);
    }

    public Throwable unclosedBracketedCommentError(String command, Origin position) {
        return new ParseException((Option<String>)new Some((Object)command), "Unclosed bracketed comment", position, position, ParseException$.MODULE$.$lessinit$greater$default$5(), ParseException$.MODULE$.$lessinit$greater$default$6());
    }

    public Throwable invalidTimeTravelSpec(String reason, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(27).append("Invalid time travel spec: ").append(reason).append(".").toString(), ctx);
    }

    public Throwable invalidNameForDropTempFunc(Seq<String> name, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(61).append("DROP TEMPORARY FUNCTION requires a single part name but got: ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(name).quoted()).toString(), ctx);
    }

    private QueryParsingErrors$() {
    }
}

