/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.AsOfTimestamp;
import org.apache.spark.sql.catalyst.analysis.AsOfVersion;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class TimeTravelSpec$ {
    public static final TimeTravelSpec$ MODULE$ = new TimeTravelSpec$();

    public Option<TimeTravelSpec> create(Option<Expression> timestamp, Option<String> version, SQLConf conf) {
        Object object;
        if (timestamp.nonEmpty() && version.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.invalidTimeTravelSpecError();
        }
        if (timestamp.nonEmpty()) {
            InternalRow x$1;
            Some tz;
            Expression ts = (Expression)timestamp.get();
            Predef$.MODULE$.assert(ts.resolved() && ts.references().isEmpty() && !SubqueryExpression$.MODULE$.hasSubquery(ts));
            if (!Cast$.MODULE$.canAnsiCast(ts.dataType(), TimestampType$.MODULE$)) {
                throw QueryCompilationErrors$.MODULE$.invalidTimestampExprForTimeTravel(ts);
            }
            Expression tsToEval = (Expression)ts.transform(new Serializable(ts){
                private static final long serialVersionUID = 0L;
                private final Expression ts$1;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof RuntimeReplaceable) {
                        RuntimeReplaceable runtimeReplaceable = (RuntimeReplaceable)((Object)A1);
                        object = runtimeReplaceable.replacement();
                    } else {
                        if (A1 instanceof Unevaluable) {
                            throw QueryCompilationErrors$.MODULE$.invalidTimestampExprForTimeTravel(this.ts$1);
                        }
                        if (!A1.deterministic()) {
                            throw QueryCompilationErrors$.MODULE$.invalidTimestampExprForTimeTravel(this.ts$1);
                        }
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    boolean bl = expression instanceof RuntimeReplaceable ? true : (expression instanceof Unevaluable ? true : !expression.deterministic());
                    return bl;
                }
                {
                    this.ts$1 = ts$1;
                }
            });
            Cast qual$1 = Cast$.MODULE$.apply(tsToEval, (DataType)TimestampType$.MODULE$, (Option<String>)(tz = new Some((Object)conf.sessionLocalTimeZone())), false);
            Object value = qual$1.eval(x$1 = qual$1.eval$default$1());
            if (value == null) {
                throw QueryCompilationErrors$.MODULE$.invalidTimestampExprForTimeTravel(ts);
            }
            object = new Some((Object)new AsOfTimestamp(BoxesRunTime.unboxToLong((Object)value)));
        } else {
            object = version.nonEmpty() ? new Some((Object)new AsOfVersion((String)version.get())) : None$.MODULE$;
        }
        return object;
    }

    private TimeTravelSpec$() {
    }
}

