/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayInsert$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(x, pos, val) - Places val into index pos of array x.\n      Array indices start at 1, or start from the end if index is negative.\n      Index above array size appends the array, or prepends the array if index is negative,\n      with 'null' elements.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, 4), 5, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(array(5, 3, 2, 1), -3, 4);\n       [5,4,3,2,1]\n  ", group="array_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\tMd\u0001\u0002\u0015*\u0001ZB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tC\u0002\u0011\t\u0012)A\u0005=\"A!\r\u0001BK\u0002\u0013\u0005Q\f\u0003\u0005d\u0001\tE\t\u0015!\u0003_\u0011!!\u0007A!f\u0001\n\u0003i\u0006\u0002C3\u0001\u0005#\u0005\u000b\u0011\u00020\t\u000b\u0019\u0004A\u0011A4\t\u000b1\u0004A\u0011I7\t\u000b]\u0004A\u0011\t=\t\r}\u0004A\u0011IA\u0001\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!!\n\u0001\t\u0003\n9\u0003\u0003\u0004\u0002D\u0001!\t%\u0018\u0005\u0007\u0003\u000b\u0002A\u0011I/\t\r\u0005\u001d\u0003\u0001\"\u0011^\u0011\u001d\tI\u0005\u0001C!\u0003\u0017Bq!!\u0018\u0001\t\u0003\ny\u0006C\u0004\u0002h\u0001!\t%!\u001b\t\u0015\u0005E\u0004\u0001#b\u0001\n\u0013\ty\u0006C\u0004\u0002|\u0001!\t&! \t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"I\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003W\u0003\u0011\u0013!C\u0001\u0003[C\u0011\"a1\u0001#\u0003%\t!!,\t\u0013\u0005\u0015\u0007!%A\u0005\u0002\u00055\u0006\"CAd\u0001\u0005\u0005I\u0011IAe\u0011%\tI\u000eAA\u0001\n\u0003\tY\u000eC\u0005\u0002d\u0002\t\t\u0011\"\u0001\u0002f\"I\u00111\u001e\u0001\u0002\u0002\u0013\u0005\u0013Q\u001e\u0005\n\u0003w\u0004\u0011\u0011!C\u0001\u0003{D\u0011B!\u0001\u0001\u0003\u0003%\tEa\u0001\t\u0013\t\u001d\u0001!!A\u0005B\t%q!\u0003B\u0017S\u0005\u0005\t\u0012\u0001B\u0018\r!A\u0013&!A\t\u0002\tE\u0002B\u00024#\t\u0003\u0011I\u0005C\u0005\u0003L\t\n\t\u0011\"\u0012\u0003N!I!q\n\u0012\u0002\u0002\u0013\u0005%\u0011\u000b\u0005\n\u00053\u0012\u0013\u0011!CA\u00057B\u0011B!\u001b#\u0003\u0003%IAa\u001b\u0003\u0017\u0005\u0013(/Y=J]N,'\u000f\u001e\u0006\u0003U-\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A&L\u0001\tG\u0006$\u0018\r\\=ti*\u0011afL\u0001\u0004gFd'B\u0001\u00192\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0004\u0001MA\u0001aN\u001e?\u0003\u001eS\u0005\u000b\u0005\u00029s5\t\u0011&\u0003\u0002;S\t\tB+\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ab\u0014BA\u001f*\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001d@\u0013\t\u0001\u0015F\u0001\u000fD_6\u0004H.\u001a=UsB,W*\u001a:hS:<W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\t+U\"A\"\u000b\u0005\u0011k\u0013AB3se>\u00148/\u0003\u0002G\u0007\ny\u0011+^3ss\u0016\u0013(o\u001c:t\u0005\u0006\u001cX\r\u0005\u00029\u0011&\u0011\u0011*\u000b\u0002\u0014'V\u0004\bo\u001c:u#V,'/_\"p]R,\u0007\u0010\u001e\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\n\u0014\u0002\b!J|G-^2u!\t\t\u0016L\u0004\u0002S/:\u00111KV\u0007\u0002)*\u0011Q+N\u0001\u0007yI|w\u000e\u001e \n\u00035K!\u0001\u0017'\u0002\u000fA\f7m[1hK&\u0011!l\u0017\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u000312\u000bAb\u001d:d\u0003J\u0014\u0018-_#yaJ,\u0012A\u0018\t\u0003q}K!\u0001Y\u0015\u0003\u0015\u0015C\bO]3tg&|g.A\u0007te\u000e\f%O]1z\u000bb\u0004(\u000fI\u0001\ba>\u001cX\t\u001f9s\u0003!\u0001xn]#yaJ\u0004\u0013\u0001C5uK6,\u0005\u0010\u001d:\u0002\u0013%$X-\\#yaJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003iS*\\\u0007C\u0001\u001d\u0001\u0011\u0015av\u00011\u0001_\u0011\u0015\u0011w\u00011\u0001_\u0011\u0015!w\u00011\u0001_\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002]B\u0019\u0011k\\9\n\u0005A\\&aA*fcB\u0011!/^\u0007\u0002g*\u0011A/L\u0001\u0006if\u0004Xm]\u0005\u0003mN\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003e\u0004\"A_?\u000e\u0003mT!\u0001`\u0016\u0002\u0011\u0005t\u0017\r\\=tSNL!A`>\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fA!\u001a<bYR!\u00111AA\u0005!\rY\u0015QA\u0005\u0004\u0003\u000fa%aA!os\"I\u00111\u0002\u0006\u0011\u0002\u0003\u0007\u0011QB\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003\u001f\t\t\"D\u0001,\u0013\r\t\u0019b\u000b\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0005\u0002\u0004\u0005e\u0011QDA\u0011\u0011\u001d\tYb\u0003a\u0001\u0003\u0007\t1!\u0019:s\u0011\u001d\tyb\u0003a\u0001\u0003\u0007\t1\u0001]8t\u0011\u001d\t\u0019c\u0003a\u0001\u0003\u0007\tA!\u001b;f[\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003S\t)$a\u0010\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\f*\u0003\u001d\u0019w\u000eZ3hK:LA!a\r\u0002.\tAQ\t\u001f9s\u0007>$W\rC\u0004\u000281\u0001\r!!\u000f\u0002\u0007\r$\b\u0010\u0005\u0003\u0002,\u0005m\u0012\u0002BA\u001f\u0003[\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002B1\u0001\r!!\u000b\u0002\u0005\u00154\u0018!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0014\u0011\t\u0005=\u0013q\u000b\b\u0005\u0003#\n\u0019\u0006\u0005\u0002T\u0019&\u0019\u0011Q\u000b'\u0002\rA\u0013X\rZ3g\u0013\u0011\tI&a\u0017\u0003\rM#(/\u001b8h\u0015\r\t)\u0006T\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011\u0011\r\t\u0004e\u0006\r\u0014bAA3g\nAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\t\tY\u0007E\u0002L\u0003[J1!a\u001cM\u0005\u001d\u0011un\u001c7fC:\f1\"\u001a7f[\u0016tG\u000fV=qK\"\u001a1#!\u001e\u0011\u0007-\u000b9(C\u0002\u0002z1\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u00025\u0002\u0000\u0005\r\u0015q\u0011\u0005\u0007\u0003\u0003#\u0002\u0019\u00010\u0002\u001f9,wo\u0015:d\u0003J\u0014\u0018-_#yaJDa!!\"\u0015\u0001\u0004q\u0016A\u00038foB{7/\u0012=qe\"1\u0011\u0011\u0012\u000bA\u0002y\u000b1B\\3x\u0013R,W.\u0012=qe\u0006\u0001\u0012N\\5u#V,'/_\"p]R,\u0007\u0010\u001e\u000b\u0003\u0003\u001f\u0003RaSAI\u0003+K1!a%M\u0005\u0019y\u0005\u000f^5p]B!\u0011qSAO\u001b\t\tIJC\u0002\u0002\u001c.\nQ\u0001\u001e:fKNLA!a(\u0002\u001a\ny1+\u0015'Rk\u0016\u0014\u0018pQ8oi\u0016DH/\u0001\u0003d_BLHc\u00025\u0002&\u0006\u001d\u0016\u0011\u0016\u0005\b9Z\u0001\n\u00111\u0001_\u0011\u001d\u0011g\u0003%AA\u0002yCq\u0001\u001a\f\u0011\u0002\u0003\u0007a,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=&f\u00010\u00022.\u0012\u00111\u0017\t\u0005\u0003k\u000by,\u0004\u0002\u00028*!\u0011\u0011XA^\u0003%)hn\u00195fG.,GMC\u0002\u0002>2\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t-a.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a3\u0011\t\u00055\u0017q[\u0007\u0003\u0003\u001fTA!!5\u0002T\u0006!A.\u00198h\u0015\t\t).\u0001\u0003kCZ\f\u0017\u0002BA-\u0003\u001f\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!8\u0011\u0007-\u000by.C\u0002\u0002b2\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0001\u0002h\"I\u0011\u0011\u001e\u000f\u0002\u0002\u0003\u0007\u0011Q\\\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\bCBAy\u0003o\f\u0019!\u0004\u0002\u0002t*\u0019\u0011Q\u001f'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002z\u0006M(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001b\u0002\u0000\"I\u0011\u0011\u001e\u0010\u0002\u0002\u0003\u0007\u00111A\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002L\n\u0015\u0001\"CAu?\u0005\u0005\t\u0019AAo\u0003\u0019)\u0017/^1mgR!\u00111\u000eB\u0006\u0011%\tI\u000fIA\u0001\u0002\u0004\t\u0019\u0001K\n\u0001\u0005\u001f\u0011)Ba\u0006\u0003\u001c\tu!\u0011\u0005B\u0012\u0005O\u0011I\u0003E\u00029\u0005#I1Aa\u0005*\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0007\u0002\u0005\u001fQ\u0001\u0005\t\u0011!?\u001a+fjQ0)q2\u0002\u0003o\\:-AY\fG.\u000b\u0011.AAc\u0017mY3tAY\fG\u000eI5oi>\u0004\u0013N\u001c3fq\u0002\u0002xn\u001d\u0011pM\u0002\n'O]1zAat#\u0002\t\u0011!A\u0001\u0002\u0013I\u001d:bs\u0002Jg\u000eZ5dKN\u00043\u000f^1si\u0002\nG\u000fI\u0019-A=\u0014\be\u001d;beR\u0004cM]8nAQDW\rI3oI\u0002Jg\rI5oI\u0016D\b%[:!]\u0016<\u0017\r^5wK:R\u0001\u0005\t\u0011!A\u0001Je\u000eZ3yA\u0005\u0014wN^3!CJ\u0014\u0018-\u001f\u0011tSj,\u0007%\u00199qK:$7\u000f\t;iK\u0002\n'O]1zY\u0001z'\u000f\t9sKB,g\u000eZ:!i\",\u0007%\u0019:sCf\u0004\u0013N\u001a\u0011j]\u0012,\u0007\u0010I5tA9,w-\u0019;jm\u0016d#\u0002\t\u0011!A\u0001\u0002s/\u001b;iA\u001drW\u000f\u001c7(A\u0015dW-\\3oiNt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\b\u0002\u0003cQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001aD\u0006\t\u001b*Y\u0001*D\u0006I\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0016\u0007\f\u001a-g1\"D&N/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)k1\u00023\u0007\f\u00113Y\u0001\n\u0014\u0006\f\u0011.g1\u0002C'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7VbC\u0007L\u001a-e1\nTL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011)#A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\u0016\u0003\u0015\u0019d\u0006\u000e\u00181\u0003-\t%O]1z\u0013:\u001cXM\u001d;\u0011\u0005a\u00123#\u0002\u0012\u00034\t}\u0002\u0003\u0003B\u001b\u0005wqfL\u00185\u000e\u0005\t]\"b\u0001B\u001d\u0019\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u001f\u0005o\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u0011\tEa\u0012\u000e\u0005\t\r#\u0002\u0002B#\u0003'\f!![8\n\u0007i\u0013\u0019\u0005\u0006\u0002\u00030\u0005AAo\\*ue&tw\r\u0006\u0002\u0002L\u0006)\u0011\r\u001d9msR9\u0001Na\u0015\u0003V\t]\u0003\"\u0002/&\u0001\u0004q\u0006\"\u00022&\u0001\u0004q\u0006\"\u00023&\u0001\u0004q\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005;\u0012)\u0007E\u0003L\u0003#\u0013y\u0006\u0005\u0004L\u0005CrfLX\u0005\u0004\u0005Gb%A\u0002+va2,7\u0007\u0003\u0005\u0003h\u0019\n\t\u00111\u0001i\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005[\u0002B!!4\u0003p%!!\u0011OAh\u0005\u0019y%M[3di\u0002")
public class ArrayInsert
extends TernaryExpression
implements ImplicitCastInputTypes,
ComplexTypeMergingExpression,
QueryErrorsBase,
SupportQueryContext {
    private transient DataType elementType;
    private final Expression srcArrayExpr;
    private final Expression posExpr;
    private final Expression itemExpr;
    private Option<SQLQueryContext> queryContext;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(ArrayInsert x$0) {
        return ArrayInsert$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, ArrayInsert> tupled() {
        return ArrayInsert$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, ArrayInsert>>> curried() {
        return ArrayInsert$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Expression srcArrayExpr() {
        return this.srcArrayExpr;
    }

    public Expression posExpr() {
        return this.posExpr;
    }

    public Expression itemExpr() {
        return this.itemExpr;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple3 tuple3 = new Tuple3((Object)this.srcArrayExpr().dataType(), (Object)this.posExpr().dataType(), (Object)this.itemExpr().dataType());
        if (tuple3 != null) {
            DataType dataType = (DataType)tuple3._1();
            DataType e2 = (DataType)tuple3._2();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        Seq seq2;
                        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e3);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            DataType dt = (DataType)some.value();
                            seq2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), IntegerType$.MODULE$, dt}));
                        } else {
                            seq2 = (Seq)package$.MODULE$.Seq().empty();
                        }
                        seq = seq2;
                        return (Seq)package$.MODULE$.Seq().empty();
                    }
                }
            }
        }
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        seq = (Seq)package$.MODULE$.Seq().empty();
        return (Seq)package$.MODULE$.Seq().empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var1_7;
        Tuple3 tuple3 = new Tuple3((Object)this.first().dataType(), (Object)this.second().dataType(), (Object)this.third().dataType());
        if (tuple3 != null) {
            DataType e2 = (DataType)tuple3._2();
            if (tuple3._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType(IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.second())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType(this.second().dataType()))}))));
                    return var1_7;
                }
            }
        }
        if (tuple3 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType = (DataType)tuple3._1();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType && (e1 = (arrayType = (ArrayType)dataType).elementType()).sameType(e3)) {
                TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                return var1_7;
            }
        }
        TypeCheckResult.DataTypeMismatch dataTypeMismatch = new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType(ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType(this.first().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType(this.third().dataType()))}))));
        return var1_7;
    }

    @Override
    public Object eval(InternalRow input) {
        Object value2;
        Object value1 = this.first().eval(input);
        if (value1 != null && (value2 = this.second().eval(input)) != null) {
            Object value3 = this.third().eval(input);
            return this.nullSafeEval(value1, value2, value3);
        }
        return null;
    }

    @Override
    public Object nullSafeEval(Object arr, Object pos, Object item) {
        boolean newPosExtendsArrayLeft;
        IntRef posInt = IntRef.create((int)BoxesRunTime.unboxToInt((Object)pos));
        if (posInt.elem == 0) {
            throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
        }
        ArrayData baseArr = (ArrayData)arr;
        DataType arrayElementType = ((ArrayType)this.dataType()).elementType();
        boolean bl = newPosExtendsArrayLeft = posInt.elem < 0 && -posInt.elem > baseArr.numElements();
        if (newPosExtendsArrayLeft) {
            int newArrayLength = -posInt.elem + 1;
            if (newArrayLength > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
            }
            Object[] newArray = new Object[newArrayLength];
            baseArr.foreach(arrayElementType, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
                ArrayInsert.$anonfun$nullSafeEval$9(posInt, baseArr, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            newArray[0] = item;
            return new GenericArrayData(newArray);
        }
        if (posInt.elem < 0) {
            posInt.elem += baseArr.numElements();
        } else if (posInt.elem > 0) {
            --posInt.elem;
        }
        int newArrayLength = scala.math.package$.MODULE$.max(baseArr.numElements() + 1, posInt.elem + 1);
        if (newArrayLength > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
        }
        Object[] newArray = new Object[newArrayLength];
        baseArr.foreach(arrayElementType, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
            ArrayInsert.$anonfun$nullSafeEval$10(posInt, newArray, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        newArray[posInt.elem] = item;
        return new GenericArrayData(newArray);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Function3 & Serializable f = (Function3 & Serializable)(arrExpr, posExpr, itemExpr) -> {
            ExprValue arr = arrExpr.value();
            ExprValue pos = posExpr.value();
            ExprValue item = itemExpr.value();
            String itemInsertionIndex = ctx.freshName("itemInsertionIndex");
            String adjustedAllocIdx = ctx.freshName("adjustedAllocIdx");
            String resLength = ctx.freshName("resLength");
            String insertedItemIsNull = ctx.freshName("insertedItemIsNull");
            String i = ctx.freshName("i");
            String j = ctx.freshName("j");
            String values = ctx.freshName("values");
            String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), resLength, new StringBuilder(8).append(this.prettyName()).append(" failed.").toString());
            String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), ExprValue$.MODULE$.exprValueToString(arr), adjustedAllocIdx, i, ((ArrayType)this.first().dataType()).containsNull());
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1577).append("\n         |int ").append(itemInsertionIndex).append(" = 0;\n         |int ").append(resLength).append(" = 0;\n         |int ").append(adjustedAllocIdx).append(" = 0;\n         |boolean ").append(insertedItemIsNull).append(" = ").append(itemExpr.isNull()).append(";\n         |\n         |if (").append(pos).append(" == 0) {\n         |  throw QueryExecutionErrors.invalidIndexOfZeroError(").append(errorContext).append(");\n         |}\n         |\n         |if (").append(pos).append(" < 0 && (java.lang.Math.abs(").append(pos).append(") > ").append(arr).append(".numElements())) {\n         |\n         |  ").append(resLength).append(" = java.lang.Math.abs(").append(pos).append(") + 1;\n         |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n         |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n         |  }\n         |\n         |  ").append(allocation).append("\n         |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n         |    ").append(adjustedAllocIdx).append(" = ").append(i).append(" + 1 + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements());\n         |    ").append(assignment).append("\n         |  }\n         |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n         |\n         |  for (int ").append(j).append(" = ").append(pos).append(" + ").append(arr).append(".numElements(); ").append(j).append(" < 0; ").append(j).append(" ++) {\n         |    ").append(values).append(".setNullAt(").append(j).append(" + 1 + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements()));\n         |  }\n         |\n         |  ").append(ev.value()).append(" = ").append(values).append(";\n         |} else {\n         |\n         |  ").append(itemInsertionIndex).append(" = 0;\n         |  if (").append(pos).append(" < 0) {\n         |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" + ").append(arr).append(".numElements();\n         |  } else if (").append(pos).append(" > 0) {\n         |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" - 1;\n         |  }\n         |\n         |  ").append(resLength).append(" = java.lang.Math.max(").append(arr).append(".numElements() + 1, ").append(itemInsertionIndex).append(" + 1);\n         |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n         |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n         |  }\n         |\n         |  ").append(allocation).append("\n         |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n         |    ").append(adjustedAllocIdx).append(" = ").append(i).append(";\n         |    if (").append(i).append(" >= ").append(itemInsertionIndex).append(") {\n         |      ").append(adjustedAllocIdx).append(" = ").append(adjustedAllocIdx).append(" + 1;\n         |    }\n         |    ").append(assignment).append("\n         |  }\n         |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n         |\n         |  for (int ").append(j).append(" = ").append(arr).append(".numElements(); ").append(j).append(" < ").append(resLength).append(" - 1; ").append(j).append(" ++) {\n         |    ").append(values).append(".setNullAt(").append(j).append(");\n         |  }\n         |\n         |  ").append(ev.value()).append(" = ").append(values).append(";\n         |}\n      ").toString()));
        };
        ExprCode leftGen = this.first().genCode(ctx);
        ExprCode midGen = this.second().genCode(ctx);
        ExprCode rightGen = this.third().genCode(ctx);
        String resultCode = (String)f.apply((Object)leftGen, (Object)midGen, (Object)rightGen);
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)leftGen.code()), ctx.nullSafeExec(this.first().nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)midGen.code()), ctx.nullSafeExec(this.second().nullable(), ExprValue$.MODULE$.exprValueToString(midGen.isNull()), new StringBuilder(67).append("\n              ").append(rightGen.code()).append("\n              ").append(ev.isNull()).append(" = false;\n              ").append(resultCode).append("\n            ").toString()))));
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        } else {
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), midGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return exprCode;
    }

    @Override
    public Expression first() {
        return this.srcArrayExpr();
    }

    @Override
    public Expression second() {
        return this.posExpr();
    }

    @Override
    public Expression third() {
        return this.itemExpr();
    }

    @Override
    public String prettyName() {
        return "array_insert";
    }

    @Override
    public DataType dataType() {
        return this.first().dataType().asNullable();
    }

    @Override
    public boolean nullable() {
        return this.first().nullable() | this.second().nullable();
    }

    private DataType elementType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.srcArrayExpr().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public ArrayInsert withNewChildrenInternal(Expression newSrcArrayExpr, Expression newPosExpr, Expression newItemExpr) {
        return this.copy(newSrcArrayExpr, newPosExpr, newItemExpr);
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        return new Some((Object)this.origin().context());
    }

    public ArrayInsert copy(Expression srcArrayExpr, Expression posExpr, Expression itemExpr) {
        return new ArrayInsert(srcArrayExpr, posExpr, itemExpr);
    }

    public Expression copy$default$1() {
        return this.srcArrayExpr();
    }

    public Expression copy$default$2() {
        return this.posExpr();
    }

    public Expression copy$default$3() {
        return this.itemExpr();
    }

    @Override
    public String productPrefix() {
        return "ArrayInsert";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.srcArrayExpr();
                break;
            }
            case 1: {
                object = this.posExpr();
                break;
            }
            case 2: {
                object = this.itemExpr();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayInsert;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "srcArrayExpr";
                break;
            }
            case 1: {
                string = "posExpr";
                break;
            }
            case 2: {
                string = "itemExpr";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayInsert)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayInsert arrayInsert = (ArrayInsert)x$1;
        Expression expression = this.srcArrayExpr();
        Expression expression2 = arrayInsert.srcArrayExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.posExpr();
        Expression expression4 = arrayInsert.posExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.itemExpr();
        Expression expression6 = arrayInsert.itemExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!arrayInsert.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$9(IntRef posInt$1, ArrayData baseArr$1, Object[] newArray$2, int i, Object v) {
        int elementPosition = i + 1 + scala.math.package$.MODULE$.abs(posInt$1.elem + baseArr$1.numElements());
        newArray$2[elementPosition] = v;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$10(IntRef posInt$1, Object[] newArray$3, int i, Object v) {
        if (i >= posInt$1.elem) {
            newArray$3[i + 1] = v;
        } else {
            newArray$3[i] = v;
        }
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr) {
        this.srcArrayExpr = srcArrayExpr;
        this.posExpr = posExpr;
        this.itemExpr = itemExpr;
        ExpectsInputTypes.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
        QueryErrorsBase.$init$(this);
        SupportQueryContext.$init$(this);
    }
}

