/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class ExprUtils$
implements QueryErrorsBase {
    public static final ExprUtils$ MODULE$ = new ExprUtils$();

    static {
        QueryErrorsBase.$init$(MODULE$);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    public DataType evalTypeExpr(Expression exp) {
        UTF8String uTF8String;
        if (exp.foldable()) {
            Object object = exp.eval(exp.eval$default$1());
            if (!(object instanceof UTF8String) || (uTF8String = (UTF8String)object) == null) {
                throw QueryCompilationErrors$.MODULE$.unexpectedSchemaTypeError(exp);
            }
        } else {
            throw QueryCompilationErrors$.MODULE$.unexpectedSchemaTypeError(exp);
        }
        DataType dataType = DataType$.MODULE$.fromDDL(uTF8String.toString());
        DataType dataType2 = CharVarcharUtils$.MODULE$.failIfHasCharVarchar(dataType);
        return dataType2;
    }

    public StructType evalSchemaExpr(Expression exp) {
        DataType dataType = this.evalTypeExpr(exp);
        if (!(dataType instanceof StructType)) {
            throw QueryCompilationErrors$.MODULE$.schemaIsNotStructTypeError(exp, dataType);
        }
        return (StructType)dataType;
    }

    public Map<String, String> convertToMapData(Expression exp) {
        CreateMap createMap;
        block5: {
            boolean bl;
            block4: {
                bl = false;
                createMap = null;
                Expression expression = exp;
                if (!(expression instanceof CreateMap)) break block4;
                bl = true;
                createMap = (CreateMap)expression;
                if (createMap.dataType().acceptsType(new MapType(StringType$.MODULE$, StringType$.MODULE$, false))) break block5;
            }
            if (bl) {
                throw QueryCompilationErrors$.MODULE$.keyValueInMapNotStringError(createMap);
            }
            throw QueryCompilationErrors$.MODULE$.nonMapFunctionNotAllowedError();
        }
        ArrayBasedMapData arrayMap = (ArrayBasedMapData)createMap.eval(createMap.eval$default$1());
        Map map = (Map)ArrayBasedMapData$.MODULE$.toScalaMap(arrayMap).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toString()), (Object)value.toString());
            return tuple22;
        });
        return map;
    }

    public void verifyColumnNameOfCorruptRecord(StructType schema, String columnNameOfCorruptRecord) {
        schema.getFieldIndex(columnNameOfCorruptRecord).foreach((Function1)(JFunction1.mcVI.sp & Serializable)corruptFieldIndex -> {
            StructField f = schema.apply(corruptFieldIndex);
            DataType dataType = f.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !f.nullable()) {
                throw QueryCompilationErrors$.MODULE$.invalidFieldTypeForCorruptRecordError();
            }
        });
    }

    public Function1<String, BigDecimal> getDecimalParser(Locale locale) {
        Function1 & Serializable intersect;
        Locale locale2 = locale;
        Locale locale3 = Locale.US;
        if (!(locale2 != null ? !((Object)locale2).equals(locale3) : locale3 != null)) {
            intersect = (Function1 & Serializable)s -> new BigDecimal(s.replaceAll(",", ""));
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("", new DecimalFormatSymbols(locale));
            decimalFormat.setParseBigDecimal(true);
            intersect = (Function1 & Serializable)s -> {
                void var3_3;
                ParsePosition pos = new ParsePosition(0);
                BigDecimal result = (BigDecimal)decimalFormat.parse((String)s, pos);
                if (pos.getIndex() != s.length() || pos.getErrorIndex() != -1) {
                    throw QueryExecutionErrors$.MODULE$.cannotParseDecimalError();
                }
                return var3_3;
            };
        }
        return intersect;
    }

    public TypeCheckResult checkJsonSchema(DataType schema) {
        boolean isInvalid = schema.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExprUtils$.$anonfun$checkJsonSchema$1(x0$1)));
        return isInvalid ? new TypeCheckResult.DataTypeMismatch("INVALID_JSON_MAP_KEY_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType(schema))})))) : TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkJsonSchema$1(DataType x0$1) {
        DataType keyType;
        DataType dataType = x0$1;
        if (!(dataType instanceof MapType)) return false;
        MapType mapType = (MapType)dataType;
        DataType dataType2 = keyType = mapType.keyType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType2 == null) {
            if (stringType$ == null) return false;
            return true;
        } else if (dataType2.equals(stringType$)) return false;
        return true;
    }

    private ExprUtils$() {
    }
}

