/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Mask$;
import org.apache.spark.sql.catalyst.expressions.QuinaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(input[, upperChar, lowerChar, digitChar, otherChar]) - masks the given string value.\n       The function replaces characters with 'X' or 'x', and numbers with 'n'.\n       This can be useful for creating copies of tables with sensitive information removed.\n      ", arguments="\n    Arguments:\n      * input      - string value to mask. Supported types: STRING, VARCHAR, CHAR\n      * upperChar  - character to replace upper-case characters with. Specify NULL to retain original character. Default value: 'X'\n      * lowerChar  - character to replace lower-case characters with. Specify NULL to retain original character. Default value: 'x'\n      * digitChar  - character to replace digit characters with. Specify NULL to retain original character. Default value: 'n'\n      * otherChar  - character to replace all other characters with. Specify NULL to retain original character. Default value: NULL\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('abcd-EFGH-8765-4321');\n        xxxx-XXXX-nnnn-nnnn\n      > SELECT _FUNC_('abcd-EFGH-8765-4321', 'Q');\n        xxxx-QQQQ-nnnn-nnnn\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q');\n        QqQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#');\n        XxXXnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q');\n        QxQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q');\n        QqQQnnn-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q', 'd');\n        QqQQddd-@$#\n      > SELECT _FUNC_('AbCD123-@$#', 'Q', 'q', 'd', 'o');\n        QqQQdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, 'q', 'd', 'o');\n        AqCDdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, 'd', 'o');\n        AbCDdddoooo\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, NULL, 'o');\n        AbCD123oooo\n      > SELECT _FUNC_(NULL, NULL, NULL, NULL, 'o');\n        NULL\n      > SELECT _FUNC_(NULL);\n        NULL\n      > SELECT _FUNC_('AbCD123-@$#', NULL, NULL, NULL, NULL);\n        AbCD123-@$#\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015h\u0001\u0002\u001c8\u0001\u0012C\u0001\u0002\u001a\u0001\u0003\u0016\u0004%\t!\u001a\u0005\tS\u0002\u0011\t\u0012)A\u0005M\"A!\u000e\u0001BK\u0002\u0013\u0005Q\r\u0003\u0005l\u0001\tE\t\u0015!\u0003g\u0011!a\u0007A!f\u0001\n\u0003)\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011\u00024\t\u00119\u0004!Q3A\u0005\u0002\u0015D\u0001b\u001c\u0001\u0003\u0012\u0003\u0006IA\u001a\u0005\ta\u0002\u0011)\u001a!C\u0001K\"A\u0011\u000f\u0001B\tB\u0003%a\rC\u0003s\u0001\u0011\u00051\u000fC\u0003s\u0001\u0011\u0005!\u0010C\u0003s\u0001\u0011\u0005A\u0010C\u0003s\u0001\u0011\u0005q\u0010\u0003\u0004s\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\u000e\u0001\t\u0003\nI\u0004C\u0004\u0002B\u0001!\t%a\u0011\t\u000f\u0005U\u0003\u0001\"\u0015\u0002X!9\u00111\u000f\u0001\u0005R\u0005U\u0004bBAK\u0001\u0011\u0005\u0013q\u0013\u0005\b\u0003?\u0003A\u0011IAQ\u0011\u001d\t)\u000b\u0001C)\u0003OC\u0011\"a-\u0001\u0003\u0003%\t!!.\t\u0013\u0005\u0005\u0007!%A\u0005\u0002\u0005\r\u0007\"CAm\u0001E\u0005I\u0011AAb\u0011%\tY\u000eAI\u0001\n\u0003\t\u0019\rC\u0005\u0002^\u0002\t\n\u0011\"\u0001\u0002D\"I\u0011q\u001c\u0001\u0012\u0002\u0013\u0005\u00111\u0019\u0005\n\u0003C\u0004\u0011\u0011!C!\u0003GD\u0011\"a=\u0001\u0003\u0003%\t!!>\t\u0013\u0005u\b!!A\u0005\u0002\u0005}\b\"\u0003B\u0003\u0001\u0005\u0005I\u0011\tB\u0004\u0011%\u0011)\u0002AA\u0001\n\u0003\u00119\u0002C\u0005\u0003\u001c\u0001\t\t\u0011\"\u0011\u0003\u001e!I!\u0011\u0005\u0001\u0002\u0002\u0013\u0005#1E\u0004\b\u0005\u001b:\u0004\u0012\u0001B(\r\u00191t\u0007#\u0001\u0003R!1!o\nC\u0001\u0005GB\u0011B!\u001a(\u0005\u0004%IAa\u001a\t\u0011\t=t\u0005)A\u0005\u0005SB\u0011B!\u001d(\u0005\u0004%IAa\u001a\t\u0011\tMt\u0005)A\u0005\u0005SB\u0011B!\u001e(\u0005\u0004%IAa\u001a\t\u0011\t]t\u0005)A\u0005\u0005SB\u0011B!\u001f(\u0005\u0004%IAa\u001f\t\u0011\t\ru\u0005)A\u0005\u0005{BqA!\"(\t\u0003\u00119\tC\u0004\u0003*\u001e\"IAa+\t\u0013\tev%!A\u0005\u0002\nm\u0006\"\u0003BdO\u0005\u0005I\u0011\u0011Be\u0011%\u0011YnJA\u0001\n\u0013\u0011iN\u0001\u0003NCN\\'B\u0001\u001d:\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005iZ\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005qj\u0014aA:rY*\u0011ahP\u0001\u0006gB\f'o\u001b\u0006\u0003\u0001\u0006\u000ba!\u00199bG\",'\"\u0001\"\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001)\u0015\n\u0014*Y!\t1u)D\u00018\u0013\tAuGA\tRk&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"A\u0012&\n\u0005-;$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011Q\nU\u0007\u0002\u001d*\u0011qjO\u0001\u0007KJ\u0014xN]:\n\u0005Es%aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005M3V\"\u0001+\u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011,\u0019\b\u00035~s!a\u00170\u000e\u0003qS!!X\"\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0016B\u00011U\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0001$\u0016!B5oaV$X#\u00014\u0011\u0005\u0019;\u0017B\u000158\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007S:\u0004X\u000f\u001e\u0011\u0002\u0013U\u0004\b/\u001a:DQ\u0006\u0014\u0018AC;qa\u0016\u00148\t[1sA\u0005IAn\\<fe\u000eC\u0017M]\u0001\u000bY><XM]\"iCJ\u0004\u0013!\u00033jO&$8\t[1s\u0003)!\u0017nZ5u\u0007\"\f'\u000fI\u0001\n_RDWM]\"iCJ\f!b\u001c;iKJ\u001c\u0005.\u0019:!\u0003\u0019a\u0014N\\5u}Q1A/\u001e<xqf\u0004\"A\u0012\u0001\t\u000b\u0011\\\u0001\u0019\u00014\t\u000b)\\\u0001\u0019\u00014\t\u000b1\\\u0001\u0019\u00014\t\u000b9\\\u0001\u0019\u00014\t\u000bA\\\u0001\u0019\u00014\u0015\u0005Q\\\b\"\u00023\r\u0001\u00041Gc\u0001;~}\")A-\u0004a\u0001M\")!.\u0004a\u0001MR9A/!\u0001\u0002\u0004\u0005\u0015\u0001\"\u00023\u000f\u0001\u00041\u0007\"\u00026\u000f\u0001\u00041\u0007\"\u00027\u000f\u0001\u00041G#\u0003;\u0002\n\u0005-\u0011QBA\b\u0011\u0015!w\u00021\u0001g\u0011\u0015Qw\u00021\u0001g\u0011\u0015aw\u00021\u0001g\u0011\u0015qw\u00021\u0001g\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\"O\u0001\tC:\fG._:jg&!\u0011qDA\r\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018AC5oaV$H+\u001f9fgV\u0011\u0011Q\u0005\t\u00063\u0006\u001d\u00121F\u0005\u0004\u0003S\u0019'aA*fcB!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022m\nQ\u0001^=qKNLA!!\u000e\u00020\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\t]VdG.\u00192mKV\u0011\u00111\b\t\u0004'\u0006u\u0012bAA )\n9!i\\8mK\u0006t\u0017\u0001B3wC2$B!!\u0012\u0002LA\u00191+a\u0012\n\u0007\u0005%CKA\u0002B]fD\u0001\u0002Z\n\u0011\u0002\u0003\u0007\u0011Q\n\t\u0005\u0003\u001f\n\t&D\u0001:\u0013\r\t\u0019&\u000f\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR1\u0011\u0011LA3\u0003_\u0002B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?:\u0014aB2pI\u0016<WM\\\u0005\u0005\u0003G\niF\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t9\u0007\u0006a\u0001\u0003S\n1a\u0019;y!\u0011\tY&a\u001b\n\t\u00055\u0014Q\f\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\t\b\u0006a\u0001\u00033\n!!\u001a<\u0002\u001f9,H\u000e\\*bM\u0016\u001cu\u000eZ3HK:$\u0002\"!\u0017\u0002x\u0005e\u00141\u0010\u0005\b\u0003O*\u0002\u0019AA5\u0011\u001d\t\t(\u0006a\u0001\u00033Bq!! \u0016\u0001\u0004\ty(A\u0001g!=\u0019\u0016\u0011QAC\u0003\u000b\u000b))!\"\u0002\u0006\u0006\u0015\u0015bAAB)\nIa)\u001e8di&|g.\u000e\t\u0005\u0003\u000f\u000byI\u0004\u0003\u0002\n\u0006-\u0005CA.U\u0013\r\ti\tV\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00151\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055E+\u0001\u0005eCR\fG+\u001f9f+\t\tI\n\u0005\u0003\u0002.\u0005m\u0015\u0002BAO\u0003_\u0011\u0001\u0002R1uCRK\b/Z\u0001\tG\"LG\u000e\u001a:f]V\u0011\u00111\u0015\t\u00053\u0006\u001db-A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u0019A/!+\t\u000f\u0005-\u0006\u00041\u0001\u0002.\u0006Ya.Z<DQ&dGM]3o!\u0011I\u0016q\u00164\n\u0007\u0005E6M\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsRYA/a.\u0002:\u0006m\u0016QXA`\u0011\u001d!\u0017\u0004%AA\u0002\u0019DqA[\r\u0011\u0002\u0003\u0007a\rC\u0004m3A\u0005\t\u0019\u00014\t\u000f9L\u0002\u0013!a\u0001M\"9\u0001/\u0007I\u0001\u0002\u00041\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bT3AZAdW\t\tI\r\u0005\u0003\u0002L\u0006UWBAAg\u0015\u0011\ty-!5\u0002\u0013Ut7\r[3dW\u0016$'bAAj)\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0017Q\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nabY8qs\u0012\"WMZ1vYR$S'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003K\u0004B!a:\u0002r6\u0011\u0011\u0011\u001e\u0006\u0005\u0003W\fi/\u0001\u0003mC:<'BAAx\u0003\u0011Q\u0017M^1\n\t\u0005E\u0015\u0011^\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003o\u00042aUA}\u0013\r\tY\u0010\u0016\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000b\u0012\t\u0001C\u0005\u0003\u0004\u0005\n\t\u00111\u0001\u0002x\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0003\u0011\r\t-!\u0011CA#\u001b\t\u0011iAC\u0002\u0003\u0010Q\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019B!\u0004\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003w\u0011I\u0002C\u0005\u0003\u0004\r\n\t\u00111\u0001\u0002F\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t)Oa\b\t\u0013\t\rA%!AA\u0002\u0005]\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002<\t\u0015\u0002\"\u0003B\u0002K\u0005\u0005\t\u0019AA#Q]\u0001!\u0011\u0006B\u0018\u0005c\u0011)Da\u000e\u0003<\tu\"\u0011\tB\"\u0005\u000f\u0012I\u0005E\u0002G\u0005WI1A!\f8\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\r\u0002\u00057yf)\u0016(D?\"Jg\u000e];u72\u0002S\u000f\u001d9fe\u000eC\u0017M\u001d\u0017!Y><XM]\"iCJd\u0003\u0005Z5hSR\u001c\u0005.\u0019:-A=$\b.\u001a:DQ\u0006\u0014X,\u000b\u0011.A5\f7o[:!i\",\u0007eZ5wK:\u00043\u000f\u001e:j]\u001e\u0004c/\u00197vK:R\u0001\u0005\t\u0011!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002\u0012X\r\u001d7bG\u0016\u001c\be\u00195be\u0006\u001cG/\u001a:tA]LG\u000f\u001b\u0011(1\u001e\u0002sN\u001d\u0011(q\u001eb\u0003%\u00198eA9,XNY3sg\u0002:\u0018\u000e\u001e5!O9<cF\u0003\u0011!A\u0001\u0002\u0003\u0005\t+iSN\u00043-\u00198!E\u0016\u0004So]3gk2\u0004cm\u001c:!GJ,\u0017\r^5oO\u0002\u001aw\u000e]5fg\u0002zg\r\t;bE2,7\u000fI<ji\"\u00043/\u001a8tSRLg/\u001a\u0011j]\u001a|'/\\1uS>t\u0007E]3n_Z,GM\f\u0006!A\u0001\u0002\u0003\u0005I\u0001\nCJ<W/\\3oiN\f#A!\u000f\u0002\t?T\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I5oaV$\b\u0005\t\u0011!A\u0001j\u0003e\u001d;sS:<\u0007E^1mk\u0016\u0004Co\u001c\u0011nCN\\g\u0006I*vaB|'\u000f^3eAQL\b/Z:;AM#&+\u0013(HY\u00012\u0016IU\"I\u0003Jc\u0003e\u0011%B%*\u0001\u0003\u0005\t\u0011!A)\u0002S\u000f\u001d9fe\u000eC\u0017M\u001d\u0011![\u0001\u001a\u0007.\u0019:bGR,'\u000f\t;pAI,\u0007\u000f\\1dK\u0002*\b\u000f]3s[\r\f7/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004s/\u001b;i]\u0001\u001a\u0006/Z2jMf\u0004c*\u0016'MAQ|\u0007E]3uC&t\u0007e\u001c:jO&t\u0017\r\u001c\u0011dQ\u0006\u0014\u0018m\u0019;fe:\u0002C)\u001a4bk2$\bE^1mk\u0016T\u0004e\n-(\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001bwn^3s\u0007\"\f'\u000f\t\u0011.A\rD\u0017M]1di\u0016\u0014\b\u0005^8!e\u0016\u0004H.Y2fA1|w/\u001a:.G\u0006\u001cX\rI2iCJ\f7\r^3sg\u0002:\u0018\u000e\u001e5/AM\u0003XmY5gs\u0002rU\u000b\u0014'!i>\u0004#/\u001a;bS:\u0004sN]5hS:\fG\u000eI2iCJ\f7\r^3s]\u0001\"UMZ1vYR\u0004c/\u00197vKj\u0002s\u0005_\u0014\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0011Lw-\u001b;DQ\u0006\u0014\b\u0005I\u0017!G\"\f'/Y2uKJ\u0004Co\u001c\u0011sKBd\u0017mY3!I&<\u0017\u000e\u001e\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004s/\u001b;i]\u0001\u001a\u0006/Z2jMf\u0004c*\u0016'MAQ|\u0007E]3uC&t\u0007e\u001c:jO&t\u0017\r\u001c\u0011dQ\u0006\u0014\u0018m\u0019;fe:\u0002C)\u001a4bk2$\bE^1mk\u0016T\u0004e\n8(\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001zG\u000f[3s\u0007\"\f'\u000f\t\u0011.A\rD\u0017M]1di\u0016\u0014\b\u0005^8!e\u0016\u0004H.Y2fA\u0005dG\u000eI8uQ\u0016\u0014\be\u00195be\u0006\u001cG/\u001a:tA]LG\u000f\u001b\u0018!'B,7-\u001b4zA9+F\n\u0014\u0011u_\u0002\u0012X\r^1j]\u0002z'/[4j]\u0006d\u0007e\u00195be\u0006\u001cG/\u001a:/A\u0011+g-Y;mi\u00022\u0018\r\\;fu\u0001rU\u000b\u0014'\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u007f\tqq\u001c\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0005\u00147\rZ\u0017F\r\u001eCU\u0006O\u001c7k5\"4GM\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001f=yq6B\u0006\f\u0017-.]:tg.\f8o]:T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ1cG\u0012lSIR$I[a:d'N\u00175gI\nt\u0005\f\u0011(#\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011yqbDX&U)R#6rgN\u001c8.]:tgN\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0003\n\u001cE)\r\u001a4[\u0001#3e\n\u0017!OE;C\u0006I\u0014rO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I)r#FsgN\\\u0017AI\rR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ!c\u0007\u0012\u000b$gM\u0017AI\r:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!1bD\u0006L\u001c8o[\u0001#3E\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0003\n\u001cE)\r\u001a4[\u0001#3e\n\u0017!OE;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!#b\f\u0016K\u001c8o[\u0001#3E\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0003\n\u001cE)\r\u001a4[\u0001#3e\n\u0017!OE;C\u0006I\u0014rO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I)r#FsgN\\\u0017AI\rR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ!c\u0007\u0012\u000b$gM\u0017AI\r:C\u0006I\u0014RO1\u0002s%]\u0014-A\u001d\"w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!AE\u000b\u0018+\u00153eI6\u0002Ee\t\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0005\u00137\tR\u00193g5\u0002EeI\u0014-A\u001d\nv\u0005\f\u0011(c\u001eb\u0003e\n3(Y\u0001:snJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n\u0016/U)eI\u0012|wn\\8\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n%m\u0011#2eMj\u0003\tJ\u0012(Y\u0001rU\u000b\u0014'-A\u001d\nx\u0005\f\u0011(I\u001eb\u0003eJ8(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%Q9D\t\u0012$Gm\\8p_*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\u00112D\tF\u00124'\f!%G\u001db\u0003ET+M\u00192\u0002c*\u0016'MY\u0001:Cm\n\u0017!O=<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003\n\u001cE\t\u001a3e_>|wN\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0003\n\u001cE)\r\u001a4[\u0001#3e\n\u0017!\u001dVcE\n\f\u0011O+2cE\u0006\t(V\u00192c\u0003eJ8(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%\u00112D\tF\u00124g\\8p_*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc*\u0016'MY\u0001rU\u000b\u0014'-A9+F\n\u0014\u0017!\u001dVcE\n\f\u0011(_\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b(V\u00192K3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014BE\u000e#\u0015GM\u001a.\u0001\u0012\u001as\u0005\f\u0011O+2cE\u0006\t(V\u00192c\u0003ET+M\u00192\u0002c*\u0016'MSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%\u00112D\tF\u00124'\f!%G)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003F\u0005)1G\f\u001b/a\u0005)qM]8va\u0006\u0012!1J\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\u0005\u001b\u0006\u001c8\u000e\u0005\u0002GOM)qEa\u0015\u0003ZA\u00191K!\u0016\n\u0007\t]CK\u0001\u0004B]f\u0014VM\u001a\t\u0005\u00057\u0012\t'\u0004\u0002\u0003^)!!qLAw\u0003\tIw.C\u0002c\u0005;\"\"Aa\u0014\u0002!5\u000b5kS#E?V\u0003\u0006+\u0012*D\u0003N+UC\u0001B5!\r\u0019&1N\u0005\u0004\u0005[\"&\u0001B\"iCJ\f\u0011#T!T\u0017\u0016#u,\u0016)Q\u000bJ\u001b\u0015iU#!\u0003Ai\u0015iU&F\t~cujV#S\u0007\u0006\u001bV)A\tN\u0003N[U\tR0M\u001f^+%kQ!T\u000b\u0002\nA\"T!T\u0017\u0016#u\fR%H\u0013R\u000bQ\"T!T\u0017\u0016#u\fR%H\u0013R\u0003\u0013!D'B'.+EiX%H\u001d>\u0013V)\u0006\u0002\u0003~A\u00191Ka \n\u0007\t\u0005EK\u0001\u0003Ok2d\u0017AD'B'.+EiX%H\u001d>\u0013V\tI\u0001\u000fiJ\fgn\u001d4pe6Le\u000e];u)1\u0011IIa&\u0003\u001a\nu%\u0011\u0015BS!\u0011\u0011YIa%\u000e\u0005\t5%\u0002BA\u0019\u0005\u001fS1A!%>\u0003\u0019)hn]1gK&!!Q\u0013BG\u0005))FK\u0012\u001dTiJLgn\u001a\u0005\u0007IF\u0002\r!!\u0012\t\u000f\tm\u0015\u00071\u0001\u0002F\u0005IQ.Y:l+B\u0004XM\u001d\u0005\b\u0005?\u000b\u0004\u0019AA#\u0003%i\u0017m]6M_^,'\u000fC\u0004\u0003$F\u0002\r!!\u0012\u0002\u00135\f7o\u001b#jO&$\bb\u0002BTc\u0001\u0007\u0011QI\u0001\n[\u0006\u001c8n\u0014;iKJ\fQ\u0002\u001e:b]N4wN]7DQ\u0006\u0014H\u0003DA|\u0005[\u0013\tLa-\u00036\n]\u0006b\u0002BXe\u0001\u0007!\u0011N\u0001\u0002G\"9!1\u0014\u001aA\u0002\u0005\u0015\u0003b\u0002BPe\u0001\u0007\u0011Q\t\u0005\b\u0005G\u0013\u0004\u0019AA#\u0011\u001d\u00119K\ra\u0001\u0003\u000b\nQ!\u00199qYf$2\u0002\u001eB_\u0005\u007f\u0013\tMa1\u0003F\")Am\ra\u0001M\")!n\ra\u0001M\")An\ra\u0001M\")an\ra\u0001M\")\u0001o\ra\u0001M\u00069QO\\1qa2LH\u0003\u0002Bf\u0005/\u0004Ra\u0015Bg\u0005#L1Aa4U\u0005\u0019y\u0005\u000f^5p]BA1Ka5gM\u001a4g-C\u0002\u0003VR\u0013a\u0001V;qY\u0016,\u0004\u0002\u0003Bmi\u0005\u0005\t\u0019\u0001;\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003`B!\u0011q\u001dBq\u0013\u0011\u0011\u0019/!;\u0003\r=\u0013'.Z2u\u0001")
public class Mask
extends QuinaryExpression
implements ExpectsInputTypes,
QueryErrorsBase,
Serializable {
    private final Expression input;
    private final Expression upperChar;
    private final Expression lowerChar;
    private final Expression digitChar;
    private final Expression otherChar;

    public static Option<Tuple5<Expression, Expression, Expression, Expression, Expression>> unapply(Mask x$0) {
        return Mask$.MODULE$.unapply(x$0);
    }

    public static UTF8String transformInput(Object input, Object maskUpper, Object maskLower, Object maskDigit, Object maskOther) {
        return Mask$.MODULE$.transformInput(input, maskUpper, maskLower, maskDigit, maskOther);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    public Expression input() {
        return this.input;
    }

    public Expression upperChar() {
        return this.upperChar;
    }

    public Expression lowerChar() {
        return this.lowerChar;
    }

    public Expression digitChar() {
        return this.digitChar;
    }

    public Expression otherChar() {
        return this.otherChar;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var1_1;
        TypeCheckResult defaultCheckResult = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheckResult.isSuccess() ? (TypeCheckResult)((IterableOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.upperChar(), (Object)"upperChar"), new Tuple2((Object)this.lowerChar(), (Object)"lowerChar"), new Tuple2((Object)this.digitChar(), (Object)"digitChar"), new Tuple2((Object)this.otherChar(), (Object)"otherChar")})).flatMap((Function1 & Serializable)x0$1 -> {
            Expression expression;
            String message;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    Expression exp = (Expression)tuple2._1();
                    message = (String)tuple2._2();
                    if (exp == null) break block2;
                    expression = exp;
                    if (message != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string = message;
            Option option = this.checkInputDataType$1(expression, string);
            return option;
        })).headOption().getOrElse((Function0 & Serializable)() -> defaultCheckResult) : var1_1;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object eval(InternalRow input) {
        return Mask$.MODULE$.transformInput(((Expression)this.children().apply(0)).eval(input), ((Expression)this.children().apply(1)).eval(input), ((Expression)this.children().apply(2)).eval(input), ((Expression)this.children().apply(3)).eval(input), ((Expression)this.children().apply(4)).eval(input));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function5<String, String, String, String, String, String>)(Function5 & Serializable)(input, upperChar, lowerChar, digitChar, otherChar) -> new StringBuilder(0).append("org.apache.spark.sql.catalyst.expressions.Mask.").append(new StringBuilder(25).append("transformInput(").append((String)input).append(", ").append((String)upperChar).append(", ").append((String)lowerChar).append(", ").append((String)digitChar).append(", ").append((String)otherChar).append(");").toString()).toString());
    }

    @Override
    public ExprCode nullSafeCodeGen(CodegenContext ctx, ExprCode ev, Function5<String, String, String, String, String, String> f) {
        ExprCode exprCode;
        ExprCode firstGen = ((Expression)this.children().apply(0)).genCode(ctx);
        ExprCode secondGen = ((Expression)this.children().apply(1)).genCode(ctx);
        ExprCode thirdGen = ((Expression)this.children().apply(2)).genCode(ctx);
        ExprCode fourthGen = ((Expression)this.children().apply(3)).genCode(ctx);
        ExprCode fifthGen = ((Expression)this.children().apply(4)).genCode(ctx);
        String resultCode = (String)f.apply((Object)ExprValue$.MODULE$.exprValueToString(firstGen.value()), (Object)ExprValue$.MODULE$.exprValueToString(secondGen.value()), (Object)ExprValue$.MODULE$.exprValueToString(thirdGen.value()), (Object)ExprValue$.MODULE$.exprValueToString(fourthGen.value()), (Object)ExprValue$.MODULE$.exprValueToString(fifthGen.value()));
        if (this.nullable()) {
            String nullSafeEval = ctx.nullSafeExec(((Expression)this.children().apply(0)).nullable(), ExprValue$.MODULE$.exprValueToString(firstGen.isNull()), resultCode);
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", "\n        ", "\n        boolean ", " = ", ";\n        ", " ", " = ", ";\n        ", "\n      "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{firstGen.code(), secondGen.code(), thirdGen.code(), fourthGen.code(), fifthGen.code(), ev.isNull(), firstGen.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        } else {
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", "\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{firstGen.code(), secondGen.code(), thirdGen.code(), fourthGen.code(), fifthGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return exprCode;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.input(), this.upperChar(), this.lowerChar(), this.digitChar(), this.otherChar()}));
    }

    @Override
    public Mask withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4));
    }

    public Mask copy(Expression input, Expression upperChar, Expression lowerChar, Expression digitChar, Expression otherChar) {
        return new Mask(input, upperChar, lowerChar, digitChar, otherChar);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.upperChar();
    }

    public Expression copy$default$3() {
        return this.lowerChar();
    }

    public Expression copy$default$4() {
        return this.digitChar();
    }

    public Expression copy$default$5() {
        return this.otherChar();
    }

    @Override
    public String productPrefix() {
        return "Mask";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.input();
                break;
            }
            case 1: {
                object = this.upperChar();
                break;
            }
            case 2: {
                object = this.lowerChar();
                break;
            }
            case 3: {
                object = this.digitChar();
                break;
            }
            case 4: {
                object = this.otherChar();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Mask;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "input";
                break;
            }
            case 1: {
                string = "upperChar";
                break;
            }
            case 2: {
                string = "lowerChar";
                break;
            }
            case 3: {
                string = "digitChar";
                break;
            }
            case 4: {
                string = "otherChar";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Mask)) return false;
        boolean bl = true;
        if (!bl) return false;
        Mask mask = (Mask)x$1;
        Expression expression = this.input();
        Expression expression2 = mask.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.upperChar();
        Expression expression4 = mask.upperChar();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.lowerChar();
        Expression expression6 = mask.lowerChar();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.digitChar();
        Expression expression8 = mask.digitChar();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.otherChar();
        Expression expression10 = mask.otherChar();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        if (!mask.canEqual(this)) return false;
        return true;
    }

    private final Option checkInputDataType$1(Expression exp, String message) {
        Object replaceChar;
        return !exp.foldable() ? new Some((Object)new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)message), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType(exp.dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(exp))}))))) : ((replaceChar = exp.eval(exp.eval$default$1())) != null && ((UTF8String)replaceChar).numChars() != 1 ? new Some((Object)new TypeCheckResult.DataTypeMismatch("INPUT_SIZE_NOT_ONE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)message)}))))) : None$.MODULE$);
    }

    public Mask(Expression input, Expression upperChar, Expression lowerChar, Expression digitChar, Expression otherChar) {
        this.input = input;
        this.upperChar = upperChar;
        this.lowerChar = lowerChar;
        this.digitChar = digitChar;
        this.otherChar = otherChar;
        ExpectsInputTypes.$init$(this);
        QueryErrorsBase.$init$(this);
    }

    public Mask(Expression input) {
        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_UPPERCASE()));
        Literal literal2 = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_LOWERCASE()));
        Literal literal3 = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_DIGIT()));
        Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_IGNORE();
        this(input, literal, literal2, literal3, new Literal(null, StringType$.MODULE$));
    }

    public Mask(Expression input, Expression upperChar) {
        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_LOWERCASE()));
        Literal literal2 = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_DIGIT()));
        Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_IGNORE();
        this(input, upperChar, literal, literal2, new Literal(null, StringType$.MODULE$));
    }

    public Mask(Expression input, Expression upperChar, Expression lowerChar) {
        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_DIGIT()));
        Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_IGNORE();
        this(input, upperChar, lowerChar, literal, new Literal(null, StringType$.MODULE$));
    }

    public Mask(Expression input, Expression upperChar, Expression lowerChar, Expression digitChar) {
        Mask$.MODULE$.org$apache$spark$sql$catalyst$expressions$Mask$$MASKED_IGNORE();
        this(input, upperChar, lowerChar, digitChar, new Literal(null, StringType$.MODULE$));
    }
}

