/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NTile$;
import org.apache.spark.sql.catalyst.expressions.RowNumberLike;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.NoOp$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(n) - Divides the rows for each window partition into `n` buckets ranging\n      from 1 to at most `n`.\n  ", arguments="\n    Arguments:\n      * buckets - an int expression which is number of buckets to divide the rows in.\n          Default value is 1.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(2) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t2\n       A2\t3\t1\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0005\t-a\u0001B\u0015+\u0001^B\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tE\u0002\u0011\t\u0012)A\u0005\u000b\")1\r\u0001C\u0001I\")1\r\u0001C\u0001O\")\u0001\u000e\u0001C!C\")\u0011\u000e\u0001C!U\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002<\u0001A\u0003%1\u000fC\u0004x\u0001\t\u0007I\u0011\u0002:\t\ra\u0004\u0001\u0015!\u0003t\u0011\u001dI\bA1A\u0005\nIDaA\u001f\u0001!\u0002\u0013\u0019\bbB>\u0001\u0005\u0004%IA\u001d\u0005\u0007y\u0002\u0001\u000b\u0011B:\t\u000bu\u0004A\u0011\u0002@\t\u0013\u0005%\u0001A1A\u0005B\u0005-\u0001\u0002CA\u000f\u0001\u0001\u0006I!!\u0004\t\u0013\u0005}\u0001A1A\u0005B\u0005\u0005\u0002\u0002CA\u0013\u0001\u0001\u0006I!a\t\t\u0013\u0005\u001d\u0002A1A\u0005B\u0005\u0005\u0002\u0002CA\u0015\u0001\u0001\u0006I!a\t\t\u0011\u0005-\u0002A1A\u0005BIDq!!\f\u0001A\u0003%1\u000fC\u0004\u00020\u0001!\t&!\r\t\u0013\u0005]\u0002!!A\u0005\u0002\u0005e\u0002\"CA\u001f\u0001E\u0005I\u0011AA \u0011%\t)\u0006AA\u0001\n\u0003\n9\u0006C\u0005\u0002j\u0001\t\t\u0011\"\u0001\u0002l!I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0011Q\u000f\u0005\n\u0003\u0003\u0003\u0011\u0011!C!\u0003\u0007C\u0011\"!$\u0001\u0003\u0003%\t!a$\t\u0013\u0005e\u0005!!A\u0005B\u0005m\u0005\"CAP\u0001\u0005\u0005I\u0011IAQ\u000f%\tYMKA\u0001\u0012\u0003\tiM\u0002\u0005*U\u0005\u0005\t\u0012AAh\u0011\u0019\u00197\u0005\"\u0001\u0002h\"I\u0011\u0011^\u0012\u0002\u0002\u0013\u0015\u00131\u001e\u0005\n\u0003[\u001c\u0013\u0011!CA\u0003_D\u0011\"a=$\u0003\u0003%\t)!>\t\u0013\t\u00051%!A\u0005\n\t\r!!\u0002(US2,'BA\u0016-\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00055r\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005=\u0002\u0014aA:rY*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001ADh\u0010%O)B\u0011\u0011HO\u0007\u0002U%\u00111H\u000b\u0002\u000e%><h*^7cKJd\u0015n[3\u0011\u0005ej\u0014B\u0001 +\u0005]\u0019\u0016N_3CCN,GmV5oI><h)\u001e8di&|g\u000eE\u0002A\u0007\u0016k\u0011!\u0011\u0006\u0003\u00052\nQ\u0001\u001e:fKNL!\u0001R!\u0003\u0013Us\u0017M]=MS.,\u0007CA\u001dG\u0013\t9%F\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u0018\u0002\r\u0015\u0014(o\u001c:t\u0013\ti%JA\bRk\u0016\u0014\u00180\u0012:s_J\u001c()Y:f!\ty%+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u001d\u0001&o\u001c3vGR\u0004\"!V/\u000f\u0005Y[fBA,[\u001b\u0005A&BA-7\u0003\u0019a$o\\8u}%\t\u0011+\u0003\u0002]!\u00069\u0001/Y2lC\u001e,\u0017B\u00010`\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ta\u0006+A\u0004ck\u000e\\W\r^:\u0016\u0003\u0015\u000b\u0001BY;dW\u0016$8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00154\u0007CA\u001d\u0001\u0011\u0015\u00017\u00011\u0001F)\u0005)\u0017!B2iS2$\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A6\u0011\u00051|W\"A7\u000b\u00059d\u0013\u0001C1oC2L8/[:\n\u0005Al'a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\r\t,8m[3u+\u0005\u0019\bCA\u001du\u0013\t)(F\u0001\nBiR\u0014\u0018NY;uKJ+g-\u001a:f]\u000e,\u0017a\u00022vG.,G\u000fI\u0001\u0010EV\u001c7.\u001a;UQJ,7\u000f[8mI\u0006\u0001\"-^2lKR$\u0006N]3tQ>dG\rI\u0001\u000bEV\u001c7.\u001a;TSj,\u0017a\u00032vG.,GoU5{K\u0002\n!CY;dW\u0016$8oV5uQB\u000bG\rZ5oO\u0006\u0019\"-^2lKR\u001cx+\u001b;i!\u0006$G-\u001b8hA\u0005q!-^2lKR|e/\u001a:gY><HcA@\u0002\u0006A\u0019\u0011(!\u0001\n\u0007\u0005\r!F\u0001\u0002JM\"1\u0011qA\bA\u0002\u0015\u000b\u0011!Z\u0001\u0014C\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm]\u000b\u0003\u0003\u001b\u0001R!a\u0004\u0002\u001aMl!!!\u0005\u000b\t\u0005M\u0011QC\u0001\nS6lW\u000f^1cY\u0016T1!a\u0006Q\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t\tBA\u0002TKF\fA#Y4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN\u0004\u0013!D5oSRL\u0017\r\u001c,bYV,7/\u0006\u0002\u0002$A)\u0011qBA\r\u000b\u0006q\u0011N\\5uS\u0006dg+\u00197vKN\u0004\u0013!E;qI\u0006$X-\u0012=qe\u0016\u001c8/[8og\u0006\u0011R\u000f\u001d3bi\u0016,\u0005\u0010\u001d:fgNLwN\\:!\u0003I)g/\u00197vCR,W\t\u001f9sKN\u001c\u0018n\u001c8\u0002'\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r)\u00171\u0007\u0005\u0007\u0003kA\u0002\u0019A#\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u0019Q-a\u000f\t\u000f\u0001L\u0002\u0013!a\u0001\u000b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA!U\r)\u00151I\u0016\u0003\u0003\u000b\u0002B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%A\u0005v]\u000eDWmY6fI*\u0019\u0011q\n)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002T\u0005%#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005!A.\u00198h\u0015\t\t\u0019'\u0001\u0003kCZ\f\u0017\u0002BA4\u0003;\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA7!\ry\u0015qN\u0005\u0004\u0003c\u0002&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA<\u0003{\u00022aTA=\u0013\r\tY\b\u0015\u0002\u0004\u0003:L\b\"CA@;\u0005\u0005\t\u0019AA7\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0011\t\u0007\u0003\u000f\u000bI)a\u001e\u000e\u0005\u0005U\u0011\u0002BAF\u0003+\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011SAL!\ry\u00151S\u0005\u0004\u0003+\u0003&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u007fz\u0012\u0011!a\u0001\u0003o\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011LAO\u0011%\ty\bIA\u0001\u0002\u0004\ti'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\u000b\u0019\u000bC\u0005\u0002\u0000\u0005\n\t\u00111\u0001\u0002x!:\u0002!a*\u0002.\u0006=\u00161WA[\u0003s\u000bY,a0\u0002B\u0006\u0015\u0017q\u0019\t\u0004s\u0005%\u0016bAAVU\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAY\u0003QT\u0001\u0005\t\u0011!?\u001a+fjQ0)]&\u0002S\u0006\t#jm&$Wm\u001d\u0011uQ\u0016\u0004#o\\<tA\u0019|'\u000fI3bG\"\u0004s/\u001b8e_^\u0004\u0003/\u0019:uSRLwN\u001c\u0011j]R|\u0007\u0005\u00198aA\t,8m[3ug\u0002\u0012\u0018M\\4j]\u001eT\u0001\u0005\t\u0011!A\u00012'o\\7!c\u0001\"x\u000eI1uA5|7\u000f\u001e\u0011a]\u0002t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA\\\u0003\u00055!\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ck\u000e\\W\r^:![\u0001\ng\u000eI5oi\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xQ&\u001c\u0007\u000eI5tA9,XNY3sA=4\u0007EY;dW\u0016$8\u000f\t;pA\u0011Lg/\u001b3fAQDW\r\t:poN\u0004\u0013N\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C)\u001a4bk2$\bE^1mk\u0016\u0004\u0013n\u001d\u00112])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti,AAL\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\nG\u0006\t2-A}3UKT\"`QIJ\u0003e\u0014,F%\u0002B\u0003+\u0011*U\u0013RKuJ\u0014\u0011C3\u0002\n\u0007e\u0014*E\u000bJ\u0003#)\u0017\u0011cS\u00012%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!e%b\u0003\u0005K\u0014Bc\u001db\u0003%M\u0015-A!:\u0013IM\u0014-AMJC\u0006\t\u0015(\u0003F:C\u0006I\u0019*AQ\f'\rK1-A\tL3H\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013EJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013EJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013IJ!G\u0003\u0011!A\u0001\u0002\u0003\u0005I!3\u0013MJ\u0011G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019-A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002J\u0006aq/\u001b8e_^|f-\u001e8dg\u0006)a\nV5mKB\u0011\u0011hI\n\u0006G\u0005E\u0017Q\u001c\t\u0007\u0003'\fI.R3\u000e\u0005\u0005U'bAAl!\u00069!/\u001e8uS6,\u0017\u0002BAn\u0003+\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\ty.!:\u000e\u0005\u0005\u0005(\u0002BAr\u0003C\n!![8\n\u0007y\u000b\t\u000f\u0006\u0002\u0002N\u0006AAo\\*ue&tw\r\u0006\u0002\u0002Z\u0005)\u0011\r\u001d9msR\u0019Q-!=\t\u000b\u00014\u0003\u0019A#\u0002\u000fUt\u0017\r\u001d9msR!\u0011q_A\u007f!\u0011y\u0015\u0011`#\n\u0007\u0005m\bK\u0001\u0004PaRLwN\u001c\u0005\t\u0003\u007f<\u0013\u0011!a\u0001K\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\u0015\u0001\u0003BA.\u0005\u000fIAA!\u0003\u0002^\t1qJ\u00196fGR\u0004")
public class NTile
extends RowNumberLike
implements SizeBasedWindowFunction,
UnaryLike<Expression>,
QueryErrorsBase {
    private final Expression buckets;
    private final AttributeReference bucket;
    private final AttributeReference bucketThreshold;
    private final AttributeReference bucketSize;
    private final AttributeReference bucketsWithPadding;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<Expression> initialValues;
    private final Seq<Expression> updateExpressions;
    private final AttributeReference evaluateExpression;
    private transient Seq<Expression> children;
    private AttributeReference n;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(NTile x$0) {
        return NTile$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<NTile, A> g) {
        return NTile$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, NTile> compose(Function1<A$, Expression> g) {
        return NTile$.MODULE$.compose(g);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        NTile nTile = this;
        synchronized (nTile) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public AttributeReference n() {
        return this.n;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$SizeBasedWindowFunction$_setter_$n_$eq(AttributeReference x$1) {
        this.n = x$1;
    }

    public Expression buckets() {
        return this.buckets;
    }

    @Override
    public Expression child() {
        return this.buckets();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        Object object = !this.buckets().foldable() ? new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"buckets"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType(this.buckets().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.buckets()))})))) : BoxedUnit.UNIT;
        DataType dataType = this.buckets().dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        Object object2 = (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) ? new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType(IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.buckets())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType(this.buckets().dataType()))})))) : BoxedUnit.UNIT;
        int i = BoxesRunTime.unboxToInt((Object)this.buckets().eval(this.buckets().eval$default$1()));
        return i > 0 ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"buckets"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)new StringBuilder(25).append("(0, ").append(Integer.MAX_VALUE).append("]").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)i), IntegerType$.MODULE$))}))));
    }

    private AttributeReference bucket() {
        return this.bucket;
    }

    private AttributeReference bucketThreshold() {
        return this.bucketThreshold;
    }

    private AttributeReference bucketSize() {
        return this.bucketSize;
    }

    private AttributeReference bucketsWithPadding() {
        return this.bucketsWithPadding;
    }

    private If bucketOverflow(Expression e) {
        return new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.rowNumber()).$greater$eq(this.bucketThreshold())), e, this.zero());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<Expression> initialValues() {
        return this.initialValues;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return this.evaluateExpression;
    }

    @Override
    public NTile withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public NTile copy(Expression buckets) {
        return new NTile(buckets);
    }

    public Expression copy$default$1() {
        return this.buckets();
    }

    @Override
    public String productPrefix() {
        return "NTile";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.buckets();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NTile;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "buckets";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        NTile nTile = (NTile)x$1;
        Expression expression = this.buckets();
        Expression expression2 = nTile.buckets();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!nTile.canEqual(this)) return false;
        return true;
    }

    public NTile(Expression buckets) {
        this.buckets = buckets;
        SizeBasedWindowFunction.$init$(this);
        UnaryLike.$init$(this);
        QueryErrorsBase.$init$(this);
        String x$1 = "bucket";
        IntegerType$ x$2 = IntegerType$.MODULE$;
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("bucket", x$2, false, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("bucket", x$2, false, x$4);
        this.bucket = new AttributeReference("bucket", x$2, false, x$4, x$5, x$6);
        String x$7 = "bucketThreshold";
        IntegerType$ x$8 = IntegerType$.MODULE$;
        boolean x$9 = false;
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5("bucketThreshold", x$8, false, x$10);
        Seq<String> x$12 = AttributeReference$.MODULE$.apply$default$6("bucketThreshold", x$8, false, x$10);
        this.bucketThreshold = new AttributeReference("bucketThreshold", x$8, false, x$10, x$11, x$12);
        String x$13 = "bucketSize";
        IntegerType$ x$14 = IntegerType$.MODULE$;
        boolean x$15 = false;
        Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$17 = AttributeReference$.MODULE$.apply$default$5("bucketSize", x$14, false, x$16);
        Seq<String> x$18 = AttributeReference$.MODULE$.apply$default$6("bucketSize", x$14, false, x$16);
        this.bucketSize = new AttributeReference("bucketSize", x$14, false, x$16, x$17, x$18);
        String x$19 = "bucketsWithPadding";
        IntegerType$ x$20 = IntegerType$.MODULE$;
        boolean x$21 = false;
        Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$23 = AttributeReference$.MODULE$.apply$default$5("bucketsWithPadding", x$20, false, x$22);
        Seq<String> x$24 = AttributeReference$.MODULE$.apply$default$6("bucketsWithPadding", x$20, false, x$22);
        this.bucketsWithPadding = new AttributeReference("bucketsWithPadding", x$20, false, x$22, x$23, x$24);
        this.aggBufferAttributes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{this.rowNumber(), this.bucket(), this.bucketThreshold(), this.bucketSize(), this.bucketsWithPadding()}));
        this.initialValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.zero(), this.zero(), this.zero(), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).div(buckets)).cast(IntegerType$.MODULE$), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).$percent(buckets)).cast(IntegerType$.MODULE$)}));
        this.updateExpressions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(this.rowNumber()).$plus(this.one()), package$expressions$.MODULE$.DslExpression(this.bucket()).$plus(this.bucketOverflow(this.one())), package$expressions$.MODULE$.DslExpression(this.bucketThreshold()).$plus(this.bucketOverflow(package$expressions$.MODULE$.DslExpression(this.bucketSize()).$plus(new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.bucket()).$less(this.bucketsWithPadding())), this.one(), this.zero())))), NoOp$.MODULE$, NoOp$.MODULE$}));
        this.evaluateExpression = this.bucket();
        Statics.releaseFence();
    }

    public NTile() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

