/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted. The result data type is consistent with the value of\n      configuration `spark.sql.timestampType`.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\tmd\u0001B\u0017/\u0001nB\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\t;\u0002\u0011\t\u0012)A\u0005y!Aa\f\u0001BK\u0002\u0013\u0005q\f\u0003\u0005d\u0001\tE\t\u0015!\u0003a\u0011!!\u0007A!f\u0001\n\u0003*\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011\u00024\t\u00115\u0004!Q3A\u0005\u00029D\u0001\u0002\u001f\u0001\u0003\u0012\u0003\u0006Ia\u001c\u0005\ts\u0002\u0011)\u001a!C\u0001u\"Aa\u0010\u0001B\tB\u0003%1\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\n\u0003\u001f\u0001\u0001R1A\u0005BqCaa \u0001\u0005\u0002\u0005E\u0001BB@\u0001\t\u0003\t9\u0002C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003?\u0002A\u0011IA1\u0011\u001d\tY\u0007\u0001C)\u0003[B\u0011\"!\u001f\u0001\u0003\u0003%\t!a\u001f\t\u0013\u0005\u001d\u0005!%A\u0005\u0002\u0005%\u0005\"CAP\u0001E\u0005I\u0011AAQ\u0011%\t)\u000bAI\u0001\n\u0003\t9\u000bC\u0005\u0002,\u0002\t\n\u0011\"\u0001\u0002.\"I\u0011\u0011\u0017\u0001\u0012\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003o\u0003\u0011\u0011!C!\u0003sC\u0011\"!3\u0001\u0003\u0003%\t!a3\t\u0013\u0005M\u0007!!A\u0005\u0002\u0005U\u0007\"CAq\u0001\u0005\u0005I\u0011IAr\u0011%\t\t\u0010AA\u0001\n\u0003\t\u0019\u0010C\u0005\u0002x\u0002\t\t\u0011\"\u0011\u0002z\"I\u0011Q \u0001\u0002\u0002\u0013\u0005\u0013q`\u0004\n\u0005Sq\u0013\u0011!E\u0001\u0005W1\u0001\"\f\u0018\u0002\u0002#\u0005!Q\u0006\u0005\u0007\u007f\u000e\"\tA!\u0012\t\u0013\t\u001d3%!A\u0005F\t%\u0003\"\u0003B&G\u0005\u0005I\u0011\u0011B'\u0011%\u0011IfII\u0001\n\u0003\ti\u000bC\u0005\u0003\\\r\n\n\u0011\"\u0001\u00024\"I!QL\u0012\u0002\u0002\u0013\u0005%q\f\u0005\n\u0005[\u001a\u0013\u0013!C\u0001\u0003[C\u0011Ba\u001c$#\u0003%\t!a-\t\u0013\tE4%!A\u0005\n\tM$\u0001\u0005)beN,Gk\u001c+j[\u0016\u001cH/Y7q\u0015\ty\u0003'A\u0006fqB\u0014Xm]:j_:\u001c(BA\u00193\u0003!\u0019\u0017\r^1msN$(BA\u001a5\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003kY\nQa\u001d9be.T!a\u000e\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0014aA8sO\u000e\u00011c\u0002\u0001=\u0001\u000e3\u0015j\u0014\t\u0003{yj\u0011AL\u0005\u0003\u007f9\u0012!\"\u0012=qe\u0016\u001c8/[8o!\ti\u0014)\u0003\u0002C]\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\tiD)\u0003\u0002F]\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002>\u000f&\u0011\u0001J\f\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002Q1:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)j\na\u0001\u0010:p_Rt\u0014\"\u0001'\n\u0005][\u0015a\u00029bG.\fw-Z\u0005\u00033j\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aV&\u0002\t1,g\r^\u000b\u0002y\u0005)A.\u001a4uA\u00051am\u001c:nCR,\u0012\u0001\u0019\t\u0004\u0015\u0006d\u0014B\u00012L\u0005\u0019y\u0005\u000f^5p]\u00069am\u001c:nCR\u0004\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u001a\u0002\u000bQL\b/Z:\n\u0005-D'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0013\u0011\fG/\u0019+za\u0016\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\tq\u000eE\u0002KCB\u0004\"!];\u000f\u0005I\u001c\bC\u0001*L\u0013\t!8*\u0001\u0004Qe\u0016$WMZ\u0005\u0003m^\u0014aa\u0015;sS:<'B\u0001;L\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u0002wB\u0011!\n`\u0005\u0003{.\u0013qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\r\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011Q\u0002\t\u0003{\u0001AQaW\u0006A\u0002qBQAX\u0006A\u0002\u0001DQ\u0001Z\u0006A\u0002\u0019Dq!\\\u0006\u0011\u0002\u0003\u0007q\u000eC\u0004z\u0017A\u0005\t\u0019A>\u0002\u0017I,\u0007\u000f\\1dK6,g\u000e\u001e\u000b\u0007\u0003\u0007\t\u0019\"!\u0006\t\u000bmk\u0001\u0019\u0001\u001f\t\u000byk\u0001\u0019\u0001\u001f\u0015\t\u0005\r\u0011\u0011\u0004\u0005\u00067:\u0001\r\u0001P\u0001\t]>$WMT1nKV\t\u0001/\u0001\u000bo_\u0012,\u0007+\u0019;uKJt7/\u00138uKJt\u0017\r\u001c\u000b\u0003\u0003G\u0001R\u0001UA\u0013\u0003SI1!a\n[\u0005\r\u0019V-\u001d\t\u0005\u0003W\tiE\u0004\u0003\u0002.\u0005\u001dc\u0002BA\u0018\u0003\u0007rA!!\r\u0002B9!\u00111GA \u001d\u0011\t)$!\u0010\u000f\t\u0005]\u00121\b\b\u0004%\u0006e\u0012\"A\u001d\n\u0005]B\u0014BA\u001b7\u0013\t\u0019D'\u0003\u00022e%\u0019\u0011Q\t\u0019\u0002\u000bQ\u0014X-Z:\n\t\u0005%\u00131J\u0001\f)J,W\rU1ui\u0016\u0014hNC\u0002\u0002FAJA!a\u0014\u0002R\tYAK]3f!\u0006$H/\u001a:o\u0015\u0011\tI%a\u0013\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0007\u0019\u000b9\u0006C\u0003n#\u0001\u0007\u0001/\u0001\u0005dQ&dGM]3o+\t\ti\u0006\u0005\u0003Q\u0003Ka\u0014AC5oaV$H+\u001f9fgV\u0011\u00111\r\t\u0006!\u0006\u0015\u0012Q\r\t\u0004O\u0006\u001d\u0014bAA5Q\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2\u0001PA8\u0011\u001d\t\t\b\u0006a\u0001\u0003g\n1B\\3x\u0007\"LG\u000e\u001a:f]B!\u0001+!\u001e=\u0013\r\t9H\u0017\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001B2paf$B\"a\u0001\u0002~\u0005}\u0014\u0011QAB\u0003\u000bCqaW\u000b\u0011\u0002\u0003\u0007A\bC\u0004_+A\u0005\t\u0019\u00011\t\u000f\u0011,\u0002\u0013!a\u0001M\"9Q.\u0006I\u0001\u0002\u0004y\u0007bB=\u0016!\u0003\u0005\ra_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYIK\u0002=\u0003\u001b[#!a$\u0011\t\u0005E\u00151T\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033[\u0015AC1o]>$\u0018\r^5p]&!\u0011QTAJ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019KK\u0002a\u0003\u001b\u000babY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002**\u001aa-!$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0016\u0016\u0004_\u00065\u0015AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0003kS3a_AG\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0017\u0001\u00026bm\u0006L1A^A`\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\rE\u0002K\u0003\u001fL1!!5L\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9.!8\u0011\u0007)\u000bI.C\u0002\u0002\\.\u00131!\u00118z\u0011%\ty.HA\u0001\u0002\u0004\ti-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003K\u0004b!a:\u0002n\u0006]WBAAu\u0015\r\tYoS\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAx\u0003S\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u001910!>\t\u0013\u0005}w$!AA\u0002\u0005]\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a/\u0002|\"I\u0011q\u001c\u0011\u0002\u0002\u0003\u0007\u0011QZ\u0001\u0007KF,\u0018\r\\:\u0015\u0007m\u0014\t\u0001C\u0005\u0002`\u0006\n\t\u00111\u0001\u0002X\":\u0002A!\u0002\u0003\f\t5!\u0011\u0003B\n\u0005/\u0011IB!\b\u0003 \t\r\"Q\u0005\t\u0004{\t\u001d\u0011b\u0001B\u0005]\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\b\u0003\t%&\u0002\t\u0011!A}3UKT\"`QQLW.Z:uC6\u0004xl\u001d;s72\u0002c-\u001c;^S\u0001j\u0003\u0005U1sg\u0016\u001c\b\u0005\u001e5fA\u0001$\u0018.\\3ti\u0006l\u0007oX:ue\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!o&$\b\u000e\t;iK\u0002\u0002g-\u001c;aA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003\u0005^8!C\u0002\"\u0018.\\3ti\u0006l\u0007O\f\u0011SKR,(O\\:!]VdG\u000eI<ji\"\u0004\u0013N\u001c<bY&$\u0007%\u001b8qkRt\u0003EQ=!I\u00164\u0017-\u001e7uY\u0001JG\u000f\t4pY2|wo\u001d\u0011dCN$\u0018N\\4!eVdWm\u001d\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0005\u0004C/[7fgR\fW\u000e\u001d\u0011jM\u0002\"\b.\u001a\u0011aM6$\b\rI5tA=l\u0017\u000e\u001e;fI:\u0002C\u000b[3!e\u0016\u001cX\u000f\u001c;!I\u0006$\u0018\r\t;za\u0016\u0004\u0013n\u001d\u0011d_:\u001c\u0018n\u001d;f]R\u0004s/\u001b;iAQDW\r\t<bYV,\u0007e\u001c4\u000bA\u0001\u0002\u0003\u0005\t\u0011d_:4\u0017nZ;sCRLwN\u001c\u0011agB\f'o\u001b\u0018tc2tC/[7fgR\fW\u000e\u001d+za\u0016\u0004gF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0003\u0016\u0005\u0011iD\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lWm\u001d;b[B|6\u000f\u001e:![\u0001\n\u0005e\u001d;sS:<\u0007\u0005^8!E\u0016\u0004\u0003/\u0019:tK\u0012\u0004Co\u001c\u0011uS6,7\u000f^1na:R\u0001\u0005\t\u0011!A\u0001R\u0003EZ7uA5\u0002C+[7fgR\fW\u000e\u001d\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8!i>\u0004cm\u001c7m_^t\u0003eU3fAq\n\u0007\u0005\u001b:fMv\u0012\u0003\u000e\u001e;qgjzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40I>\u001c7o\f7bi\u0016\u001cHoL:rY6\u0012XMZ\u0017eCR,G/[7f[A\fG\u000f^3s]:BG/\u001c7#}\u0011\u000bG/\u001a;j[\u0016\u0004\u0003+\u0019;uKJt7\u000fP\u0018b}\u00012wN\u001d\u0011wC2LGM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t3bi\u0016\u0004\u0013M\u001c3!i&lW\r\t4pe6\fG\u000f\t9biR,'O\\:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tm\u0011!!\u0015\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'\r\u001c.cIj3'\r\u00111ai\n$G\u000f\u00191O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\n$'L\u001a2AA\u0002$(\r\u001a;aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0013GM\u00174c\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0013GM\u00174c\u0001\u0002\u0004G\u000f\u00191uA\u0002$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\u0005\u0012A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005O\tQA\r\u00183]A\n\u0001\u0003U1sg\u0016$v\u000eV5nKN$\u0018-\u001c9\u0011\u0005u\u001a3#B\u0012\u00030\tm\u0002c\u0003B\u0019\u0005oa\u0004MZ8|\u0003\u0007i!Aa\r\u000b\u0007\tU2*A\u0004sk:$\u0018.\\3\n\t\te\"1\u0007\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:,\u0004\u0003\u0002B\u001f\u0005\u0007j!Aa\u0010\u000b\t\t\u0005\u00131Y\u0001\u0003S>L1!\u0017B )\t\u0011Y#\u0001\u0005u_N#(/\u001b8h)\t\tY,A\u0003baBd\u0017\u0010\u0006\u0007\u0002\u0004\t=#\u0011\u000bB*\u0005+\u00129\u0006C\u0003\\M\u0001\u0007A\bC\u0003_M\u0001\u0007\u0001\rC\u0003eM\u0001\u0007a\rC\u0004nMA\u0005\t\u0019A8\t\u000fe4\u0003\u0013!a\u0001w\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0003\u001d)h.\u00199qYf$BA!\u0019\u0003jA!!*\u0019B2!!Q%Q\r\u001faM>\\\u0018b\u0001B4\u0017\n1A+\u001e9mKVB\u0011Ba\u001b*\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tU\u0004\u0003BA_\u0005oJAA!\u001f\u0002@\n1qJ\u00196fGR\u0004")
public class ParseToTimestamp
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeZoneAwareExpression,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Option<Expression> format;
    private final DataType dataType;
    private final Option<String> timeZoneId;
    private final boolean failOnError;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private Expression canonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return ParseToTimestamp$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return ParseToTimestamp$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Option<Expression>, DataType, Option<String>, Object>> unapply(ParseToTimestamp x$0) {
        return ParseToTimestamp$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$5() {
        return ParseToTimestamp$.MODULE$.apply$default$5();
    }

    public static Option<String> apply$default$4() {
        return ParseToTimestamp$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<Expression, Option<Expression>, DataType, Option<String>, Object>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<DataType, Function1<Option<String>, Function1<Object, ParseToTimestamp>>>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private Expression replacement$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)this.format().map((Function1 & Serializable)f -> new GetTimestamp(this.left(), (Expression)f, this.dataType(), this.timeZoneId(), this.failOnError())).getOrElse((Function0 & Serializable)() -> Cast$.MODULE$.apply(this.left(), this.dataType(), this.timeZoneId(), this.failOnError()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String nodeName() {
        return "to_timestamp";
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.RUNTIME_REPLACEABLE()}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        DataType x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1, x$5);
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq types = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$}));
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)(this.dataType() instanceof TimestampType ? (Seq)types.$colon$plus((Object)NumericType$.MODULE$) : types));
        return (Seq)Option$.MODULE$.option2Iterable(this.format().map((Function1 & Serializable)x$7 -> StringType$.MODULE$)).toSeq().$plus$colon((Object)typeCollection);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.format().isDefined() ? this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3(), this.copy$default$4(), this.copy$default$5()) : this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, DataType dataType, Option<String> timeZoneId, boolean failOnError) {
        return new ParseToTimestamp(left, format, dataType, timeZoneId, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public DataType copy$default$3() {
        return this.dataType();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    public boolean copy$default$5() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.dataType();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            case 2: {
                string = "dataType";
                break;
            }
            case 3: {
                string = "timeZoneId";
                break;
            }
            case 4: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        if (this.failOnError() != parseToTimestamp.failOnError()) return false;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        DataType dataType = this.dataType();
        DataType dataType2 = parseToTimestamp.dataType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = parseToTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, DataType dataType, Option<String> timeZoneId, boolean failOnError) {
        this.left = left;
        this.format = format;
        this.dataType = dataType;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), SQLConf$.MODULE$.get().timestampType(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$4(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$5());
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, SQLConf$.MODULE$.get().timestampType(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$4(), ParseToTimestamp$.MODULE$.$lessinit$greater$default$5());
    }
}

