/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase;
import org.apache.spark.sql.catalyst.expressions.RegExpInStr$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp) - Searches a string for a regular expression and returns an integer that indicates the beginning position of the matched substring. Positions are 1-based, not 0-based. If no match is found, returns 0.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('user@spark.apache.org', '@[^.]*');\n       5\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0011\"\u0001:B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u00031\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B$\t\u000b=\u0003A\u0011\u0001)\t\u000b=\u0003A\u0011A+\t\u000bi\u0003A\u0011I.\t\u000b\r\u0004A\u0011\t3\t\u000b-\u0004A\u0011\t7\t\u000bU\u0004A\u0011\u000b<\t\u000f\u0005%\u0001\u0001\"\u0015\u0002\f!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003G\u0001\u0011\u0013!C\u0001\u0003KA\u0011\"a\u000f\u0001#\u0003%\t!!\n\t\u0013\u0005u\u0002!%A\u0005\u0002\u0005\u0015\u0002\"CA \u0001\u0005\u0005I\u0011IA!\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0001\u0002^!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003g\u0002\u0011\u0011!C\u0001\u0003kB\u0011\"a \u0001\u0003\u0003%\t%!!\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001du!CAYC\u0005\u0005\t\u0012AAZ\r!\u0001\u0013%!A\t\u0002\u0005U\u0006BB(\u001b\t\u0003\ti\rC\u0005\u0002Pj\t\t\u0011\"\u0012\u0002R\"I\u00111\u001b\u000e\u0002\u0002\u0013\u0005\u0015Q\u001b\u0005\n\u0003;T\u0012\u0011!CA\u0003?D\u0011\"!=\u001b\u0003\u0003%I!a=\u0003\u0017I+w-\u0012=q\u0013:\u001cFO\u001d\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M!\u0001aL\u001a:!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014EA\tSK\u001e,\u0005\u0010]#yiJ\f7\r\u001e\"bg\u0016\u0004\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002;\u0005:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}5\na\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005\u0005+\u0014a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!Q\u001b\u0002\u000fM,(M[3diV\tq\t\u0005\u00021\u0011&\u0011\u0011*\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001C:vE*,7\r\u001e\u0011\u0002\rI,w-\u001a=q\u0003\u001d\u0011XmZ3ya\u0002\n1!\u001b3y\u0003\u0011IG\r\u001f\u0011\u0002\rqJg.\u001b;?)\u0011\t&k\u0015+\u0011\u0005A\u0002\u0001\"B#\b\u0001\u00049\u0005\"B&\b\u0001\u00049\u0005\"B'\b\u0001\u00049EcA)W1\")q\u000b\u0003a\u0001\u000f\u0006\t1\u000fC\u0003Z\u0011\u0001\u0007q)A\u0001s\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011av\fY1\u0011\u0005Qj\u0016B\u000106\u0005\r\te.\u001f\u0005\u0006/&\u0001\r\u0001\u0018\u0005\u00063&\u0001\r\u0001\u0018\u0005\u0006E&\u0001\r\u0001X\u0001\u0002S\u0006AA-\u0019;b)f\u0004X-F\u0001f!\t1\u0017.D\u0001h\u0015\tAW%A\u0003usB,7/\u0003\u0002kO\nAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!\u001c\t\u0003]Jt!a\u001c9\u0011\u0005q*\u0014BA96\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E,\u0014!\u00033p\u000f\u0016t7i\u001c3f)\u00119X0!\u0002\u0011\u0005a\\X\"A=\u000b\u0005i\f\u0013aB2pI\u0016<WM\\\u0005\u0003yf\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006}2\u0001\ra`\u0001\u0004GRD\bc\u0001=\u0002\u0002%\u0019\u00111A=\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u0011q\u0001\u0007A\u0002]\f!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB)\u0002\u000e\u0005E\u0011Q\u0003\u0005\u0007\u0003\u001fi\u0001\u0019A$\u0002\u00119,wOR5sgRDa!a\u0005\u000e\u0001\u00049\u0015!\u00038foN+7m\u001c8e\u0011\u0019\t9\"\u0004a\u0001\u000f\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLHcB)\u0002\u001e\u0005}\u0011\u0011\u0005\u0005\b\u000b:\u0001\n\u00111\u0001H\u0011\u001dYe\u0002%AA\u0002\u001dCq!\u0014\b\u0011\u0002\u0003\u0007q)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d\"fA$\u0002*-\u0012\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003%)hn\u00195fG.,GMC\u0002\u00026U\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI$a\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0011\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005!A.\u00198h\u0015\t\ti%\u0001\u0003kCZ\f\u0017bA:\u0002H\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u000b\t\u0004i\u0005]\u0013bAA-k\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A,a\u0018\t\u0013\u0005\u0005D#!AA\u0002\u0005U\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002hA)\u0011\u0011NA896\u0011\u00111\u000e\u0006\u0004\u0003[*\u0014AC2pY2,7\r^5p]&!\u0011\u0011OA6\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0014Q\u0010\t\u0004i\u0005e\u0014bAA>k\t9!i\\8mK\u0006t\u0007\u0002CA1-\u0005\u0005\t\u0019\u0001/\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0007\n\u0019\tC\u0005\u0002b]\t\t\u00111\u0001\u0002V\u00051Q-];bYN$B!a\u001e\u0002\n\"A\u0011\u0011\r\r\u0002\u0002\u0003\u0007A\fK\f\u0001\u0003\u001b\u000b\u0019*!&\u0002\u001a\u0006m\u0015qTAQ\u0003K\u000b9+a+\u0002.B\u0019\u0001'a$\n\u0007\u0005E\u0015EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005]\u0015!!3\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\u0012XmZ3ya&\u0002S\u0006I*fCJ\u001c\u0007.Z:!C\u0002\u001aHO]5oO\u00022wN\u001d\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011b]\u0012\u0004#/\u001a;ve:\u001c\b%\u00198!S:$XmZ3sAQD\u0017\r\u001e\u0011j]\u0012L7-\u0019;fg\u0002\"\b.\u001a\u0011cK\u001eLgN\\5oO\u0002\u0002xn]5uS>t\u0007e\u001c4!i\",\u0007%\\1uG\",G\rI:vEN$(/\u001b8h]\u0001\u0002vn]5uS>t7\u000fI1sK\u0002\nTFY1tK\u0012d\u0003E\\8uAAj#-Y:fI:\u0002\u0013J\u001a\u0011o_\u0002j\u0017\r^2iA%\u001c\bEZ8v]\u0012d\u0003E]3ukJt7\u000f\t\u0019/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\ti*AC\u001d\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o])\u0001\u0003\u0005\t\u0011!A)\u0002#/Z4fqB\u0004S\u0006I1!gR\u0014\u0018N\\4!e\u0016\u0004(/Z:f]RLgn\u001a\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007E]3hKb\u00043\u000f\u001e:j]\u001e\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011b\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003ES1wC\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/y\t\u0014h\b\u00102s})\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I*j]\u000e,\u0007e\u00159be.\u0004#G\f\u0019-AM$(/\u001b8hA1LG/\u001a:bYN\u0004\u0003&\u001b8dYV$\u0017N\\4!e\u0016<W\r\u001f\u0011qCR$XM\u001d8tS\u0001\n'/\u001a\u0011v]\u0016\u001c8-\u00199fI\u0002Jg\u000eI8ve\u0002\u001a\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0018M]:fe:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006I1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|g\u000e\t4pe\u0002\u0002'/Z4fqB\u0004\u0007eY1oA\t,'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!EycF,\u00192dI\trCH\u0019:?y\t\u0014hH\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQCWM]3!SN\u0004\u0013\rI*R\u0019\u0002\u001awN\u001c4jO\u0002:3\u000f]1sW:\u001a\u0018\u000f\u001c\u0018qCJ\u001cXM\u001d\u0018fg\u000e\f\u0007/\u001a3TiJLgn\u001a'ji\u0016\u0014\u0018\r\\:(AQD\u0017\r\u001e\u0011dC:\u0004#-\u001a\u0011vg\u0016$\u0007\u0005^8\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002c-\u00197mE\u0006\u001c7\u000e\t;pAQDW\rI*qCJ\\\u0007%\r\u00187A\t,\u0007.\u0019<j_J\u0004#/Z4be\u0012Lgn\u001a\u0011tiJLgn\u001a\u0011mSR,'/\u00197!a\u0006\u00148/\u001b8h]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001b4!i\",\u0007eY8oM&<\u0007%[:!K:\f'\r\\3eY\u0001\"\b.\u001a\u0011ae\u0016<W\r\u001f9aAQD\u0017\r\u001e\u0011dC:\u0004S.\u0019;dQ\u0002\u0012C,\u00192dE\u0001J7\u000f\t\u0012_9\u0006\u00147\r\n\u0012/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0016\u0001\u0016\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OU\u001cXM\u001d!ta\u0006\u00148NL1qC\u000eDWML8sO\u001eb\u0003e\n!\\=:j&fJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AUR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003S\u000bQa\r\u00185]A\nQa\u001a:pkB\f#!a,\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0017I+w-\u0012=q\u0013:\u001cFO\u001d\t\u0003ai\u0019RAGA\\\u0003\u0007\u0004\u0002\"!/\u0002@\u001e;u)U\u0007\u0003\u0003wS1!!06\u0003\u001d\u0011XO\u001c;j[\u0016LA!!1\u0002<\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fTA!!3\u0002L\u0005\u0011\u0011n\\\u0005\u0004\u0007\u0006\u001dGCAAZ\u0003!!xn\u0015;sS:<GCAA\"\u0003\u0015\t\u0007\u000f\u001d7z)\u001d\t\u0016q[Am\u00037DQ!R\u000fA\u0002\u001dCQaS\u000fA\u0002\u001dCQ!T\u000fA\u0002\u001d\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002b\u00065\b#\u0002\u001b\u0002d\u0006\u001d\u0018bAAsk\t1q\n\u001d;j_:\u0004b\u0001NAu\u000f\u001e;\u0015bAAvk\t1A+\u001e9mKNB\u0001\"a<\u001f\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA{!\u0011\t)%a>\n\t\u0005e\u0018q\t\u0002\u0007\u001f\nTWm\u0019;")
public class RegExpInStr
extends RegExpExtractBase
implements Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpInStr x$0) {
        return RegExpInStr$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpInStr> tupled() {
        return RegExpInStr$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpInStr>>> curried() {
        return RegExpInStr$.MODULE$.curried();
    }

    @Override
    public Expression subject() {
        return this.subject;
    }

    @Override
    public Expression regexp() {
        return this.regexp;
    }

    @Override
    public Expression idx() {
        return this.idx;
    }

    @Override
    public Object nullSafeEval(Object s, Object r, Object i) {
        Integer n;
        block3: {
            try {
                Matcher m = this.getLastMatcher(s, r);
                if (m.find()) {
                    n = BoxesRunTime.boxToInteger((int)(m.toMatchResult().start() + 1));
                    break block3;
                }
                n = BoxesRunTime.boxToInteger((int)0);
            }
            catch (IllegalStateException illegalStateException) {
                n = BoxesRunTime.boxToInteger((int)0);
            }
        }
        return n;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "regexp_instr";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String matcher = ctx.freshName("matcher");
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(subject, regexp, x$10) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(258).append("\n         |try {\n         |  ").append(setEvNotNull).append("\n         |  ").append(this.initLastMatcherCode(ctx, (String)subject, (String)regexp, matcher)).append("\n         |  if (").append(matcher).append(".find()) {\n         |    ").append(ev.value()).append(" = ").append(matcher).append(".toMatchResult().start() + 1;\n         |  } else {\n         |    ").append(ev.value()).append(" = 0;\n         |  }\n         |} catch (IllegalStateException e) {\n         |  ").append(ev.value()).append(" = 0;\n         |}\n         |").toString())));
    }

    @Override
    public RegExpInStr withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public RegExpInStr copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpInStr(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpInStr";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.subject();
                break;
            }
            case 1: {
                object = this.regexp();
                break;
            }
            case 2: {
                object = this.idx();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpInStr;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "subject";
                break;
            }
            case 1: {
                string = "regexp";
                break;
            }
            case 2: {
                string = "idx";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpInStr)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpInStr regExpInStr = (RegExpInStr)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpInStr.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpInStr.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpInStr.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpInStr.canEqual(this)) return false;
        return true;
    }

    public RegExpInStr(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
    }

    public RegExpInStr(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

