/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(fmt, ts) - Returns timestamp `ts` truncated to the unit specified by the format model `fmt`.\n  ", arguments="\n    Arguments:\n      * fmt - the format representing the unit to be truncated to\n          - \"YEAR\", \"YYYY\", \"YY\" - truncate to the first date of the year that the `ts` falls in, the time part will be zero out\n          - \"QUARTER\" - truncate to the first date of the quarter that the `ts` falls in, the time part will be zero out\n          - \"MONTH\", \"MM\", \"MON\" - truncate to the first date of the month that the `ts` falls in, the time part will be zero out\n          - \"WEEK\" - truncate to the Monday of the week that the `ts` falls in, the time part will be zero out\n          - \"DAY\", \"DD\" - zero out the time part\n          - \"HOUR\" - zero out the minute and second with fraction part\n          - \"MINUTE\"- zero out the second with fraction part\n          - \"SECOND\" -  zero out the second fraction part\n          - \"MILLISECOND\" - zero out the microseconds\n          - \"MICROSECOND\" - everything remains\n      * ts - datetime value or valid timestamp string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('YEAR', '2015-03-05T09:32:05.359');\n       2015-01-01 00:00:00\n      > SELECT _FUNC_('MM', '2015-03-05T09:32:05.359');\n       2015-03-01 00:00:00\n      > SELECT _FUNC_('DD', '2015-03-05T09:32:05.359');\n       2015-03-05 00:00:00\n      > SELECT _FUNC_('HOUR', '2015-03-05T09:32:05.359');\n       2015-03-05 09:00:00\n      > SELECT _FUNC_('MILLISECOND', '2015-03-05T09:32:05.123456');\n       2015-03-05 09:32:05.123\n  ", group="datetime_funcs", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0005\tub\u0001\u0002\u0015*\u0001ZB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\"A\u0011\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003V\u0011!Y\u0006A!f\u0001\n\u0003a\u0006\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B/\t\u000b%\u0004A\u0011\u00016\t\u000b=\u0004A\u0011\t+\t\u000bA\u0004A\u0011\t+\t\u000bE\u0004A\u0011\t:\t\u000bq\u0004A\u0011I?\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!A\u0011q\u0001\u0001C\u0002\u0013\u0005C\u000bC\u0004\u0002\n\u0001\u0001\u000b\u0011B+\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!1\u0011\u000e\u0001C\u0001\u0003#Aq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005-\u0003\u0001\"\u0015\u0002N!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003C\u0002\u0011\u0013!C\u0001\u0003GB\u0011\"!\u001f\u0001#\u0003%\t!a\u0019\t\u0013\u0005m\u0004!%A\u0005\u0002\u0005u\u0004\"CAA\u0001\u0005\u0005I\u0011IAB\u0011%\t\u0019\nAA\u0001\n\u0003\t)\nC\u0005\u0002\u001e\u0002\t\t\u0011\"\u0001\u0002 \"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0013q\u0015\u0005\n\u0003k\u0003\u0011\u0011!C\u0001\u0003oC\u0011\"!1\u0001\u0003\u0003%\t%a1\t\u0013\u0005\u001d\u0007!!A\u0005B\u0005%w!CAzS\u0005\u0005\t\u0012AA{\r!A\u0013&!A\t\u0002\u0005]\bBB5!\t\u0003\u0011y\u0001C\u0005\u0003\u0012\u0001\n\t\u0011\"\u0012\u0003\u0014!I!Q\u0003\u0011\u0002\u0002\u0013\u0005%q\u0003\u0005\n\u0005?\u0001\u0013\u0013!C\u0001\u0003{B\u0011B!\t!\u0003\u0003%\tIa\t\t\u0013\tE\u0002%%A\u0005\u0002\u0005u\u0004\"\u0003B\u001aA\u0005\u0005I\u0011\u0002B\u001b\u00059!&/\u001e8d)&lWm\u001d;b[BT!AK\u0016\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Y5\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003]=\n1a]9m\u0015\t\u0001\u0014'A\u0003ta\u0006\u00148N\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<7\u0001A\n\u0007\u0001]Zd(Q$\u0011\u0005aJT\"A\u0015\n\u0005iJ#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tAD(\u0003\u0002>S\taAK];oG&s7\u000f^1oiB\u0011\u0001hP\u0005\u0003\u0001&\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001\n\u0015\b\u0003\u0013:s!AS'\u000e\u0003-S!\u0001T\u001b\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0015BA(D\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0015*\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005=\u001b\u0015A\u00024pe6\fG/F\u0001V!\tAd+\u0003\u0002XS\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000f\u0019|'/\\1uA\u0005IA/[7fgR\fW\u000e]\u0001\u000bi&lWm\u001d;b[B\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\tQ\fE\u0002C=\u0002L!aX\"\u0003\r=\u0003H/[8o!\t\tWM\u0004\u0002cGB\u0011!jQ\u0005\u0003I\u000e\u000ba\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011AmQ\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005W2lg\u000e\u0005\u00029\u0001!)1k\u0002a\u0001+\")\u0011l\u0002a\u0001+\"91l\u0002I\u0001\u0002\u0004i\u0016\u0001\u00027fMR\fQA]5hQR\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0019\bc\u0001%um&\u0011QO\u0015\u0002\u0004'\u0016\f\bCA<{\u001b\u0005A(BA=.\u0003\u0015!\u0018\u0010]3t\u0013\tY\bP\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001\u007f!\t9x0C\u0002\u0002\u0002a\u0014Q\u0002V5nKN$\u0018-\u001c9UsB,\u0017A\u00039sKR$\u0018PT1nKV\t\u0001-A\u0004j]N$\u0018M\u001c;\u0002\u0011%t7\u000f^1oi\u0002\nAb^5uQRKW.\u001a.p]\u0016$2APA\b\u0011\u0015Yv\u00021\u0001a)\u0015Y\u00171CA\u000b\u0011\u0015\u0019\u0006\u00031\u0001V\u0011\u0015I\u0006\u00031\u0001V\u0003\u0011)g/\u00197\u0015\t\u0005m\u0011\u0011\u0005\t\u0004\u0005\u0006u\u0011bAA\u0010\u0007\n\u0019\u0011I\\=\t\u0013\u0005\r\u0012\u0003%AA\u0002\u0005\u0015\u0012!B5oaV$\b\u0003BA\u0014\u0003Si\u0011aK\u0005\u0004\u0003WY#aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005E\u0012QHA$!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001cS\u000591m\u001c3fO\u0016t\u0017\u0002BA\u001e\u0003k\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u007f\u0011\u0002\u0019AA!\u0003\r\u0019G\u000f\u001f\t\u0005\u0003g\t\u0019%\u0003\u0003\u0002F\u0005U\"AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0013\u0012\u0002\u0019AA\u0019\u0003\t)g/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)1.a\u0014\u0002T!1\u0011\u0011K\nA\u0002U\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002VM\u0001\r!V\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u001dY\u00171LA/\u0003?Bqa\u0015\u000b\u0011\u0002\u0003\u0007Q\u000bC\u0004Z)A\u0005\t\u0019A+\t\u000fm#\u0002\u0013!a\u0001;\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA3U\r)\u0016qM\u0016\u0003\u0003S\u0002B!a\u001b\u0002v5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0005v]\u000eDWmY6fI*\u0019\u00111O\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002x\u00055$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u007fR3!XA4\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0015\u0001\u00026bm\u0006L1AZAE\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\nE\u0002C\u00033K1!a'D\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY\"!)\t\u0013\u0005\r&$!AA\u0002\u0005]\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002*B1\u00111VAY\u00037i!!!,\u000b\u0007\u0005=6)\u0001\u0006d_2dWm\u0019;j_:LA!a-\u0002.\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI,a0\u0011\u0007\t\u000bY,C\u0002\u0002>\u000e\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002$r\t\t\u00111\u0001\u0002\u001c\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t))!2\t\u0013\u0005\rV$!AA\u0002\u0005]\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002:\u0006-\u0007\"CAR=\u0005\u0005\t\u0019AA\u000eQ]\u0001\u0011qZAk\u0003/\fY.!8\u0002b\u0006\r\u0018q]Au\u0003[\fy\u000fE\u00029\u0003#L1!a5*\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!7\u0002W*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015g[Rd\u0003\u0005^:*A5\u0002#+\u001a;ve:\u001c\b\u0005^5nKN$\u0018-\u001c9!AR\u001c\b\r\t;sk:\u001c\u0017\r^3eAQ|\u0007\u0005\u001e5fAUt\u0017\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u0012\u0017\u0010\t;iK\u00022wN]7bi\u0002jw\u000eZ3mA\u00014W\u000e\u001e1/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\ty.ADJ\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002c-\u001c;![\u0001\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0011sKB\u0014Xm]3oi&tw\r\t;iK\u0002*h.\u001b;!i>\u0004#-\u001a\u0011ueVt7-\u0019;fI\u0002\"xN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%W#B%\nb\u0003EI-Z3f\u0013C\u0006\t\u0012Z3\n\u0002S\u0006\t;sk:\u001c\u0017\r^3!i>\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011eCR,\u0007e\u001c4!i\",\u0007%_3be\u0002\"\b.\u0019;!i\",\u0007\u0005\u0019;tA\u00022\u0017\r\u001c7tA%tG\u0006\t;iK\u0002\"\u0018.\\3!a\u0006\u0014H\u000fI<jY2\u0004#-\u001a\u0011{KJ|\u0007e\\;u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011##V\u000b%\u000bV#SE\u0001j\u0003\u0005\u001e:v]\u000e\fG/\u001a\u0011u_\u0002\"\b.\u001a\u0011gSJ\u001cH\u000f\t3bi\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013/^1si\u0016\u0014\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011aiN\u0004\u0007EZ1mYN\u0004\u0013N\u001c\u0017!i\",\u0007\u0005^5nK\u0002\u0002\u0018M\u001d;!o&dG\u000e\t2fAi,'o\u001c\u0011pkRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tjuJ\u0014+IE1\u0002#%T'#Y\u0001\u0012Sj\u0014(#A5\u0002CO];oG\u0006$X\r\t;pAQDW\r\t4jeN$\b\u0005Z1uK\u0002zg\r\t;iK\u0002jwN\u001c;iAQD\u0017\r\u001e\u0011uQ\u0016\u0004\u0003\r^:aA\u0019\fG\u000e\\:!S:d\u0003\u0005\u001e5fAQLW.\u001a\u0011qCJ$\be^5mY\u0002\u0012W\r\t>fe>\u0004s.\u001e;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012X\u000b\u0016[%\u0005I\u0017!iJ,hnY1uK\u0002\"x\u000e\t;iK\u0002juN\u001c3bs\u0002zg\r\t;iK\u0002:X-Z6!i\"\fG\u000f\t;iK\u0002\u0002Go\u001d1!M\u0006dGn\u001d\u0011j]2\u0002C\u000f[3!i&lW\r\t9beR\u0004s/\u001b7mA\t,\u0007E_3s_\u0002zW\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t#B3\nb\u0003E\t#EE\u0001j\u0003E_3s_\u0002zW\u000f\u001e\u0011uQ\u0016\u0004C/[7fAA\f'\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t%P+J\u0013\u0003%\f\u0011{KJ|\u0007e\\;uAQDW\rI7j]V$X\rI1oI\u0002\u001aXmY8oI\u0002:\u0018\u000e\u001e5!MJ\f7\r^5p]\u0002\u0002\u0018M\u001d;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u0013:+F+\u0012\u0012.Ai,'o\u001c\u0011pkR\u0004C\u000f[3!g\u0016\u001cwN\u001c3!o&$\b\u000e\t4sC\u000e$\u0018n\u001c8!a\u0006\u0014HO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#eU#D\u001f:#%\u0005I\u0017!Ai,'o\u001c\u0011pkR\u0004C\u000f[3!g\u0016\u001cwN\u001c3!MJ\f7\r^5p]\u0002\u0002\u0018M\u001d;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u00132c\u0015jU#D\u001f:#%\u0005I\u0017!u\u0016\u0014x\u000eI8vi\u0002\"\b.\u001a\u0011nS\u000e\u0014xn]3d_:$7O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%T%D%>\u001bViQ(O\t\n\u0002S\u0006I3wKJLH\u000f[5oO\u0002\u0012X-\\1j]NT\u0001\u0005\t\u0011!A\u0001R\u0003\u0005^:![\u0001\"\u0017\r^3uS6,\u0007E^1mk\u0016\u0004sN\u001d\u0011wC2LG\r\t;j[\u0016\u001cH/Y7qAM$(/\u001b8h\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0018a!#\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dJV)\u0011*(Y\u0001:#\u0007M\u00196[A\u001aT\u0006M\u001bUaeR4G\r\u001e1k9\u001aT'O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001b.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":S*T\u0014-A\u001d\u0012\u0004'M\u001b.aMj\u0003'\u000e+1si\u001a$G\u000f\u00196]M*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171g5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"Ei\n\u0017!OI\u0002\u0014'N\u00171g5\u0002T\u0007\u0016\u0019:uM\u0012$\bM\u001b/gUJt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nT'\f\u00194[A*\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!{UKU\u0014-A\u001d\u0012\u0004'M\u001b.aMj\u0003'\u000e+1si\u001a$G\u000f\u00196]M*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171g5\u0002T\u0007\t\u0019:uA\u0002$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dj\u0015\n\u0014'J'\u0016\u001buJ\u0014#(Y\u0001:#\u0007M\u00196[A\u001aT\u0006M\u001bUaeR4G\r\u001e1k9\n$g\r\u001b6m\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cUj\u0003gM\u00171k\u0001\u0002\u0014HO\u001a3uA*d&\r\u001a4\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAv\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!!=\u0002\u000bIr3G\f\u0019\u0002\u001dQ\u0013XO\\2US6,7\u000f^1naB\u0011\u0001\bI\n\u0006A\u0005e(Q\u0001\t\t\u0003w\u0014\t!V+^W6\u0011\u0011Q \u0006\u0004\u0003\u007f\u001c\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005\u0007\tiPA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BAa\u0002\u0003\u000e5\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\ti)\u0001\u0002j_&\u0019\u0011K!\u0003\u0015\u0005\u0005U\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0015!B1qa2LHcB6\u0003\u001a\tm!Q\u0004\u0005\u0006'\u000e\u0002\r!\u0016\u0005\u00063\u000e\u0002\r!\u0016\u0005\b7\u000e\u0002\n\u00111\u0001^\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005K\u0011i\u0003\u0005\u0003C=\n\u001d\u0002C\u0002\"\u0003*U+V,C\u0002\u0003,\r\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\u0018K\u0005\u0005\t\u0019A6\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005o\u0001B!a\"\u0003:%!!1HAE\u0005\u0019y%M[3di\u0002")
public class TruncTimestamp
extends BinaryExpression
implements TruncInstant,
TimeZoneAwareExpression,
Serializable {
    private final Expression format;
    private final Expression timestamp;
    private final Option<String> timeZoneId;
    private final Expression instant;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return TruncTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(TruncTimestamp x$0) {
        return TruncTimestamp$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return TruncTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, TruncTimestamp> tupled() {
        return TruncTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, TruncTimestamp>>> curried() {
        return TruncTimestamp$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public boolean nullable() {
        return TruncInstant.nullable$(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int minLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant.evalHelper$(this, input, minLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int minLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant.codeGenHelper$(this, ctx, ev, minLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant.codeGenHelper$default$4$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncTimestamp truncTimestamp = this;
        synchronized (truncTimestamp) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public Expression format() {
        return this.format;
    }

    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.format();
    }

    @Override
    public Expression right() {
        return this.timestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, TimestampType$.MODULE$}));
    }

    @Override
    public TimestampType dataType() {
        return TimestampType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "date_trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_TIMESTAMP_TRUNC(), (Function2<Object, Object, Object>)(Function2 & Serializable)(t, level) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.truncTimestamp(BoxesRunTime.unboxToLong((Object)t), BoxesRunTime.unboxToInt((Object)level), this.zoneId())));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_TIMESTAMP_TRUNC(), true, (Function2<String, String, String>)(Function2 & Serializable)(date, fmt) -> new StringBuilder(21).append("truncTimestamp(").append((String)date).append(", ").append((String)fmt).append(", ").append(zid).append(");").toString());
    }

    @Override
    public TruncTimestamp withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public TruncTimestamp copy(Expression format, Expression timestamp, Option<String> timeZoneId) {
        return new TruncTimestamp(format, timestamp, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.format();
    }

    public Expression copy$default$2() {
        return this.timestamp();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TruncTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.format();
                break;
            }
            case 1: {
                object = this.timestamp();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "format";
                break;
            }
            case 1: {
                string = "timestamp";
                break;
            }
            case 2: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncTimestamp truncTimestamp = (TruncTimestamp)x$1;
        Expression expression = this.format();
        Expression expression2 = truncTimestamp.format();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.timestamp();
        Expression expression4 = truncTimestamp.timestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = truncTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncTimestamp.canEqual(this)) return false;
        return true;
    }

    public TruncTimestamp(Expression format, Expression timestamp, Option<String> timeZoneId) {
        this.format = format;
        this.timestamp = timestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TruncInstant.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        this.instant = timestamp;
        Statics.releaseFence();
    }

    public TruncTimestamp(Expression format, Expression timestamp) {
        this(format, timestamp, (Option<String>)None$.MODULE$);
    }
}

