/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ToNumberBase;
import org.apache.spark.sql.catalyst.expressions.TryToNumber$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n     _FUNC_(expr, fmt) - Convert string 'expr' to a number based on the string format `fmt`.\n       Returns NULL if the string 'expr' does not match the expected format. The format follows the\n       same semantics as the to_number function.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('454', '999');\n       454\n      > SELECT _FUNC_('454.00', '000.00');\n       454.00\n      > SELECT _FUNC_('12,454', '99,999');\n       12454\n      > SELECT _FUNC_('$78.12', '$99.99');\n       78.12\n      > SELECT _FUNC_('12,454.8-', '99,999.9S');\n       -12454.8\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001\u0002\u000e\u001c\u0001\"B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015Y\u0006\u0001\"\u0015]\u0011\u001d\t\u0007!!A\u0005\u0002\tDq!\u001a\u0001\u0012\u0002\u0013\u0005a\rC\u0004r\u0001E\u0005I\u0011\u00014\t\u000fI\u0004\u0011\u0011!C!g\"91\u0010AA\u0001\n\u0003a\b\"CA\u0001\u0001\u0005\u0005I\u0011AA\u0002\u0011%\ty\u0001AA\u0001\n\u0003\n\t\u0002C\u0005\u0002 \u0001\t\t\u0011\"\u0001\u0002\"!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0013q\u0005\u0005\n\u0003W\u0001\u0011\u0011!C!\u0003[9\u0011\"!\u0015\u001c\u0003\u0003E\t!a\u0015\u0007\u0011iY\u0012\u0011!E\u0001\u0003+Baa\u0012\u000b\u0005\u0002\u00055\u0004\"CA8)\u0005\u0005IQIA9\u0011%\t\u0019\bFA\u0001\n\u0003\u000b)\bC\u0005\u0002|Q\t\t\u0011\"!\u0002~!I\u0011q\u0012\u000b\u0002\u0002\u0013%\u0011\u0011\u0013\u0002\f)JLHk\u001c(v[\n,'O\u0003\u0002\u001d;\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqr$\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011&L\u001a\u0011\u0005)ZS\"A\u000e\n\u00051Z\"\u0001\u0004+p\u001dVl'-\u001a:CCN,\u0007C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#a\u0002)s_\u0012,8\r\u001e\t\u0003iqr!!\u000e\u001e\u000f\u0005YJT\"A\u001c\u000b\u0005a:\u0013A\u0002\u001fs_>$h(C\u00011\u0013\tYt&A\u0004qC\u000e\\\u0017mZ3\n\u0005ur$\u0001D*fe&\fG.\u001b>bE2,'BA\u001e0\u0003\u0011aWM\u001a;\u0016\u0003\u0005\u0003\"A\u000b\"\n\u0005\r[\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA%K\u0017B\u0011!\u0006\u0001\u0005\u0006\u007f\u0015\u0001\r!\u0011\u0005\u0006\u000b\u0016\u0001\r!Q\u0001\t]VdG.\u00192mKV\ta\n\u0005\u0002/\u001f&\u0011\u0001k\f\u0002\b\u0005>|G.Z1o\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002'B\u0011A\u000b\u0017\b\u0003+Z\u0003\"AN\u0018\n\u0005]{\u0013A\u0002)sK\u0012,g-\u0003\u0002Z5\n11\u000b\u001e:j]\u001eT!aV\u0018\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcA%^?\")a\f\u0003a\u0001\u0003\u00069a.Z<MK\u001a$\b\"\u00021\t\u0001\u0004\t\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0004\u0013\u000e$\u0007bB \n!\u0003\u0005\r!\u0011\u0005\b\u000b&\u0001\n\u00111\u0001B\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001a\u0016\u0003\u0003\"\\\u0013!\u001b\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00059|\u0013AC1o]>$\u0018\r^5p]&\u0011\u0001o\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\t1\fgn\u001a\u0006\u0002s\u0006!!.\u0019<b\u0013\tIf/\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001~!\tqc0\u0003\u0002\u0000_\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QAA\u0006!\rq\u0013qA\u0005\u0004\u0003\u0013y#aA!os\"A\u0011Q\u0002\b\u0002\u0002\u0003\u0007Q0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0001b!!\u0006\u0002\u001c\u0005\u0015QBAA\f\u0015\r\tIbL\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000f\u0003/\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019a*a\t\t\u0013\u00055\u0001#!AA\u0002\u0005\u0015\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2\u0001^A\u0015\u0011!\ti!EA\u0001\u0002\u0004i\u0018AB3rk\u0006d7\u000fF\u0002O\u0003_A\u0011\"!\u0004\u0013\u0003\u0003\u0005\r!!\u0002)'\u0001\t\u0019$!\u000f\u0002<\u0005}\u0012\u0011IA#\u0003\u000f\nY%!\u0014\u0011\u0007)\n)$C\u0002\u00028m\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002>\u0005\tYO\u0003\u0011!A\u0001\u0002sLR+O\u0007~CS\r\u001f9sY\u00012W\u000e^\u0015![\u0001\u001auN\u001c<feR\u00043\u000f\u001e:j]\u001e\u0004s%\u001a=qe\u001e\u0002Co\u001c\u0011bA9,XNY3sA\t\f7/\u001a3!_:\u0004C\u000f[3!gR\u0014\u0018N\\4!M>\u0014X.\u0019;!A\u001alG\u000f\u0019\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!%\u0016$XO\u001d8tA9+F\n\u0014\u0011jM\u0002\"\b.\u001a\u0011tiJLgn\u001a\u0011(Kb\u0004(o\n\u0011e_\u0016\u001c\bE\\8uA5\fGo\u00195!i\",\u0007%\u001a=qK\u000e$X\r\u001a\u0011g_Jl\u0017\r\u001e\u0018!)\",\u0007EZ8s[\u0006$\bEZ8mY><8\u000f\t;iK*\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0018-\\3!g\u0016l\u0017M\u001c;jGN\u0004\u0013m\u001d\u0011uQ\u0016\u0004Co\\0ok6\u0014WM\u001d\u0011gk:\u001cG/[8o])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019%\u0001B,\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C'\u000e\u001b(Y\u0001:\u0013(O\u001d(SmR\u0001\u0005\t\u0011!A\u0001\u0002C'\u000e\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"T\u0007\u000e\u00181a\u001db\u0003e\n\u00191a9\u0002\u0004gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ*DG\f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013G\r\u00175kQ:C\u0006I\u0014:s1J\u0014(O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0007N\u001b5\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":Ce\u000e\u001d/cI:C\u0006I\u0014%ser\u0013(O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001:\u0004HL\u00193\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013G\r\u00175kQr\u0003(L\u0014-A\u001dJ\u0014\bL\u001d:s9J4kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A5\n$\u0007N\u001b5]aR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0013\nQa\r\u00184]A\nQa\u001a:pkB\f#!a\u0014\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0017Q\u0013\u0018\u0010V8Ok6\u0014WM\u001d\t\u0003UQ\u0019R\u0001FA,\u0003G\u0002r!!\u0017\u0002`\u0005\u000b\u0015*\u0004\u0002\u0002\\)\u0019\u0011QL\u0018\u0002\u000fI,h\u000e^5nK&!\u0011\u0011MA.\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e=\u0002\u0005%|\u0017bA\u001f\u0002hQ\u0011\u00111K\u0001\ti>\u001cFO]5oOR\tA/A\u0003baBd\u0017\u0010F\u0003J\u0003o\nI\bC\u0003@/\u0001\u0007\u0011\tC\u0003F/\u0001\u0007\u0011)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}\u00141\u0012\t\u0006]\u0005\u0005\u0015QQ\u0005\u0004\u0003\u0007{#AB(qi&|g\u000eE\u0003/\u0003\u000f\u000b\u0015)C\u0002\u0002\n>\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAG1\u0005\u0005\t\u0019A%\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002\u0014B\u0019Q/!&\n\u0007\u0005]eO\u0001\u0004PE*,7\r\u001e")
public class TryToNumber
extends ToNumberBase {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(TryToNumber x$0) {
        return TryToNumber$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, TryToNumber> tupled() {
        return TryToNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TryToNumber>> curried() {
        return TryToNumber$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "try_to_number";
    }

    @Override
    public TryToNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public TryToNumber copy(Expression left, Expression right) {
        return new TryToNumber(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "TryToNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TryToNumber;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TryToNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        TryToNumber tryToNumber = (TryToNumber)x$1;
        Expression expression = this.left();
        Expression expression2 = tryToNumber.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = tryToNumber.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!tryToNumber.canEqual(this)) return false;
        return true;
    }

    public TryToNumber(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super(left, right, false);
    }
}

