/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Base64;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnBase64$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str) - Converts the argument from a base 64 string `str` to a binary.", examples="\n    Examples:\n      > SELECT _FUNC_('U3BhcmsgU1FM');\n       Spark SQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001B\u0010!\u00016B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003V\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015I\u0006\u0001\"\u0001l\u0011\u0015q\u0007\u0001\"\u0015p\u0011\u0015)\b\u0001\"\u0011w\u0011\u001d\tI\u0001\u0001C)\u0003\u0017A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005m\u0001\"CA\u0019\u0001E\u0005I\u0011AA\u001a\u0011%\t9\u0004AA\u0001\n\u0003\nI\u0004C\u0005\u0002L\u0001\t\t\u0011\"\u0001\u0002N!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003;\u0002\u0011\u0011!C!\u0003?B\u0011\"!\u001c\u0001\u0003\u0003%\t!a\u001c\t\u0013\u0005M\u0004!!A\u0005B\u0005U\u0004\"CA=\u0001\u0005\u0005I\u0011IA>\u000f\u001d\ty\n\tE\u0001\u0003C3aa\b\u0011\t\u0002\u0005\r\u0006BB-\u0018\t\u0003\t)\fC\u0004\u00028^!\t!!/\t\u0013\u00055w#!A\u0005\u0002\u0006=\u0007\"CAk/E\u0005I\u0011AA\u001a\u0011%\t9nFA\u0001\n\u0003\u000bI\u000eC\u0005\u0002l^\t\n\u0011\"\u0001\u00024!I\u0011Q^\f\u0002\u0002\u0013%\u0011q\u001e\u0002\t+:\u0014\u0015m]37i)\u0011\u0011EI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002$I\u0005A1-\u0019;bYf\u001cHO\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001]I*DH\u0011\t\u0003_Aj\u0011\u0001I\u0005\u0003c\u0001\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003_MJ!\u0001\u000e\u0011\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AN\u001d\u000f\u0005=:\u0014B\u0001\u001d!\u0003\u001d\u0001\u0018mY6bO\u0016L!AO\u001e\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011\u0001\b\t\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\b!J|G-^2u!\t\u0019%J\u0004\u0002E\u0013:\u0011Q\tS\u0007\u0002\r*\u0011q\tL\u0001\u0007yI|w\u000e\u001e \n\u0003}J!\u0001\u000f \n\u0005-c%\u0001D*fe&\fG.\u001b>bE2,'B\u0001\u001d?\u0003\u0015\u0019\u0007.\u001b7e+\u0005y\u0005CA\u0018Q\u0013\t\t\u0006E\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013a\u00034bS2|e.\u0012:s_J,\u0012!\u0016\t\u0003{YK!a\u0016 \u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"2a\u0017/^!\ty\u0003\u0001C\u0003N\u000b\u0001\u0007q\nC\u0004T\u000bA\u0005\t\u0019A+\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u0012\nQ\u0001^=qKNL!!\u001a2\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005A\u0007cA\"jA&\u0011!\u000e\u0014\u0002\u0004'\u0016\fHCA.m\u0011\u0015i\u0007\u00021\u0001P\u0003\u0011)\u0007\u0010\u001d:\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0005A\u001c\bCA\u001fr\u0013\t\u0011hHA\u0002B]fDQ\u0001^\u0005A\u0002A\faa\u001d;sS:<\u0017!\u00033p\u000f\u0016t7i\u001c3f)\u00119X0!\u0002\u0011\u0005a\\X\"A=\u000b\u0005i\u0004\u0013aB2pI\u0016<WM\\\u0005\u0003yf\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006}*\u0001\ra`\u0001\u0004GRD\bc\u0001=\u0002\u0002%\u0019\u00111A=\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u0011q\u0001\u0006A\u0002]\f!!\u001a<\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\rY\u0016Q\u0002\u0005\u0007\u0003\u001fY\u0001\u0019A(\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR)1,!\u0006\u0002\u0018!9Q\n\u0004I\u0001\u0002\u0004y\u0005bB*\r!\u0003\u0005\r!V\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiBK\u0002P\u0003?Y#!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Wq\u0014AC1o]>$\u0018\r^5p]&!\u0011qFA\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)DK\u0002V\u0003?\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA\u0001\\1oO*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005}\"AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002PA\u0019Q(!\u0015\n\u0007\u0005McHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002q\u00033B\u0011\"a\u0017\u0012\u0003\u0003\u0005\r!a\u0014\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0007E\u0003\u0002d\u0005%\u0004/\u0004\u0002\u0002f)\u0019\u0011q\r \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002l\u0005\u0015$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!VA9\u0011!\tYfEA\u0001\u0002\u0004\u0001\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u000f\u0002x!I\u00111\f\u000b\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0007KF,\u0018\r\\:\u0015\u0007U\u000bi\b\u0003\u0005\u0002\\U\t\t\u00111\u0001qQM\u0001\u0011\u0011QAD\u0003\u0013\u000bi)a$\u0002\u0014\u0006U\u0015\u0011TAN!\ry\u00131Q\u0005\u0004\u0003\u000b\u0003#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0017\u000bAj\u0018$V\u001d\u000e{\u0006f\u001d;sS\u0001j\u0003eQ8om\u0016\u0014Ho\u001d\u0011uQ\u0016\u0004\u0013M]4v[\u0016tG\u000f\t4s_6\u0004\u0013\r\t2bg\u0016\u0004c\u0007\u000e\u0011tiJLgn\u001a\u0011agR\u0014\b\r\t;pA\u0005\u0004#-\u001b8beft\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005E\u0015!\u0013\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OU\u001b$\t[2ng\u001e,\u0016GR'(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b]1sW\u0002\u001a\u0016\u000b\u0014\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qS\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003;\u000bAb\u001d;sS:<wLZ;oGN\f\u0001\"\u00168CCN,g\u0007\u000e\t\u0003_]\u0019RaFAS\u0003W\u00032!PAT\u0013\r\tIK\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\t\u00055\u00161W\u0007\u0003\u0003_SA!!-\u0002D\u0005\u0011\u0011n\\\u0005\u0004\u0017\u0006=FCAAQ\u00035I7OV1mS\u0012\u0014\u0015m]37iQ\u0019Q+a/\t\u000f\u0005u\u0016\u00041\u0001\u0002@\u0006I1O]2TiJLgn\u001a\t\u0005\u0003\u0003\fI-\u0004\u0002\u0002D*\u00191-!2\u000b\u0007\u0005\u001dg%\u0001\u0004v]N\fg-Z\u0005\u0005\u0003\u0017\f\u0019M\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001e\fQ!\u00199qYf$RaWAi\u0003'DQ!\u0014\u000eA\u0002=Cqa\u0015\u000e\u0011\u0002\u0003\u0007Q+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$B!a7\u0002hB)Q(!8\u0002b&\u0019\u0011q\u001c \u0003\r=\u0003H/[8o!\u0015i\u00141](V\u0013\r\t)O\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005%H$!AA\u0002m\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u001f\t\u0005\u0003{\t\u00190\u0003\u0003\u0002v\u0006}\"AB(cU\u0016\u001cG\u000f")
public class UnBase64
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$2() {
        return UnBase64$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(UnBase64 x$0) {
        return UnBase64$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return UnBase64$.MODULE$.apply$default$2();
    }

    public static boolean isValidBase64(UTF8String srcString) {
        return UnBase64$.MODULE$.isValidBase64(srcString);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object string) {
        if (this.failOnError() && !UnBase64$.MODULE$.isValidBase64((UTF8String)string)) {
            throw QueryExecutionErrors$.MODULE$.invalidInputInConversionError(BinaryType$.MODULE$, (UTF8String)string, UTF8String.fromString((String)"BASE64"), "try_to_binary");
        }
        return Base64.getMimeDecoder().decode(((UTF8String)string).toString());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)child -> {
            String string;
            if (this.failOnError()) {
                String unbase64 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(UnBase64$.MODULE$.getClass().getName()), "$");
                UTF8String format = UTF8String.fromString((String)"BASE64");
                String binaryType = ctx.addReferenceObj("to", BinaryType$.MODULE$, BinaryType$.MODULE$.getClass().getName());
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n           |if (!").append(unbase64).append(".isValidBase64(").append((String)child).append(")) {\n           |  throw QueryExecutionErrors.invalidInputInConversionError(\n           |    ").append(binaryType).append(",\n           |    ").append((String)child).append(",\n           |    ").append(format).append(",\n           |    \"try_to_binary\");\n           |}\n       ").toString()));
            } else {
                string = "";
            }
            String maybeValidateInputCode = string;
            return new StringBuilder(69).append("\n         ").append(maybeValidateInputCode).append("\n         ").append(ev.value()).append(" = ").append(Base64.class.getName()).append(".getMimeDecoder().decode(").append((String)child).append(".toString());\n       ").toString();
        });
    }

    @Override
    public UnBase64 withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.failOnError());
    }

    public UnBase64 copy(Expression child, boolean failOnError) {
        return new UnBase64(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnBase64";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnBase64;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnBase64)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnBase64 unBase64 = (UnBase64)x$1;
        if (this.failOnError() != unBase64.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = unBase64.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!unBase64.canEqual(this)) return false;
        return true;
    }

    public UnBase64(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public UnBase64(Expression expr) {
        this(expr, false);
    }
}

