/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.DecimalAddNoOverflowCheck;
import org.apache.spark.sql.catalyst.expressions.DecimalDivideWithOverflowCheck;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.DivideDTInterval;
import org.apache.spark.sql.catalyst.expressions.DivideYMInterval;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the mean calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (3) AS tab(col);\n       2.0\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (NULL) AS tab(col);\n       1.5\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0005\t\u001dg\u0001\u0002\u00180\u0001zB\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u0005!\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005s\u0001\tE\t\u0015!\u0003k\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015\u0019\b\u0001\"\u0001y\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!a\b\u0001\t\u0003\n\t\u0003C\u0004\u00020\u0001!\t%!\r\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!I\u00111\t\u0001C\u0002\u0013\u0015\u0013Q\t\u0005\t\u0003_\u0002\u0001\u0015!\u0004\u0002H!Q\u0011\u0011\u000f\u0001\t\u0006\u0004%\t\"a\u001d\t\u0015\u0005=\u0005\u0001#b\u0001\n\u0003\t\t\n\u0003\u0006\u0002\u0018\u0002A)\u0019!C\u0001\u00033C!\"!)\u0001\u0011\u000b\u0007I\u0011AAM\u0011\u001d\t\u0019\u000b\u0001C\t\u0003KC!\"a,\u0001\u0011\u000b\u0007I\u0011IAY\u0011)\t\u0019\r\u0001EC\u0002\u0013\u0005\u0013Q\u0019\u0005\u000b\u0003#\u0004\u0001R1A\u0005B\u0005M\u0007\"CAl\u0001!\u0015\r\u0011\"\u0011g\u0011)\tI\u000e\u0001EC\u0002\u0013\u0005\u00131\u001c\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\ty\u000f\u0001C)\u0003cDq!a>\u0001\t\u0003\nI\u0010C\u0005\u0003\b\u0001\t\t\u0011\"\u0001\u0003\n!I!q\u0002\u0001\u0012\u0002\u0013\u0005!\u0011\u0003\u0005\n\u0005O\u0001\u0011\u0013!C\u0001\u0005SA\u0011B!\f\u0001\u0003\u0003%\tEa\f\t\u0013\tm\u0002!!A\u0005\u0002\tu\u0002\"\u0003B#\u0001\u0005\u0005I\u0011\u0001B$\u0011%\u0011i\u0005AA\u0001\n\u0003\u0012y\u0005C\u0005\u0003X\u0001\t\t\u0011\"\u0001\u0003Z!I!Q\f\u0001\u0002\u0002\u0013\u0005#q\f\u0005\n\u0005G\u0002\u0011\u0011!C!\u0005K:\u0011B!#0\u0003\u0003E\tAa#\u0007\u00119z\u0013\u0011!E\u0001\u0005\u001bCaa\u001d\u0014\u0005\u0002\tm\u0005\"\u0003BOM\u0005\u0005IQ\tBP\u0011%\u0011\tKJA\u0001\n\u0003\u0013\u0019\u000bC\u0005\u0003*\u001a\n\n\u0011\"\u0001\u0003*!I!1\u0016\u0014\u0002\u0002\u0013\u0005%Q\u0016\u0005\n\u0005w3\u0013\u0013!C\u0001\u0005SA\u0011B!0'\u0003\u0003%IAa0\u0003\u000f\u00053XM]1hK*\u0011\u0001'M\u0001\nC\u001e<'/Z4bi\u0016T!AM\u001a\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003iU\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003m]\n1a]9m\u0015\tA\u0014(A\u0003ta\u0006\u00148N\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<7\u0001A\n\b\u0001}\u001auIS*Z!\t\u0001\u0015)D\u00010\u0013\t\u0011uF\u0001\u000bEK\u000ed\u0017M]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\t\u0003\t\u0016k\u0011!M\u0005\u0003\rF\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\t\"K!!S\u0019\u0003'M+\b\u000f]8siF+XM]=D_:$X\r\u001f;\u0011\u0007-s\u0005+D\u0001M\u0015\ti5'A\u0003ue\u0016,7/\u0003\u0002P\u0019\nIQK\\1ss2K7.\u001a\t\u0003\tFK!AU\u0019\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002U/6\tQKC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAVKA\u0004Qe>$Wo\u0019;\u0011\u0005i\u0013gBA.a\u001d\tav,D\u0001^\u0015\tqV(\u0001\u0004=e>|GOP\u0005\u0002-&\u0011\u0011-V\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019GM\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002b+\u0006)1\r[5mIV\t\u0001+\u0001\u0004dQ&dG\rI\u0001\tKZ\fG.T8eKV\t!\u000e\u0005\u0002l]:\u0011A\t\\\u0005\u0003[F\n\u0001\"\u0012<bY6{G-Z\u0005\u0003_B\u0014QAV1mk\u0016L!!]+\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\nKZ\fG.T8eK\u0002\na\u0001P5oSRtDcA;woB\u0011\u0001\t\u0001\u0005\u0006K\u0016\u0001\r\u0001\u0015\u0005\bQ\u0016\u0001\n\u00111\u0001k)\t)\u0018\u0010C\u0003f\r\u0001\u0007\u0001+\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001 \t\u0004{\u0006\raB\u0001@\u0000!\taV+C\u0002\u0002\u0002U\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u0011aa\u0015;sS:<'bAA\u0001+\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u00055\u0001#\u0002.\u0002\u0010\u0005M\u0011bAA\tI\n\u00191+Z9\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u00076\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ti\"a\u0006\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015g\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002.\u0005\u001d\"a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u00119,H\u000e\\1cY\u0016,\"!a\r\u0011\u0007Q\u000b)$C\u0002\u00028U\u0013qAQ8pY\u0016\fg.\u0001\u0005eCR\fG+\u001f9f+\t\ti\u0004\u0005\u0003\u0002\u0016\u0005}\u0012\u0002BA!\u0003/\u0011\u0001\u0002R1uCRK\b/Z\u0001\r]>$W\rU1ui\u0016\u0014hn]\u000b\u0003\u0003\u000f\u0002RAWA\b\u0003\u0013\u0002B!a\u0013\u0002j9!\u0011QJA3\u001d\u0011\ty%a\u0019\u000f\t\u0005E\u0013\u0011\r\b\u0005\u0003'\nyF\u0004\u0003\u0002V\u0005uc\u0002BA,\u00037r1\u0001XA-\u0013\u0005a\u0014B\u0001\u001e<\u0013\tA\u0014(\u0003\u00027o%\u0011A'N\u0005\u0003\u001bNJ1!a\u001aM\u0003-!&/Z3QCR$XM\u001d8\n\t\u0005-\u0014Q\u000e\u0002\f)J,W\rU1ui\u0016\u0014hNC\u0002\u0002h1\u000bQB\\8eKB\u000bG\u000f^3s]N\u0004\u0013A\u0003:fgVdG\u000fV=qKV\u0011\u0011Q\u000f\n\b\u0003o\nYhUAA\r\u0019\tI\b\u0001\u0001\u0002v\taAH]3gS:,W.\u001a8u}A!\u0011QCA?\u0013\u0011\ty(a\u0006\u0003\u0015\u0005#x.\\5d)f\u0004X\r\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\u0005%|'BAAF\u0003\u0011Q\u0017M^1\n\u0007\r\f))A\u0006tk6$\u0015\r^1UsB,WCAAJ%\u001d\t)*a\u001fT\u0003\u00033a!!\u001f\u0001\u0001\u0005M\u0015aA:v[V\u0011\u00111\u0014\t\u0004\t\u0006u\u0015bAAPc\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0003\u0015\u0019w.\u001e8u\u0003\r\tG\r\u001a\u000b\u0006!\u0006\u001d\u00161\u0016\u0005\u0007\u0003S\u0013\u0002\u0019\u0001)\u0002\t1,g\r\u001e\u0005\u0007\u0003[\u0013\u0002\u0019\u0001)\u0002\u000bILw\r\u001b;\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0005\u0005M\u0006CBA[\u0003\u007f\u000bY*\u0004\u0002\u00028*!\u0011\u0011XA^\u0003%IW.\\;uC\ndWMC\u0002\u0002>V\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t-a.\u0003\t1K7\u000f^\u0001\u000eS:LG/[1m-\u0006dW/Z:\u0016\u0005\u0005\u001d\u0007CBA[\u0003\u0013\fY-\u0003\u0003\u0002\u0012\u0005]\u0006c\u0001#\u0002N&\u0019\u0011qZ\u0019\u0003\u000f1KG/\u001a:bY\u0006\u0001R.\u001a:hK\u0016C\bO]3tg&|gn]\u000b\u0003\u0003+\u0004R!!.\u0002JB\u000b!#\u001a<bYV\fG/Z#yaJ,7o]5p]\u0006\tR\u000f\u001d3bi\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0016\u0005\u0005u\u0007\u0003\u0002.\u0002\u0010A\u000bQB\u001a7bi\u0006\u0013x-^7f]R\u001cXCAAr!\u0015Q\u0016Q]Au\u0013\r\t9\u000f\u001a\u0002\t\u0013R,'/\u0019;peB\u0019A+a;\n\u0007\u00055XKA\u0002B]f\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA;\u0002t\"1\u0011Q_\rA\u0002A\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0011S:LG/U;fef\u001cuN\u001c;fqR$\"!a?\u0011\u000bQ\u000biP!\u0001\n\u0007\u0005}XK\u0001\u0004PaRLwN\u001c\t\u0004\u0017\n\r\u0011b\u0001B\u0003\u0019\ny1+\u0015'Rk\u0016\u0014\u0018pQ8oi\u0016DH/\u0001\u0003d_BLH#B;\u0003\f\t5\u0001bB3\u001c!\u0003\u0005\r\u0001\u0015\u0005\bQn\u0001\n\u00111\u0001k\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0005+\u0007A\u0013)b\u000b\u0002\u0003\u0018A!!\u0011\u0004B\u0012\u001b\t\u0011YB\u0003\u0003\u0003\u001e\t}\u0011!C;oG\",7m[3e\u0015\r\u0011\t#V\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0013\u00057\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u000b+\u0007)\u0014)\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005c\u0001BAa\r\u0003:5\u0011!Q\u0007\u0006\u0005\u0005o\tI)\u0001\u0003mC:<\u0017\u0002BA\u0003\u0005k\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0010\u0011\u0007Q\u0013\t%C\u0002\u0003DU\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!;\u0003J!I!1\n\u0011\u0002\u0002\u0003\u0007!qH\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tE\u0003C\u0002B*\u0005+\nI/\u0004\u0002\u0002<&!\u0011q]A^\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001a\u00057B\u0011Ba\u0013#\u0003\u0003\u0005\r!!;\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005c\u0011\t\u0007C\u0005\u0003L\r\n\t\u00111\u0001\u0003@\u00051Q-];bYN$B!a\r\u0003h!I!1\n\u0013\u0002\u0002\u0003\u0007\u0011\u0011\u001e\u0015\u0014\u0001\t-$\u0011\u000fB:\u0005o\u0012IH! \u0003\u0000\t\r%Q\u0011\t\u0004\t\n5\u0014b\u0001B8c\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B;\u0003\t{f)\u0016(D?\"*\u0007\u0010\u001d:*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA5,\u0017M\u001c\u0011dC2\u001cW\u000f\\1uK\u0012\u0004cM]8nAY\fG.^3tA=4\u0007%\u0019\u0011he>,\bOL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!1P\u0001\u0002^)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)c%b\u0003\u0005\u000b\u001a*Y\u0001B3'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a/a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)c%b\u0003\u0005\u000b\u001a*Y\u0001Bc*\u0016'MS\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AErSG\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011\t)A\u0005bO\u001e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!qQ\u0001\u0006c9\u0002d\u0006M\u0001\b\u0003Z,'/Y4f!\t\u0001eeE\u0003'\u0005\u001f\u000b\t\tE\u0004\u0003\u0012\n]\u0005K[;\u000e\u0005\tM%b\u0001BK+\u00069!/\u001e8uS6,\u0017\u0002\u0002BM\u0005'\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011Y)\u0001\u0005u_N#(/\u001b8h)\t\u0011\t$A\u0003baBd\u0017\u0010F\u0003v\u0005K\u00139\u000bC\u0003fS\u0001\u0007\u0001\u000bC\u0004iSA\u0005\t\u0019\u00016\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u00030\n]\u0006#\u0002+\u0002~\nE\u0006#\u0002+\u00034BS\u0017b\u0001B[+\n1A+\u001e9mKJB\u0001B!/,\u0003\u0003\u0005\r!^\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003BB!!1\u0007Bb\u0013\u0011\u0011)M!\u000e\u0003\r=\u0013'.Z2u\u0001")
public class Average
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
SupportQueryContext,
UnaryLike<Expression> {
    private AtomicType resultType;
    private AtomicType sumDataType;
    private AttributeReference sum;
    private AttributeReference count;
    private List<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private Seq<Expression> updateExpressions;
    private final Expression child;
    private final Enumeration.Value evalMode;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient Seq<Expression> children;
    private Option<SQLQueryContext> queryContext;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$2() {
        return Average$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Enumeration.Value>> unapply(Average x$0) {
        return Average$.MODULE$.unapply(x$0);
    }

    public static Enumeration.Value apply$default$2() {
        return Average$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Enumeration.Value>, Average> tupled() {
        return Average$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Enumeration.Value, Average>> curried() {
        return Average$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    private Seq<Expression> children$lzycompute() {
        Average average = this;
        synchronized (average) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Enumeration.Value evalMode() {
        return this.evalMode;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "avg");
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$}))}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForAnsiIntervalOrNumericType(this.child());
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private AtomicType resultType$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 1) == 0) {
                AtomicType atomicType;
                DecimalType decimalType;
                Option<Tuple2<Object, Object>> option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    atomicType = DecimalType$.MODULE$.bounded(p + 4, s + 4);
                } else {
                    atomicType = dataType instanceof YearMonthIntervalType ? YearMonthIntervalType$.MODULE$.apply() : (dataType instanceof DayTimeIntervalType ? DayTimeIntervalType$.MODULE$.apply() : DoubleType$.MODULE$);
                }
                this.resultType = atomicType;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    public AtomicType resultType() {
        return (this.bitmap$0 & 1) == 0 ? this.resultType$lzycompute() : this.resultType;
    }

    private AtomicType sumDataType$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 2) == 0) {
                AtomicType atomicType;
                DecimalType decimalType;
                Option<Tuple2<Object, Object>> option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    atomicType = DecimalType$.MODULE$.bounded(p + 10, s);
                } else {
                    atomicType = dataType instanceof YearMonthIntervalType ? YearMonthIntervalType$.MODULE$.apply() : (dataType instanceof DayTimeIntervalType ? DayTimeIntervalType$.MODULE$.apply() : DoubleType$.MODULE$);
                }
                this.sumDataType = atomicType;
                this.bitmap$0 |= 2;
            }
        }
        return this.sumDataType;
    }

    public AtomicType sumDataType() {
        return (this.bitmap$0 & 2) == 0 ? this.sumDataType$lzycompute() : this.sumDataType;
    }

    private AttributeReference sum$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "sum";
                AtomicType x$2 = this.sumDataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("sum", x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("sum", x$2, x$3, x$4);
                this.sum = new AttributeReference("sum", x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.sum;
    }

    public AttributeReference sum() {
        return (this.bitmap$0 & 4) == 0 ? this.sum$lzycompute() : this.sum;
    }

    private AttributeReference count$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 8) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("count", x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("count", x$2, x$3, x$4);
                this.count = new AttributeReference("count", x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 8;
            }
        }
        return this.count;
    }

    public AttributeReference count() {
        return (this.bitmap$0 & 8) == 0 ? this.count$lzycompute() : this.count;
    }

    public Expression add(Expression left, Expression right) {
        DataType dataType = left.dataType();
        BinaryOperator binaryOperator = dataType instanceof DecimalType ? new DecimalAddNoOverflowCheck(left, right, left.dataType()) : new Add(left, right, this.evalMode());
        return binaryOperator;
    }

    private List<AttributeReference> aggBufferAttributes$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.sum();
                AttributeReference attributeReference2 = this.count();
                this.aggBufferAttributes = package$.MODULE$.Nil().$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    public List<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.default(this.sumDataType()), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))}));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.mergeExpressions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(this.RichAttribute(this.sum()).left(), this.RichAttribute(this.sum()).right()), package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.count()).left()).$plus(this.RichAttribute(this.count()).right())}));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x80) == 0) {
                Expression expression;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType) {
                    Enumeration.Value value = this.evalMode();
                    Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
                    expression = new If(new EqualTo(this.count(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))), new Literal(null, this.resultType()), new DecimalDivideWithOverflowCheck(this.sum(), package$expressions$.MODULE$.DslExpression(this.count()).cast(DecimalType$.MODULE$.LongDecimal()), (DecimalType)this.resultType(), this.getContextOrNull(), value == null ? value2 != null : !value.equals(value2)));
                } else {
                    expression = dataType instanceof YearMonthIntervalType ? new If(new EqualTo(this.count(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))), new Literal(null, YearMonthIntervalType$.MODULE$.apply()), new DivideYMInterval(this.sum(), this.count())) : (dataType instanceof DayTimeIntervalType ? new If(new EqualTo(this.count(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))), new Literal(null, DayTimeIntervalType$.MODULE$.apply()), new DivideDTInterval(this.sum(), this.count())) : new Divide(package$expressions$.MODULE$.DslExpression(this.sum()).cast(this.resultType()), package$expressions$.MODULE$.DslExpression(this.count()).cast(this.resultType()), EvalMode$.MODULE$.LEGACY()));
                }
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        return (this.bitmap$0 & 0x80) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.updateExpressions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(this.sum(), package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(this.child()).cast(this.sumDataType()), Literal$.MODULE$.default(this.sumDataType())}))), new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.count(), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L)))}));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x100) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public Average withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
        return !(value != null ? !value.equals(value2) : value2 != null) ? new Some((Object)this.origin().context()) : None$.MODULE$;
    }

    public Average copy(Expression child, Enumeration.Value evalMode) {
        return new Average(child, evalMode);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Enumeration.Value copy$default$2() {
        return this.evalMode();
    }

    @Override
    public String productPrefix() {
        return "Average";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.evalMode();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Average;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "evalMode";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Average)) return false;
        boolean bl = true;
        if (!bl) return false;
        Average average = (Average)x$1;
        Expression expression = this.child();
        Expression expression2 = average.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = average.evalMode();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!average.canEqual(this)) return false;
        return true;
    }

    public Average(Expression child, Enumeration.Value evalMode) {
        this.child = child;
        this.evalMode = evalMode;
        ExpectsInputTypes.$init$(this);
        SupportQueryContext.$init$(this);
        UnaryLike.$init$(this);
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.AVERAGE()}));
    }

    public Average(Expression child) {
        this(child, EvalMode$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

