/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.optimizer.ConstantFolding$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$DefaultColumnAnalyzer$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ResolveDefaultColumns$ {
    public static final ResolveDefaultColumns$ MODULE$ = new ResolveDefaultColumns$();
    private static final String CURRENT_DEFAULT_COLUMN_METADATA_KEY = "CURRENT_DEFAULT";
    private static final String EXISTS_DEFAULT_COLUMN_METADATA_KEY = "EXISTS_DEFAULT";
    private static final String CURRENT_DEFAULT_COLUMN_NAME = "DEFAULT";

    public String CURRENT_DEFAULT_COLUMN_METADATA_KEY() {
        return CURRENT_DEFAULT_COLUMN_METADATA_KEY;
    }

    public String EXISTS_DEFAULT_COLUMN_METADATA_KEY() {
        return EXISTS_DEFAULT_COLUMN_METADATA_KEY;
    }

    public String CURRENT_DEFAULT_COLUMN_NAME() {
        return CURRENT_DEFAULT_COLUMN_NAME;
    }

    public StructType constantFoldCurrentDefaultsToExistDefaults(StructType tableSchema, String statementType) {
        StructType structType;
        if (SQLConf$.MODULE$.get().enableDefaultColumns()) {
            IndexedSeq newFields = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields()), (Function1 & Serializable)field -> {
                StructField structField;
                if (field.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY())) {
                    Metadata newMetadata;
                    Expression analyzed = MODULE$.analyze((StructField)field, statementType, MODULE$.analyze$default$3());
                    Metadata x$1 = newMetadata = new MetadataBuilder().withMetadata(field.metadata()).putString(MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), analyzed.sql()).build();
                    String x$2 = field.copy$default$1();
                    DataType x$3 = field.copy$default$2();
                    boolean x$4 = field.copy$default$3();
                    structField = field.copy(x$2, x$3, x$4, x$1);
                } else {
                    structField = field;
                }
                return structField;
            }, ClassTag$.MODULE$.apply(StructField.class)));
            structType = StructType$.MODULE$.apply((Seq<StructField>)newFields);
        } else {
            structType = tableSchema;
        }
        return structType;
    }

    public void validateCatalogForDefaultValue(StructType schema, TableCatalog catalog, Identifier ident) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns() && schema.exists((Function1<StructField, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$validateCatalogForDefaultValue$1(x$1))) && !catalog.capabilities().contains((Object)TableCatalogCapability.SUPPORT_COLUMN_DEFAULT_VALUE)) {
            throw QueryCompilationErrors$.MODULE$.unsupportedTableOperationError(catalog, ident, "column default value");
        }
    }

    public void validateTableProviderForDefaultValue(StructType schema, Option<String> tableProvider, String statementType, boolean addNewColumnToExistingTable) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns() && schema.exists((Function1<StructField, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$validateTableProviderForDefaultValue$1(x$2)))) {
            String[] keywords = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS()).toLowerCase().split(",")), (Function1 & Serializable)x$3 -> x$3.trim(), ClassTag$.MODULE$.apply(String.class));
            String[] allowedTableProviders = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])keywords), (Function1 & Serializable)x$4 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$4), "*"), ClassTag$.MODULE$.apply(String.class));
            String[] addColumnExistingTableBannedProviders = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])keywords), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.endsWith("*")))), (Function1 & Serializable)x$6 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$6), "*"), ClassTag$.MODULE$.apply(String.class));
            String givenTableProvider = ((String)tableProvider.getOrElse((Function0 & Serializable)() -> "")).toLowerCase();
            if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])allowedTableProviders), (Object)givenTableProvider)) {
                throw QueryCompilationErrors$.MODULE$.defaultReferencesNotAllowedInDataSource(statementType, givenTableProvider);
            }
            if (addNewColumnToExistingTable && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(givenTableProvider)) && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])addColumnExistingTableBannedProviders), (Object)givenTableProvider)) {
                throw QueryCompilationErrors$.MODULE$.addNewDefaultColumnToExistingTableNotAllowed(statementType, givenTableProvider);
            }
        }
    }

    public Expression analyze(StructField field, String statementType, String metadataKey) {
        return this.analyze(field.name(), field.dataType(), field.metadata().getString(metadataKey), statementType);
    }

    public Expression analyze(String colName, DataType dataType, String defaultSQL, String statementType) {
        Expression expression;
        LogicalPlan logicalPlan;
        Expression expression2;
        LazyRef parser$lzy = new LazyRef();
        try {
            expression2 = ResolveDefaultColumns$.parser$1(parser$lzy).parseExpression(defaultSQL);
        }
        catch (ParseException ex) {
            throw new AnalysisException(new StringBuilder(0).append(new StringBuilder(64).append("Failed to execute ").append(statementType).append(" command because the destination table column ").toString()).append(new StringBuilder(57).append(colName).append(" has a DEFAULT value of ").append(defaultSQL).append(" which fails to parse as a valid ").toString()).append(new StringBuilder(12).append("expression: ").append(ex.getMessage()).toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
        }
        Expression parsed = expression2;
        if (parsed.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())) {
            throw QueryCompilationErrors$.MODULE$.defaultValuesMayNotContainSubQueryExpressions();
        }
        try {
            ResolveDefaultColumns$DefaultColumnAnalyzer$ analyzer = ResolveDefaultColumns$DefaultColumnAnalyzer$.MODULE$;
            Alias[] aliasArray = new Alias[1];
            Expression x$1 = parsed;
            String x$2 = colName;
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            aliasArray[0] = new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            LogicalPlan analyzed = analyzer.execute(new Project((Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])aliasArray))), new OneRowRelation()));
            analyzer.checkAnalysis(analyzed);
            logicalPlan = ConstantFolding$.MODULE$.apply(analyzed);
        }
        catch (AnalysisException ex) {
            throw new AnalysisException(new StringBuilder(0).append(new StringBuilder(64).append("Failed to execute ").append(statementType).append(" command because the destination table column ").toString()).append(new StringBuilder(59).append(colName).append(" has a DEFAULT value of ").append(defaultSQL).append(" which fails to resolve as a valid ").toString()).append(new StringBuilder(12).append("expression: ").append(ex.getMessage()).toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
        }
        LogicalPlan plan2 = logicalPlan;
        Expression analyzed = (Expression)plan2.collectFirst(new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Project) {
                    NamedExpression a;
                    SeqOps seqOps;
                    Project project = (Project)A1;
                    Seq<NamedExpression> seq = project.projectList();
                    LogicalPlan logicalPlan = project.child();
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (a = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Alias) {
                        Alias alias = (Alias)a;
                        if (logicalPlan instanceof OneRowRelation) {
                            object = alias.child();
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (!(logicalPlan instanceof Project)) return false;
                Project project = (Project)logicalPlan;
                Seq<NamedExpression> seq = project.projectList();
                LogicalPlan logicalPlan2 = project.child();
                if (seq == null) return false;
                SeqOps seqOps = package$.MODULE$.Seq().unapplySeq(seq);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) return false;
                if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null) return false;
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0) return false;
                NamedExpression a = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                if (!(a instanceof Alias)) return false;
                if (!(logicalPlan2 instanceof OneRowRelation)) return false;
                return true;
            }
        }).get();
        DataType dataType2 = dataType;
        DataType dataType3 = analyzed.dataType();
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            expression = analyzed;
        } else if (Cast$.MODULE$.canUpCast(analyzed.dataType(), dataType)) {
            expression = new Cast(analyzed, dataType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        } else {
            throw new AnalysisException(new StringBuilder(0).append(new StringBuilder(64).append("Failed to execute ").append(statementType).append(" command because the destination table column ").toString()).append(new StringBuilder(41).append(colName).append(" has a DEFAULT value with type ").append(dataType).append(", but the ").toString()).append(new StringBuilder(48).append("statement provided a value of incompatible type ").append(analyzed.dataType()).toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7(), AnalysisException$.MODULE$.$lessinit$greater$default$8());
        }
        return expression;
    }

    public String analyze$default$3() {
        return this.CURRENT_DEFAULT_COLUMN_METADATA_KEY();
    }

    public String normalizeFieldName(String str) {
        return SQLConf$.MODULE$.get().caseSensitiveAnalysis() ? str : str.toLowerCase();
    }

    public Object[] getExistenceDefaultValues(StructType schema) {
        return (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            Option<String> defaultValue = field.getExistenceDefaultValue();
            return defaultValue.map((Function1 & Serializable)text -> {
                Expression expression;
                try {
                    Expression expr;
                    Expression expression2 = expr = MODULE$.analyze((StructField)field, "", MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
                    boolean bl = expression2 instanceof Literal ? true : expression2 instanceof Cast;
                    if (!bl) {
                        throw new MatchError((Object)expression2);
                    }
                    Expression expression3 = expr;
                    expression = expression3;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof AnalysisException ? true : throwable2 instanceof MatchError;
                    if (bl) {
                        throw QueryCompilationErrors$.MODULE$.failedToParseExistenceDefaultAsLiteral(field.name(), (String)text);
                    }
                    throw throwable;
                }
                Expression expr = expression;
                return expr.eval(expr.eval$default$1());
            }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }, ClassTag$.MODULE$.Any());
    }

    public boolean[] getExistenceDefaultsBitmask(StructType schema) {
        return (boolean[])Array$.MODULE$.fill(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.genericArrayOps((Object)schema.existenceDefaultValues())), (Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (ClassTag)ClassTag$.MODULE$.Boolean());
    }

    public void resetExistenceDefaultsBitmask(StructType schema) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.genericArrayOps((Object)schema.existenceDefaultValues()))).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            schema$1.existenceDefaultsBitmask()[i] = schema.existenceDefaultValues()[i] != null;
        });
    }

    public void applyExistenceDefaultValuesToRow(StructType schema, InternalRow row) {
        block0: {
            if (!schema.hasExistenceDefaultValues()) break block0;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.genericArrayOps((Object)schema.existenceDefaultValues()))).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                block0: {
                    if (!schema.existenceDefaultsBitmask()[i]) break block0;
                    row.update(i, schema.existenceDefaultValues()[i]);
                }
            });
        }
    }

    public Seq<Tuple3<String, String, String>> getDescribeMetadata(StructType schema) {
        ArrayBuffer rows;
        block0: {
            rows = new ArrayBuffer();
            if (!ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$getDescribeMetadata$1(x$7)))) break block0;
            rows.append((Object)new Tuple3((Object)"", (Object)"", (Object)""));
            rows.append((Object)new Tuple3((Object)"# Column Default Values", (Object)"", (Object)""));
            schema.foreach((Function1 & Serializable)column -> column.getCurrentDefaultValue().map((Function1 & Serializable)value -> (ArrayBuffer)rows.append((Object)new Tuple3((Object)column.name(), (Object)column.dataType().simpleString(), value))));
        }
        return rows.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$validateCatalogForDefaultValue$1(StructField x$1) {
        return x$1.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    public static final /* synthetic */ boolean $anonfun$validateTableProviderForDefaultValue$1(StructField x$2) {
        return x$2.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    private static final /* synthetic */ CatalystSqlParser parser$lzycompute$1(LazyRef parser$lzy$1) {
        CatalystSqlParser catalystSqlParser;
        LazyRef lazyRef = parser$lzy$1;
        synchronized (lazyRef) {
            catalystSqlParser = parser$lzy$1.initialized() ? (CatalystSqlParser)parser$lzy$1.value() : (CatalystSqlParser)parser$lzy$1.initialize((Object)new CatalystSqlParser());
        }
        return catalystSqlParser;
    }

    private static final CatalystSqlParser parser$1(LazyRef parser$lzy$1) {
        return parser$lzy$1.initialized() ? (CatalystSqlParser)parser$lzy$1.value() : ResolveDefaultColumns$.parser$lzycompute$1(parser$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$getDescribeMetadata$1(StructField x$7) {
        return x$7.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    private ResolveDefaultColumns$() {
    }
}

