/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class StringUtils$
implements Logging {
    public static final StringUtils$ MODULE$ = new StringUtils$();
    private static final Set<UTF8String> trueStrings;
    private static final Set<UTF8String> falseStrings;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        trueStrings = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "true", "y", "yes", "1"}))).map((Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1));
        falseStrings = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f", "false", "n", "no", "0"}))).map((Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String escapeLikeRegex(String pattern, char escapeChar) {
        Iterator in = StringOps$.MODULE$.iterator$extension(Predef$.MODULE$.augmentString(pattern));
        scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
        while (in.hasNext()) {
            scala.collection.mutable.StringBuilder stringBuilder;
            char c = BoxesRunTime.unboxToChar((Object)in.next());
            if (c == escapeChar && in.hasNext()) {
                scala.collection.mutable.StringBuilder stringBuilder2;
                char c2;
                char c3 = c2 = BoxesRunTime.unboxToChar((Object)in.next());
                switch (c3) {
                    case '%': 
                    case '_': {
                        stringBuilder2 = out.$plus$plus$eq(Pattern.quote(Character.toString(c2)));
                        break;
                    }
                    default: {
                        if (c3 == escapeChar) {
                            stringBuilder2 = out.$plus$plus$eq(Pattern.quote(Character.toString(c3)));
                            break;
                        }
                        throw QueryCompilationErrors$.MODULE$.escapeCharacterInTheMiddleError(pattern, Character.toString(c2));
                    }
                }
                stringBuilder = stringBuilder2;
                continue;
            }
            if (c == escapeChar) {
                throw QueryCompilationErrors$.MODULE$.escapeCharacterAtTheEndError(pattern);
            }
            stringBuilder = '_' == c ? out.$plus$plus$eq(".") : ('%' == c ? out.$plus$plus$eq(".*") : out.$plus$plus$eq(Pattern.quote(Character.toString(c))));
        }
        return new StringBuilder(4).append("(?s)").append(out.result()).toString();
    }

    public Seq<String> orderStringsBySimilarity(String baseString, Seq<String> testStrings) {
        return (Seq)testStrings.sortBy((Function1 & Serializable)x$1 -> LevenshteinDistance.getDefaultInstance().apply((CharSequence)x$1, (CharSequence)baseString), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    public boolean isTrueString(UTF8String s) {
        return trueStrings.contains((Object)s.trimAll().toLowerCase());
    }

    public boolean isFalseString(UTF8String s) {
        return falseStrings.contains((Object)s.trimAll().toLowerCase());
    }

    public Seq<String> filterPattern(Seq<String> names, String pattern) {
        SortedSet funcNames = (SortedSet)SortedSet$.MODULE$.empty((Object)Ordering.String$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])pattern.trim().split("\\|")), (Function1 & Serializable)subPattern -> {
            BoxedUnit boxedUnit;
            try {
                Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(4).append("(?i)").append(subPattern.replaceAll("\\*", ".*")).toString()));
                boxedUnit = funcNames.$plus$plus$eq((IterableOnce)names.filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)StringUtils$.$anonfun$filterPattern$2(regex, name))));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return funcNames.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$filterPattern$2(Regex regex$1, String name) {
        return regex$1.pattern().matcher(name).matches();
    }

    private StringUtils$() {
    }
}

