/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.InterpretedOrdering;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.AnsiIntervalType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class TypeUtils$
implements QueryErrorsBase {
    public static final TypeUtils$ MODULE$ = new TypeUtils$();

    static {
        QueryErrorsBase.$init$(MODULE$);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    public TypeCheckResult checkForOrderingExpr(DataType dt, String caller) {
        return RowOrdering$.MODULE$.isOrderable(dt) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.DataTypeMismatch("INVALID_ORDERING_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(caller)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType(dt))}))));
    }

    public TypeCheckResult checkForSameTypeInputExpr(Seq<DataType> types, String caller) {
        return TypeCoercion$.MODULE$.haveSameType(types) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.DataTypeMismatch("DATA_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(caller)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)((IterableOnceOps)types.map((Function1 & Serializable)t -> MODULE$.toSQLType((AbstractDataType)t))).mkString("(", " or ", ")"))}))));
    }

    public TypeCheckResult checkForMapKeyType(DataType keyType) {
        return keyType.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TypeUtils$.$anonfun$checkForMapKeyType$1(x$1))) ? new TypeCheckResult.DataTypeMismatch("INVALID_MAP_KEY_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keyType"), (Object)this.toSQLType(keyType))})))) : TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    public TypeCheckResult checkForAnsiIntervalOrNumericType(Expression input) {
        DataType dataType = input.dataType();
        boolean bl = dataType instanceof AnsiIntervalType ? true : NullType$.MODULE$.equals(dataType);
        TypeCheckResult typeCheckResult = bl ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : (dataType instanceof NumericType ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, AnsiIntervalType$.MODULE$})).map((Function1 & Serializable)t -> MODULE$.toSQLType((AbstractDataType)t))).mkString(" or ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(input)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType(dataType))})))));
        return typeCheckResult;
    }

    public Numeric<Object> getNumeric(DataType t, boolean exactNumericRequired) {
        return exactNumericRequired ? ((NumericType)t).exactNumeric() : ((NumericType)t).numeric();
    }

    public boolean getNumeric$default$2() {
        return false;
    }

    public Ordering<Object> getInterpretedOrdering(DataType t) {
        InterpretedOrdering interpretedOrdering;
        block4: {
            DataType dataType;
            while (true) {
                if ((dataType = t) instanceof AtomicType) {
                    AtomicType atomicType = (AtomicType)dataType;
                    interpretedOrdering = atomicType.ordering();
                    break block4;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    interpretedOrdering = arrayType.interpretedOrdering();
                    break block4;
                }
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    interpretedOrdering = structType.interpretedOrdering();
                    break block4;
                }
                if (!(dataType instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                t = userDefinedType.sqlType();
            }
            throw new MatchError((Object)dataType);
        }
        return interpretedOrdering;
    }

    public boolean typeWithProperEquals(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = BinaryType$.MODULE$.equals(dataType2) ? false : dataType2 instanceof AtomicType;
        return bl;
    }

    public void failWithIntervalType(DataType dataType) {
        this.invokeOnceForInterval(dataType, false, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.cannotUseIntervalTypeInTableSchemaError();
        });
    }

    public void invokeOnceForInterval(DataType dataType2, boolean forbidAnsiIntervals, Function0<BoxedUnit> f) {
        block0: {
            if (!dataType2.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable)dataType -> BoxesRunTime.boxToBoolean((boolean)TypeUtils$.isInterval$1(dataType, forbidAnsiIntervals)))) break block0;
            f.apply$mcV$sp();
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkForMapKeyType$1(DataType x$1) {
        return x$1 instanceof MapType;
    }

    private static final boolean isInterval$1(DataType dataType, boolean forbidAnsiIntervals$1) {
        DataType dataType2 = dataType;
        boolean bl = dataType2 instanceof AnsiIntervalType ? forbidAnsiIntervals$1 : CalendarIntervalType$.MODULE$.equals(dataType2);
        return bl;
    }

    private TypeUtils$() {
    }
}

