/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Catalogs$;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc!\u0002\u000f\u001e\u0001\u0005J\u0003\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\t\u0003!Q1A\u0005\u0002\rC\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0006\u0015\u0002!\ta\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019!\u0007\u0001)A\u0005#\")a\u0004\u0001C\u0001K\")\u0001\u000e\u0001C\u0001S\")a\u000e\u0001C\u0005_\"1\u0001\u000f\u0001C\u0001CEDqA\u001d\u0001A\u0002\u0013%1\u000fC\u0004{\u0001\u0001\u0007I\u0011B>\t\u000f\u0005\r\u0001\u0001)Q\u0005i\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\n\u0003#\u0001\u0001\u0019!C\u0005\u0003'A\u0011\"a\u0006\u0001\u0001\u0004%I!!\u0007\t\u0011\u0005u\u0001\u0001)Q\u0005\u0003+Aa!a\b\u0001\t\u0003\t\bbBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011!\t\u0019\u0005\u0001C\u0001C\u0005\u0015s\u0001CA$;!\u0005\u0011%!\u0013\u0007\u000fqi\u0002\u0012A\u0011\u0002L!1!\n\u0007C\u0001\u0003\u001bB\u0011\"a\u0014\u0019\u0005\u0004%\t!!\u0015\t\u000f\u0005M\u0003\u0004)A\u00053\nq1)\u0019;bY><W*\u00198bO\u0016\u0014(B\u0001\u0010 \u0003\u001d\u0019\u0017\r^1m_\u001eT!\u0001I\u0011\u0002\u0013\r|gN\\3di>\u0014(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sON!\u0001A\u000b\u00197!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0007N\u0007\u0002e)\u00111'I\u0001\tG\u0006$\u0018\r\\=ti&\u0011QG\r\u0002\u000e'Fc5i\u001c8g\u0011\u0016d\u0007/\u001a:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\u001a\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005mB$a\u0002'pO\u001eLgnZ\u0001\u0016I\u00164\u0017-\u001e7u'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h\u0007\u0001\u0001\"a\u0010!\u000e\u0003uI!!Q\u000f\u0003\u001b\r\u000bG/\u00197pOBcWoZ5o\u0003A1\u0018gU3tg&|gnQ1uC2|w-F\u0001E!\t)u)D\u0001G\u0015\tq\"'\u0003\u0002I\r\nq1+Z:tS>t7)\u0019;bY><\u0017!\u0005<2'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8hA\u00051A(\u001b8jiz\"2\u0001T'O!\ty\u0004\u0001C\u0003=\t\u0001\u0007a\bC\u0003C\t\u0001\u0007A)\u0001\u0005dCR\fGn\\4t+\u0005\t\u0006\u0003\u0002*X3zj\u0011a\u0015\u0006\u0003)V\u000bq!\\;uC\ndWM\u0003\u0002WY\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a\u001b&a\u0002%bg\"l\u0015\r\u001d\t\u00035\u0006t!aW0\u0011\u0005qcS\"A/\u000b\u0005yk\u0014A\u0002\u001fs_>$h(\u0003\u0002aY\u00051\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001G&A\u0005dCR\fGn\\4tAQ\u0011aH\u001a\u0005\u0006O\u001e\u0001\r!W\u0001\u0005]\u0006lW-A\njg\u000e\u000bG/\u00197pOJ+w-[:uKJ,G\r\u0006\u0002k[B\u00111f[\u0005\u0003Y2\u0012qAQ8pY\u0016\fg\u000eC\u0003h\u0011\u0001\u0007\u0011,\u0001\u000bm_\u0006$gKM*fgNLwN\\\"bi\u0006dwn\u001a\u000b\u0002}\u0005\u0001bOM*fgNLwN\\\"bi\u0006dwnZ\u000b\u0002}\u0005\trlY;se\u0016tGOT1nKN\u0004\u0018mY3\u0016\u0003Q\u00042aK;x\u0013\t1HF\u0001\u0004PaRLwN\u001c\t\u0004WaL\u0016BA=-\u0005\u0015\t%O]1z\u0003Uy6-\u001e:sK:$h*Y7fgB\f7-Z0%KF$\"\u0001`@\u0011\u0005-j\u0018B\u0001@-\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005A\"!AA\u0002Q\f1\u0001\u001f\u00132\u0003Iy6-\u001e:sK:$h*Y7fgB\f7-\u001a\u0011\u0002!\r,(O]3oi:\u000bW.Z:qC\u000e,W#A<\u0002'M,GoQ;se\u0016tGOT1nKN\u0004\u0018mY3\u0015\u0007q\fi\u0001\u0003\u0004\u0002\u0010=\u0001\ra^\u0001\n]\u0006lWm\u001d9bG\u0016\f1cX2veJ,g\u000e^\"bi\u0006dwn\u001a(b[\u0016,\"!!\u0006\u0011\u0007-*\u0018,A\f`GV\u0014(/\u001a8u\u0007\u0006$\u0018\r\\8h\u001d\u0006lWm\u0018\u0013fcR\u0019A0a\u0007\t\u0013\u0005\u0005\u0011#!AA\u0002\u0005U\u0011\u0001F0dkJ\u0014XM\u001c;DCR\fGn\\4OC6,\u0007%\u0001\bdkJ\u0014XM\u001c;DCR\fGn\\4\u0002#M,GoQ;se\u0016tGoQ1uC2|w\rF\u0002}\u0003KAa!a\n\u0015\u0001\u0004I\u0016aC2bi\u0006dwn\u001a(b[\u0016\fA\u0002\\5ti\u000e\u000bG/\u00197pON$B!!\f\u0002@A)\u0011qFA\u001d3:!\u0011\u0011GA\u001b\u001d\ra\u00161G\u0005\u0002[%\u0019\u0011q\u0007\u0017\u0002\u000fA\f7m[1hK&!\u00111HA\u001f\u0005\r\u0019V-\u001d\u0006\u0004\u0003oa\u0003bBA!+\u0001\u0007\u0011QC\u0001\ba\u0006$H/\u001a:o\u0003\u0015\u0011Xm]3u)\u0005a\u0018AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\t\u0003\u007fa\u0019\"\u0001\u0007\u0016\u0015\u0005\u0005%\u0013\u0001F*F'NKuJT0D\u0003R\u000bEjT$`\u001d\u0006kU)F\u0001Z\u0003U\u0019ViU*J\u001f:{6)\u0011+B\u0019>;uLT!N\u000b\u0002\u0002")
public class CatalogManager
implements SQLConfHelper,
Logging {
    private final CatalogPlugin defaultSessionCatalog;
    private final SessionCatalog v1SessionCatalog;
    private final HashMap<String, CatalogPlugin> catalogs;
    private Option<String[]> _currentNamespace;
    private Option<String> _currentCatalogName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String SESSION_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SessionCatalog v1SessionCatalog() {
        return this.v1SessionCatalog;
    }

    private HashMap<String, CatalogPlugin> catalogs() {
        return this.catalogs;
    }

    public synchronized CatalogPlugin catalog(String name) {
        return name.equalsIgnoreCase(CatalogManager$.MODULE$.SESSION_CATALOG_NAME()) ? this.v2SessionCatalog() : (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> Catalogs$.MODULE$.load(name, this.conf()));
    }

    public boolean isCatalogRegistered(String name) {
        boolean bl;
        try {
            this.catalog(name);
            bl = true;
        }
        catch (CatalogNotFoundException catalogNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private CatalogPlugin loadV2SessionCatalog() {
        CatalogPlugin catalogPlugin;
        CatalogPlugin catalogPlugin2 = Catalogs$.MODULE$.load(CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), this.conf());
        if (catalogPlugin2 instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin2;
            catalogExtension.setDelegateCatalog(this.defaultSessionCatalog);
            catalogPlugin = catalogExtension;
        } else {
            catalogPlugin = catalogPlugin2;
        }
        return catalogPlugin;
    }

    public CatalogPlugin v2SessionCatalog() {
        return (CatalogPlugin)this.conf().getConf(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION()).map((Function1 & Serializable)x$1 -> (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), (Function0 & Serializable)() -> this.loadV2SessionCatalog())).getOrElse((Function0 & Serializable)() -> $this.defaultSessionCatalog);
    }

    private Option<String[]> _currentNamespace() {
        return this._currentNamespace;
    }

    private void _currentNamespace_$eq(Option<String[]> x$1) {
        this._currentNamespace = x$1;
    }

    public String[] currentNamespace() {
        String[] stringArray;
        String string = this.currentCatalog().name();
        String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
        String[] defaultNamespace = !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{this.v1SessionCatalog().getCurrentDatabase()}) : this.currentCatalog().defaultNamespace();
        CatalogManager catalogManager = this;
        synchronized (catalogManager) {
            stringArray = (String[])this._currentNamespace().getOrElse((Function0 & Serializable)() -> defaultNamespace);
        }
        return stringArray;
    }

    public synchronized void setCurrentNamespace(String[] namespace) {
        CatalogPlugin catalogPlugin = this.currentCatalog();
        if (CatalogV2Util$.MODULE$.isSessionCatalog(this.currentCatalog()) && namespace.length == 1) {
            this.v1SessionCatalog().setCurrentDatabase((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namespace)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            SupportsNamespaces supportsNamespaces;
            if (CatalogV2Util$.MODULE$.isSessionCatalog(this.currentCatalog())) {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
            }
            if (catalogPlugin instanceof SupportsNamespaces && !(supportsNamespaces = (SupportsNamespaces)catalogPlugin).namespaceExists(namespace)) {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
            }
            this._currentNamespace_$eq((Option<String[]>)new Some((Object)namespace));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Option<String> _currentCatalogName() {
        return this._currentCatalogName;
    }

    private void _currentCatalogName_$eq(Option<String> x$1) {
        this._currentCatalogName = x$1;
    }

    public synchronized CatalogPlugin currentCatalog() {
        return this.catalog((String)this._currentCatalogName().getOrElse((Function0 & Serializable)() -> this.conf().getConf(SQLConf$.MODULE$.DEFAULT_CATALOG())));
    }

    public synchronized void setCurrentCatalog(String catalogName) {
        block0: {
            String string = this.currentCatalog().name();
            String string2 = catalogName;
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.catalog(catalogName);
            this._currentCatalogName_$eq((Option<String>)new Some((Object)catalogName));
            this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
            this.v1SessionCatalog().setCurrentDatabase(this.conf().defaultDatabase());
        }
    }

    public Seq<String> listCatalogs(Option<String> pattern) {
        Seq seq;
        CatalogManager catalogManager = this;
        synchronized (catalogManager) {
            seq = this.catalogs().keys().toSeq();
        }
        Seq allCatalogs = (Seq)((SeqOps)((SeqOps)seq.$colon$plus((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        return (Seq)pattern.map((Function1 & Serializable)x$2 -> StringUtils$.MODULE$.filterPattern((Seq<String>)allCatalogs, (String)x$2)).getOrElse((Function0 & Serializable)() -> allCatalogs);
    }

    public synchronized void reset() {
        this.catalogs().clear();
        this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
        this._currentCatalogName_$eq((Option<String>)None$.MODULE$);
        this.v1SessionCatalog().setCurrentDatabase(this.conf().defaultDatabase());
    }

    public CatalogManager(CatalogPlugin defaultSessionCatalog, SessionCatalog v1SessionCatalog) {
        this.defaultSessionCatalog = defaultSessionCatalog;
        this.v1SessionCatalog = v1SessionCatalog;
        SQLConfHelper.$init$(this);
        Logging.$init$((Logging)this);
        this.catalogs = HashMap$.MODULE$.empty();
        this._currentNamespace = None$.MODULE$;
        this._currentCatalogName = None$.MODULE$;
    }
}

