/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.catalyst.expressions.TimeWindow$;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalacheck.Arbitrary;
import org.scalacheck.Gen;
import org.scalacheck.Shrink;
import org.scalacheck.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.WheneverAsserting;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatest.prop.Whenever;
import org.scalatestplus.scalacheck.CheckerAsserting;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration;
import org.scalatestplus.scalacheck.ScalaCheckDrivenPropertyChecks;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00054A!\u0002\u0004\u0001'!)!\u0005\u0001C\u0001G!)Q\u0005\u0001C\u0005M!9q\u000b\u0001b\u0001\n\u0013A\u0006B\u00021\u0001A\u0003%\u0011LA\bUS6,w+\u001b8e_^\u001cV/\u001b;f\u0015\t9\u0001\"A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0005\u000b\u0003!\u0019\u0017\r^1msN$(BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u00151q\u0001\"!\u0006\f\u000e\u00031I!a\u0006\u0007\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tI\"$D\u0001\u0007\u0013\tYbA\u0001\u000bFqB\u0014Xm]:j_:,e/\u00197IK2\u0004XM\u001d\t\u0003;\u0001j\u0011A\b\u0006\u0003?A\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005\u0005r\"a\u0005)sSZ\fG/Z'fi\"|G\rV3ti\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001%!\tI\u0002!A\tdQ\u0016\u001c7.\u0012:s_JlUm]:bO\u0016,\"aJ\u001d\u0015\u0007!ZU\u000b\u0006\u0002*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5u\u0011\u001d\u0001$!!AA\u0004E\n!\"\u001a<jI\u0016t7-\u001a\u00132!\r\u0011TgN\u0007\u0002g)\u0011AgK\u0001\be\u00164G.Z2u\u0013\t14G\u0001\u0005DY\u0006\u001c8\u000fV1h!\tA\u0014\b\u0004\u0001\u0005\u000bi\u0012!\u0019A\u001e\u0003\u0003\u0015\u000b\"\u0001P \u0011\u0005)j\u0014B\u0001 ,\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u0011%\u000f\u0005\u00053eB\u0001\"F\u001b\u0005\u0019%B\u0001#\u0013\u0003\u0019a$o\\8u}%\tA&\u0003\u0002HW\u00059\u0001/Y2lC\u001e,\u0017BA%K\u0005%)\u0005pY3qi&|gN\u0003\u0002HW!)AJ\u0001a\u0001\u001b\u0006\u0019Qn]4\u0011\u00059\u0013fBA(Q!\t\u00115&\u0003\u0002RW\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\rM#(/\u001b8h\u0015\t\t6\u0006C\u0003W\u0005\u0001\u0007Q*A\u0003wC2,X-A\bqCJ\u001cX-\u0012=qe\u0016\u001c8/[8o+\u0005I\u0006c\u0001.\\;6\t\u0001!\u0003\u0002]A\ti\u0001K]5wCR,W*\u001a;i_\u0012\u0004\"A\u000b0\n\u0005}[#\u0001\u0002'p]\u001e\f\u0001\u0003]1sg\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011")
public class TimeWindowSuite
extends SparkFunSuite
implements ExpressionEvalHelper,
PrivateMethodTester {
    private final PrivateMethodTester.PrivateMethod<Object> parseExpression;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;
    private String sparkHome;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;
    private Configuration.PropertyCheckConfiguration generatorDrivenConfig;
    private volatile boolean bitmap$0;

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    @Override
    public InternalRow create_row(Seq<Object> values) {
        return ExpressionEvalHelper.create_row$(this, values);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Tuple2<?, ?>> entries) {
        return ExpressionEvalHelper.create_map$(this, entries);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Object> keys, Seq<Object> values) {
        return ExpressionEvalHelper.create_map$(this, keys, values);
    }

    @Override
    public void checkEvaluation(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluation$default$3() {
        return ExpressionEvalHelper.checkEvaluation$default$3$(this);
    }

    @Override
    public boolean checkResult(Object result, Object expected, Expression expression) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, expression);
    }

    @Override
    public boolean checkResult(Object result, Object expected, DataType exprDataType, boolean exprNullable) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, exprDataType, exprNullable);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, String errorClass, Map<String, String> parameters, ClassTag<T> evidence$1) {
        ExpressionEvalHelper.checkErrorInExpression$(this, expression, errorClass, parameters, evidence$1);
    }

    @Override
    public <T extends SparkThrowable> Map<String, String> checkErrorInExpression$default$3() {
        return ExpressionEvalHelper.checkErrorInExpression$default$3$(this);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, InternalRow inputRow, String errorClass, Map<String, String> parameters, ClassTag<T> evidence$2) {
        ExpressionEvalHelper.checkErrorInExpression$(this, expression, inputRow, errorClass, parameters, evidence$2);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, String expectedErrMsg, ClassTag<T> evidence$3) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, expectedErrMsg, evidence$3);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, InternalRow inputRow, String expectedErrMsg, ClassTag<T> evidence$4) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, inputRow, expectedErrMsg, evidence$4);
    }

    @Override
    public Object evaluateWithoutCodegen(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithoutCodegen$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithoutCodegen$default$2() {
        return ExpressionEvalHelper.evaluateWithoutCodegen$default$2$(this);
    }

    @Override
    public void checkEvaluationWithoutCodegen(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithoutCodegen$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithoutCodegen$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithoutCodegen$default$3$(this);
    }

    @Override
    public void checkEvaluationWithMutableProjection(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithMutableProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithMutableProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithMutableProjection$default$3$(this);
    }

    @Override
    public Object evaluateWithMutableProjection(Function0<Expression> expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithMutableProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithMutableProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithMutableProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithUnsafeProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithUnsafeProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$default$3$(this);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithOptimization(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithOptimization$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithOptimization$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithOptimization$default$3$(this);
    }

    @Override
    public void checkDoubleEvaluation(Function0<Expression> expression, TripleEqualsSupport.Spread<Object> expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkDoubleEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkDoubleEvaluation$default$3() {
        return ExpressionEvalHelper.checkDoubleEvaluation$default$3$(this);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function3<Expression, Expression, Expression, Expression> c, DataType dataType1, DataType dataType2, DataType dataType3) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType1, dataType2, dataType3);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Seq<Expression>, Expression> c, DataType dataType, int minNumElements) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType, minNumElements);
    }

    @Override
    public int checkConsistencyBetweenInterpretedAndCodegen$default$3() {
        return ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$default$3$(this);
    }

    @Override
    public void cmpInterpretWithCodegen(InternalRow inputRow, Expression expr, boolean exceptionAllowed) {
        ExpressionEvalHelper.cmpInterpretWithCodegen$(this, inputRow, expr, exceptionAllowed);
    }

    @Override
    public boolean cmpInterpretWithCodegen$default$3() {
        return ExpressionEvalHelper.cmpInterpretWithCodegen$default$3$(this);
    }

    @Override
    public void testBothCodegenAndInterpreted(String name, Function0<BoxedUnit> f) {
        ExpressionEvalHelper.testBothCodegenAndInterpreted$(this, name, f);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public ScalaCheckDrivenPropertyChecks.ConfiguredPropertyCheck forAll(Seq<Configuration.PropertyCheckConfigParam> configParams) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, configParams);
    }

    public <A, ASSERTION> Object forAll(Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(String nameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Gen<A> genA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(String nameA, String nameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(String nameA, String nameB, String nameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, String nameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, (String)nameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Gen<F> genF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, genF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Tuple2<Gen<F>, String> genAndNameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, genAndNameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Test.Parameters getScalaCheckParams(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return ScalaCheckConfiguration.getScalaCheckParams$((ScalaCheckConfiguration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public Configuration.Parameter getParameter(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return Configuration.getParameter$((Configuration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public <T> Object whenever(boolean condition, Function0<T> fun, WheneverAsserting<T> wa) {
        return Whenever.whenever$((Whenever)this, (boolean)condition, fun, wa);
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    private String sparkHome$lzycompute() {
        TimeWindowSuite timeWindowSuite = this;
        synchronized (timeWindowSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
        this.generatorDrivenConfig = x$1;
    }

    private <E extends Exception> void checkErrorMessage(String msg, String value, ClassTag<E> evidence$1) {
        String validDuration = "10 second";
        String validTime = "5 second";
        Exception e1 = (Exception)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> TimeWindow$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), value, validDuration, validTime).windowDuration(), evidence$1, new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        Exception e2 = (Exception)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> TimeWindow$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), validDuration, value, validTime).slideDuration(), evidence$1, new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        Exception e3 = (Exception)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> TimeWindow$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), validDuration, validDuration, value).startTime(), evidence$1, new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Exception[]{e1, e2, e3})).foreach((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)TimeWindowSuite.$anonfun$checkErrorMessage$4(msg, e)));
    }

    private PrivateMethodTester.PrivateMethod<Object> parseExpression() {
        return this.parseExpression;
    }

    private final void PrivateMethod$lzycompute$1() {
        TimeWindowSuite timeWindowSuite = this;
        synchronized (timeWindowSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        TimeWindowSuite timeWindowSuite = this;
        synchronized (timeWindowSuite) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        TimeWindowSuite timeWindowSuite = this;
        synchronized (timeWindowSuite) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        TimeWindowSuite timeWindowSuite = this;
        synchronized (timeWindowSuite) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
        }
    }

    private final void MinSize$lzycompute$1() {
        TimeWindowSuite timeWindowSuite = this;
        synchronized (timeWindowSuite) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
        }
    }

    private final void SizeRange$lzycompute$1() {
        TimeWindowSuite timeWindowSuite = this;
        synchronized (timeWindowSuite) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
        }
    }

    private final void Workers$lzycompute$1() {
        TimeWindowSuite timeWindowSuite = this;
        synchronized (timeWindowSuite) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkErrorMessage$4(String msg$1, Exception e) {
        return e.getMessage().contains(msg$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$new$11(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$26(TimeWindowSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq intervalVariants = (Seq)tuple2._1();
        long expectedMs = tuple2._2$mcJ$sp();
        intervalVariants.foreach((Function1 & Serializable)x0$2 -> {
            String string = x0$2;
            TimeWindow timeWindow = TimeWindow$.MODULE$.apply((Expression)new Literal((Object)BoxesRunTime.boxToLong((long)10L), (DataType)TimestampType$.MODULE$), string, string, string);
            TimeWindow expected = new TimeWindow((Expression)new Literal((Object)BoxesRunTime.boxToLong((long)10L), (DataType)TimestampType$.MODULE$), expectedMs, expectedMs, expectedMs);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(timeWindow);
            TimeWindow $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            return assertion;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TimeWindowSuite() {
        Whenever.$init$((Whenever)this);
        Configuration.$init$((Configuration)this);
        ScalaCheckConfiguration.$init$((ScalaCheckConfiguration)this);
        ScalaCheckDrivenPropertyChecks.$init$((ScalaCheckDrivenPropertyChecks)this);
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        ExpressionEvalHelper.$init$(this);
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        this.test("time window is unevaluable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (SparkException)this.intercept((Function0 & Serializable)() -> this.evaluateWithoutCodegen((Expression)TimeWindow$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), "1 second", "1 second", "0 second"), this.evaluateWithoutCodegen$default$2()), ClassTag$.MODULE$.apply(SparkException.class), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33)), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("blank intervals throw exception", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{null, " ", "\n", "\t"})).foreach((Function1 & Serializable)blank -> {
            this.checkErrorMessage("The window duration, slide duration and start time cannot be null or blank.", blank, ClassTag$.MODULE$.apply(AnalysisException.class));
            return BoxedUnit.UNIT;
        }), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("invalid intervals throw exception", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkErrorMessage("did not correspond to a valid interval string.", "2 apples", ClassTag$.MODULE$.apply(AnalysisException.class)), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("intervals greater than a month throws exception", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkErrorMessage("Intervals greater than or equal to a month is not supported (1 month).", "1 month", ClassTag$.MODULE$.apply(IllegalArgumentException.class)), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("interval strings work with and without 'interval' prefix and return microseconds", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String validDuration = "10 second";
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"1 second", (Object)BoxesRunTime.boxToInteger((int)1000000)), new Tuple2((Object)"1 minute", (Object)BoxesRunTime.boxToInteger((int)60000000)), new Tuple2((Object)"2 hours", (Object)BoxesRunTime.boxToLong((long)7200000000L))})).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TimeWindowSuite.$anonfun$new$8(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String text = (String)tuple2._1();
                Object seconds = tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)TimeWindow$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), text, validDuration, "0 seconds").windowDuration()));
                Object $org_scalatest_assert_macro_right = seconds;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)TimeWindow$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), new StringBuilder(9).append("interval ").append(text).toString(), validDuration, "0 seconds").windowDuration()));
                Object $org_scalatest_assert_macro_right2 = seconds;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
                return assertion;
            });
        }, new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("SPARK-21590: Start time works with negative values and return microseconds", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String validDuration = "10 minutes";
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"-10 seconds", (Object)BoxesRunTime.boxToInteger((int)-10000000)), new Tuple2((Object)"-1 minute", (Object)BoxesRunTime.boxToInteger((int)-60000000)), new Tuple2((Object)"-1 hour", (Object)BoxesRunTime.boxToLong((long)-3600000000L))})).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TimeWindowSuite.$anonfun$new$11(check$ifrefutable$2))).foreach((Function1 & Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String text = (String)tuple2._1();
                Object seconds = tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)TimeWindow$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), validDuration, validDuration, new StringBuilder(9).append("interval ").append(text).toString()).startTime()));
                Object $org_scalatest_assert_macro_right = seconds;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)TimeWindow$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), validDuration, validDuration, text).startTime()));
                Object $org_scalatest_assert_macro_right2 = seconds;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
                return assertion;
            });
        }, new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.parseExpression = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "parseExpression"));
        this.test("parse sql expression for duration in microseconds - string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long dur;
            long $org_scalatest_assert_macro_left = dur = BoxesRunTime.unboxToLong((Object)this.anyRefToInvoker(TimeWindow$.MODULE$).invokePrivate(this.parseExpression().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Literal$.MODULE$.apply((Object)"5 seconds")}))));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "isInstanceOf", "scala.Long", BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left) instanceof Long, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)dur));
            int $org_scalatest_assert_macro_right = 5000000;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("parse sql expression for duration in microseconds - integer", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long dur;
            long $org_scalatest_assert_macro_left = dur = BoxesRunTime.unboxToLong((Object)this.anyRefToInvoker(TimeWindow$.MODULE$).invokePrivate(this.parseExpression().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100))}))));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "isInstanceOf", "scala.Long", BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left) instanceof Long, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)dur));
            int $org_scalatest_assert_macro_right = 100;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("parse sql expression for duration in microseconds - long", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long dur;
            long $org_scalatest_assert_macro_left = dur = BoxesRunTime.unboxToLong((Object)this.anyRefToInvoker(TimeWindow$.MODULE$).invokePrivate(this.parseExpression().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)0x20000000000000L), (DataType)LongType$.MODULE$)}))));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "isInstanceOf", "scala.Long", BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left) instanceof Long, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)dur));
            long $org_scalatest_assert_macro_right = 0x20000000000000L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }, new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("parse sql expression for duration in microseconds - invalid interval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (AnalysisException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)this.anyRefToInvoker(TimeWindow$.MODULE$).invokePrivate(this.parseExpression().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Literal$.MODULE$.apply((Object)"2 apples")})))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118)), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("parse sql expression for duration in microseconds - invalid expression", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (AnalysisException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)this.anyRefToInvoker(TimeWindow$.MODULE$).invokePrivate(this.parseExpression().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Rand$.MODULE$.apply(123L)})))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124)), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("SPARK-16837: TimeWindow.apply equivalent to TimeWindow constructor", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String slideLength = "1 second";
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"10 second", "1 minute", "2 hours"})).foreach((Function1 & Serializable)windowLength -> {
                TimeWindow applyValue = TimeWindow$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), windowLength, slideLength, "0 seconds");
                TimeWindow constructed = new TimeWindow((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), (Expression)Literal$.MODULE$.apply(windowLength), (Expression)Literal$.MODULE$.apply((Object)slideLength), (Expression)Literal$.MODULE$.apply((Object)"0 seconds"));
                TimeWindow $org_scalatest_assert_macro_left = applyValue;
                TimeWindow $org_scalatest_assert_macro_right = constructed;
                TimeWindow timeWindow = $org_scalatest_assert_macro_left;
                TimeWindow timeWindow2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(timeWindow != null ? !timeWindow.equals(timeWindow2) : timeWindow2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            });
        }, new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("SPARK-36091: Support TimestampNTZ type in expression TimeWindow", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TimeWindow timestampWindow = TimeWindow$.MODULE$.apply((Expression)new Literal((Object)BoxesRunTime.boxToLong((long)10L), (DataType)TimestampType$.MODULE$), "10 seconds", "10 seconds", "0 seconds");
            DataType $org_scalatest_assert_macro_left = timestampWindow.child().dataType();
            TimestampType$ $org_scalatest_assert_macro_right = TimestampType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            TimestampType$ timestampType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            DataType $org_scalatest_assert_macro_left2 = timestampWindow.dataType();
            StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("start", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("end", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            StructType structType = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(structType) : structType != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            TimeWindow timestampNTZWindow = TimeWindow$.MODULE$.apply((Expression)new Literal((Object)BoxesRunTime.boxToLong((long)10L), (DataType)TimestampNTZType$.MODULE$), "10 seconds", "10 seconds", "0 seconds");
            DataType $org_scalatest_assert_macro_left3 = timestampNTZWindow.child().dataType();
            TimestampNTZType$ $org_scalatest_assert_macro_right3 = TimestampNTZType$.MODULE$;
            DataType dataType3 = $org_scalatest_assert_macro_left3;
            TimestampNTZType$ timestampNTZType$ = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(timestampNTZType$) : timestampNTZType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            DataType $org_scalatest_assert_macro_left4 = timestampNTZWindow.dataType();
            StructType $org_scalatest_assert_macro_right4 = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("start", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("end", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            DataType dataType4 = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType4 != null ? !dataType4.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        }, new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"true", "false"})).foreach((Function1 & Serializable)legacyIntervalEnabled -> {
            this.test(new StringBuilder(59).append("SPARK-36323: Support ANSI interval literals for TimeWindow ").append(new StringBuilder(3).append("(").append(SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()).append("=").append(legacyIntervalEnabled).append(")").toString()).toString(), (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)legacyIntervalEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"3 days", "Interval 3 day", "inTerval '3' day"})), (Object)BoxesRunTime.boxToLong((long)259200000000L)), new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" 5 hours", "INTERVAL 5 hour", "interval '5' hour"})), (Object)BoxesRunTime.boxToLong((long)18000000000L)), new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\t8 minutes", "interval 8 minute", "interval '8' minute"})), (Object)BoxesRunTime.boxToLong((long)480000000L)), new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"10 seconds", "interval 10 second", "interval '10' second"})), (Object)BoxesRunTime.boxToLong((long)10000000L)), new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1 day 2 hours 3 minutes 4 seconds", " interval 1 day 2 hours 3 minutes 4 seconds", "\tinterval '1' day '2' hours '3' minutes '4' seconds", "interval '1 2:3:4' day to second"})), (Object)BoxesRunTime.boxToLong((long)93784000000L))})).foreach((Function1 & Serializable)x0$1 -> {
                    TimeWindowSuite.$anonfun$new$26($this, x0$1);
                    return BoxedUnit.UNIT;
                });
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1 years", "interval 1 year", "interval '1' year", "1 months", "interval 1 month", "interval '1' month", " 1 year 2 months", "interval 1 year 2 month", "interval '1' year '2' month", "\tinterval '1-2' year to month"})).foreach((Function1 & Serializable)interval -> (IllegalArgumentException)$this.intercept((Function0 & Serializable)() -> TimeWindow$.MODULE$.apply((Expression)new Literal((Object)BoxesRunTime.boxToLong((long)10L), (DataType)TimestampType$.MODULE$), interval, interval, interval), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189)));
            }), new Position("TimeWindowSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            return BoxedUnit.UNIT;
        });
        Statics.releaseFence();
    }
}

