/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.MultiAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.CaseKeyWhen$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentDate$;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.Exists$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.InSubquery;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.ListQuery$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.UnresolvedNamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.UnresolvedWindowExpression;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.WindowSpecReference;
import org.apache.spark.sql.catalyst.expressions.aggregate.First;
import org.apache.spark.sql.catalyst.expressions.aggregate.Last;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ExpressionParserSuite$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001\u0002\n\u0014\u0001\u0001BQa\u000b\u0001\u0005\u00021BQa\f\u0001\u0005\u0004ABq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\u0006\u001d\u0002!\ta\u0014\u0005\bE\u0002\t\n\u0011\"\u0001d\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u0015)\b\u0001\"\u0001w\u0011\u001dq\b!%A\u0005\u0002\rDaa \u0001\u0005\n\u0005\u0005\u0001\"CA\n\u0001\t\u0007I\u0011AA\u000b\u0011!\t)\u0004\u0001Q\u0001\n\u0005]\u0001\"CA\u001c\u0001\t\u0007I\u0011AA\u000b\u0011!\tI\u0004\u0001Q\u0001\n\u0005]\u0001bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u0017\u0002A\u0011AA'\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\u0012Q#\u0012=qe\u0016\u001c8/[8o!\u0006\u00148/\u001a:Tk&$XM\u0003\u0002\u0015+\u00051\u0001/\u0019:tKJT!AF\f\u0002\u0011\r\fG/\u00197zgRT!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011&!\t\u00113%D\u0001\u001a\u0013\t!\u0013DA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003M%j\u0011a\n\u0006\u0003QU\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003U\u001d\u0012A\"\u00118bYf\u001c\u0018n\u001d+fgR\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\n\u0002\u001fM$(/\u001b8h)>,FK\u0012\u001dTiJ$\"!M\u001d\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014!\u0002;za\u0016\u001c(B\u0001\u001c\u001a\u0003\u0019)hn]1gK&\u0011\u0001h\r\u0002\u000b+R3\u0005h\u0015;sS:<\u0007\"\u0002\u001e\u0003\u0001\u0004Y\u0014aA:ueB\u0011A(\u0012\b\u0003{\r\u0003\"AP!\u000e\u0003}R!\u0001Q\u0010\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0003\u0019\u0001&/\u001a3fM&\u0011ai\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\u000b\u0015!\u00043fM\u0006,H\u000e\u001e)beN,'/F\u0001K\u001d\tq3*\u0003\u0002M'\u0005\t2)\u0019;bYf\u001cHoU9m!\u0006\u00148/\u001a:\u0002\u001d\u0011,g-Y;miB\u000b'o]3sA\u0005Y\u0011m]:feR,\u0015/^1m)\u0011\u0001FK\u00160\u0011\u0005E\u0013V\"A!\n\u0005M\u000b%\u0001B+oSRDQ!V\u0003A\u0002m\n!b]9m\u0007>lW.\u00198e\u0011\u00159V\u00011\u0001Y\u0003\u0005)\u0007CA-]\u001b\u0005Q&BA.\u0016\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005uS&AC#yaJ,7o]5p]\"9A#\u0002I\u0001\u0002\u0004y\u0006C\u0001\u0018a\u0013\t\t7CA\bQCJ\u001cXM]%oi\u0016\u0014h-Y2f\u0003U\t7o]3si\u0016\u000bX/\u00197%I\u00164\u0017-\u001e7uIM*\u0012\u0001\u001a\u0016\u0003?\u0016\\\u0013A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005-\f\u0015AC1o]>$\u0018\r^5p]&\u0011Q\u000e\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00049beN,W\t_2faRLwN\u001c\u000b\u0003aN\u0004\"AI9\n\u0005IL\"AD*qCJ\\G\u000b\u001b:po\u0006\u0014G.\u001a\u0005\u0006i\u001e\u0001\raO\u0001\bgFdG+\u001a=u\u0003)\t7o]3si\u00163\u0018\r\u001c\u000b\u0005!^DX\u0010C\u0003V\u0011\u0001\u00071\bC\u0003z\u0011\u0001\u0007!0\u0001\u0004fqB,7\r\u001e\t\u0003#nL!\u0001`!\u0003\u0007\u0005s\u0017\u0010C\u0004\u0015\u0011A\u0005\t\u0019A0\u0002)\u0005\u001c8/\u001a:u\u000bZ\fG\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003\tag\u000f\u0006\u0003\u0002\u0004\u0005%\u0001cA-\u0002\u0006%\u0019\u0011q\u0001.\u0003;Us'/Z:pYZ,GMT1nK\u0012d\u0015-\u001c2eCZ\u000b'/[1cY\u0016Dq!a\u0003\u000b\u0001\u0004\ti!A\u0001t!\r\t\u0016qB\u0005\u0004\u0003#\t%AB*z[\n|G.A\bz[&sG/\u001a:wC2,f.\u001b;t+\t\t9\u0002\u0005\u0004\u0002\u001a\u0005\r\u0012qE\u0007\u0003\u00037QA!!\b\u0002 \u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003C\t\u0015AC2pY2,7\r^5p]&!\u0011QEA\u000e\u0005\r\u0019V-\u001d\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006L1ARA\u0016\u0003AIX.\u00138uKJ4\u0018\r\\+oSR\u001c\b%A\bei&sG/\u001a:wC2,f.\u001b;t\u0003A!G/\u00138uKJ4\u0018\r\\+oSR\u001c\b%A\tz[&sG/\u001a:wC2d\u0015\u000e^3sC2$b!a\u0010\u0002F\u0005%\u0003cA-\u0002B%\u0019\u00111\t.\u0003\u000f1KG/\u001a:bY\"1\u0011qI\bA\u0002m\n\u0011!\u001e\u0005\u0007\u0003\u0017y\u0001\u0019A\u001e\u0002#\u0011$\u0018J\u001c;feZ\fG\u000eT5uKJ\fG\u000e\u0006\u0004\u0002@\u0005=\u0013\u0011\u000b\u0005\u0007\u0003\u000f\u0002\u0002\u0019A\u001e\t\r\u0005-\u0001\u00031\u0001<\u0003UaWmZ1ds&sG/\u001a:wC2d\u0015\u000e^3sC2$b!a\u0010\u0002X\u0005e\u0003BBA$#\u0001\u00071\b\u0003\u0004\u0002\fE\u0001\ra\u000f")
public class ExpressionParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private final CatalystSqlParser$ defaultParser;
    private final Seq<String> ymIntervalUnits;
    private final Seq<String> dtIntervalUnits;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public void createTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public void createGlobalTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createGlobalTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void checkAnalysisWithoutViewWrapper(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive, boolean inlineCTE) {
        AnalysisTest.checkAnalysisWithoutViewWrapper$(this, inputPlan, expectedPlan, caseSensitive, inlineCTE);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$3() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$3$(this);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$4() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$4$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void assertAnalysisErrorClass(LogicalPlan inputPlan, String expectedErrorClass, Map<String, String> expectedMessageParameters, QueryContext[] queryContext, boolean caseSensitive) {
        AnalysisTest.assertAnalysisErrorClass$(this, inputPlan, expectedErrorClass, expectedMessageParameters, queryContext, caseSensitive);
    }

    @Override
    public QueryContext[] assertAnalysisErrorClass$default$4() {
        return AnalysisTest.assertAnalysisErrorClass$default$4$(this);
    }

    @Override
    public boolean assertAnalysisErrorClass$default$5() {
        return AnalysisTest.assertAnalysisErrorClass$default$5$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages, Option<String> errorClass) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages, errorClass);
    }

    @Override
    public Option<String> interceptParseException$default$4(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        return AnalysisTest.interceptParseException$default$4$(this, parser, sqlCommand, messages);
    }

    @Override
    public ParseException parseException(Function1<String, Object> parser, String sqlText) {
        return AnalysisTest.parseException$(this, parser, sqlText);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        ExpressionParserSuite expressionParserSuite = this;
        synchronized (expressionParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public UTF8String stringToUTF8Str(String str) {
        return UTF8String.fromString((String)str);
    }

    public CatalystSqlParser$ defaultParser() {
        return this.defaultParser;
    }

    public void assertEqual(String sqlCommand, Expression e, ParserInterface parser) {
        this.compareExpressions(parser.parseExpression(sqlCommand), e);
    }

    public ParserInterface assertEqual$default$3() {
        return this.defaultParser();
    }

    private SparkThrowable parseException(String sqlText2) {
        return AnalysisTest.parseException$(this, (Function1 & Serializable)sqlText -> this.defaultParser().parseExpression(sqlText), sqlText2);
    }

    public void assertEval(String sqlCommand, Object expect, ParserInterface parser) {
        Expression qual$1 = parser.parseExpression(sqlCommand);
        InternalRow x$1 = qual$1.eval$default$1();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(qual$1.eval(x$1));
        Object $org_scalatest_assert_macro_right = expect;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
    }

    public ParserInterface assertEval$default$3() {
        return this.defaultParser();
    }

    private UnresolvedNamedLambdaVariable lv(Symbol s) {
        return new UnresolvedNamedLambdaVariable((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{s.name()})));
    }

    public Seq<String> ymIntervalUnits() {
        return this.ymIntervalUnits;
    }

    public Seq<String> dtIntervalUnits() {
        return this.dtIntervalUnits;
    }

    public Literal ymIntervalLiteral(String u, String s) {
        Period period;
        block4: {
            String string = u;
            switch (string == null ? 0 : string.hashCode()) {
                case 0x38883D: {
                    if (!"year".equals(string)) break;
                    period = Period.ofYears(Integer.parseInt(s));
                    break block4;
                }
                case 104080000: {
                    if (!"month".equals(string)) break;
                    period = Period.ofMonths(Integer.parseInt(s));
                    break block4;
                }
            }
            throw new MatchError((Object)string);
        }
        Period period2 = period;
        return Literal$.MODULE$.create((Object)period2, (DataType)YearMonthIntervalType$.MODULE$.apply(BoxesRunTime.unboxToByte((Object)YearMonthIntervalType$.MODULE$.stringToField().apply((Object)u))));
    }

    public Literal dtIntervalLiteral(String u, String s) {
        Tuple2 tuple2;
        block10: {
            String string = u;
            String string2 = "second";
            long value = !(string != null ? !string.equals(string2) : string2 != null) ? scala.package$.MODULE$.BigDecimal().apply(s).$times(BigDecimal$.MODULE$.long2bigDecimal(1000000000L)).toLong() : Long.parseLong(s);
            String string3 = u;
            switch (string3 == null ? 0 : string3.hashCode()) {
                case -1074026988: {
                    if (!"minute".equals(string3)) break;
                    tuple2 = new Tuple2((Object)Duration.ofMinutes(value), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()));
                    break block10;
                }
                case -906279820: {
                    if (!"second".equals(string3)) break;
                    tuple2 = new Tuple2((Object)Duration.ofNanos(value), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()));
                    break block10;
                }
                case -368353224: {
                    if (!"microsecond".equals(string3)) break;
                    tuple2 = new Tuple2((Object)Duration.ofNanos(value * 1000L), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()));
                    break block10;
                }
                case 99228: {
                    if (!"day".equals(string3)) break;
                    tuple2 = new Tuple2((Object)Duration.ofDays(value), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()));
                    break block10;
                }
                case 3208676: {
                    if (!"hour".equals(string3)) break;
                    tuple2 = new Tuple2((Object)Duration.ofHours(value), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()));
                    break block10;
                }
                case 3645428: {
                    if (!"week".equals(string3)) break;
                    tuple2 = new Tuple2((Object)Duration.ofDays(value * 7L), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()));
                    break block10;
                }
                case 1942410881: {
                    if (!"millisecond".equals(string3)) break;
                    tuple2 = new Tuple2((Object)Duration.ofMillis(value), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()));
                    break block10;
                }
            }
            throw new MatchError((Object)string3);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Duration duration = (Duration)tuple22._1();
        byte field = BoxesRunTime.unboxToByte((Object)tuple22._2());
        Tuple2 tuple23 = new Tuple2((Object)duration, (Object)BoxesRunTime.boxToByte((byte)field));
        Tuple2 tuple24 = tuple23;
        Duration duration2 = (Duration)tuple24._1();
        byte field2 = BoxesRunTime.unboxToByte((Object)tuple24._2());
        return Literal$.MODULE$.create((Object)duration2, (DataType)DayTimeIntervalType$.MODULE$.apply(field2));
    }

    public Literal legacyIntervalLiteral(String u, String s) {
        return Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str(new StringBuilder(1).append(s).append(" ").append(u.toString()).toString())));
    }

    public static final /* synthetic */ String $anonfun$new$5(int x) {
        return new StringBuilder(4).append(x).append(" == ").append(x).toString();
    }

    private final void testVeryBinaryExpression$1(String op, Class clazz) {
        String sql = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000).map((Function1 & Serializable)x -> ExpressionParserSuite.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)x))).mkString(op);
        Expression e = this.defaultParser().parseExpression(sql);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)e.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof EqualTo ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof EqualTo;
                return bl;
            }
        }).size()));
        int $org_scalatest_assert_macro_right = 1000;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)e.collect((PartialFunction)new Serializable(null, clazz){
            private static final long serialVersionUID = 0L;
            private final Class clazz$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = this.clazz$1.isInstance(A1) ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = this.clazz$1.isInstance(expression);
                return bl;
            }
            {
                this.clazz$1 = clazz$1;
            }
        }).size()));
        int $org_scalatest_assert_macro_right2 = 999;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
    }

    public static final /* synthetic */ void $anonfun$new$17(ExpressionParserSuite $this, String quantifier) {
        $this.assertEqual(new StringBuilder(22).append("a like ").append(quantifier).append(" ('foo%', 'b%')").toString(), (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).likeAny((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), $this.assertEqual$default$3());
        $this.assertEqual(new StringBuilder(26).append("a not like ").append(quantifier).append(" ('foo%', 'b%')").toString(), (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).notLikeAny((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), $this.assertEqual$default$3());
        $this.assertEqual(new StringBuilder(28).append("not (a like ").append(quantifier).append(" ('foo%', 'b%'))").toString(), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).likeAny((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")}))).unary_$bang(), $this.assertEqual$default$3());
    }

    private static final Expression windowed$1(Seq partitioning, Seq ordering, WindowFrame frame, UnresolvedFunction func$1) {
        return new WindowExpression((Expression)func$1, new WindowSpecDefinition(partitioning, ordering, frame));
    }

    private static final Seq windowed$default$1$1() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private static final Seq windowed$default$2$1() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private static final WindowFrame windowed$default$3$1() {
        return UnspecifiedFrame$.MODULE$;
    }

    private static final Expression windowed$2(Seq partitioning, Seq ordering, WindowFrame frame, UnresolvedFunction func$2) {
        return new WindowExpression((Expression)func$2, new WindowSpecDefinition(partitioning, ordering, frame));
    }

    private static final Seq windowed$default$1$2() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private static final Seq windowed$default$2$2() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private static final WindowFrame windowed$default$3$2() {
        return UnspecifiedFrame$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$new$29(ExpressionParserSuite $this, String frameTypeSql$1, Product frameType$1, UnresolvedFunction func$2, Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String boundarySql = (String)tuple3._1();
        Expression begin = (Expression)tuple3._2();
        Expression end = (Expression)tuple3._3();
        String query = new StringBuilder(41).append("foo(*) over (partition by a order by b ").append(frameTypeSql$1).append(" ").append(boundarySql).append(")").toString();
        Expression expr = ExpressionParserSuite.windowed$2((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc()})), (WindowFrame)new SpecifiedWindowFrame((FrameType)frameType$1, begin, end), func$2);
        $this.assertEqual(query, expr, $this.assertEqual$default$3());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$28(ExpressionParserSuite $this, Seq boundaries$1, UnresolvedFunction func$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String frameTypeSql = (String)tuple2._1();
        Product frameType = (Product)tuple2._2();
        boundaries$1.foreach((Function1 & Serializable)x0$2 -> {
            ExpressionParserSuite.$anonfun$new$29($this, frameTypeSql, frameType, func$2, x0$2);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void checkTimestampNTZAndLTZ$1() {
        this.assertEqual("tImEstAmp_LTZ '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2016-03-11 20:54:00.000")), this.assertEqual$default$3());
        this.checkError(this.parseException("timestamP_LTZ '2016-33-11 20:54:00.000'"), "INVALID_TYPED_LITERAL", "42604", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)"\"TIMESTAMP_LTZ\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"'2016-33-11 20:54:00.000'")})), (QueryContext)this.ExpectedContext().apply("timestamP_LTZ '2016-33-11 20:54:00.000'", 0, 38));
        this.assertEqual("tImEstAmp_Ntz '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)LocalDateTime.parse("2016-03-11T20:54:00.000")), this.assertEqual$default$3());
        this.checkError(this.parseException("tImEstAmp_Ntz '2016-33-11 20:54:00.000'"), "INVALID_TYPED_LITERAL", "42604", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)"\"TIMESTAMP_NTZ\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"'2016-33-11 20:54:00.000'")})), (QueryContext)this.ExpectedContext().apply("tImEstAmp_Ntz '2016-33-11 20:54:00.000'", 0, 38));
    }

    public static final /* synthetic */ byte $anonfun$new$40(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ byte $anonfun$new$41(int x$2) {
        return (byte)x$2;
    }

    private final void testDecimal$1(String value) {
        this.assertEqual(value, (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply(value).underlying()), this.assertEqual$default$3());
    }

    private final void testDecimal$2(String value, ParserInterface parser) {
        this.assertEqual(value, (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply(value).underlying()), parser);
    }

    public static final /* synthetic */ void $anonfun$new$50(ExpressionParserSuite $this, String intervalValue$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String sign = (String)tuple2._1();
        Expression expectedLiteral = (Expression)tuple2._2();
        $this.assertEqual(new StringBuilder(9).append(sign).append("interval ").append(intervalValue$1).toString(), expectedLiteral, $this.assertEqual$default$3());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void checkIntervals$1(String intervalValue, Literal expected) {
        scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)expected), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-"), (Object)new UnaryMinus((Expression)expected, UnaryMinus$.MODULE$.apply$default$2()))})).foreach((Function1 & Serializable)x0$1 -> {
            ExpressionParserSuite.$anonfun$new$50(this, intervalValue, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$53(ExpressionParserSuite $this, String unit$1, String form$1, String value) {
        Literal expected = $this.ymIntervalLiteral(unit$1, value);
        $this.checkIntervals$1(new StringBuilder(1).append(value).append(" ").append(unit$1).append(form$1).toString(), expected);
        $this.checkIntervals$1(new StringBuilder(3).append("'").append(value).append("' ").append(unit$1).append(form$1).toString(), expected);
    }

    public static final /* synthetic */ void $anonfun$new$56(ExpressionParserSuite $this, String unit$2, String form$2, String value) {
        Literal expected = $this.dtIntervalLiteral(unit$2, value);
        $this.checkIntervals$1(new StringBuilder(1).append(value).append(" ").append(unit$2).append(form$2).toString(), expected);
        $this.checkIntervals$1(new StringBuilder(3).append("'").append(value).append("' ").append(unit$2).append(form$2).toString(), expected);
    }

    public static final /* synthetic */ void $anonfun$new$60(ExpressionParserSuite $this, String unit$3, String form$3, String value) {
        Literal expected = $this.legacyIntervalLiteral(unit$3, value);
        $this.checkIntervals$1(new StringBuilder(1).append(value).append(" ").append(unit$3).append(form$3).toString(), expected);
        $this.checkIntervals$1(new StringBuilder(3).append("'").append(value).append("' ").append(unit$3).append(form$3).toString(), expected);
    }

    public static final /* synthetic */ void $anonfun$new$62(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.fromYearMonthString(value));
        $this.checkIntervals$1(new StringBuilder(16).append("'").append(value).append("' year to month").toString(), result);
    }

    public static final /* synthetic */ void $anonfun$new$63(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.fromDayTimeString(value));
        $this.checkIntervals$1(new StringBuilder(16).append("'").append(value).append("' day to second").toString(), result);
    }

    public static final /* synthetic */ void $anonfun$new$64(ExpressionParserSuite $this, String value) {
        Literal result = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.fromDayTimeString(value, DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND()));
        $this.checkIntervals$1(new StringBuilder(17).append("'").append(value).append("' hour to second").toString(), result);
    }

    private static final long toMicros$1(LocalDateTime time, ZoneId zid$1) {
        long seconds = time.atZone(zid$1).toInstant().getEpochSecond();
        return TimeUnit.SECONDS.toMicros(seconds);
    }

    private final void testNonAnsiBehavior$1() {
        this.assertEqual("current_date", (Expression)UnresolvedAttribute$.MODULE$.quoted("current_date"), this.assertEqual$default$3());
        this.assertEqual("current_timestamp", (Expression)UnresolvedAttribute$.MODULE$.quoted("current_timestamp"), this.assertEqual$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$82(ExpressionParserSuite $this, String quantifier) {
        $this.assertEqual(new StringBuilder(23).append("a ilike ").append(quantifier).append(" ('FOO%', 'b%')").toString(), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.lower((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$))).likeAny((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), $this.assertEqual$default$3());
        $this.assertEqual(new StringBuilder(27).append("a not ilike ").append(quantifier).append(" ('foo%', 'B%')").toString(), (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.lower((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$))).notLikeAny((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), $this.assertEqual$default$3());
        $this.assertEqual(new StringBuilder(29).append("not (a ilike ").append(quantifier).append(" ('FOO%', 'B%'))").toString(), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.lower((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$))).likeAny((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")}))).unary_$bang(), $this.assertEqual$default$3());
    }

    public ExpressionParserSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.defaultParser = CatalystSqlParser$.MODULE$;
        this.test("star expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("*", (Expression)new UnresolvedStar((Option)None$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("a.b.*", (Expression)new UnresolvedStar(Option$.MODULE$.apply((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("named expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            UnresolvedAttribute r0 = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$);
            this.assertEqual("a", (Expression)r0, this.assertEqual$default$3());
            NamedExpression r1 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).as("b");
            this.assertEqual("a as b", (Expression)r1, this.assertEqual$default$3());
            this.assertEqual("a b", (Expression)r1, this.assertEqual$default$3());
            this.assertEqual("a as (b, c)", (Expression)new MultiAlias((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))), this.assertEqual$default$3());
            this.assertEqual("a() (b, c)", (Expression)new MultiAlias((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).function((Seq)Nil$.MODULE$), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))), this.assertEqual$default$3());
            this.assertEqual("1SL", (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1SL"}))).$((Seq)Nil$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("a.* b", (Expression)package.expressions$.MODULE$.DslExpression((Expression)new UnresolvedStar(Option$.MODULE$.apply((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))))).as("b"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("binary logical expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a and b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$amp$amp((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a or b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$bar$bar((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a and b or c and d", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$amp$amp((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$amp$amp((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$))), this.assertEqual$default$3());
            this.assertEqual("a or b or c and d", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$bar$bar((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$bar$bar((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$amp$amp((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$))), this.assertEqual$default$3());
            this.assertEqual("a or b or c or d or e or f", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$bar$bar((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$bar$bar((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).$bar$bar((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$))).$bar$bar((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$))), this.assertEqual$default$3());
            this.assertEqual("a and b and c and d and e and f", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$amp$amp((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$amp$amp((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).$amp$amp((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$))).$amp$amp((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("long binary logical expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testVeryBinaryExpression$1(" AND ", And.class);
            this.testVeryBinaryExpression$1(" OR ", Or.class);
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("not expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("not a", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("!a", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("not true > true", (Expression)new Not((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.booleanToLiteral(true), (Expression)package.expressions$.MODULE$.booleanToLiteral(true))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("exists expression", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertEqual("exists (select 1 from b where b.x = a.x)", (Expression)new Exists(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b.x"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a.x"}))).$((Seq)Nil$.MODULE$)))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), Exists$.MODULE$.apply$default$2(), Exists$.MODULE$.apply$default$3(), Exists$.MODULE$.apply$default$4(), Exists$.MODULE$.apply$default$5()), this.assertEqual$default$3()), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("comparison expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a = b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a == b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a <=> b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq$greater((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a <> b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$bang$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a != b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$bang$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a < b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a <= b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a !> b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a > b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a >= b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a !< b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("between expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a between b and c", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$))), this.assertEqual$default$3());
            this.assertEqual("a not between b and c", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$amp$amp((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("in expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a in (b, c, d)", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)})), this.assertEqual$default$3());
            this.assertEqual("a not in (b, c, d)", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).in((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)}))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("in sub-query", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a in (select b from c)", (Expression)new InSubquery((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5(), ListQuery$.MODULE$.apply$default$6())), this.assertEqual$default$3());
            this.assertEqual("(a, b, c) in (select d, e, f from g)", (Expression)new InSubquery((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"g"}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5(), ListQuery$.MODULE$.apply$default$6())), this.assertEqual$default$3());
            this.assertEqual("(a, b) in (select c from d)", (Expression)new InSubquery((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5(), ListQuery$.MODULE$.apply$default$6())), this.assertEqual$default$3());
            this.assertEqual("(a) in (select b from c)", (Expression)new InSubquery((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)})), new ListQuery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), ListQuery$.MODULE$.apply$default$2(), ListQuery$.MODULE$.apply$default$3(), ListQuery$.MODULE$.apply$default$4(), ListQuery$.MODULE$.apply$default$5(), ListQuery$.MODULE$.apply$default$6())), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("like expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package.ExpressionConversions.DslAttr qual$1 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$));
            Literal x$1 = package.expressions$.MODULE$.stringToLiteral("pattern%");
            char x$2 = qual$1.like$default$2();
            this.assertEqual("a like 'pattern%'", (Expression)qual$1.like((Expression)x$1, x$2), this.assertEqual$default$3());
            package.ExpressionConversions.DslAttr qual$2 = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$));
            Literal x$3 = package.expressions$.MODULE$.stringToLiteral("pattern%");
            char x$4 = qual$2.like$default$2();
            this.assertEqual("a not like 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression((Expression)qual$2.like((Expression)x$3, x$4)).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a rlike 'pattern%'", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")), this.assertEqual$default$3());
            this.assertEqual("a not rlike 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a regexp 'pattern%'", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%")), this.assertEqual$default$3());
            this.assertEqual("a not regexp 'pattern%'", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"))).unary_$bang(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("like escape expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String message = "Escape string must contain only one character.";
            this.assertEqual("a like 'pattern%' escape '#'", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '#'), this.assertEqual$default$3());
            this.assertEqual("a like 'pattern%' escape '\"'", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '\"'), this.assertEqual$default$3());
            this.checkError(this.parseException("a like 'pattern%' escape '##'"), "_LEGACY_ERROR_TEMP_0017", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("like 'pattern%' escape '##'", 2, 28));
            this.checkError(this.parseException("a like 'pattern%' escape ''"), "_LEGACY_ERROR_TEMP_0017", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("like 'pattern%' escape ''", 2, 26));
            this.assertEqual("a not like 'pattern%' escape '#'", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '#')).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a not like 'pattern%' escape '\"'", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).like((Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), '\"')).unary_$bang(), this.assertEqual$default$3());
            this.checkError(this.parseException("a not like 'pattern%' escape '\"/'"), "_LEGACY_ERROR_TEMP_0017", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("not like 'pattern%' escape '\"/'", 2, 32));
            this.checkError(this.parseException("a not like 'pattern%' escape ''"), "_LEGACY_ERROR_TEMP_0017", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("not like 'pattern%' escape ''", 2, 30));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("like expressions with ESCAPED_STRING_LITERALS = true", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ESCAPED_STRING_LITERALS().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            CatalystSqlParser parser = new CatalystSqlParser();
            this.assertEqual("a rlike '^\\x20[\\x20-\\x23]+$'", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("^\\x20[\\x20-\\x23]+$")), (ParserInterface)parser);
            this.assertEqual("a rlike 'pattern\\\\'", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\")), (ParserInterface)parser);
            this.assertEqual("a rlike 'pattern\\t\\n'", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).rlike((Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\t\\n")), (ParserInterface)parser);
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("(NOT) LIKE (ANY | SOME | ALL) expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"any", "some"})).foreach((Function1 & Serializable)quantifier -> {
                ExpressionParserSuite.$anonfun$new$17(this, quantifier);
                return BoxedUnit.UNIT;
            });
            this.assertEqual("a like all ('foo%', 'b%')", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).likeAll((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), this.assertEqual$default$3());
            this.assertEqual("a not like all ('foo%', 'b%')", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).notLikeAll((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), this.assertEqual$default$3());
            this.assertEqual("not (a like all ('foo%', 'b%'))", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).likeAll((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")}))).unary_$bang(), this.assertEqual$default$3());
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"any", "some", "all"})).foreach((Function1 & Serializable)quantifier -> {
                this.checkError(this.parseException(new StringBuilder(9).append("a like ").append(quantifier).append("()").toString()), "_LEGACY_ERROR_TEMP_0064", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"Expected something between '(' and ')'.")})), (QueryContext)this.ExpectedContext().apply(new StringBuilder(7).append("like ").append(quantifier).append("()").toString(), 2, 8 + quantifier.length()));
                return BoxedUnit.UNIT;
            });
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.test("is null expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a is null", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).isNull(), this.assertEqual$default$3());
            this.assertEqual("a is not null", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).isNotNull(), this.assertEqual$default$3());
            this.assertEqual("a = b is null", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).isNull(), this.assertEqual$default$3());
            this.assertEqual("a = b is not null", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).isNotNull(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        this.test("is distinct expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a is distinct from b", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq$greater((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).unary_$bang(), this.assertEqual$default$3());
            this.assertEqual("a is not distinct from b", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$less$eq$greater((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        this.test("binary arithmetic expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a * b", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$times((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a / b", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$div((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a DIV b", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).div((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a % b", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$percent((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a + b", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a - b", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$minus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a & b", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$amp((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a ^ b", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$up((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a | b", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$bar((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a * t | b ^ c & d - e + f % g DIV h / i * k", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$times((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).$((Seq)Nil$.MODULE$))).$bar(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).$up(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).$amp(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).$minus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$))).$plus(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).$percent((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"g"}))).$((Seq)Nil$.MODULE$))).div((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h"}))).$((Seq)Nil$.MODULE$))).$div((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"i"}))).$((Seq)Nil$.MODULE$))).$times((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"k"}))).$((Seq)Nil$.MODULE$)))))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        this.test("unary arithmetic expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("+a", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).unary_$plus(), this.assertEqual$default$3());
            this.assertEqual("-a", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).unary_$minus(), this.assertEqual$default$3());
            this.assertEqual("~a", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).unary_$tilde(), this.assertEqual$default$3());
            this.assertEqual("-+~~a", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).unary_$tilde()).unary_$tilde()).unary_$plus()).unary_$minus(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        this.test("cast expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("cast(a as int)", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).cast((DataType)IntegerType$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("cast(a as timestamp)", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).cast((DataType)TimestampType$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("cast(a as array<int>)", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).cast((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("cast(cast(a as int) as long)", package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).cast((DataType)IntegerType$.MODULE$)).cast((DataType)LongType$.MODULE$), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
        this.test("function expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("foo()", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).$((Seq)Nil$.MODULE$)).function((Seq)Nil$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("foo.bar()", (Expression)UnresolvedFunction$.MODULE$.apply(FunctionIdentifier$.MODULE$.apply("bar", (Option)new Some((Object)"foo")), (Seq)scala.package$.MODULE$.Seq().empty(), false), this.assertEqual$default$3());
            this.assertEqual("foo(*)", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), this.assertEqual$default$3());
            this.assertEqual("count(*)", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"count"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), this.assertEqual$default$3());
            this.assertEqual("foo(a, b)", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), this.assertEqual$default$3());
            this.assertEqual("foo(all a, b)", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), this.assertEqual$default$3());
            this.assertEqual("foo(distinct a, b)", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).$((Seq)Nil$.MODULE$)).distinctFunction((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), this.assertEqual$default$3());
            this.assertEqual("grouping(distinct a, b)", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"grouping"}))).$((Seq)Nil$.MODULE$)).distinctFunction((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), this.assertEqual$default$3());
            this.assertEqual("`select`(all a, b)", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), this.assertEqual$default$3());
            SparkThrowable x$5 = this.parseException("foo(a x)");
            String x$6 = "PARSE_SYNTAX_ERROR";
            Map x$7 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'x'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)": extra input 'x'")}));
            Option x$8 = this.checkError$default$3();
            boolean x$9 = this.checkError$default$5();
            QueryContext[] x$10 = this.checkError$default$6();
            this.checkError(x$5, "PARSE_SYNTAX_ERROR", x$8, x$7, x$9, x$10);
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        this.test("lambda functions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("x -> x + 1", (Expression)new LambdaFunction(package.expressions$.MODULE$.DslExpression((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedNamedLambdaVariable[]{this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))})), LambdaFunction$.MODULE$.apply$default$3()), this.assertEqual$default$3());
            this.assertEqual("(x, y) -> x + y", (Expression)new LambdaFunction(package.expressions$.MODULE$.DslExpression((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x"))).$plus((Expression)this.lv((Symbol)SymbolLiteral.bootstrap("apply", "y"))), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedNamedLambdaVariable[]{this.lv((Symbol)SymbolLiteral.bootstrap("apply", "x")), this.lv((Symbol)SymbolLiteral.bootstrap("apply", "y"))})), LambdaFunction$.MODULE$.apply$default$3()), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        this.test("window function expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            UnresolvedFunction func = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("foo(*) over w1", (Expression)new UnresolvedWindowExpression((Expression)func, new WindowSpecReference("w1")), this.assertEqual$default$3());
            this.assertEqual("foo(*) over ()", ExpressionParserSuite.windowed$1(ExpressionParserSuite.windowed$default$1$1(), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (partition by a, b)", ExpressionParserSuite.windowed$1((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (distribute by a, b)", ExpressionParserSuite.windowed$1((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (cluster by a, b)", ExpressionParserSuite.windowed$1((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), ExpressionParserSuite.windowed$default$2$1(), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (order by a desc, b asc)", ExpressionParserSuite.windowed$1((Seq)scala.package$.MODULE$.Seq().empty(), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).desc(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (sort by a desc, b asc)", ExpressionParserSuite.windowed$1((Seq)scala.package$.MODULE$.Seq().empty(), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).desc(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (partition by a, b order by c)", ExpressionParserSuite.windowed$1((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("foo(*) over (distribute by a, b sort by c)", ExpressionParserSuite.windowed$1((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).asc()})), ExpressionParserSuite.windowed$default$3$1(), func), this.assertEqual$default$3());
            this.assertEqual("sum(product + 1) over (partition by ((product) + (1)) order by 2)", (Expression)new WindowExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"product"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), new WindowSpecDefinition((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"product"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).asc()})), (WindowFrame)UnspecifiedFrame$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("sum(product + 1) over (partition by ((product / 2) + 1) order by 2)", (Expression)new WindowExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"product"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), new WindowSpecDefinition((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"product"}))).$((Seq)Nil$.MODULE$)).$div((Expression)package.expressions$.MODULE$.intToLiteral(2))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))})), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).asc()})), (WindowFrame)UnspecifiedFrame$.MODULE$)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        this.test("range/rows window function expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            UnresolvedFunction func = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            Seq frameTypes = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"rows", (Object)RowFrame$.MODULE$), new Tuple2((Object)"range", (Object)RangeFrame$.MODULE$)}));
            Seq boundaries = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"unbounded preceding", (Object)UnboundedPreceding$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"2147483648 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"10 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"3 + 1 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"0 preceding", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"current row", (Object)CurrentRow$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"0 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"3 + 1 following", (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3()), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"10 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"2147483649 following", (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L)), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"unbounded following", (Object)UnboundedFollowing$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between unbounded preceding and 5 following", (Object)UnboundedPreceding$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between unbounded preceding and 3 + 1 following", (Object)UnboundedPreceding$.MODULE$, (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())), new Tuple3((Object)"between unbounded preceding and 2147483649 following", (Object)UnboundedPreceding$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L))), new Tuple3((Object)"between unbounded preceding and current row", (Object)UnboundedPreceding$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 2147483648 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 10 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 3 + 1 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between 0 preceding and current row", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between current row and current row", (Object)CurrentRow$.MODULE$, (Object)CurrentRow$.MODULE$), new Tuple3((Object)"between current row and 0 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))), new Tuple3((Object)"between current row and 5 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between current row and 3 + 1 following", (Object)CurrentRow$.MODULE$, (Object)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())), new Tuple3((Object)"between current row and 2147483649 following", (Object)CurrentRow$.MODULE$, (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000001L))), new Tuple3((Object)"between current row and unbounded following", (Object)CurrentRow$.MODULE$, (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 2147483648 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0x80000000L))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 10 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 3 + 1 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)new Add((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Add$.MODULE$.apply$default$3())).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 0 preceding and unbounded following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))).unary_$minus(), (Object)UnboundedFollowing$.MODULE$), new Tuple3((Object)"between 10 preceding and 5 following", (Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))).unary_$minus(), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))), new Tuple3((Object)"between unbounded preceding and unbounded following", (Object)UnboundedPreceding$.MODULE$, (Object)UnboundedFollowing$.MODULE$)}));
            frameTypes.foreach((Function1 & Serializable)x0$1 -> {
                ExpressionParserSuite.$anonfun$new$28(this, boundaries, func, x0$1);
                return BoxedUnit.UNIT;
            });
            this.checkError(this.parseException("foo(*) over (partition by a order by b rows exp(b) preceding)"), "_LEGACY_ERROR_TEMP_0064", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"Frame bound value must be a literal.")})), (QueryContext)this.ExpectedContext().apply("exp(b) preceding", 44, 59));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.test("row constructor", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("(a, b)", (Expression)CreateStruct$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))), this.assertEqual$default$3());
            this.assertEqual("(a, b, c)", (Expression)CreateStruct$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))), this.assertEqual$default$3());
            this.assertEqual("(a as b, b as c)", (Expression)CreateStruct$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedExpression[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).as("b"), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).as("c")}))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
        this.test("scalar sub-query", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("(select max(val) from tbl) > current", (Expression)package.expressions$.MODULE$.DslExpression((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4(), ScalarSubquery$.MODULE$.apply$default$5(), ScalarSubquery$.MODULE$.apply$default$6())).$greater((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"current"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a = (select b from s)", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4(), ScalarSubquery$.MODULE$.apply$default$5(), ScalarSubquery$.MODULE$.apply$default$6())), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        this.test("case when", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("case a when 1 then b when 2 then c else d end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.intToLiteral(2), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)}))), this.assertEqual$default$3());
            this.assertEqual("case (a or b) when true then c when false then d else e end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$bar$bar((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.booleanToLiteral(true), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.booleanToLiteral(false), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e"}))).$((Seq)Nil$.MODULE$)}))), this.assertEqual$default$3());
            this.assertEqual("case 'a'='a' when true then 1 end", (Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.DslString("a").$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("a")), (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.booleanToLiteral(true), package.expressions$.MODULE$.intToLiteral(1)}))), this.assertEqual$default$3());
            this.assertEqual("case when a = 1 then b when a = 2 then c else d end", (Expression)CaseWhen$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).expr()), new Tuple2((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).expr())})), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("case when (1) + case when a > b then c else d end then f else g end", (Expression)CaseWhen$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)CaseWhen$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), (Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).expr())})), (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).expr())), (Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).expr())})), (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"g"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        this.test("dereference", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a.b", (Expression)UnresolvedAttribute$.MODULE$.apply("a.b"), this.assertEqual$default$3());
            this.assertEqual("`select`.b", (Expression)UnresolvedAttribute$.MODULE$.apply("select.b"), this.assertEqual$default$3());
            this.assertEqual("(a + b).b", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).getField("b"), this.assertEqual$default$3());
            this.assertEqual("struct(a, b).b", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.namedStruct((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)"a"), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), Literal$.MODULE$.apply((Object)"b"), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).getField("b"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        this.test("reference", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a", (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("1a", (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1a"}))).$((Seq)Nil$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("`select`", (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select"}))).$((Seq)Nil$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("columns", (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"columns"}))).$((Seq)Nil$.MODULE$), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        this.test("subscript", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("a[b]", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).getItem((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
            this.assertEqual("a[1 + 1]", (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).getItem(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))), this.assertEqual$default$3());
            this.assertEqual("`c`.a[b]", (Expression)package.expressions$.MODULE$.DslAttr(UnresolvedAttribute$.MODULE$.apply("c.a")).getItem((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
        this.test("parenthesis", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("(a)", (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), this.assertEqual$default$3());
            this.assertEqual("r * (a + b)", package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"r"}))).$((Seq)Nil$.MODULE$)).$times(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$plus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
        this.test("type constructors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("dAte '2016-03-11'", (Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-03-11")), this.assertEqual$default$3());
            this.checkError(this.parseException("DAtE 'mar 11 2016'"), "INVALID_TYPED_LITERAL", "42604", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)"\"DATE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"'mar 11 2016'")})), (QueryContext)this.ExpectedContext().apply("DAtE 'mar 11 2016'", 0, 17));
            this.assertEqual("tImEstAmp '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2016-03-11 20:54:00.000")), this.assertEqual$default$3());
            this.checkError(this.parseException("timestamP '2016-33-11 20:54:00.000'"), "INVALID_TYPED_LITERAL", "42604", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)"\"TIMESTAMP\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"'2016-33-11 20:54:00.000'")})), (QueryContext)this.ExpectedContext().apply("timestamP '2016-33-11 20:54:00.000'", 0, 34));
            this.checkTimestampNTZAndLTZ$1();
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.TIMESTAMP_TYPE().key()), (Object)SQLConf.TimestampTypes$.MODULE$.TIMESTAMP_NTZ().toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.assertEqual("tImEstAmp '2016-03-11 20:54:00.000'", (Expression)Literal$.MODULE$.apply((Object)LocalDateTime.parse("2016-03-11T20:54:00.000")), this.assertEqual$default$3());
                this.checkError(this.parseException("timestamP '2016-33-11 20:54:00.000'"), "INVALID_TYPED_LITERAL", "42604", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)"\"TIMESTAMP\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"'2016-33-11 20:54:00.000'")})), (QueryContext)this.ExpectedContext().apply("timestamP '2016-33-11 20:54:00.000'", 0, 34));
                this.assertEqual("tImEstAmp '1970-01-01 00:00:00.000 +01:00'", (Expression)new Literal((Object)BoxesRunTime.boxToLong((long)-3600000000L), (DataType)TimestampType$.MODULE$), this.assertEqual$default$3());
                this.checkTimestampNTZAndLTZ$1();
            });
            Literal ymIntervalLiteral = Literal$.MODULE$.create((Object)Period.of(1, 2, 0), (DataType)YearMonthIntervalType$.MODULE$.apply());
            this.assertEqual("InterVal 'interval 1 year 2 month'", (Expression)ymIntervalLiteral, this.assertEqual$default$3());
            this.assertEqual("INTERVAL '1 year 2 month'", (Expression)ymIntervalLiteral, this.assertEqual$default$3());
            this.checkError(this.parseException("Interval 'interval 1 yearsss 2 monthsss'"), "INVALID_TYPED_LITERAL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)"\"INTERVAL\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"'interval 1 yearsss 2 monthsss'")})), (QueryContext)this.ExpectedContext().apply("Interval 'interval 1 yearsss 2 monthsss'", 0, 39));
            this.assertEqual("-interval '1 year 2 month'", (Expression)new UnaryMinus((Expression)ymIntervalLiteral, UnaryMinus$.MODULE$.apply$default$2()), this.assertEqual$default$3());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ExpressionParserSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.time.Duration").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator1$1(ExpressionParserSuite $outer) {
                }
            }
            Literal dtIntervalLiteral = Literal$.MODULE$.create((Object)Duration.ofDays(1L).plusHours(2L).plusMinutes(3L).plusSeconds(4L).plusMillis(5L).plusNanos(6000L), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator1$1(null)));
            this.assertEqual("InterVal 'interval 1 day 2 hour 3 minute 4.005006 second'", (Expression)dtIntervalLiteral, this.assertEqual$default$3());
            this.assertEqual("INTERVAL '1 day 2 hour 3 minute 4.005006 second'", (Expression)dtIntervalLiteral, this.assertEqual$default$3());
            this.checkError(this.parseException("Interval 'interval 1 daysss 2 hoursss'"), "INVALID_TYPED_LITERAL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)"\"INTERVAL\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"'interval 1 daysss 2 hoursss'")})), (QueryContext)this.ExpectedContext().apply("Interval 'interval 1 daysss 2 hoursss'", 0, 37));
            this.assertEqual("-interval '1 day 2 hour 3 minute 4.005006 second'", (Expression)new UnaryMinus((Expression)dtIntervalLiteral, UnaryMinus$.MODULE$.apply$default$2()), this.assertEqual$default$3());
            this.checkError(this.parseException("INTERVAL '1 year 2 second'"), "_LEGACY_ERROR_TEMP_0029", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"literal"), (Object)"INTERVAL '1 year 2 second'")})), (QueryContext)this.ExpectedContext().apply("INTERVAL '1 year 2 second'", 0, 25));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Literal intervalLiteral = Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str("interval 3 month 1 hour")));
                this.assertEqual("InterVal 'interval 3 month 1 hour'", (Expression)intervalLiteral, this.assertEqual$default$3());
                this.assertEqual("INTERVAL '3 month 1 hour'", (Expression)intervalLiteral, this.assertEqual$default$3());
                this.checkError(this.parseException("Interval 'interval 3 monthsss 1 hoursss'"), "INVALID_TYPED_LITERAL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)"\"INTERVAL\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"'interval 3 monthsss 1 hoursss'")})), (QueryContext)this.ExpectedContext().apply("Interval 'interval 3 monthsss 1 hoursss'", 0, 39));
                this.assertEqual("-interval '3 month 1 hour'", (Expression)new UnaryMinus((Expression)Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str("interval 3 month 1 hour"))), UnaryMinus$.MODULE$.apply$default$2()), this.assertEqual$default$3());
                String intervalStrWithAllUnits = "1 year 3 months 2 weeks 2 days 1 hour 3 minutes 2 seconds 100 millisecond 200 microseconds";
                this.assertEqual(new StringBuilder(11).append("interval '").append(intervalStrWithAllUnits).append("'").toString(), (Expression)Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str(intervalStrWithAllUnits))), this.assertEqual$default$3());
            });
            this.assertEqual("X'A'", (Expression)Literal$.MODULE$.apply(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(new int[]{10}), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToByte((byte)ExpressionParserSuite.$anonfun$new$40(BoxesRunTime.unboxToInt((Object)x$1))), (ClassTag)ClassTag$.MODULE$.Byte())), this.assertEqual$default$3());
            this.assertEqual("x'A10C'", (Expression)Literal$.MODULE$.apply(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(new int[]{161, 12}), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToByte((byte)ExpressionParserSuite.$anonfun$new$41(BoxesRunTime.unboxToInt((Object)x$2))), (ClassTag)ClassTag$.MODULE$.Byte())), this.assertEqual$default$3());
            this.checkError(this.parseException("x'A1OC'"), "INVALID_TYPED_LITERAL", "42604", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)"\"X\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"'A1OC'")})), (QueryContext)this.ExpectedContext().apply("x'A1OC'", 0, 6));
            this.checkError(this.parseException("GEO '(10,-6)'"), "UNSUPPORTED_TYPED_LITERAL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsupportedType"), (Object)"\"GEO\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"supportedTypes"), (Object)"\"DATE\", \"TIMESTAMP_NTZ\", \"TIMESTAMP_LTZ\", \"TIMESTAMP\", \"INTERVAL\", \"X\"")})), (QueryContext)this.ExpectedContext().apply("GEO '(10,-6)'", 0, 12));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
        this.test("literals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("null", (Expression)Literal$.MODULE$.apply(null), this.assertEqual$default$3());
            this.assertEqual("trUe", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.assertEqual$default$3());
            this.assertEqual("False", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)), this.assertEqual$default$3());
            this.assertEqual("787324", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)787324)), this.assertEqual$default$3());
            this.assertEqual("7873247234798249234", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)7873247234798249234L)), this.assertEqual$default$3());
            this.testDecimal$1("78732472347982492793712334");
            this.testDecimal$1("7873247234798249279371.2334");
            this.assertEqual("9.0e1", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)90)), this.assertEqual$default$3());
            this.assertEqual(".9e+2", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)90)), this.assertEqual$default$3());
            this.assertEqual("0.9e+2", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)90)), this.assertEqual$default$3());
            this.assertEqual("900e-1BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("900e-1").underlying()), this.assertEqual$default$3());
            this.assertEqual("900.0E-1BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("900.0E-1").underlying()), this.assertEqual$default$3());
            this.assertEqual("9.e+1BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("9.e+1").underlying()), this.assertEqual$default$3());
            SparkThrowable x$11 = this.parseException(".e3");
            String x$12 = "PARSE_SYNTAX_ERROR";
            Map x$13 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'.'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)": extra input '.'")}));
            Option x$14 = this.checkError$default$3();
            boolean x$15 = this.checkError$default$5();
            QueryContext[] x$16 = this.checkError$default$6();
            this.checkError(x$11, "PARSE_SYNTAX_ERROR", x$14, x$13, x$15, x$16);
            this.assertEqual("10Y", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)10))), this.assertEqual$default$3());
            this.checkError(this.parseException("1000Y"), "_LEGACY_ERROR_TEMP_0023", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rawStrippedQualifier"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minValue"), (Object)Byte.toString((byte)-128)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxValue"), (Object)Byte.toString((byte)127)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)"tinyint")})), (QueryContext)this.ExpectedContext().apply("1000Y", 0, 4));
            this.assertEqual("10S", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)10))), this.assertEqual$default$3());
            this.checkError(this.parseException("40000S"), "_LEGACY_ERROR_TEMP_0023", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rawStrippedQualifier"), (Object)"40000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minValue"), (Object)Short.toString((short)Short.MIN_VALUE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxValue"), (Object)Short.toString((short)Short.MAX_VALUE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)"smallint")})), (QueryContext)this.ExpectedContext().apply("40000S", 0, 5));
            this.assertEqual("10L", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)10L)), this.assertEqual$default$3());
            this.checkError(this.parseException("78732472347982492793712334L"), "_LEGACY_ERROR_TEMP_0023", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rawStrippedQualifier"), (Object)"78732472347982492793712334"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minValue"), (Object)Long.toString(Long.MIN_VALUE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxValue"), (Object)Long.toString(Long.MAX_VALUE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)"bigint")})), (QueryContext)this.ExpectedContext().apply("78732472347982492793712334L", 0, 26));
            this.assertEqual("10.0D", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)10.0)), this.assertEqual$default$3());
            this.checkError(this.parseException("-1.8E308D"), "_LEGACY_ERROR_TEMP_0023", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rawStrippedQualifier"), (Object)"-1.8E308"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minValue"), (Object)scala.package$.MODULE$.BigDecimal().apply(Double$.MODULE$.MinValue()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxValue"), (Object)scala.package$.MODULE$.BigDecimal().apply(Double.MAX_VALUE).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)"double")})), (QueryContext)this.ExpectedContext().apply("-1.8E308D", 0, 8));
            this.checkError(this.parseException("1.8E308D"), "_LEGACY_ERROR_TEMP_0023", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rawStrippedQualifier"), (Object)"1.8E308"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minValue"), (Object)scala.package$.MODULE$.BigDecimal().apply(Double$.MODULE$.MinValue()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxValue"), (Object)scala.package$.MODULE$.BigDecimal().apply(Double.MAX_VALUE).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)"double")})), (QueryContext)this.ExpectedContext().apply("1.8E308D", 0, 7));
            this.assertEqual("90912830918230182310293801923652346786BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("90912830918230182310293801923652346786").underlying()), this.assertEqual$default$3());
            this.assertEqual("123.0E-28BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("123.0E-28").underlying()), this.assertEqual$default$3());
            this.assertEqual("123.08BD", (Expression)Literal$.MODULE$.apply((Object)scala.package$.MODULE$.BigDecimal().apply("123.08").underlying()), this.assertEqual$default$3());
            this.checkError(this.parseException("1.20E-38BD"), "_LEGACY_ERROR_TEMP_0061", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"[DECIMAL_PRECISION_EXCEEDS_MAX_PRECISION] Decimal precision 40 exceeds max precision 38.")})), (QueryContext)this.ExpectedContext().apply("1.20E-38BD", 0, 9));
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
        this.test("SPARK-30252: Decimal should set zero scale rather than negative scale by default", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("123.0BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("123.0")), (DataType)new DecimalType(4, 1)), this.assertEqual$default$3());
            this.assertEqual("123BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("123")), (DataType)new DecimalType(3, 0)), this.assertEqual$default$3());
            this.assertEqual("123E10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("123E10")), (DataType)new DecimalType(13, 0)), this.assertEqual$default$3());
            this.assertEqual("123E+10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("123E+10")), (DataType)new DecimalType(13, 0)), this.assertEqual$default$3());
            this.assertEqual("123E-10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("123E-10")), (DataType)new DecimalType(10, 10)), this.assertEqual$default$3());
            this.assertEqual("1.23E10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("1.23E10")), (DataType)new DecimalType(11, 0)), this.assertEqual$default$3());
            this.assertEqual("-1.23E10BD", (Expression)new Literal((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply("-1.23E10")), (DataType)new DecimalType(11, 0)), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 818));
        this.test("SPARK-29956: scientific decimal should be parsed as Decimal in legacy mode", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_EXPONENT_LITERAL_AS_DECIMAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            CatalystSqlParser parser = new CatalystSqlParser();
            this.testDecimal$2("9e1", (ParserInterface)parser);
            this.testDecimal$2("9e-1", (ParserInterface)parser);
            this.testDecimal$2("-9e1", (ParserInterface)parser);
            this.testDecimal$2("9.0e1", (ParserInterface)parser);
            this.testDecimal$2(".9e+2", (ParserInterface)parser);
            this.testDecimal$2("0.9e+2", (ParserInterface)parser);
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 828));
        this.test("strings", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)escape -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ESCAPED_STRING_LITERALS().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)escape)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                CatalystSqlParser parser = new CatalystSqlParser();
                $this.assertEqual("\"hello\"", (Expression)package.expressions$.MODULE$.stringToLiteral("hello"), (ParserInterface)parser);
                $this.assertEqual("'hello'", (Expression)package.expressions$.MODULE$.stringToLiteral("hello"), (ParserInterface)parser);
                $this.assertEqual("\"hello\" 'world'", (Expression)package.expressions$.MODULE$.stringToLiteral("helloworld"), (ParserInterface)parser);
                $this.assertEqual("'hello' \" \" 'world'", (Expression)package.expressions$.MODULE$.stringToLiteral("hello world"), (ParserInterface)parser);
                $this.assertEqual("'pattern%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern%"), (ParserInterface)parser);
                $this.assertEqual("'no-pattern\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("no-pattern\\%"), (ParserInterface)parser);
                if (escape) {
                    $this.assertEqual("'pattern\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\%"), (ParserInterface)parser);
                    $this.assertEqual("'pattern\\\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\\\%"), (ParserInterface)parser);
                    $this.assertEqual("'\\0'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\0"), (ParserInterface)parser);
                    SparkThrowable x$17 = $this.parseException("'''");
                    String x$18 = "PARSE_SYNTAX_ERROR";
                    Map x$19 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'''"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)": extra input '''")}));
                    Option x$20 = $this.checkError$default$3();
                    boolean x$21 = $this.checkError$default$5();
                    QueryContext[] x$22 = $this.checkError$default$6();
                    $this.checkError(x$17, "PARSE_SYNTAX_ERROR", x$20, x$19, x$21, x$22);
                    $this.assertEqual("'\\\"'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\\""), (ParserInterface)parser);
                    $this.assertEqual("'\\b'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\b"), (ParserInterface)parser);
                    $this.assertEqual("'\\n'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\n"), (ParserInterface)parser);
                    $this.assertEqual("'\\r'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\r"), (ParserInterface)parser);
                    $this.assertEqual("'\\t'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\t"), (ParserInterface)parser);
                    $this.assertEqual("'\\110\\145\\154\\154\\157\\041'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\110\\145\\154\\154\\157\\041"), (ParserInterface)parser);
                    $this.assertEqual("'\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029'", (Expression)package.expressions$.MODULE$.stringToLiteral("\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029"), (ParserInterface)parser);
                } else {
                    $this.assertEqual("'pattern\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\%"), (ParserInterface)parser);
                    $this.assertEqual("'pattern\\\\\\%'", (Expression)package.expressions$.MODULE$.stringToLiteral("pattern\\\\%"), (ParserInterface)parser);
                    $this.assertEqual("'\\0'", (Expression)package.expressions$.MODULE$.stringToLiteral("\u0000"), (ParserInterface)parser);
                    $this.assertEqual("'\\''", (Expression)package.expressions$.MODULE$.stringToLiteral("'"), (ParserInterface)parser);
                    $this.assertEqual("'\\\"'", (Expression)package.expressions$.MODULE$.stringToLiteral("\""), (ParserInterface)parser);
                    $this.assertEqual("'\\b'", (Expression)package.expressions$.MODULE$.stringToLiteral("\b"), (ParserInterface)parser);
                    $this.assertEqual("'\\n'", (Expression)package.expressions$.MODULE$.stringToLiteral("\n"), (ParserInterface)parser);
                    $this.assertEqual("'\\r'", (Expression)package.expressions$.MODULE$.stringToLiteral("\r"), (ParserInterface)parser);
                    $this.assertEqual("'\\t'", (Expression)package.expressions$.MODULE$.stringToLiteral("\t"), (ParserInterface)parser);
                    $this.assertEqual("'\\Z'", (Expression)package.expressions$.MODULE$.stringToLiteral("\u001a"), (ParserInterface)parser);
                    $this.assertEqual("'\\110\\145\\154\\154\\157\\041'", (Expression)package.expressions$.MODULE$.stringToLiteral("Hello!"), (ParserInterface)parser);
                    $this.assertEqual("'\\u0057\\u006F\\u0072\\u006C\\u0064\\u0020\\u003A\\u0029'", (Expression)package.expressions$.MODULE$.stringToLiteral("World :)"), (ParserInterface)parser);
                }
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
        this.ymIntervalUnits = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"year", "month"}));
        this.dtIntervalUnits = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"week", "day", "hour", "minute", "second", "millisecond", "microsecond"}));
        this.test("intervals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq forms = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "s"}));
            Seq values = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "-7", "21"}));
            this.ymIntervalUnits().foreach((Function1 & Serializable)unit -> {
                forms.foreach((Function1 & Serializable)form -> {
                    values$1.foreach((Function1 & Serializable)value -> {
                        ExpressionParserSuite.$anonfun$new$53($this, unit$1, form, value);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.dtIntervalUnits().foreach((Function1 & Serializable)unit -> {
                forms.foreach((Function1 & Serializable)form -> {
                    values$1.foreach((Function1 & Serializable)value -> {
                        ExpressionParserSuite.$anonfun$new$56($this, unit$2, form, value);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.checkIntervals$1("13.123456789 seconds", this.dtIntervalLiteral("second", "13.123456789"));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                ((IterableOnceOps)this.ymIntervalUnits().$plus$plus(this.dtIntervalUnits())).foreach((Function1 & Serializable)unit -> {
                    forms.foreach((Function1 & Serializable)form -> {
                        values$1.foreach((Function1 & Serializable)value -> {
                            ExpressionParserSuite.$anonfun$new$60($this, unit$3, form, value);
                            return BoxedUnit.UNIT;
                        });
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                this.checkIntervals$1("-13.123456789 second", Literal$.MODULE$.apply((Object)new CalendarInterval(0, 0, DateTimeTestUtils$.MODULE$.secFrac(-13, -123, -456))));
                this.checkIntervals$1("13.123456 second", Literal$.MODULE$.apply((Object)new CalendarInterval(0, 0, DateTimeTestUtils$.MODULE$.secFrac(13, 123, 456))));
                this.checkIntervals$1("1.001 second", Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str("1 second 1 millisecond"))));
            });
            this.checkError(this.parseException("interval 10 nanoseconds"), "_LEGACY_ERROR_TEMP_0062", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"Error parsing ' 10 nanoseconds' to interval, invalid unit 'nanoseconds'")})), (QueryContext)this.ExpectedContext().apply("10 nanoseconds", 9, 22));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Seq yearMonthValues = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"123-10", "496-0", "-2-3", "-123-0", "\t -1-2\t"}));
                yearMonthValues.foreach((Function1 & Serializable)value -> {
                    ExpressionParserSuite.$anonfun$new$62(this, value);
                    return BoxedUnit.UNIT;
                });
                Seq datTimeValues = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"99 11:22:33.123456789", "-99 11:22:33.123456789", "10 9:8:7.123456789", "1 0:0:0", "-1 0:0:0", "1 0:0:1", "\t 1 0:0:1 "}));
                datTimeValues.foreach((Function1 & Serializable)value -> {
                    ExpressionParserSuite.$anonfun$new$63(this, value);
                    return BoxedUnit.UNIT;
                });
                Seq hourTimeValues = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"11:22:33.123456789", "9:8:7.123456789", "-19:18:17.123456789", "0:0:0", "0:0:1"}));
                hourTimeValues.foreach((Function1 & Serializable)value -> {
                    ExpressionParserSuite.$anonfun$new$64(this, value);
                    return BoxedUnit.UNIT;
                });
            });
            this.checkError(this.parseException("interval '10' month to second"), "_LEGACY_ERROR_TEMP_0028", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)"month"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)"second")})), (QueryContext)this.ExpectedContext().apply("'10' month to second", 9, 28));
            this.checkIntervals$1("10 years 3 months", Literal$.MODULE$.create((Object)Period.of(10, 3, 0), (DataType)YearMonthIntervalType$.MODULE$.apply()));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ExpressionParserSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.time.Duration").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator2$1(ExpressionParserSuite $outer) {
                }
            }
            this.checkIntervals$1("8 days 2 hours 3 minutes 21 seconds", Literal$.MODULE$.create((Object)Duration.ofDays(8L).plusHours(2L).plusMinutes(3L).plusSeconds(21L), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_parser_ExpressionParserSuite$$typecreator2$1(null))));
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)legacyEnabled -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)legacyEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    String intervalStr = "3 monThs 4 dayS 22 sEcond 1 millisecond";
                    if (legacyEnabled) {
                        $this.checkIntervals$1(intervalStr, Literal$.MODULE$.apply((Object)new CalendarInterval(3, 4, 22001000L)));
                    } else {
                        $this.checkError($this.parseException(new StringBuilder(9).append("interval ").append(intervalStr).toString()), "_LEGACY_ERROR_TEMP_0029", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"literal"), (Object)"interval 3 monThs 4 dayS 22 sEcond 1 millisecond")})), (QueryContext)$this.ExpectedContext().apply(new StringBuilder(9).append("interval ").append(intervalStr).toString(), 0, 47));
                    }
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 963));
        this.test("composed expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("1 + r.r As q", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)UnresolvedAttribute$.MODULE$.apply("r.r"))).as("q"), this.assertEqual$default$3());
            this.assertEqual("1 - f('o', o(bar))", package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$minus((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("o"), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"o"}))).$((Seq)Nil$.MODULE$)).function((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar"}))).$((Seq)Nil$.MODULE$)}))}))), this.assertEqual$default$3());
            SparkThrowable x$23 = this.parseException("1 - f('o', o(bar)) hello * world");
            String x$24 = "PARSE_SYNTAX_ERROR";
            Map x$25 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'*'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$26 = this.checkError$default$3();
            boolean x$27 = this.checkError$default$5();
            QueryContext[] x$28 = this.checkError$default$6();
            this.checkError(x$23, "PARSE_SYNTAX_ERROR", x$26, x$25, x$27, x$28);
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1109));
        this.test("SPARK-17364, fully qualified column name which starts with number", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("123_", (Expression)UnresolvedAttribute$.MODULE$.apply("123_"), this.assertEqual$default$3());
            this.assertEqual("1a.123_", (Expression)UnresolvedAttribute$.MODULE$.apply("1a.123_"), this.assertEqual$default$3());
            this.assertEqual("a.123A", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123A"), this.assertEqual$default$3());
            this.assertEqual("a.123E3_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123E3_column"), this.assertEqual$default$3());
            this.assertEqual("a.123D_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123D_column"), this.assertEqual$default$3());
            this.assertEqual("a.123BD_column", (Expression)UnresolvedAttribute$.MODULE$.apply("a.123BD_column"), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1118));
        this.test("SPARK-17832 function identifier contains backtick", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            FunctionIdentifier complexName = FunctionIdentifier$.MODULE$.apply("`ba`r", (Option)new Some((Object)"`fo`o"));
            this.assertEqual(complexName.quotedString(), (Expression)new UnresolvedAttribute((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"`fo`o", "`ba`r"}))), this.assertEqual$default$3());
            SparkThrowable x$29 = this.parseException(complexName.unquotedString());
            String x$30 = "PARSE_SYNTAX_ERROR";
            Map x$31 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'.'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$32 = this.checkError$default$3();
            boolean x$33 = this.checkError$default$5();
            QueryContext[] x$34 = this.checkError$default$6();
            this.checkError(x$29, "PARSE_SYNTAX_ERROR", x$32, x$31, x$33, x$34);
            FunctionIdentifier complexName2 = FunctionIdentifier$.MODULE$.apply("ba``r", (Option)new Some((Object)"fo``o"));
            this.assertEqual(complexName2.quotedString(), (Expression)new UnresolvedAttribute((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fo``o", "ba``r"}))), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1131));
        this.test("SPARK-19526 Support ignore nulls keywords for first and last", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("first(a ignore nulls)", (Expression)new First((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), true).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("first(a)", (Expression)new First((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), false).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("last(a ignore nulls)", (Expression)new Last((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), true).toAggregateExpression(), this.assertEqual$default$3());
            this.assertEqual("last(a)", (Expression)new Last((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), false).toAggregateExpression(), this.assertEqual$default$3());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1144));
        this.test("timestamp literals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)zid.getId())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.assertEval("TIMESTAMP '2019-01-14 20:54:00.000'", BoxesRunTime.boxToLong((long)ExpressionParserSuite.toMicros$1(LocalDateTime.of(2019, 1, 14, 20, 54), zid)), $this.assertEval$default$3());
                $this.assertEval("Timestamp '2000-01-01T00:55:00'", BoxesRunTime.boxToLong((long)ExpressionParserSuite.toMicros$1(LocalDateTime.of(2000, 1, 1, 0, 55), zid)), $this.assertEval$default$3());
                $this.assertEval("TIMESTAMP '2019-01-16 20:50:00.567000+01:00'", BoxesRunTime.boxToLong((long)1547668200567000L), $this.assertEval$default$3());
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1151));
        this.test("date literals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1 & Serializable)timeZone -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)timeZone)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.assertEval("DATE '2019-01-14'", BoxesRunTime.boxToInteger((int)17910), $this.assertEval$default$3());
                $this.assertEval("DATE '2019-01'", BoxesRunTime.boxToInteger((int)17897), $this.assertEval$default$3());
                $this.assertEval("DATE '2019'", BoxesRunTime.boxToInteger((int)17897), $this.assertEval$default$3());
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1173));
        this.test("current date/timestamp braceless expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENFORCE_RESERVED_KEYWORDS().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.assertEqual("current_date", (Expression)new CurrentDate(CurrentDate$.MODULE$.apply$default$1()), this.assertEqual$default$3());
                this.assertEqual("current_timestamp", (Expression)new CurrentTimestamp(), this.assertEqual$default$3());
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENFORCE_RESERVED_KEYWORDS().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.testNonAnsiBehavior$1());
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENFORCE_RESERVED_KEYWORDS().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.testNonAnsiBehavior$1());
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1183));
        this.test("SPARK-36736: (NOT) ILIKE (ANY | SOME | ALL) expressions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"any", "some"})).foreach((Function1 & Serializable)quantifier -> {
                ExpressionParserSuite.$anonfun$new$82(this, quantifier);
                return BoxedUnit.UNIT;
            });
            this.assertEqual("a ilike all ('Foo%', 'b%')", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.lower((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$))).likeAll((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), this.assertEqual$default$3());
            this.assertEqual("a not ilike all ('foo%', 'B%')", (Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.lower((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$))).notLikeAll((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")})), this.assertEqual$default$3());
            this.assertEqual("not (a ilike all ('foO%', 'b%'))", (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.lower((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$))).likeAll((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("foo%"), package.expressions$.MODULE$.stringToLiteral("b%")}))).unary_$bang(), this.assertEqual$default$3());
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"any", "some", "all"})).foreach((Function1 & Serializable)quantifier -> {
                this.checkError(this.parseException(new StringBuilder(10).append("a ilike ").append(quantifier).append("()").toString()), "_LEGACY_ERROR_TEMP_0064", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"Expected something between '(' and ')'.")})), (QueryContext)this.ExpectedContext().apply(new StringBuilder(8).append("ilike ").append(quantifier).append("()").toString(), 2, 9 + quantifier.length()));
                return BoxedUnit.UNIT;
            });
        }, new Position("ExpressionParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1206));
    }
}

