/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(keys, values) - Creates a map with a pair of the given key/value arrays. All elements\n      in keys should not be null", examples="\n    Examples:\n      > SELECT _FUNC_(array(1.0, 3.0), array('2', '4'));\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.4.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\tma\u0001B\u0010!\u00016B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015i\u0007\u0001\"\u0011o\u0011!\u0011\b\u0001#b\u0001\n\u0013\u0019\b\"\u0002>\u0001\t\u0003Z\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\tI\u0004\u0001C)\u0003wA\u0011\"!\u0012\u0001\u0003\u0003%\t!a\u0012\t\u0013\u00055\u0003!%A\u0005\u0002\u0005=\u0003\"CA3\u0001E\u0005I\u0011AA(\u0011%\t9\u0007AA\u0001\n\u0003\nI\u0007C\u0005\u0002z\u0001\t\t\u0011\"\u0001\u0002|!I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u0017\u0003\u0011\u0011!C!\u0003\u001bC\u0011\"a'\u0001\u0003\u0003%\t!!(\t\u0013\u0005\u001d\u0006!!A\u0005B\u0005%\u0006\"CAW\u0001\u0005\u0005I\u0011IAX\u000f%\t\u0019\u000eIA\u0001\u0012\u0003\t)N\u0002\u0005 A\u0005\u0005\t\u0012AAl\u0011\u0019)\u0016\u0004\"\u0001\u0002p\"I\u0011\u0011_\r\u0002\u0002\u0013\u0015\u00131\u001f\u0005\n\u0003kL\u0012\u0011!CA\u0003oD\u0011\"!@\u001a\u0003\u0003%\t)a@\t\u0013\tE\u0011$!A\u0005\n\tM!!D'ba\u001a\u0013x.\\!se\u0006L8O\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0019\u0001aFM\u001b=\u0005B\u0011q\u0006M\u0007\u0002A%\u0011\u0011\u0007\t\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"aL\u001a\n\u0005Q\u0002#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011a'\u000f\b\u0003_]J!\u0001\u000f\u0011\u0002\u000fA\f7m[1hK&\u0011!h\u000f\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tA\u0004\u0005\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teHA\u0004Qe>$Wo\u0019;\u0011\u0005\rSeB\u0001#J\u001d\t)\u0005*D\u0001G\u0015\t9E&\u0001\u0004=e>|GOP\u0005\u0002\u007f%\u0011\u0001HP\u0005\u0003\u00172\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u000f \u0002\t1,g\r^\u000b\u0002\u001fB\u0011q\u0006U\u0005\u0003#\u0002\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2a\u0016-Z!\ty\u0003\u0001C\u0003N\u000b\u0001\u0007q\nC\u0003T\u000b\u0001\u0007q*\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u0018\t\u0004\u0007v{\u0016B\u00010M\u0005\r\u0019V-\u001d\t\u0003A\u000el\u0011!\u0019\u0006\u0003E\u0012\nQ\u0001^=qKNL!\u0001Z1\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A4\u0011\u0005!\\W\"A5\u000b\u0005)\u0014\u0013\u0001C1oC2L8/[:\n\u00051L'a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u001c\t\u0003ABL!!]1\u0003\u000f5\u000b\u0007\u000fV=qK\u0006QQ.\u00199Ck&dG-\u001a:\u0016\u0003Q\u0004\"!\u001e=\u000e\u0003YT!a\u001e\u0012\u0002\tU$\u0018\u000e\\\u0005\u0003sZ\u0014A#\u0011:sCf\u0014\u0015m]3e\u001b\u0006\u0004()^5mI\u0016\u0014\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003\u0002?\u0000\u0003\u0007\u0001\"!P?\n\u0005yt$aA!os\"1\u0011\u0011\u0001\u0006A\u0002q\f\u0001b[3z\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003\u000bQ\u0001\u0019\u0001?\u0002\u0015Y\fG.^3BeJ\f\u00170A\u0005e_\u001e+gnQ8eKR1\u00111BA\f\u0003C\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#\u0001\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003+\tyA\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tIb\u0003a\u0001\u00037\t1a\u0019;y!\u0011\ti!!\b\n\t\u0005}\u0011q\u0002\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\u0019c\u0003a\u0001\u0003\u0017\t!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002*A!\u00111FA\u001a\u001d\u0011\ti#a\f\u0011\u0005\u0015s\u0014bAA\u0019}\u00051\u0001K]3eK\u001aLA!!\u000e\u00028\t11\u000b\u001e:j]\u001eT1!!\r?\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003X\u0003{\t\t\u0005\u0003\u0004\u0002@5\u0001\raT\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t\u0019%\u0004a\u0001\u001f\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B,\u0002J\u0005-\u0003bB'\u000f!\u0003\u0005\ra\u0014\u0005\b':\u0001\n\u00111\u0001P\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0015+\u0007=\u000b\u0019f\u000b\u0002\u0002VA!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013!C;oG\",7m[3e\u0015\r\tyFP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA2\u00033\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\nA\u0001\\1oO*\u0011\u0011QO\u0001\u0005U\u00064\u0018-\u0003\u0003\u00026\u0005=\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA?!\ri\u0014qP\u0005\u0004\u0003\u0003s$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001?\u0002\b\"I\u0011\u0011R\n\u0002\u0002\u0003\u0007\u0011QP\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0005#BAI\u0003/cXBAAJ\u0015\r\t)JP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAM\u0003'\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qTAS!\ri\u0014\u0011U\u0005\u0004\u0003Gs$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u0013+\u0012\u0011!a\u0001y\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tY'a+\t\u0013\u0005%e#!AA\u0002\u0005u\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002 \u0006E\u0006\u0002CAE/\u0005\u0005\t\u0019\u0001?)'\u0001\t),a/\u0002>\u0006\u0005\u00171YAd\u0003\u0013\fi-a4\u0011\u0007=\n9,C\u0002\u0002:\u0002\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002@\u0006\t)A\u0003\u0011!A\u0001zf)\u0016(D?\"ZW-_:-AY\fG.^3tS\u0001j\u0003e\u0011:fCR,7\u000fI1![\u0006\u0004\be^5uQ\u0002\n\u0007\u0005]1je\u0002zg\r\t;iK\u0002:\u0017N^3oA-,\u0017p\f<bYV,\u0007%\u0019:sCf\u001ch\u0006I!mY\u0002*G.Z7f]R\u001c(\u0002\t\u0011!A\u0001\u0002\u0013N\u001c\u0011lKf\u001c\be\u001d5pk2$\u0007E\\8uA\t,\u0007E\\;mY\u0006AQ\r_1na2,7/\t\u0002\u0002F\u0006\u0019'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u00181Y\u0001\u001ad\u0006M\u0015-A\u0005\u0014(/Y=)OI:C\u0006I\u00145O%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>2]AR$E\r\u0012-g9\u0002$H\t\u001b#{*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002L\u0006)!G\f\u001b/a\u0005)qM]8va\u0006\u0012\u0011\u0011[\u0001\n[\u0006\u0004xLZ;oGN\fQ\"T1q\rJ|W.\u0011:sCf\u001c\bCA\u0018\u001a'\u0015I\u0012\u0011\\As!\u001d\tY.!9P\u001f^k!!!8\u000b\u0007\u0005}g(A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0018Q\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAt\u0003[l!!!;\u000b\t\u0005-\u00181O\u0001\u0003S>L1aSAu)\t\t).\u0001\u0005u_N#(/\u001b8h)\t\tY'A\u0003baBd\u0017\u0010F\u0003X\u0003s\fY\u0010C\u0003N9\u0001\u0007q\nC\u0003T9\u0001\u0007q*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0005!Q\u0002\t\u0006{\t\r!qA\u0005\u0004\u0005\u000bq$AB(qi&|g\u000eE\u0003>\u0005\u0013yu*C\u0002\u0003\fy\u0012a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\b;\u0005\u0005\t\u0019A,\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u0016A!\u0011Q\u000eB\f\u0013\u0011\u0011I\"a\u001c\u0003\r=\u0013'.Z2u\u0001")
public class MapFromArrays
extends BinaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(MapFromArrays x$0) {
        return MapFromArrays$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, MapFromArrays> tupled() {
        return MapFromArrays$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MapFromArrays>> curried() {
        return MapFromArrays$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$, ArrayType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            typeCheckResult = defaultCheck;
        } else {
            DataType keyType = ((ArrayType)this.left().dataType()).elementType();
            typeCheckResult = TypeUtils$.MODULE$.checkForMapKeyType(keyType);
        }
        return typeCheckResult;
    }

    @Override
    public MapType dataType() {
        return new MapType(((ArrayType)this.left().dataType()).elementType(), ((ArrayType)this.right().dataType()).elementType(), ((ArrayType)this.right().dataType()).containsNull());
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        MapFromArrays mapFromArrays = this;
        synchronized (mapFromArrays) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return !this.bitmap$0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object keyArray, Object valueArray) {
        ArrayData keyArrayData = (ArrayData)keyArray;
        ArrayData valueArrayData = (ArrayData)valueArray;
        return this.mapBuilder().from(keyArrayData.copy(), valueArrayData.copy());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(keyArrayData, valueArrayData) -> {
            String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
            return new StringBuilder(27).append(ev.value()).append(" = ").append(builderTerm).append(".from(").append((String)keyArrayData).append(".copy(), ").append((String)valueArrayData).append(".copy());").toString();
        });
    }

    @Override
    public String prettyName() {
        return "map_from_arrays";
    }

    @Override
    public MapFromArrays withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public MapFromArrays copy(Expression left, Expression right) {
        return new MapFromArrays(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "MapFromArrays";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapFromArrays;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapFromArrays)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapFromArrays mapFromArrays = (MapFromArrays)x$1;
        Expression expression = this.left();
        Expression expression2 = mapFromArrays.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapFromArrays.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!mapFromArrays.canEqual(this)) return false;
        return true;
    }

    public MapFromArrays(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

