/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AggregateWindowFunction;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NthValue$;
import org.apache.spark.sql.catalyst.expressions.OffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset]) - Returns the value of `input` at the row that is the `offset`th row\n      from beginning of the window frame. Offset starts at 1. If ignoreNulls=true, we will skip\n      nulls when finding the `offset`th row. Otherwise, every row counts for the `offset`. If\n      there is no such an `offset`th row (e.g., when the offset is 10, size of the window frame\n      is less than 10), null is returned.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b, 2) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t1\n       A2\t3\tNULL\n  ", arguments="\n    Arguments:\n      * input - the target column or expression that the function operates on.\n      * offset - a positive int literal to indicate the offset in the window frame. It starts\n          with 1.\n      * ignoreNulls - an optional specification that indicates the NthValue should skip null\n          values in the determination of which row to use.\n  ", since="3.1.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0005\tMd\u0001B\u0017/\u0001nB\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\tS\u0002\u0011\t\u0012)A\u0005\u0019\"A!\u000e\u0001BK\u0002\u0013\u0005\u0001\u000e\u0003\u0005l\u0001\tE\t\u0015!\u0003M\u0011!a\u0007A!f\u0001\n\u0003i\u0007\u0002C9\u0001\u0005#\u0005\u000b\u0011\u00028\t\u000bI\u0004A\u0011A:\t\u000bI\u0004A\u0011\u0001=\t\u0011q\u0004\u0001R1A\u0005BuDa!a\u0001\u0001\t\u0003B\u0007BBA\u0003\u0001\u0011\u0005\u0003\u000eC\u0005\u0002\b\u0001\u0011\r\u0011\"\u0011\u0002\n!A\u0011\u0011\u0003\u0001!\u0002\u0013\tY\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!9\u00111\u0007\u0001\u0005B\u0005U\u0002BCA\"\u0001!\u0015\r\u0011\"\u0003\u0002F!Q\u0011Q\n\u0001\t\u0006\u0004%I!a\u0014\t\u0015\u0005]\u0003\u0001#b\u0001\n\u0013\ty\u0005\u0003\u0006\u0002Z\u0001A)\u0019!C!\u00037B!\"a\u0018\u0001\u0011\u000b\u0007I\u0011IA1\u0011)\t)\u0007\u0001EC\u0002\u0013\u0005\u0013q\r\u0005\u000b\u0003W\u0002\u0001R1A\u0005B\u0005=\u0003bBA7\u0001\u0011\u0005\u0013q\u000e\u0005\u0007g\u0001!\t%a\u001c\t\u000f\u0005\u0005\u0005\u0001\"\u0015\u0002\u0004\"I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003/\u0003\u0011\u0013!C\u0001\u00033C\u0011\"a,\u0001#\u0003%\t!!'\t\u0013\u0005E\u0006!%A\u0005\u0002\u0005M\u0006\"CA\\\u0001\u0005\u0005I\u0011IA]\u0011%\tI\rAA\u0001\n\u0003\tY\rC\u0005\u0002T\u0002\t\t\u0011\"\u0001\u0002V\"I\u0011\u0011\u001d\u0001\u0002\u0002\u0013\u0005\u00131\u001d\u0005\n\u0003c\u0004\u0011\u0011!C\u0001\u0003gD\u0011\"a>\u0001\u0003\u0003%\t%!?\t\u0013\u0005u\b!!A\u0005B\u0005}x!\u0003B\u0015]\u0005\u0005\t\u0012\u0001B\u0016\r!ic&!A\t\u0002\t5\u0002B\u0002:(\t\u0003\u0011)\u0005C\u0005\u0003H\u001d\n\t\u0011\"\u0012\u0003J!I!1J\u0014\u0002\u0002\u0013\u0005%Q\n\u0005\n\u0005+:\u0013\u0011!CA\u0005/B\u0011B!\u001b(\u0003\u0003%IAa\u001b\u0003\u00119#\bNV1mk\u0016T!a\f\u0019\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003cI\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003gQ\n1a]9m\u0015\t)d'A\u0003ta\u0006\u00148N\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<7\u0001A\n\t\u0001q\u00025IR(V7B\u0011QHP\u0007\u0002]%\u0011qH\f\u0002\u0018\u0003\u001e<'/Z4bi\u0016<\u0016N\u001c3po\u001a+hn\u0019;j_:\u0004\"!P!\n\u0005\ts#\u0001F(gMN,GoV5oI><h)\u001e8di&|g\u000e\u0005\u0002>\t&\u0011QI\f\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0019qI\u0013'\u000e\u0003!S!!\u0013\u0019\u0002\u000bQ\u0014X-Z:\n\u0005-C%A\u0003\"j]\u0006\u0014\u0018\u0010T5lKB\u0011Q(T\u0005\u0003\u001d:\u0012!\"\u0012=qe\u0016\u001c8/[8o!\t\u00016+D\u0001R\u0015\t\u0011&'\u0001\u0004feJ|'o]\u0005\u0003)F\u0013q\"U;fef,%O]8sg\n\u000b7/\u001a\t\u0003-fk\u0011a\u0016\u0006\u00021\u0006)1oY1mC&\u0011!l\u0016\u0002\b!J|G-^2u!\taFM\u0004\u0002^E:\u0011a,Y\u0007\u0002?*\u0011\u0001MO\u0001\u0007yI|w\u000e\u001e \n\u0003aK!aY,\u0002\u000fA\f7m[1hK&\u0011QM\u001a\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003G^\u000bQ!\u001b8qkR,\u0012\u0001T\u0001\u0007S:\u0004X\u000f\u001e\u0011\u0002\r=4gm]3u\u0003\u001dygMZ:fi\u0002\n1\"[4o_J,g*\u001e7mgV\ta\u000e\u0005\u0002W_&\u0011\u0001o\u0016\u0002\b\u0005>|G.Z1o\u00031IwM\\8sK:+H\u000e\\:!\u0003\u0019a\u0014N\\5u}Q!A/\u001e<x!\ti\u0004\u0001C\u0003h\u000f\u0001\u0007A\nC\u0003k\u000f\u0001\u0007A\nC\u0003m\u000f\u0001\u0007a\u000eF\u0002usnDQA\u001f\u0005A\u00021\u000bQa\u00195jY\u0012DQA\u001b\u0005A\u00021\u000bq\u0001Z3gCVdG/F\u0001\u007f!\tit0C\u0002\u0002\u00029\u0012q\u0001T5uKJ\fG.\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018!\u00024sC6,WCAA\u0006!\ri\u0014QB\u0005\u0004\u0003\u001fq#aC,j]\u0012|wO\u0012:b[\u0016\faA\u001a:b[\u0016\u0004\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005]\u0001\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005u!'A\u0003usB,7/\u0003\u0003\u0002\"\u0005m!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002(A)A,!\u000b\u0002.%\u0019\u00111\u00064\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u001a\u0005=\u0012\u0002BA\u0019\u00037\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u\u0002'\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t\t%a\u000f\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0011b\u001c4gg\u0016$h+\u00197\u0016\u0005\u0005\u001d\u0003c\u0001,\u0002J%\u0019\u00111J,\u0003\t1{gnZ\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0016\u0005\u0005E\u0003cA\u001f\u0002T%\u0019\u0011Q\u000b\u0018\u0003%\u0005#HO]5ckR,'+\u001a4fe\u0016t7-Z\u0001\u0006G>,h\u000e^\u0001\u0014C\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm]\u000b\u0003\u0003;\u0002R\u0001XA\u0015\u0003#\nQ\"\u001b8ji&\fGNV1mk\u0016\u001cXCAA2!\u0011a\u0016\u0011\u0006@\u0002#U\u0004H-\u0019;f\u000bb\u0004(/Z:tS>t7/\u0006\u0002\u0002jA!A,!\u000bM\u0003I)g/\u00197vCR,W\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002rA!\u00111OA>\u001d\u0011\t)(a\u001e\u0011\u0005y;\u0016bAA=/\u00061\u0001K]3eK\u001aLA!! \u0002\u0000\t11\u000b\u001e:j]\u001eT1!!\u001fX\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003u\u0003\u000b\u000bI\t\u0003\u0004\u0002\bj\u0001\r\u0001T\u0001\b]\u0016<H*\u001a4u\u0011\u0019\tYI\u0007a\u0001\u0019\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLHc\u0002;\u0002\u0012\u0006M\u0015Q\u0013\u0005\bOn\u0001\n\u00111\u0001M\u0011\u001dQ7\u0004%AA\u00021Cq\u0001\\\u000e\u0011\u0002\u0003\u0007a.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005m%f\u0001'\u0002\u001e.\u0012\u0011q\u0014\t\u0005\u0003C\u000bY+\u0004\u0002\u0002$*!\u0011QUAT\u0003%)hn\u00195fG.,GMC\u0002\u0002*^\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti+a)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0017\u0016\u0004]\u0006u\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002<B!\u0011QXAd\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017\u0001\u00027b]\u001eT!!!2\u0002\t)\fg/Y\u0005\u0005\u0003{\ny,\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002NB\u0019a+a4\n\u0007\u0005EwKA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002X\u0006u\u0007c\u0001,\u0002Z&\u0019\u00111\\,\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002`\u0006\n\t\u00111\u0001\u0002N\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!:\u0011\r\u0005\u001d\u0018Q^Al\u001b\t\tIOC\u0002\u0002l^\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty/!;\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004]\u0006U\b\"CApG\u0005\u0005\t\u0019AAl\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005m\u00161 \u0005\n\u0003?$\u0013\u0011!a\u0001\u0003\u001b\fa!Z9vC2\u001cHc\u00018\u0003\u0002!I\u0011q\\\u0013\u0002\u0002\u0003\u0007\u0011q\u001b\u0015\u0018\u0001\t\u0015!1\u0002B\u0007\u0005#\u0011\u0019Ba\u0006\u0003\u001a\tu!q\u0004B\u0012\u0005K\u00012!\u0010B\u0004\u0013\r\u0011IA\f\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011y!AB-\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK5oaV$8\f\f\u0011pM\u001a\u001cX\r^/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAY\fG.^3!_\u001a\u0004\u0003-\u001b8qkR\u0004\u0007%\u0019;!i\",\u0007E]8xAQD\u0017\r\u001e\u0011jg\u0002\"\b.\u001a\u0011a_\u001a47/\u001a;ai\"\u0004#o\\<\u000bA\u0001\u0002\u0003\u0005\t\u0011ge>l\u0007EY3hS:t\u0017N\\4!_\u001a\u0004C\u000f[3!o&tGm\\<!MJ\fW.\u001a\u0018!\u001f\u001a47/\u001a;!gR\f'\u000f^:!CR\u0004\u0013G\f\u0011JM\u0002JwM\\8sK:+H\u000e\\:>iJ,X\r\f\u0011xK\u0002:\u0018\u000e\u001c7!g.L\u0007O\u0003\u0011!A\u0001\u0002\u0003E\\;mYN\u0004s\u000f[3oA\u0019Lg\u000eZ5oO\u0002\"\b.\u001a\u0011a_\u001a47/\u001a;ai\"\u0004#o\\</A=#\b.\u001a:xSN,G\u0006I3wKJL\bE]8xA\r|WO\u001c;tA\u0019|'\u000f\t;iK\u0002\u0002wN\u001a4tKR\u0004g\u0006I%g\u0015\u0001\u0002\u0003\u0005\t\u0011!i\",'/\u001a\u0011jg\u0002rw\u000eI:vG\"\u0004\u0013M\u001c\u0011a_\u001a47/\u001a;ai\"\u0004#o\\<!Q\u0015tsM\f\u0017!o\",g\u000e\t;iK\u0002zgMZ:fi\u0002J7\u000fI\u00191Y\u0001\u001a\u0018N_3!_\u001a\u0004C\u000f[3!o&tGm\\<!MJ\fW.\u001a\u0006!A\u0001\u0002\u0003\u0005I5tA1,7o\u001d\u0011uQ\u0006t\u0007%\r\u0019*Y\u0001rW\u000f\u001c7!SN\u0004#/\u001a;ve:,GM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003\u0016\u0005\t\u0019K\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011bY\u0001\u0012G\u0006I0G+:\u001bu\f\u000b2-AIJ\u0003e\u0014,F%\u0002B\u0003+\u0011*U\u0013RKuJ\u0014\u0011C3\u0002\n\u0007e\u0014*E\u000bJ\u0003#)\u0017\u0011cS\u00012%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!e%b\u0003\u0005K\u0014Bc\u001db\u0003%M\u0015-A!:\u0013IM\u0014-AMJC\u0006\t\u0015(\u0003F:C\u0006I\u0019*AQ\f'\rK1-A\tL3H\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013EJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013EJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013IJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005I!3\u0013MJa*\u0016'M\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\u0011Y\"\u0001Bj\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u0013N\u001c9vi\u0002j\u0003\u0005\u001e5fAQ\f'oZ3uA\r|G.^7oA=\u0014\b%\u001a=qe\u0016\u001c8/[8oAQD\u0017\r\u001e\u0011uQ\u0016\u0004c-\u001e8di&|g\u000eI8qKJ\fG/Z:!_:t#\u0002\t\u0011!A\u0001\u0002#\u0006I8gMN,G\u000fI\u0017!C\u0002\u0002xn]5uSZ,\u0007%\u001b8uA1LG/\u001a:bY\u0002\"x\u000eI5oI&\u001c\u0017\r^3!i\",\u0007e\u001c4gg\u0016$\b%\u001b8!i\",\u0007e^5oI><\bE\u001a:b[\u0016t\u0003%\u0013;!gR\f'\u000f^:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002s/\u001b;iAEr#\u0002\t\u0011!A\u0001\u0002#\u0006I5h]>\u0014XMT;mYN\u0004S\u0006I1oA=\u0004H/[8oC2\u00043\u000f]3dS\u001aL7-\u0019;j_:\u0004C\u000f[1uA%tG-[2bi\u0016\u001c\b\u0005\u001e5fA9#\bNV1mk\u0016\u00043\u000f[8vY\u0012\u00043o[5qA9,H\u000e\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012\u0018\r\\;fg\u0002Jg\u000e\t;iK\u0002\"W\r^3s[&t\u0017\r^5p]\u0002zg\rI<iS\u000eD\u0007E]8xAQ|\u0007%^:f])\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003\"\u0005)1GL\u0019/a\u0005)qM]8va\u0006\u0012!qE\u0001\ro&tGm\\<`MVt7m]\u0001\t\u001dRDg+\u00197vKB\u0011QhJ\n\u0006O\t=\"1\b\t\t\u0005c\u00119\u0004\u0014'oi6\u0011!1\u0007\u0006\u0004\u0005k9\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005s\u0011\u0019DA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BA!\u0010\u0003D5\u0011!q\b\u0006\u0005\u0005\u0003\n\u0019-\u0001\u0002j_&\u0019QMa\u0010\u0015\u0005\t-\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0016!B1qa2LHc\u0002;\u0003P\tE#1\u000b\u0005\u0006O*\u0002\r\u0001\u0014\u0005\u0006U*\u0002\r\u0001\u0014\u0005\u0006Y*\u0002\rA\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IF!\u001a\u0011\u000bY\u0013YFa\u0018\n\u0007\tusK\u0001\u0004PaRLwN\u001c\t\u0007-\n\u0005D\n\u00148\n\u0007\t\rtK\u0001\u0004UkBdWm\r\u0005\t\u0005OZ\u0013\u0011!a\u0001i\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t5\u0004\u0003BA_\u0005_JAA!\u001d\u0002@\n1qJ\u00196fGR\u0004")
public class NthValue
extends AggregateWindowFunction
implements OffsetWindowFunction,
ImplicitCastInputTypes,
BinaryLike<Expression>,
QueryErrorsBase {
    private Literal default;
    private long offsetVal;
    private AttributeReference result;
    private AttributeReference count;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> updateExpressions;
    private AttributeReference evaluateExpression;
    private final Expression input;
    private final Expression offset;
    private final boolean ignoreNulls;
    private final WindowFrame frame;
    private transient Seq<Expression> children;
    private SpecifiedWindowFrame fakeFrame;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(NthValue x$0) {
        return NthValue$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, NthValue> tupled() {
        return NthValue$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, NthValue>>> curried() {
        return NthValue$.MODULE$.curried();
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    private SpecifiedWindowFrame fakeFrame$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.fakeFrame = OffsetWindowFunction.fakeFrame$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.fakeFrame;
    }

    @Override
    public SpecifiedWindowFrame fakeFrame() {
        return (this.bitmap$0 & 0x100) == 0 ? this.fakeFrame$lzycompute() : this.fakeFrame;
    }

    @Override
    public Expression input() {
        return this.input;
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    @Override
    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    private Literal default$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 1) == 0) {
                this.default = Literal$.MODULE$.create(null, this.input().dataType());
                this.bitmap$0 |= 1;
            }
        }
        return this.default;
    }

    @Override
    public Literal default() {
        return (this.bitmap$0 & 1) == 0 ? this.default$lzycompute() : this.default;
    }

    @Override
    public Expression left() {
        return this.input();
    }

    @Override
    public Expression right() {
        return this.offset();
    }

    @Override
    public WindowFrame frame() {
        return this.frame;
    }

    @Override
    public DataType dataType() {
        return this.input().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyDataType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult check = ExpectsInputTypes.checkInputDataTypes$(this);
        return check.isFailure() ? check : (!this.offset().foldable() ? new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"offset"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType(this.offset().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.offset()))})))) : (this.offsetVal() <= 0L ? new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"offset"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)new StringBuilder(34).append("(0, ").append(Long.MAX_VALUE).append("]").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)this.toSQLValue(BoxesRunTime.boxToLong((long)this.offsetVal()), LongType$.MODULE$))})))) : TypeCheckResult$TypeCheckSuccess$.MODULE$));
    }

    private long offsetVal$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 2) == 0) {
                this.offsetVal = BoxesRunTime.unboxToInt((Object)this.offset().eval(this.offset().eval$default$1()));
                this.bitmap$0 |= 2;
            }
        }
        return this.offsetVal;
    }

    private long offsetVal() {
        return (this.bitmap$0 & 2) == 0 ? this.offsetVal$lzycompute() : this.offsetVal;
    }

    private AttributeReference result$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "result";
                DataType x$2 = this.input().dataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("result", x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("result", x$2, x$3, x$4);
                this.result = new AttributeReference("result", x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.result;
    }

    private AttributeReference result() {
        return (this.bitmap$0 & 4) == 0 ? this.result$lzycompute() : this.result;
    }

    private AttributeReference count$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 8) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("count", x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("count", x$2, x$3, x$4);
                this.count = new AttributeReference("count", x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 8;
            }
        }
        return this.count;
    }

    private AttributeReference count() {
        return (this.bitmap$0 & 8) == 0 ? this.count$lzycompute() : this.count;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.result();
                AttributeReference attributeReference2 = this.count();
                this.aggBufferAttributes = package$.MODULE$.Nil().$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{this.default(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L))}));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.updateExpressions = this.ignoreNulls() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new If[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal())))).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNotNull()))), this.input(), this.result()), new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.input()).isNull()), this.count(), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L)))})) : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.count()).$eq$eq$eq(package$expressions$.MODULE$.longToLiteral(this.offsetVal()))), this.input(), this.result()), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L))}));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private AttributeReference evaluateExpression$lzycompute() {
        NthValue nthValue = this;
        synchronized (nthValue) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.evaluateExpression = this.result();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return (this.bitmap$0 & 0x80) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public String prettyName() {
        return "nth_value";
    }

    @Override
    public String sql() {
        return new StringBuilder(4).append(this.prettyName()).append("(").append(this.input().sql()).append(", ").append(this.offset().sql()).append(")").append((Object)(this.ignoreNulls() ? " ignore nulls" : "")).toString();
    }

    @Override
    public NthValue withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public NthValue copy(Expression input, Expression offset, boolean ignoreNulls) {
        return new NthValue(input, offset, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.offset();
    }

    public boolean copy$default$3() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "NthValue";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.input();
                break;
            }
            case 1: {
                object = this.offset();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NthValue;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "input";
                break;
            }
            case 1: {
                string = "offset";
                break;
            }
            case 2: {
                string = "ignoreNulls";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NthValue)) return false;
        boolean bl = true;
        if (!bl) return false;
        NthValue nthValue = (NthValue)x$1;
        if (this.ignoreNulls() != nthValue.ignoreNulls()) return false;
        Expression expression = this.input();
        Expression expression2 = nthValue.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.offset();
        Expression expression4 = nthValue.offset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!nthValue.canEqual(this)) return false;
        return true;
    }

    public NthValue(Expression input, Expression offset, boolean ignoreNulls) {
        this.input = input;
        this.offset = offset;
        this.ignoreNulls = ignoreNulls;
        OffsetWindowFunction.$init$(this);
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        QueryErrorsBase.$init$(this);
        this.frame = UnspecifiedFrame$.MODULE$;
    }

    public NthValue(Expression child, Expression offset) {
        this(child, offset, false);
    }
}

