/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t}b\u0001\u0002\u0014(\u0001RB\u0001\u0002\u0016\u0001\u0003\u0016\u0004%\t!\u0016\u0005\t3\u0002\u0011\t\u0012)A\u0005-\"A!\f\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005\\\u0001\tE\t\u0015!\u0003W\u0011!a\u0006A!f\u0001\n\u0003)\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011\u0002,\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011\u00013\t\u000by\u0003A\u0011\u00015\t\u000b)\u0004A\u0011I+\t\u000b-\u0004A\u0011I+\t\u000b1\u0004A\u0011I+\t\u000b5\u0004A\u0011\t8\t\u000ba\u0004A\u0011I=\t\u0011u\u0004\u0001R1A\u0005\nyDq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002\"\u0001!\t&a\t\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!9\u00111\u000b\u0001\u0005R\u0005U\u0003\"CA2\u0001\u0005\u0005I\u0011AA3\u0011%\ti\u0007AI\u0001\n\u0003\ty\u0007C\u0005\u0002\u0006\u0002\t\n\u0011\"\u0001\u0002p!I\u0011q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u000e\u0005\n\u0003\u0013\u0003\u0011\u0011!C!\u0003\u0017C\u0011\"a'\u0001\u0003\u0003%\t!!(\t\u0013\u0005\u0015\u0006!!A\u0005\u0002\u0005\u001d\u0006\"CAW\u0001\u0005\u0005I\u0011IAX\u0011%\ti\fAA\u0001\n\u0003\ty\fC\u0005\u0002J\u0002\t\t\u0011\"\u0011\u0002L\"I\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0013\u0011[\u0004\n\u0003k<\u0013\u0011!E\u0001\u0003o4\u0001BJ\u0014\u0002\u0002#\u0005\u0011\u0011 \u0005\u0007=\u0002\"\tA!\u0005\t\u0013\tM\u0001%!A\u0005F\tU\u0001\"\u0003B\fA\u0005\u0005I\u0011\u0011B\r\u0011%\u0011\t\u0003IA\u0001\n\u0003\u0013\u0019\u0003C\u0005\u00036\u0001\n\t\u0011\"\u0003\u00038\tY1\u000b\u001e:j]\u001e$v.T1q\u0015\tA\u0013&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0016,\u0003!\u0019\u0017\r^1msN$(B\u0001\u0017.\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO\u000e\u00011C\u0002\u00016sq\u001a\u0015\n\u0005\u00027o5\tq%\u0003\u00029O\t\tB+\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005YR\u0014BA\u001e(\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003{\u0001s!A\u000e \n\u0005}:\u0013a\u00029bG.\fw-Z\u0005\u0003\u0003\n\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002@OA\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n9\u0001K]8ek\u000e$\bC\u0001&R\u001d\tY\u0005K\u0004\u0002M\u001f6\tQJ\u0003\u0002Og\u00051AH]8pizJ\u0011AR\u0005\u0003\u007f\u0015K!AU*\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005}*\u0015\u0001\u0002;fqR,\u0012A\u0016\t\u0003m]K!\u0001W\u0014\u0003\u0015\u0015C\bO]3tg&|g.A\u0003uKb$\b%A\u0005qC&\u0014H)\u001a7j[\u0006Q\u0001/Y5s\t\u0016d\u0017.\u001c\u0011\u0002\u001b-,\u0017PV1mk\u0016$U\r\\5n\u00039YW-\u001f,bYV,G)\u001a7j[\u0002\na\u0001P5oSRtD\u0003\u00021bE\u000e\u0004\"A\u000e\u0001\t\u000bQ;\u0001\u0019\u0001,\t\u000bi;\u0001\u0019\u0001,\t\u000bq;\u0001\u0019\u0001,\u0015\u0007\u0001,w\rC\u0003g\u0011\u0001\u0007a+A\u0003dQ&dG\rC\u0003[\u0011\u0001\u0007a\u000b\u0006\u0002aS\")a-\u0003a\u0001-\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005y\u0007c\u0001&qe&\u0011\u0011o\u0015\u0002\u0004'\u0016\f\bCA:w\u001b\u0005!(BA;,\u0003\u0015!\u0018\u0010]3t\u0013\t9HO\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001{!\t\u001980\u0003\u0002}i\nAA)\u0019;b)f\u0004X-\u0001\u0006nCB\u0014U/\u001b7eKJ,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0015\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\t\u0019A\u0001\u000bBeJ\f\u0017PQ1tK\u0012l\u0015\r\u001d\"vS2$WM]\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\t\u0003\u001f\t)\"!\u0007\u0002\u001eA\u0019A)!\u0005\n\u0007\u0005MQIA\u0002B]fDq!a\u0006\u0011\u0001\u0004\ty!A\u0006j]B,Ho\u0015;sS:<\u0007bBA\u000e!\u0001\u0007\u0011qB\u0001\u0010gR\u0014\u0018N\\4EK2LW.\u001b;fe\"9\u0011q\u0004\tA\u0002\u0005=\u0011!E6fsZ\u000bG.^3EK2LW.\u001b;fe\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003K\t\t$a\u000f\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b(\u0003\u001d\u0019w\u000eZ3hK:LA!a\f\u0002*\tAQ\t\u001f9s\u0007>$W\rC\u0004\u00024E\u0001\r!!\u000e\u0002\u0007\r$\b\u0010\u0005\u0003\u0002(\u0005]\u0012\u0002BA\u001d\u0003S\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002>E\u0001\r!!\n\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u00111\t\t\u0005\u0003\u000b\niE\u0004\u0003\u0002H\u0005%\u0003C\u0001'F\u0013\r\tY%R\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0013\u0011\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-S)A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR9a+a\u0016\u0002\\\u0005}\u0003BBA-'\u0001\u0007a+\u0001\u0005oK^4\u0015N]:u\u0011\u0019\tif\u0005a\u0001-\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0007\u0003C\u001a\u0002\u0019\u0001,\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsR9\u0001-a\u001a\u0002j\u0005-\u0004b\u0002+\u0015!\u0003\u0005\rA\u0016\u0005\b5R\u0001\n\u00111\u0001W\u0011\u001daF\u0003%AA\u0002Y\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002r)\u001aa+a\u001d,\u0005\u0005U\u0004\u0003BA<\u0003\u0003k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a F\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0007\u000bIHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\t\u0005\u0003\u0002\u0010\u0006eUBAAI\u0015\u0011\t\u0019*!&\u0002\t1\fgn\u001a\u0006\u0003\u0003/\u000bAA[1wC&!\u0011qJAI\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\nE\u0002E\u0003CK1!a)F\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty!!+\t\u0013\u0005-&$!AA\u0002\u0005}\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00022B1\u00111WA]\u0003\u001fi!!!.\u000b\u0007\u0005]V)\u0001\u0006d_2dWm\u0019;j_:LA!a/\u00026\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t-a2\u0011\u0007\u0011\u000b\u0019-C\u0002\u0002F\u0016\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002,r\t\t\u00111\u0001\u0002\u0010\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ti)!4\t\u0013\u0005-V$!AA\u0002\u0005}\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002B\u0006M\u0007\"CAV=\u0005\u0005\t\u0019AA\bQM\u0001\u0011q[Ao\u0003?\f\u0019/!:\u0002j\u0006-\u0018q^Ay!\r1\u0014\u0011\\\u0005\u0004\u00037<#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003C\f!qC0G+:\u001bu\f\u000b;fqR\\F\u0006\t9bSJ$U\r\\5n72\u00023.Z=WC2,X\rR3mS6lV,\u000b\u0011.A\r\u0013X-\u0019;fg\u0002\n\u0007%\\1qA\u00054G/\u001a:!gBd\u0017\u000e\u001e;j]\u001e\u0004C\u000f[3!i\u0016DH\u000fI5oi>\u00043.Z=0m\u0006dW/\u001a\u0011qC&\u00148\u000fI;tS:<\u0007\u0005Z3mS6LG/\u001a:t]\u0001\"UMZ1vYR\u0004C-\u001a7j[&$XM]:!CJ,\u0007e\n\u0017(A\u0019|'\u000f\t1qC&\u0014H)\u001a7j[\u0002\u0004\u0013M\u001c3!Oi:\u0003EZ8sA\u0001\\W-\u001f,bYV,G)\u001a7j[\u0002t\u0003EQ8uQ\u0002\u0002\u0007/Y5s\t\u0016d\u0017.\u001c1!C:$\u0007\u0005Y6fsZ\u000bG.^3EK2LW\u000e\u0019\u0011be\u0016\u0004CO]3bi\u0016$\u0007%Y:!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gn\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a:\u0002\u0003CQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ1;c1\u0012'H\r\u0017duM:C\u0006I\u0014-O1\u0002sEO\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;EE\u0012CF\t2#u\t\u0012$\u0005\f\u0012dEi\u00123GI?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\nw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\n'E\u000f8vY2l(\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u00055\u0018!\u0002\u001a/a9\n\u0014!B4s_V\u0004\u0018EAAz\u0003%i\u0017\r]0gk:\u001c7/A\u0006TiJLgn\u001a+p\u001b\u0006\u0004\bC\u0001\u001c!'\u0015\u0001\u00131 B\u0004!!\tiPa\u0001W-Z\u0003WBAA\u0000\u0015\r\u0011\t!R\u0001\beVtG/[7f\u0013\u0011\u0011)!a@\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0003\n\t=QB\u0001B\u0006\u0015\u0011\u0011i!!&\u0002\u0005%|\u0017b\u0001*\u0003\fQ\u0011\u0011q_\u0001\ti>\u001cFO]5oOR\u0011\u0011QR\u0001\u0006CB\u0004H.\u001f\u000b\bA\nm!Q\u0004B\u0010\u0011\u0015!6\u00051\u0001W\u0011\u0015Q6\u00051\u0001W\u0011\u0015a6\u00051\u0001W\u0003\u001d)h.\u00199qYf$BA!\n\u00032A)AIa\n\u0003,%\u0019!\u0011F#\u0003\r=\u0003H/[8o!\u0019!%Q\u0006,W-&\u0019!qF#\u0003\rQ+\b\u000f\\34\u0011!\u0011\u0019\u0004JA\u0001\u0002\u0004\u0001\u0017a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\b\t\u0005\u0003\u001f\u0013Y$\u0003\u0003\u0003>\u0005E%AB(cU\u0016\u001cG\u000f")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap x$0) {
        return StringToMap$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Expression first() {
        return this.text();
    }

    @Override
    public Expression second() {
        return this.pairDelim();
    }

    @Override
    public Expression third() {
        return this.keyValueDelim();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(StringType$.MODULE$, StringType$.MODULE$);
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(StringType$.MODULE$, StringType$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return !this.bitmap$0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = keyValues[i].split(keyValueDelimiterUTF8String, 2);
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(text, pd, kvd) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(230).append("\n         |UTF8String[] ").append(keyValues).append(" = ").append((String)text).append(".split(").append((String)pd).append(", -1);\n         |for(UTF8String kvEntry: ").append(keyValues).append(") {\n         |  UTF8String[] kv = kvEntry.split(").append((String)kvd).append(", 2);\n         |  ").append(builderTerm).append(".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |").append(ev.value()).append(" = ").append(builderTerm).append(".build();\n         |").toString())));
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.text();
                break;
            }
            case 1: {
                object = this.pairDelim();
                break;
            }
            case 2: {
                object = this.keyValueDelim();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "text";
                break;
            }
            case 1: {
                string = "pairDelim";
                break;
            }
            case 2: {
                string = "keyValueDelim";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

