/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskKilledException;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.CodegenMetrics$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEquals;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.ByteCodeStats;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.EmptyBlock$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.SubExprEliminationState;
import org.apache.spark.sql.catalyst.expressions.codegen.VariableValue;
import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalBinaryType$;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType$;
import org.apache.spark.sql.catalyst.types.PhysicalByteType$;
import org.apache.spark.sql.catalyst.types.PhysicalCalendarIntervalType$;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType;
import org.apache.spark.sql.catalyst.types.PhysicalDoubleType$;
import org.apache.spark.sql.catalyst.types.PhysicalFloatType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalNullType$;
import org.apache.spark.sql.catalyst.types.PhysicalShortType$;
import org.apache.spark.sql.catalyst.types.PhysicalStringType$;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.UnsafeRowUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.ParentClassLoader;
import org.apache.spark.util.Utils$;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.InternalCompilerException;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;
import org.sparkproject.guava.util.concurrent.ExecutionError;
import org.sparkproject.guava.util.concurrent.UncheckedExecutionException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class CodeGenerator$
implements Logging {
    public static final CodeGenerator$ MODULE$ = new CodeGenerator$();
    private static final LongAccumulator org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime;
    private static final LoadingCache<CodeAndComment, Tuple2<GeneratedClass, ByteCodeStats>> cache;
    private static final Seq<String> primitiveTypes;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime = new LongAccumulator();
        cache = CacheBuilder.newBuilder().maximumSize((long)SQLConf$.MODULE$.get().codegenCacheMaxEntries()).build((CacheLoader)new CacheLoader<CodeAndComment, Tuple2<GeneratedClass, ByteCodeStats>>(){

            public Tuple2<GeneratedClass, ByteCodeStats> load(CodeAndComment code) {
                long startTime = System.nanoTime();
                Tuple2<GeneratedClass, ByteCodeStats> result = CodeGenerator$.MODULE$.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$doCompile(code);
                long endTime = System.nanoTime();
                long duration = endTime - startTime;
                double timeMs = (double)duration / (double)1000000L;
                CodegenMetrics$.MODULE$.METRIC_SOURCE_CODE_SIZE().update(code.body().length());
                CodegenMetrics$.MODULE$.METRIC_COMPILATION_TIME().update((long)timeMs);
                CodeGenerator$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Code generated in ").append(timeMs).append(" ms").toString());
                CodeGenerator$.MODULE$.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime().add(duration);
                return result;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$load$1(double )}, serializedLambda);
            }
        });
        primitiveTypes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"boolean", "byte", "short", "int", "long", "float", "double"}));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public final int DEFAULT_JVM_HUGE_METHOD_LIMIT() {
        return 8000;
    }

    public final int MAX_JVM_METHOD_PARAMS_LENGTH() {
        return 255;
    }

    public final int MAX_JVM_CONSTANT_POOL_SIZE() {
        return 65535;
    }

    public final int MERGE_SPLIT_METHODS_THRESHOLD() {
        return 3;
    }

    public final int GENERATED_CLASS_SIZE_THRESHOLD() {
        return 1000000;
    }

    public final int OUTER_CLASS_VARIABLES_THRESHOLD() {
        return 10000;
    }

    public final int MUTABLESTATEARRAY_SIZE_LIMIT() {
        return 32768;
    }

    public LongAccumulator org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime() {
        return org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime;
    }

    public long compileTime() {
        return this.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime().sum();
    }

    public void resetCompileTime() {
        this.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime().reset();
    }

    public Tuple2<GeneratedClass, ByteCodeStats> compile(CodeAndComment code) {
        Tuple2 tuple2;
        try {
            tuple2 = (Tuple2)this.cache().get((Object)code);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof UncheckedExecutionException ? true : throwable2 instanceof ExecutionError;
            if (bl) {
                throw throwable2.getCause();
            }
            throw throwable;
        }
        return tuple2;
    }

    public Tuple2<GeneratedClass, ByteCodeStats> org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$doCompile(CodeAndComment code) {
        ByteCodeStats byteCodeStats;
        ClassBodyEvaluator evaluator = new ClassBodyEvaluator();
        ParentClassLoader parentClassLoader = new ParentClassLoader(Utils$.MODULE$.getContextOrSparkClassLoader());
        evaluator.setParentClassLoader((ClassLoader)parentClassLoader);
        evaluator.setClassName("org.apache.spark.sql.catalyst.expressions.GeneratedClass");
        evaluator.setDefaultImports(new String[]{Platform.class.getName(), InternalRow.class.getName(), UnsafeRow.class.getName(), UTF8String.class.getName(), Decimal.class.getName(), CalendarInterval.class.getName(), ArrayData.class.getName(), UnsafeArrayData.class.getName(), MapData.class.getName(), UnsafeMapData.class.getName(), Expression.class.getName(), TaskContext.class.getName(), TaskKilledException.class.getName(), InputMetrics.class.getName(), StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(QueryExecutionErrors$.MODULE$.getClass().getName()), "$")});
        evaluator.setExtendedClass(GeneratedClass.class);
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> {
            evaluator.setDebuggingInformation(true, true, false);
            return new StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, CodeFormatter$.MODULE$.format$default$2())).toString();
        });
        try {
            evaluator.cook("generated.java", code.body());
            byteCodeStats = this.updateAndGetCompilationStats(evaluator);
        }
        catch (InternalCompilerException e) {
            String msg = QueryExecutionErrors$.MODULE$.failedToCompileMsg((Exception)((Object)e));
            this.logError((Function0<String>)(Function0 & Serializable)() -> msg, e);
            this.logGeneratedCode(code);
            throw QueryExecutionErrors$.MODULE$.internalCompilerError(e);
        }
        catch (CompileException e) {
            String msg = QueryExecutionErrors$.MODULE$.failedToCompileMsg((Exception)((Object)e));
            this.logError((Function0<String>)(Function0 & Serializable)() -> msg, e);
            this.logGeneratedCode(code);
            throw QueryExecutionErrors$.MODULE$.compilerError(e);
        }
        ByteCodeStats codeStats = byteCodeStats;
        return new Tuple2((Object)((GeneratedClass)evaluator.getClazz().getConstructor(new Class[0]).newInstance(new Object[0])), (Object)codeStats);
    }

    private void logGeneratedCode(CodeAndComment code) {
        int maxLines = SQLConf$.MODULE$.get().loggingMaxLinesForCodegen();
        if (Utils$.MODULE$.isTesting()) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, maxLines)).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, maxLines)).toString());
        }
    }

    private ByteCodeStats updateAndGetCompilationStats(ClassBodyEvaluator evaluator) {
        Map classes = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(evaluator.getBytecodes()).asScala();
        Class codeAttr = Utils$.MODULE$.classForName("org.codehaus.janino.util.ClassFile$CodeAttribute", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        Field codeAttrField = codeAttr.getDeclaredField("code");
        codeAttrField.setAccessible(true);
        Map codeStats = (Map)classes.map((Function1 & Serializable)x0$1 -> {
            Tuple2.mcII.sp sp2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                byte[] classBytes = (byte[])tuple2._2();
                int classCodeSize = classBytes.length;
                CodegenMetrics$.MODULE$.METRIC_GENERATED_CLASS_BYTECODE_SIZE().update(classCodeSize);
                try {
                    ClassFile cf = new ClassFile((InputStream)new ByteArrayInputStream(classBytes));
                    int constPoolSize = cf.getConstantPoolSize();
                    Buffer methodCodeSizes = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(cf.methodInfos).asScala()).flatMap((Function1 & Serializable)method -> Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])method.getAttributes()), (Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)CodeGenerator$.$anonfun$updateAndGetCompilationStats$3(codeAttr, x$23)))), (Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)CodeGenerator$.$anonfun$updateAndGetCompilationStats$4(codeAttrField, cf, method, a)), (ClassTag)ClassTag$.MODULE$.Int())));
                    sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)methodCodeSizes.max((Ordering)Ordering.Int$.MODULE$)), constPoolSize);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error calculating stats of compiled class.", e);
                    Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(-1, -1);
                    sp2 = sp3;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple2.mcII.sp sp4 = sp2;
            return sp4;
        });
        Tuple2 tuple2 = codeStats.unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable maxMethodSizes = (Iterable)tuple2._1();
        Iterable constPoolSize = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)maxMethodSizes, (Object)constPoolSize);
        Tuple2 tuple23 = tuple22;
        Iterable maxMethodSizes2 = (Iterable)tuple23._1();
        Iterable constPoolSize2 = (Iterable)tuple23._2();
        return new ByteCodeStats(BoxesRunTime.unboxToInt((Object)maxMethodSizes2.max((Ordering)Ordering.Int$.MODULE$)), BoxesRunTime.unboxToInt((Object)constPoolSize2.max((Ordering)Ordering.Int$.MODULE$)), classes.size() - 2);
    }

    private LoadingCache<CodeAndComment, Tuple2<GeneratedClass, ByteCodeStats>> cache() {
        return cache;
    }

    public final String JAVA_BOOLEAN() {
        return "boolean";
    }

    public final String JAVA_BYTE() {
        return "byte";
    }

    public final String JAVA_SHORT() {
        return "short";
    }

    public final String JAVA_INT() {
        return "int";
    }

    public final String JAVA_LONG() {
        return "long";
    }

    public final String JAVA_FLOAT() {
        return "float";
    }

    public final String JAVA_DOUBLE() {
        return "double";
    }

    public Seq<String> primitiveTypes() {
        return primitiveTypes;
    }

    public boolean isPrimitiveType(String jt) {
        return this.primitiveTypes().contains((Object)jt);
    }

    public boolean isPrimitiveType(DataType dt) {
        return this.isPrimitiveType(this.javaType(dt));
    }

    public String getValue(String input, DataType dataType, String ordinal) {
        String string;
        String jt;
        while (true) {
            jt = this.javaType(dataType);
            DataType dataType2 = dataType;
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        if (this.isPrimitiveType(jt)) {
            string = new StringBuilder(6).append(input).append(".get").append(this.primitiveTypeName(jt)).append("(").append(ordinal).append(")").toString();
        } else {
            String string2;
            PhysicalDataType physicalDataType = dataType.physicalDataType();
            if (physicalDataType instanceof PhysicalArrayType) {
                string2 = new StringBuilder(11).append(input).append(".getArray(").append(ordinal).append(")").toString();
            } else if (PhysicalBinaryType$.MODULE$.equals(physicalDataType)) {
                string2 = new StringBuilder(12).append(input).append(".getBinary(").append(ordinal).append(")").toString();
            } else if (PhysicalCalendarIntervalType$.MODULE$.equals(physicalDataType)) {
                string2 = new StringBuilder(14).append(input).append(".getInterval(").append(ordinal).append(")").toString();
            } else if (physicalDataType instanceof PhysicalDecimalType) {
                PhysicalDecimalType physicalDecimalType = (PhysicalDecimalType)physicalDataType;
                string2 = new StringBuilder(17).append(input).append(".getDecimal(").append(ordinal).append(", ").append(physicalDecimalType.precision()).append(", ").append(physicalDecimalType.scale()).append(")").toString();
            } else if (physicalDataType instanceof PhysicalMapType) {
                string2 = new StringBuilder(9).append(input).append(".getMap(").append(ordinal).append(")").toString();
            } else if (PhysicalNullType$.MODULE$.equals(physicalDataType)) {
                string2 = "null";
            } else if (PhysicalStringType$.MODULE$.equals(physicalDataType)) {
                string2 = new StringBuilder(16).append(input).append(".getUTF8String(").append(ordinal).append(")").toString();
            } else if (physicalDataType instanceof PhysicalStructType) {
                PhysicalStructType physicalStructType = (PhysicalStructType)physicalDataType;
                string2 = new StringBuilder(14).append(input).append(".getStruct(").append(ordinal).append(", ").append(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])physicalStructType.fields()))).append(")").toString();
            } else {
                string2 = new StringBuilder(14).append("(").append(jt).append(")").append(input).append(".get(").append(ordinal).append(", null)").toString();
            }
            string = string2;
        }
        return string;
    }

    public String createArrayData(String arrayName, DataType elementType, String numElements, String additionalErrorMessage) {
        int elementSize = this.isPrimitiveType(elementType) ? elementType.defaultSize() : -1;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(75).append("\n       |ArrayData ").append(arrayName).append(" = ArrayData.allocateArrayData(\n       |  ").append(elementSize).append(", ").append(numElements).append(", \"").append(additionalErrorMessage).append("\");\n     ").toString()));
    }

    public String createArrayAssignment(String dstArray, DataType elementType, String srcArray, String dstArrayIndex, String srcArrayIndex, boolean needNullCheck) {
        return this.setArrayElement(dstArray, elementType, dstArrayIndex, this.getValue(srcArray, elementType, srcArrayIndex), (Option<String>)(needNullCheck ? new Some((Object)new StringBuilder(11).append(srcArray).append(".isNullAt(").append(srcArrayIndex).append(")").toString()) : None$.MODULE$));
    }

    public String setColumn(String row, DataType dataType, int ordinal, String value) {
        String string;
        block4: {
            DataType dataType2;
            while (true) {
                String jt = this.javaType(dataType);
                dataType2 = dataType;
                if (this.isPrimitiveType(jt)) {
                    string = new StringBuilder(8).append(row).append(".set").append(this.primitiveTypeName(jt)).append("(").append(ordinal).append(", ").append(value).append(")").toString();
                    break block4;
                }
                if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
                    string = new StringBuilder(16).append(row).append(".setInterval(").append(ordinal).append(", ").append(value).append(")").toString();
                    break block4;
                }
                if (dataType2 instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType2;
                    string = new StringBuilder(17).append(row).append(".setDecimal(").append(ordinal).append(", ").append(value).append(", ").append(decimalType.precision()).append(")").toString();
                    break block4;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
            }
            boolean bl = StringType$.MODULE$.equals(dataType2) ? true : (dataType2 instanceof StructType ? true : (dataType2 instanceof ArrayType ? true : dataType2 instanceof MapType));
            string = bl ? new StringBuilder(18).append(row).append(".update(").append(ordinal).append(", ").append(value).append(".copy())").toString() : new StringBuilder(11).append(row).append(".update(").append(ordinal).append(", ").append(value).append(")").toString();
        }
        return string;
    }

    public String updateColumn(String row, DataType dataType, int ordinal, ExprCode ev, boolean nullable, boolean isVectorized) {
        return nullable ? (!isVectorized && UnsafeRowUtils$.MODULE$.avoidSetNullAt(dataType) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(98).append("\n           |if (!").append(ev.isNull()).append(") {\n           |  ").append(this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";\n           |} else {\n           |  ").append(this.setColumn(row, dataType, ordinal, "null")).append(";\n           |}\n         ").toString())) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n           |if (!").append(ev.isNull()).append(") {\n           |  ").append(this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";\n           |} else {\n           |  ").append(row).append(".setNullAt(").append(ordinal).append(");\n           |}\n         ").toString()))) : new StringBuilder(1).append(this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";").toString();
    }

    public String setValue(String vector, String rowId, DataType dataType, String value) {
        String string;
        String jt = this.javaType(dataType);
        DataType dataType2 = dataType;
        if (this.isPrimitiveType(jt)) {
            string = new StringBuilder(9).append(vector).append(".put").append(this.primitiveTypeName(jt)).append("(").append(rowId).append(", ").append(value).append(");").toString();
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            string = new StringBuilder(18).append(vector).append(".putDecimal(").append(rowId).append(", ").append(value).append(", ").append(decimalType.precision()).append(");").toString();
        } else if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            string = new StringBuilder(17).append(vector).append(".putInterval(").append(rowId).append(", ").append(value).append(");").toString();
        } else if (dataType2 instanceof StringType) {
            string = new StringBuilder(29).append(vector).append(".putByteArray(").append(rowId).append(", ").append(value).append(".getBytes());").toString();
        } else {
            throw new IllegalArgumentException(new StringBuilder(43).append("cannot generate code for unsupported type: ").append(dataType).toString());
        }
        return string;
    }

    public String setArrayElement(String array, DataType elementType, String i, String value, Option<String> isNull) {
        boolean isPrimitiveType = this.isPrimitiveType(elementType);
        String setFunc = isPrimitiveType ? new StringBuilder(3).append("set").append(this.primitiveTypeName(elementType)).toString() : "update";
        return isNull.isDefined() && isPrimitiveType ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         |if (").append(isNull.get()).append(") {\n         |  ").append(array).append(".setNullAt(").append(i).append(");\n         |} else {\n         |  ").append(array).append(".").append(setFunc).append("(").append(i).append(", ").append(value).append(");\n         |}\n       ").toString())) : new StringBuilder(6).append(array).append(".").append(setFunc).append("(").append(i).append(", ").append(value).append(");").toString();
    }

    public Option<String> setArrayElement$default$5() {
        return None$.MODULE$;
    }

    public String updateColumn(String vector, String rowId, DataType dataType, ExprCode ev, boolean nullable) {
        return nullable ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n         |if (!").append(ev.isNull()).append(") {\n         |  ").append(this.setValue(vector, rowId, dataType, ExprValue$.MODULE$.exprValueToString(ev.value()))).append("\n         |} else {\n         |  ").append(vector).append(".putNull(").append(rowId).append(");\n         |}\n       ").toString())) : new StringBuilder(1).append(this.setValue(vector, rowId, dataType, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";").toString();
    }

    public boolean updateColumn$default$6() {
        return false;
    }

    public String getValueFromVector(String vector, DataType dataType, String rowId) {
        DataType dataType2;
        DataType dataType3 = dataType;
        if (dataType3 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            dataType2 = userDefinedType.sqlType();
        } else {
            dataType2 = dataType;
        }
        DataType sqlDataType = dataType2;
        return sqlDataType instanceof StructType ? new StringBuilder(12).append(vector).append(".getStruct(").append(rowId).append(")").toString() : this.getValue(vector, sqlDataType, rowId);
    }

    public Tuple2<scala.collection.immutable.Set<VariableValue>, scala.collection.immutable.Set<ExprCode>> getLocalInputVariableValues(CodegenContext ctx, Expression expr, scala.collection.immutable.Map<ExpressionEquals, SubExprEliminationState> subExprs) {
        Set argSet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set exprCodesNeedEvaluate = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = ctx.INPUT_ROW() != null ? argSet.$plus$eq((Object)JavaCode$.MODULE$.variable(ctx.INPUT_ROW(), InternalRow.class)) : BoxedUnit.UNIT;
        Function1 & Serializable collectLocalVariable = (Function1 & Serializable)ev -> {
            BoxedUnit boxedUnit;
            ExprValue exprValue = ev;
            if (exprValue instanceof VariableValue) {
                VariableValue variableValue = (VariableValue)exprValue;
                boxedUnit = argSet.$plus$eq((Object)variableValue);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        };
        Stack stack = (Stack)Stack$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{expr}));
        while (stack.nonEmpty()) {
            Object object2;
            Option option;
            Object object3;
            Expression expression = (Expression)stack.pop();
            if (expression instanceof BoundReference) {
                BoundReference boundReference = (BoundReference)expression;
                if (ctx.currentVars() != null && ctx.currentVars().apply(boundReference.ordinal()) != null) {
                    ExprCode exprCode = (ExprCode)ctx.currentVars().apply(boundReference.ordinal());
                    Block block = exprCode.code();
                    EmptyBlock$ emptyBlock$ = EmptyBlock$.MODULE$;
                    if (block == null ? emptyBlock$ != null : !block.equals(emptyBlock$)) {
                        exprCodesNeedEvaluate.$plus$eq((Object)exprCode.copy(exprCode.copy$default$1(), exprCode.copy$default$2(), exprCode.copy$default$3()));
                        exprCode.code_$eq(EmptyBlock$.MODULE$);
                    }
                    collectLocalVariable.apply((Object)exprCode.value());
                    object3 = collectLocalVariable.apply((Object)exprCode.isNull());
                    continue;
                }
            }
            if ((option = subExprs.get((Object)new ExpressionEquals(expression))) instanceof Some) {
                Some some = (Some)option;
                SubExprEliminationState state = (SubExprEliminationState)some.value();
                collectLocalVariable.apply((Object)state.eval().value());
                object2 = collectLocalVariable.apply((Object)state.eval().isNull());
            } else if (None$.MODULE$.equals(option)) {
                object2 = stack.pushAll(expression.children());
            } else {
                throw new MatchError((Object)option);
            }
            object3 = object2;
        }
        return new Tuple2((Object)argSet.toSet(), (Object)exprCodesNeedEvaluate.toSet());
    }

    public scala.collection.immutable.Map<ExpressionEquals, SubExprEliminationState> getLocalInputVariableValues$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public String primitiveTypeName(String jt) {
        String string;
        block3: {
            String string2 = jt;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case 104431: {
                    if (!"int".equals(string2)) break;
                    string = "Int";
                    break block3;
                }
            }
            string = this.boxedType(jt);
        }
        return string;
    }

    public String primitiveTypeName(DataType dt) {
        return this.primitiveTypeName(this.javaType(dt));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String javaType(DataType dt) {
        DataType dataType;
        ObjectType objectType;
        boolean bl;
        while (true) {
            bl = false;
            objectType = null;
            dataType = dt;
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof ObjectType) {
            bl = true;
            objectType = (ObjectType)dataType;
            Class<?> cls = objectType.cls();
            if (cls.isArray()) {
                return new StringBuilder(2).append(this.javaType(new ObjectType(cls.getComponentType()))).append("[]").toString();
            }
        }
        if (bl) {
            Class<?> cls = objectType.cls();
            return cls.getName();
        }
        PhysicalDataType physicalDataType = dt.physicalDataType();
        if (physicalDataType instanceof PhysicalArrayType) {
            return "ArrayData";
        }
        if (PhysicalBinaryType$.MODULE$.equals(physicalDataType)) {
            return "byte[]";
        }
        if (PhysicalBooleanType$.MODULE$.equals(physicalDataType)) {
            return "boolean";
        }
        if (PhysicalByteType$.MODULE$.equals(physicalDataType)) {
            return "byte";
        }
        if (PhysicalCalendarIntervalType$.MODULE$.equals(physicalDataType)) {
            return "CalendarInterval";
        }
        if (PhysicalIntegerType$.MODULE$.equals(physicalDataType)) {
            return "int";
        }
        if (physicalDataType instanceof PhysicalDecimalType) {
            return "Decimal";
        }
        if (PhysicalDoubleType$.MODULE$.equals(physicalDataType)) {
            return "double";
        }
        if (PhysicalFloatType$.MODULE$.equals(physicalDataType)) {
            return "float";
        }
        if (PhysicalLongType$.MODULE$.equals(physicalDataType)) {
            return "long";
        }
        if (physicalDataType instanceof PhysicalMapType) {
            return "MapData";
        }
        if (PhysicalShortType$.MODULE$.equals(physicalDataType)) {
            return "short";
        }
        if (PhysicalStringType$.MODULE$.equals(physicalDataType)) {
            return "UTF8String";
        }
        if (!(physicalDataType instanceof PhysicalStructType)) return "Object";
        return "InternalRow";
    }

    public Class<?> javaClass(DataType dt) {
        Class<Object> clazz;
        block17: {
            DataType dataType;
            while (true) {
                if (BooleanType$.MODULE$.equals(dataType = dt)) {
                    clazz = Boolean.TYPE;
                    break block17;
                }
                if (ByteType$.MODULE$.equals(dataType)) {
                    clazz = Byte.TYPE;
                    break block17;
                }
                if (ShortType$.MODULE$.equals(dataType)) {
                    clazz = Short.TYPE;
                    break block17;
                }
                boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType);
                if (bl) {
                    clazz = Integer.TYPE;
                    break block17;
                }
                boolean bl2 = LongType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType));
                if (bl2) {
                    clazz = Long.TYPE;
                    break block17;
                }
                if (FloatType$.MODULE$.equals(dataType)) {
                    clazz = Float.TYPE;
                    break block17;
                }
                if (DoubleType$.MODULE$.equals(dataType)) {
                    clazz = Double.TYPE;
                    break block17;
                }
                if (dataType instanceof DecimalType) {
                    clazz = Decimal.class;
                    break block17;
                }
                if (BinaryType$.MODULE$.equals(dataType)) {
                    clazz = byte[].class;
                    break block17;
                }
                if (StringType$.MODULE$.equals(dataType)) {
                    clazz = UTF8String.class;
                    break block17;
                }
                if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                    clazz = CalendarInterval.class;
                    break block17;
                }
                if (dataType instanceof StructType) {
                    clazz = InternalRow.class;
                    break block17;
                }
                if (dataType instanceof ArrayType) {
                    clazz = ArrayData.class;
                    break block17;
                }
                if (dataType instanceof MapType) {
                    clazz = MapData.class;
                    break block17;
                }
                if (!(dataType instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                dt = userDefinedType.sqlType();
            }
            if (dataType instanceof ObjectType) {
                ObjectType objectType = (ObjectType)dataType;
                Class<?> cls = objectType.cls();
                clazz = cls;
            } else {
                clazz = Object.class;
            }
        }
        return clazz;
    }

    public String boxedType(String jt) {
        String string;
        block9: {
            String string2 = jt;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -1325958191: {
                    if (!"double".equals(string2)) break;
                    string = "Double";
                    break block9;
                }
                case 104431: {
                    if (!"int".equals(string2)) break;
                    string = "Integer";
                    break block9;
                }
                case 3039496: {
                    if (!"byte".equals(string2)) break;
                    string = "Byte";
                    break block9;
                }
                case 3327612: {
                    if (!"long".equals(string2)) break;
                    string = "Long";
                    break block9;
                }
                case 64711720: {
                    if (!"boolean".equals(string2)) break;
                    string = "Boolean";
                    break block9;
                }
                case 97526364: {
                    if (!"float".equals(string2)) break;
                    string = "Float";
                    break block9;
                }
                case 109413500: {
                    if (!"short".equals(string2)) break;
                    string = "Short";
                    break block9;
                }
            }
            string = string2;
        }
        return string;
    }

    public String boxedType(DataType dt) {
        return this.boxedType(this.javaType(dt));
    }

    public String typeName(Class<?> clazz) {
        return clazz.isArray() ? new StringBuilder(2).append(this.typeName(clazz.getComponentType())).append("[]").toString() : clazz.getName();
    }

    public String defaultValue(String jt, boolean typedNull) {
        String string;
        block9: {
            String string2 = jt;
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -1325958191: {
                    if (!"double".equals(string2)) break;
                    string = "-1.0";
                    break block9;
                }
                case 104431: {
                    if (!"int".equals(string2)) break;
                    string = "-1";
                    break block9;
                }
                case 3039496: {
                    if (!"byte".equals(string2)) break;
                    string = "(byte)-1";
                    break block9;
                }
                case 3327612: {
                    if (!"long".equals(string2)) break;
                    string = "-1L";
                    break block9;
                }
                case 64711720: {
                    if (!"boolean".equals(string2)) break;
                    string = "false";
                    break block9;
                }
                case 97526364: {
                    if (!"float".equals(string2)) break;
                    string = "-1.0f";
                    break block9;
                }
                case 109413500: {
                    if (!"short".equals(string2)) break;
                    string = "(short)-1";
                    break block9;
                }
            }
            string = typedNull ? new StringBuilder(8).append("((").append(jt).append(")null)").toString() : "null";
        }
        return string;
    }

    public String defaultValue(DataType dt, boolean typedNull) {
        return this.defaultValue(this.javaType(dt), typedNull);
    }

    public boolean defaultValue$default$2() {
        return false;
    }

    public int calculateParamLength(Seq<Expression> params) {
        return 1 + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)params.map((Function1 & Serializable)input -> BoxesRunTime.boxToInteger((int)this.paramLengthForExpr$1(input)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public int calculateParamLengthFromExprValues(Seq<ExprValue> params) {
        return 1 + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)params.map((Function1 & Serializable)input -> BoxesRunTime.boxToInteger((int)CodeGenerator$.paramLengthForExpr$2(input)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public boolean isValidParamLength(int paramLength) {
        boolean bl;
        block5: {
            String string;
            block4: {
                string = SQLConf$.MODULE$.get().getConfString("spark.sql.CodeGenerator.validParamLength", null);
                switch (string == null ? 0 : string.hashCode()) {
                    case 0: {
                        if (string == null || "".equals(string)) {
                            break;
                        }
                        break block4;
                    }
                    default: {
                        break block4;
                    }
                }
                bl = paramLength <= 255;
                break block5;
            }
            bl = paramLength <= StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string));
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$updateAndGetCompilationStats$3(Class codeAttr$1, ClassFile.AttributeInfo x$23) {
        return x$23.getClass() == codeAttr$1;
    }

    public static final /* synthetic */ int $anonfun$updateAndGetCompilationStats$4(Field codeAttrField$1, ClassFile cf$1, ClassFile.MethodInfo method$1, ClassFile.AttributeInfo a) {
        int byteCodeSize;
        block0: {
            byteCodeSize = ((byte[])codeAttrField$1.get(a)).length;
            CodegenMetrics$.MODULE$.METRIC_GENERATED_METHOD_BYTECODE_SIZE().update(byteCodeSize);
            if (byteCodeSize <= 8000) break block0;
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Generated method too long to be JIT compiled: ").append(new StringBuilder(11).append(cf$1.getThisClassName()).append(".").append(method$1.getName()).append(" is ").append(byteCodeSize).append(" bytes").toString()).toString());
        }
        return byteCodeSize;
    }

    private final int paramLengthForExpr$1(Expression input) {
        int n;
        block7: {
            block6: {
                String string = this.javaType(input.dataType());
                switch (string == null ? 0 : string.hashCode()) {
                    case -1325958191: {
                        if ("double".equals(string)) {
                            break;
                        }
                        break block6;
                    }
                    case 3327612: {
                        if ("long".equals(string)) {
                            break;
                        }
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
                n = 2;
                break block7;
            }
            n = 1;
        }
        int javaParamLength = n;
        return (input.nullable() ? 1 : 0) + javaParamLength;
    }

    private static final int paramLengthForExpr$2(ExprValue input) {
        boolean bl;
        Class<?> clazz = input.javaType();
        Class<Long> clazz2 = Long.TYPE;
        Class<?> clazz3 = clazz;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            bl = true;
        } else {
            Class<Double> clazz4 = Double.TYPE;
            Class<?> clazz5 = clazz;
            bl = !(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null);
        }
        int n = bl ? 2 : 1;
        return n;
    }

    private CodeGenerator$() {
    }
}

