/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Subquery;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class RemoveRedundantAliases$
extends Rule<LogicalPlan> {
    public static final RemoveRedundantAliases$ MODULE$ = new RemoveRedundantAliases$();

    private Seq<Tuple2<Attribute, Attribute>> createAttributeMapping(LogicalPlan current, LogicalPlan next) {
        return (Seq)((IterableOps)current.output().zip(next.output())).filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RemoveRedundantAliases$.$anonfun$createAttributeMapping$1(x0$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression removeRedundantAlias(Expression e, AttributeSet excludeList) {
        Expression expression = e;
        if (!(expression instanceof Alias)) return expression;
        Alias alias = (Alias)expression;
        Expression attr = alias.child();
        String name = alias.name();
        if (!(attr instanceof Attribute)) return expression;
        Attribute attribute = (Attribute)attr;
        Metadata metadata = alias.metadata();
        Metadata metadata2 = Metadata$.MODULE$.empty();
        if (metadata == null ? metadata2 != null : !((Object)metadata).equals(metadata2)) {
            Metadata metadata3 = alias.metadata();
            Metadata metadata4 = attribute.metadata();
            if (metadata3 == null) {
                if (metadata4 != null) {
                    return expression;
                }
            } else if (!((Object)metadata3).equals(metadata4)) return expression;
        }
        String string = name;
        String string2 = attribute.name();
        if (string == null) {
            if (string2 != null) {
                return expression;
            }
        } else if (!string.equals(string2)) return expression;
        if (excludeList.contains(attribute)) return expression;
        if (excludeList.contains(alias)) return expression;
        return attribute;
    }

    private LogicalPlan removeRedundantAliases(LogicalPlan plan2, AttributeSet excluded) {
        LogicalPlan logicalPlan;
        if (!plan2.containsPattern(TreePattern$.MODULE$.ALIAS())) {
            return plan2;
        }
        LogicalPlan logicalPlan2 = plan2;
        if (logicalPlan2 instanceof Subquery) {
            Subquery subquery = (Subquery)logicalPlan2;
            LogicalPlan child2 = subquery.child();
            boolean correlated = subquery.correlated();
            logicalPlan = new Subquery(this.removeRedundantAliases(child2, excluded.$plus$plus(child2.outputSet())), correlated);
        } else if (logicalPlan2 instanceof Join) {
            Join join = (Join)logicalPlan2;
            LogicalPlan left = join.left();
            LogicalPlan right = join.right();
            JoinType joinType = join.joinType();
            Option<Expression> condition = join.condition();
            JoinHint hint = join.hint();
            LogicalPlan newLeft = this.removeRedundantAliases(left, excluded.$plus$plus(right.outputSet()));
            LogicalPlan newRight = this.removeRedundantAliases(right, excluded.$plus$plus(newLeft.outputSet()));
            AttributeMap mapping = AttributeMap$.MODULE$.apply((Seq)this.createAttributeMapping(left, newLeft).$plus$plus(this.createAttributeMapping(right, newRight)));
            Option newCondition = condition.map((Function1 & Serializable)x$11 -> (Expression)x$11.transform(new Serializable(mapping){
                private static final long serialVersionUID = 0L;
                private final AttributeMap mapping$1;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Attribute) {
                        Attribute attribute = (Attribute)A1;
                        object = this.mapping$1.getOrElse(attribute, (Function0 & Serializable)() -> attribute);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    boolean bl = expression instanceof Attribute;
                    return bl;
                }
                {
                    this.mapping$1 = mapping$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
                }
            }));
            logicalPlan = new Join(newLeft, newRight, joinType, (Option<Expression>)newCondition, hint);
        } else if (logicalPlan2 instanceof Union) {
            Union union = (Union)logicalPlan2;
            BooleanRef first = BooleanRef.create((boolean)true);
            logicalPlan = (LogicalPlan)plan2.mapChildren((Function1 & Serializable)child -> {
                LogicalPlan logicalPlan;
                if (first$1.elem) {
                    first$1.elem = false;
                    logicalPlan = MODULE$.removeRedundantAliases((LogicalPlan)child, excluded.$plus$plus(child.outputSet()));
                } else {
                    logicalPlan = MODULE$.removeRedundantAliases((LogicalPlan)child, excluded.$minus$minus(((QueryPlan)union.children().head()).outputSet()));
                }
                return logicalPlan;
            });
        } else {
            Buffer currentNextAttrPairs = (Buffer)Buffer$.MODULE$.empty();
            LogicalPlan newNode = (LogicalPlan)plan2.mapChildren((Function1 & Serializable)child -> {
                void var3_3;
                LogicalPlan newChild = MODULE$.removeRedundantAliases((LogicalPlan)child, excluded);
                currentNextAttrPairs.$plus$plus$eq(MODULE$.createAttributeMapping((LogicalPlan)child, newChild));
                return var3_3;
            });
            AttributeMap mapping = AttributeMap$.MODULE$.apply(currentNextAttrPairs);
            LogicalPlan logicalPlan3 = plan2;
            Function1 & Serializable intersect = logicalPlan3 instanceof Project ? (Function1 & Serializable)x$12 -> MODULE$.removeRedundantAlias((Expression)x$12, excluded) : (logicalPlan3 instanceof Aggregate ? (Function1 & Serializable)x$13 -> MODULE$.removeRedundantAlias((Expression)x$13, excluded) : (logicalPlan3 instanceof Window ? (Function1 & Serializable)x$14 -> MODULE$.removeRedundantAlias((Expression)x$14, excluded) : (Function1 & Serializable)x -> (Expression)Predef$.MODULE$.identity(x)));
            Function1 & Serializable clean = intersect;
            logicalPlan = (LogicalPlan)newNode.mapExpressions((Function1<Expression, Expression>)(Function1 & Serializable)expr -> (Expression)clean.apply(expr.transform(new Serializable(mapping){
                private static final long serialVersionUID = 0L;
                private final AttributeMap mapping$2;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof Attribute) {
                        Attribute attribute = (Attribute)A1;
                        object = this.mapping$2.get(attribute).map((Function1 & Serializable)x$15 -> x$15.withName(attribute.name())).getOrElse((Function0 & Serializable)() -> attribute);
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Expression x2) {
                    Expression expression = x2;
                    boolean bl = expression instanceof Attribute;
                    return bl;
                }
                {
                    this.mapping$2 = mapping$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$7(org.apache.spark.sql.catalyst.expressions.Attribute org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$8(org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
                }
            })));
        }
        return logicalPlan;
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return this.removeRedundantAliases(plan2, AttributeSet$.MODULE$.empty());
    }

    public static final /* synthetic */ boolean $anonfun$createAttributeMapping$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Attribute a1 = (Attribute)tuple2._1();
        Attribute a2 = (Attribute)tuple2._2();
        boolean bl = a1.semanticEquals(a2);
        return bl;
    }

    private RemoveRedundantAliases$() {
    }
}

