/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.KnownNotNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNodeTag;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Project$
implements Serializable {
    public static final Project$ MODULE$ = new Project$();
    private static final TreeNodeTag<Seq<Attribute>> hiddenOutputTag = new TreeNodeTag("hidden_output");

    public TreeNodeTag<Seq<Attribute>> hiddenOutputTag() {
        return hiddenOutputTag;
    }

    public Project matchSchema(LogicalPlan plan2, StructType schema, SQLConf conf) {
        Predef$.MODULE$.assert(plan2.resolved());
        Seq<NamedExpression> projectList = this.reorderFields((Seq<Tuple2<String, Expression>>)((Seq)plan2.output().map((Function1 & Serializable)a -> new Tuple2((Object)a.name(), a))), (Seq<StructField>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)schema.fields()), (Seq<String>)package$.MODULE$.Nil(), conf);
        return new Project(projectList, plan2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression reconcileColumnType(Expression col, Seq<String> columnPath, DataType dt, boolean nullable, SQLConf conf) {
        Expression expression;
        if (col.nullable() && !nullable) {
            throw QueryCompilationErrors$.MODULE$.nullableColumnOrFieldError(columnPath);
        }
        Tuple2 tuple2 = new Tuple2((Object)col.dataType(), (Object)dt);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType expected = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                if (expected instanceof StructType) {
                    StructType structType2 = (StructType)expected;
                    Seq<NamedExpression> newFields = this.reorderFields((Seq<Tuple2<String, Expression>>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])fields))), (Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        StructField f = (StructField)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Tuple2 tuple22 = col.nullable() ? new Tuple2((Object)f.name(), (Object)new GetStructField(new KnownNotNull(col), index, GetStructField$.MODULE$.apply$default$3())) : new Tuple2((Object)f.name(), (Object)new GetStructField(col, index, GetStructField$.MODULE$.apply$default$3()));
                        return tuple22;
                    }, ClassTag$.MODULE$.apply(Tuple2.class))), (Seq<StructField>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)structType2.fields()), columnPath, conf);
                    return col.nullable() ? new If(new IsNull(col), new Literal(null, dt), CreateStruct$.MODULE$.apply(newFields)) : CreateStruct$.MODULE$.apply(newFields);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType expected = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (expected instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)expected;
                    if (containsNull & !arrayType2.containsNull()) {
                        throw QueryCompilationErrors$.MODULE$.notNullConstraintViolationArrayElementError(columnPath);
                    }
                    NamedLambdaVariable param = new NamedLambdaVariable("x", et, containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                    Expression reconciledElement = this.reconcileColumnType(param, (Seq<String>)((Seq)columnPath.$colon$plus((Object)"element")), arrayType2.elementType(), arrayType2.containsNull(), conf);
                    LambdaFunction func = new LambdaFunction(reconciledElement, (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{param}))), LambdaFunction$.MODULE$.apply$default$3());
                    return new ArrayTransform(col, func);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType expected = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                if (expected instanceof MapType) {
                    MapType mapType2 = (MapType)expected;
                    if (valueContainsNull & !mapType2.valueContainsNull()) {
                        throw QueryCompilationErrors$.MODULE$.notNullConstraintViolationMapValueError(columnPath);
                    }
                    NamedLambdaVariable keyParam = new NamedLambdaVariable("key", kt, false, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                    NamedLambdaVariable valueParam = new NamedLambdaVariable("value", vt, valueContainsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                    Expression reconciledKey = this.reconcileColumnType(keyParam, (Seq<String>)((Seq)columnPath.$colon$plus((Object)"key")), mapType2.keyType(), false, conf);
                    Expression reconciledValue = this.reconcileColumnType(valueParam, (Seq<String>)((Seq)columnPath.$colon$plus((Object)"value")), mapType2.valueType(), mapType2.valueContainsNull(), conf);
                    LambdaFunction keyFunc = new LambdaFunction(reconciledKey, (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{keyParam}))), LambdaFunction$.MODULE$.apply$default$3());
                    LambdaFunction valueFunc = new LambdaFunction(reconciledValue, (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{valueParam}))), LambdaFunction$.MODULE$.apply$default$3());
                    ArrayTransform newKeys = new ArrayTransform(new MapKeys(col), keyFunc);
                    ArrayTransform newValues = new ArrayTransform(new MapValues(col), valueFunc);
                    return new MapFromArrays(newKeys, newValues);
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        DataType other = (DataType)tuple2._1();
        DataType target = (DataType)tuple2._2();
        DataType dataType = other;
        DataType dataType2 = target;
        if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
            expression = col;
            return expression;
        } else {
            if (!Cast$.MODULE$.canANSIStoreAssign(other, target)) throw QueryCompilationErrors$.MODULE$.invalidColumnOrFieldDataTypeError(columnPath, other, target);
            expression = Cast$.MODULE$.apply(col, target, (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), true);
        }
        return expression;
    }

    private Seq<NamedExpression> reorderFields(Seq<Tuple2<String, Expression>> fields, Seq<StructField> expected, Seq<String> columnPath, SQLConf conf) {
        return (Seq)expected.map((Function1 & Serializable)f -> {
            Metadata metadata;
            NamedExpression namedExpression;
            Seq matched = (Seq)fields.filter((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)Project$.$anonfun$reorderFields$2(conf, f, field)));
            if (matched.isEmpty()) {
                if (f.nullable()) {
                    Literal columnExpr = Literal$.MODULE$.create(null, f.dataType());
                    namedExpression = MODULE$.createNewColumn(columnExpr, f.name(), f.metadata(), Metadata$.MODULE$.empty());
                    return namedExpression;
                }
                if (!columnPath.isEmpty()) throw QueryCompilationErrors$.MODULE$.unresolvedFieldError(f.name(), columnPath, (Seq<String>)((Seq)fields.map((Function1 & Serializable)x$5 -> (String)x$5._1())));
                Seq candidates = (Seq)fields.map((Function1 & Serializable)x$4 -> (String)x$4._1());
                Seq<String> orderedCandidates = StringUtils$.MODULE$.orderStringsBySimilarity(f.name(), (Seq<String>)candidates);
                throw QueryCompilationErrors$.MODULE$.unresolvedColumnError(f.name(), orderedCandidates);
            }
            if (matched.length() > 1) {
                throw QueryCompilationErrors$.MODULE$.ambiguousColumnOrFieldError((Seq<String>)((Seq)columnPath.$colon$plus((Object)f.name())), matched.length());
            }
            Expression columnExpr = (Expression)((Tuple2)matched.head())._2();
            Expression expression = columnExpr;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2 = (NamedExpression)((Object)expression);
                metadata = namedExpression2.metadata();
            } else if (expression instanceof GetStructField) {
                GetStructField getStructField = (GetStructField)expression;
                metadata = getStructField.childSchema().apply(getStructField.ordinal()).metadata();
            } else {
                metadata = Metadata$.MODULE$.empty();
            }
            Metadata originalMetadata = metadata;
            Seq newColumnPath = (Seq)columnPath.$colon$plus(((Tuple2)matched.head())._1());
            Expression newColumnExpr = MODULE$.reconcileColumnType(columnExpr, (Seq<String>)newColumnPath, f.dataType(), f.nullable(), conf);
            namedExpression = MODULE$.createNewColumn(newColumnExpr, f.name(), f.metadata(), originalMetadata);
            return namedExpression;
        });
    }

    private NamedExpression createNewColumn(Expression col, String name, Metadata newMetadata, Metadata originalMetadata) {
        Expression expression;
        Metadata metadata = new MetadataBuilder().withMetadata(originalMetadata).withMetadata(newMetadata).build();
        Expression expression2 = col;
        if (expression2 instanceof Attribute) {
            Attribute attribute = (Attribute)expression2;
            expression = attribute.withName(name).withMetadata(metadata);
        } else {
            Alias alias;
            Metadata metadata2 = metadata;
            Metadata metadata3 = Metadata$.MODULE$.empty();
            if (!(metadata2 != null ? !((Object)metadata2).equals(metadata3) : metadata3 != null)) {
                Expression x$1 = expression2;
                String x$2 = name;
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                alias = new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            } else {
                Expression x$7 = expression2;
                String x$8 = name;
                Some x$9 = new Some((Object)metadata);
                ExprId x$10 = Alias$.MODULE$.apply$default$3(x$7, x$8);
                Seq<String> x$11 = Alias$.MODULE$.apply$default$4(x$7, x$8);
                Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
                alias = new Alias(x$7, x$8, x$10, x$11, (Option<Metadata>)x$9, x$12);
            }
            expression = alias;
        }
        return expression;
    }

    public Project apply(Seq<NamedExpression> projectList, LogicalPlan child) {
        return new Project(projectList, child);
    }

    public Option<Tuple2<Seq<NamedExpression>, LogicalPlan>> unapply(Project x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.projectList(), (Object)x$0.child()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Project$.class);
    }

    public static final /* synthetic */ boolean $anonfun$reorderFields$2(SQLConf conf$1, StructField f$1, Tuple2 field) {
        return BoxesRunTime.unboxToBoolean((Object)conf$1.resolver().apply(field._1(), (Object)f$1.name()));
    }

    private Project$() {
    }
}

