/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.sparkproject.guava.base.Preconditions;

@Evolving
class IdentifierImpl
implements Identifier {
    private String[] namespace;
    private String name;

    IdentifierImpl(String[] namespace, String name) {
        Preconditions.checkNotNull((Object)namespace, (Object)"Identifier namespace cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Identifier name cannot be null");
        this.namespace = namespace;
        this.name = name;
    }

    @Override
    public String[] namespace() {
        return this.namespace;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(".");
        for (String p : this.namespace) {
            joiner.add(package$.MODULE$.quoteIfNeeded(p));
        }
        joiner.add(package$.MODULE$.quoteIfNeeded(this.name));
        return joiner.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentifierImpl)) {
            return false;
        }
        IdentifierImpl that = (IdentifierImpl)o;
        return Arrays.equals(this.namespace, that.namespace) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Arrays.hashCode(this.namespace);
        return result;
    }
}

