/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkArithmeticException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.CastSuiteBase;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\u0007\u000f\u0001mAQA\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005B)BQ!\u000e\u0001\u0005\nYBQa\u000f\u0001\u0005\nqBQ\u0001\u0013\u0001\u0005\n%CQa\u0013\u0001\u0005\n1Cq!\u0019\u0001\u0012\u0002\u0013%!\rC\u0003L\u0001\u0011%Q\u000eC\u0003L\u0001\u0011%Q\u000fC\u0003y\u0001\u0011E\u0011\u0010C\u0004\u0002\u0002\u0001!\t\"a\u0001\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e\t\u00192)Y:u/&$\b.\u00118tS>s7+^5uK*\u0011q\u0002E\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0012%\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001aE\u0002\u00019\u0001\u0002\"!\b\u0010\u000e\u00039I!a\b\b\u0003\u001b\r\u000b7\u000f^*vSR,')Y:f!\t\tC%D\u0001#\u0015\t\u0019##\u0001\u0004feJ|'o]\u0005\u0003K\t\u0012q\"U;fef,%O]8sg\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\b\u0001\u0002\u0011\u00154\u0018\r\\'pI\u0016,\u0012a\u000b\t\u0003Y=r!!H\u0017\n\u00059r\u0011\u0001C#wC2lu\u000eZ3\n\u0005A\n$!\u0002,bYV,\u0017B\u0001\u001a4\u0005-)e.^7fe\u0006$\u0018n\u001c8\u000b\u0003Q\nQa]2bY\u0006\f\u0011\"[:Uef\u001c\u0015m\u001d;\u0016\u0003]\u0002\"\u0001O\u001d\u000e\u0003MJ!AO\u001a\u0003\u000f\t{w\u000e\\3b]\u0006\u0001B/Z:u\u0013:$X*\u0019=B]\u0012l\u0015N\u001c\u000b\u0003{\u0001\u0003\"\u0001\u000f \n\u0005}\u001a$\u0001B+oSRDQ!\u0011\u0003A\u0002\t\u000b!\u0001\u001a;\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015\u0013\u0012!\u0002;za\u0016\u001c\u0018BA$E\u0005!!\u0015\r^1UsB,\u0017!\u0005;fgRduN\\4NCb\fe\u000eZ'j]R\u0011QH\u0013\u0005\u0006\u0003\u0016\u0001\rAQ\u0001\u000bG\u0006\u001cH/\u0012:s\u001bN<G\u0003B'Y;~\u0003\"AT+\u000f\u0005=\u001b\u0006C\u0001)4\u001b\u0005\t&B\u0001*\u001b\u0003\u0019a$o\\8u}%\u0011AkM\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002Ug!)\u0011L\u0002a\u00015\u0006\ta\u000f\u0005\u000297&\u0011Al\r\u0002\u0004\u0003:L\b\"\u00020\u0007\u0001\u0004\u0011\u0015A\u0001;p\u0011\u001d\u0001g\u0001%AA\u0002\t\u000bAA\u001a:p[\u0006!2-Y:u\u000bJ\u0014Xj]4%I\u00164\u0017-\u001e7uIM*\u0012a\u0019\u0016\u0003\u0005\u0012\\\u0013!\u001a\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005)\u001c\u0014AC1o]>$\u0018\r^5p]&\u0011An\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0003B'ogRDQa\u001c\u0005A\u0002A\f\u0011\u0001\u001c\t\u0003;EL!A\u001d\b\u0003\u000f1KG/\u001a:bY\")a\f\u0003a\u0001\u0005\")\u0001\r\u0003a\u0001\u0005R\u0019QJ^<\t\u000b=L\u0001\u0019\u00019\t\u000byK\u0001\u0019\u0001\"\u0002/\rDWmY6DCN$Hk\u001c(v[\u0016\u0014\u0018nY#se>\u0014H#B\u001f{wrt\b\"B8\u000b\u0001\u0004\u0001\b\"\u00020\u000b\u0001\u0004\u0011\u0005\"B?\u000b\u0001\u0004\u0011\u0015AG3ya\u0016\u001cG/\u001a3ECR\fG+\u001f9f\u0013:,%O]8s\u001bN<\u0007\"B@\u000b\u0001\u0004Q\u0016!\u0004;ss\u000e\u000b7\u000f\u001e*fgVdG/A\fdQ\u0016\u001c7nQ1tiR{'i\\8mK\u0006tWI\u001d:peR9Q(!\u0002\u0002\b\u0005%\u0001\"B8\f\u0001\u0004\u0001\b\"\u00020\f\u0001\u0004\u0011\u0005\"B@\f\u0001\u0004Q\u0016AE2bgR|e/\u001a:gY><XI\u001d:Ng\u001e$r!TA\b\u0003#\t\u0019\u0002C\u0003Z\u0019\u0001\u0007!\fC\u0003a\u0019\u0001\u0007!\tC\u0003_\u0019\u0001\u0007!\t")
public class CastWithAnsiOnSuite
extends CastSuiteBase
implements QueryErrorsBase {
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$((QueryErrorsBase)this, (Object)v, (DataType)t);
    }

    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$((QueryErrorsBase)this, (String)text);
    }

    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, (String)parts);
    }

    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$((QueryErrorsBase)this, (String)conf);
    }

    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$((QueryErrorsBase)this, (String)conf);
    }

    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$((QueryErrorsBase)this, (String)option);
    }

    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$((QueryErrorsBase)this, (Expression)e);
    }

    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$((QueryErrorsBase)this, (String)schema);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$((QueryErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$((QueryErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public Enumeration.Value evalMode() {
        return EvalMode$.MODULE$.ANSI();
    }

    private boolean isTryCast() {
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = EvalMode$.MODULE$.TRY();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private void testIntMaxAndMin(DataType dt) {
        Seq $org_scalatest_assert_macro_left = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IntegralType[]{IntegerType$.MODULE$, ShortType$.MODULE$, ByteType$.MODULE$}));
        DataType $org_scalatest_assert_macro_right = dt;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0x80000000L, -2147483649L})).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)value -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)value), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Decimal$.MODULE$.apply(Long.toString(value)), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)((float)value * 1.5f)), (DataType)FloatType$.MODULE$), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)((double)value * 1.0)), (DataType)DoubleType$.MODULE$), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        });
    }

    private void testLongMaxAndMin(DataType dt) {
        Seq $org_scalatest_assert_macro_left = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IntegralType[]{LongType$.MODULE$, IntegerType$.MODULE$}));
        DataType $org_scalatest_assert_macro_right = dt;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Decimal[]{Decimal$.MODULE$.apply(Long.MAX_VALUE).$plus(Decimal$.MODULE$.apply(1)), Decimal$.MODULE$.apply(Long.MIN_VALUE).$minus(Decimal$.MODULE$.apply(1))})).foreach((Function1 & Serializable)value -> {
            CastWithAnsiOnSuite.$anonfun$testLongMaxAndMin$1(this, dt, value);
            return BoxedUnit.UNIT;
        });
    }

    private String castErrMsg(Object v, DataType to, DataType from) {
        return new StringBuilder(0).append(new StringBuilder(24).append("The value ").append(this.toSQLValue(v, from)).append(" of the type ").append(this.toSQLType((AbstractDataType)from)).append(" ").toString()).append(new StringBuilder(43).append("cannot be cast to ").append(this.toSQLType((AbstractDataType)to)).append(" because it is malformed.").toString()).toString();
    }

    private String castErrMsg(Literal l, DataType to, DataType from) {
        return new StringBuilder(0).append(new StringBuilder(24).append("The value ").append(this.toSQLValue(l.eval(l.eval$default$1()), from)).append(" of the type ").append(this.toSQLType((AbstractDataType)from)).append(" ").toString()).append(new StringBuilder(43).append("cannot be cast to ").append(this.toSQLType((AbstractDataType)to)).append(" because it is malformed.").toString()).toString();
    }

    private String castErrMsg(Literal l, DataType to) {
        return this.castErrMsg(l, to, l.dataType());
    }

    private DataType castErrMsg$default$3() {
        return StringType$.MODULE$;
    }

    public void checkCastToNumericError(Literal l, DataType to, DataType expectedDataTypeInErrorMsg, Object tryCastResult) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(l, to, this.cast$default$3()), this.castErrMsg("true", expectedDataTypeInErrorMsg, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    public void checkCastToBooleanError(Literal l, DataType to, Object tryCastResult) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(l, to, this.cast$default$3()), "cannot be cast to \"BOOLEAN\"", ClassTag$.MODULE$.apply(SparkRuntimeException.class));
    }

    private String castOverflowErrMsg(Object v, DataType from, DataType to) {
        return new StringBuilder(0).append(new StringBuilder(34).append("The value ").append(this.toSQLValue(v, from)).append(" of the type ").append(this.toSQLType((AbstractDataType)from)).append(" cannot be ").toString()).append(new StringBuilder(28).append("cast to ").append(this.toSQLType((AbstractDataType)to)).append(" due to an overflow.").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$testLongMaxAndMin$1(CastWithAnsiOnSuite $this, DataType dt$2, Decimal value) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(value, dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(BoxesRunTime.boxToFloat((float)value.$times(Decimal$.MODULE$.apply(1.1)).toFloat()), dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(BoxesRunTime.boxToDouble((double)value.$times(Decimal$.MODULE$.apply(1.1)).toDouble()), dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
    }

    public static final /* synthetic */ void $anonfun$new$6(CastWithAnsiOnSuite $this, byte value) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(BoxesRunTime.boxToByte((byte)value), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(Byte.toString(value), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(Decimal$.MODULE$.apply(Byte.toString(value)), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$17(CastWithAnsiOnSuite $this, short value) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(BoxesRunTime.boxToShort((short)value), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(Short.toString(value), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(Decimal$.MODULE$.apply(Short.toString(value)), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
    }

    private final void check$1(String value, DataType dataType) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(value, dataType, this.cast$default$3()), this.castErrMsg(value, dataType, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    public static final /* synthetic */ void $anonfun$new$52(CastWithAnsiOnSuite $this, IntegralType dataType) {
        $this.check$1("string", (DataType)dataType);
        $this.check$1("123-string", (DataType)dataType);
        $this.check$1("2020-07-19", (DataType)dataType);
        $this.check$1("1.23", (DataType)dataType);
    }

    public static final /* synthetic */ void $anonfun$new$53(CastWithAnsiOnSuite $this, FractionalType dataType) {
        $this.check$1("string", (DataType)dataType);
        $this.check$1("123.000.00", (DataType)dataType);
        $this.check$1("abc.com", (DataType)dataType);
    }

    private final void checkCastToTimestampError$1(Literal l, DataType to) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(l, to, this.cast$default$3()), "cannot be cast to \"TIMESTAMP\" because it is malformed", ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ Cast $anonfun$new$85(CastWithAnsiOnSuite $this, Literal array$1, DataType to$4) {
        return $this.cast(array$1, to$4, $this.cast$default$3());
    }

    public static final /* synthetic */ Cast $anonfun$new$86(CastWithAnsiOnSuite $this, Literal overflowArray$1, DataType to$4) {
        return $this.cast(overflowArray$1, to$4, $this.cast$default$3());
    }

    public static final /* synthetic */ Cast $anonfun$new$87(CastWithAnsiOnSuite $this, Literal overflowArray$1, DataType to$4) {
        return $this.cast(overflowArray$1, to$4, $this.cast$default$3());
    }

    public static final /* synthetic */ Cast $anonfun$new$93(CastWithAnsiOnSuite $this, Literal map$1, DataType to$5) {
        return $this.cast(map$1, to$5, $this.cast$default$3());
    }

    public static final /* synthetic */ Cast $anonfun$new$99(CastWithAnsiOnSuite $this, Literal struct$1, DataType to$6) {
        return $this.cast(struct$1, to$6, $this.cast$default$3());
    }

    private final void checkCastWithParseError$1(String str, ZoneId zid$1) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)str), (DataType)TimestampType$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)zid$1.getId())), this.castErrMsg(str, (DataType)TimestampType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ void $anonfun$new$105(CastWithAnsiOnSuite $this, ZoneId zid) {
        $this.checkCastWithParseError$1("123", zid);
        $this.checkCastWithParseError$1("2015-03-18 123142", zid);
        $this.checkCastWithParseError$1("2015-03-18T123123", zid);
        $this.checkCastWithParseError$1("2015-03-18X", zid);
        $this.checkCastWithParseError$1("2015/03/18", zid);
        $this.checkCastWithParseError$1("2015.03.18", zid);
        $this.checkCastWithParseError$1("20150318", zid);
        $this.checkCastWithParseError$1("2015-031-8", zid);
        $this.checkCastWithParseError$1("2015-03-18T12:03:17-0:70", zid);
        $this.checkCastWithParseError$1("abdef", zid);
    }

    private final void checkCastWithParseError$2(String str, ZoneId zid$2) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)str), (DataType)DateType$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)zid$2.getId())), this.castErrMsg(str, (DataType)DateType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ void $anonfun$new$108(CastWithAnsiOnSuite $this, ZoneId zid) {
        $this.checkCastWithParseError$2("2015-13-18", zid);
        $this.checkCastWithParseError$2("2015-03-128", zid);
        $this.checkCastWithParseError$2("2015/03/18", zid);
        $this.checkCastWithParseError$2("2015.03.18", zid);
        $this.checkCastWithParseError$2("20150318", zid);
        $this.checkCastWithParseError$2("2015-031-8", zid);
        $this.checkCastWithParseError$2("2015-03-18ABC", zid);
        $this.checkCastWithParseError$2("abdef", zid);
    }

    public CastWithAnsiOnSuite() {
        QueryErrorsBase.$init$((QueryErrorsBase)this);
        this.test("ANSI mode: Throw exception on casting out-of-range value to byte type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testIntMaxAndMin((DataType)ByteType$.MODULE$);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, -129})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)value -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            });
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{127, (byte)0, -128})).foreach((Function1 & Serializable)value -> {
                CastWithAnsiOnSuite.$anonfun$new$6(this, BoxesRunTime.unboxToByte((Object)value));
                return BoxedUnit.UNIT;
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("ANSI mode: Throw exception on casting out-of-range value to short type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testIntMaxAndMin((DataType)ShortType$.MODULE$);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{32768, -32769})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)value -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            });
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Short.MAX_VALUE, (short)0, Short.MIN_VALUE})).foreach((Function1 & Serializable)value -> {
                CastWithAnsiOnSuite.$anonfun$new$17(this, BoxesRunTime.unboxToShort((Object)value));
                return BoxedUnit.UNIT;
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("ANSI mode: Throw exception on casting out-of-range value to int type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testIntMaxAndMin((DataType)IntegerType$.MODULE$);
            this.testLongMaxAndMin((DataType)IntegerType$.MODULE$);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{Integer.MAX_VALUE, 0, Integer.MIN_VALUE})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)value -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Integer.toString(value), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Decimal$.MODULE$.apply(Integer.toString(value)), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)((double)value * 1.0)), (DataType)DoubleType$.MODULE$), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)2.1474836479E9), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-2.1474836489E9), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), this.checkEvaluation$default$3());
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("ANSI mode: Throw exception on casting out-of-range value to long type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testLongMaxAndMin((DataType)LongType$.MODULE$);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{Long.MAX_VALUE, 0L, Long.MIN_VALUE})).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)value -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)value), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Long.toString(value), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Decimal$.MODULE$.apply(Long.toString(value)), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)9.223372E18f), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)-9.223372E18f), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)9.223372036854776E18), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-9.223372036854776E18), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), this.checkEvaluation$default$3());
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("ANSI mode: Throw exception on casting out-of-range value to decimal type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)"134.12"), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(134.12)), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)134.12)), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("ANSI mode: disallow type conversions between Numeric types and Date type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkInvalidCastFromNumericType((DataType)DateType$.MODULE$);
            this.verifyCastFailure(this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (DataType)DateType$.MODULE$, this.cast$default$3()), new TypeCheckResult.DataTypeMismatch("CAST_WITH_FUNC_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BIGINT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"DATE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionNames"), (Object)"`DATE_FROM_UNIX_DATE`")}))));
            Literal dateLiteral = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)DateType$.MODULE$);
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable)numericType -> {
                this.withClue(new StringBuilder(14).append("numericType = ").append(numericType.sql()).toString(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.verifyCastFailure(this.cast(dateLiteral, (DataType)numericType, this.cast$default$3()), new TypeCheckResult.DataTypeMismatch("CAST_WITH_FUNC_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"DATE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)new StringBuilder(2).append("\"").append(numericType.sql()).append("\"").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionNames"), (Object)"`UNIX_DATE`")})))));
                return BoxedUnit.UNIT;
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("ANSI mode: disallow type conversions between Numeric types and Binary type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkInvalidCastFromNumericType((DataType)BinaryType$.MODULE$);
            Literal binaryLiteral = new Literal((Object)new byte[(byte)1], (DataType)BinaryType$.MODULE$);
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable)numericType -> {
                TypeCheckResult $org_scalatest_assert_macro_left = this.cast(binaryLiteral, (DataType)numericType, this.cast$default$3()).checkInputDataTypes();
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BINARY\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType((AbstractDataType)numericType))})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("ANSI mode: disallow type conversions between Datatime types and Boolean types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            Literal timestampLiteral = new Literal((Object)BoxesRunTime.boxToLong((long)1L), (DataType)TimestampType$.MODULE$);
            TypeCheckResult checkResult1 = this.cast(timestampLiteral, (DataType)BooleanType$.MODULE$, this.cast$default$3()).checkInputDataTypes();
            Enumeration.Value value = this.evalMode();
            Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                TypeCheckResult $org_scalatest_assert_macro_left = checkResult1;
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITH_CONF_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"TIMESTAMP\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configVal"), (Object)"'false'")})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                boxedUnit4 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            } else {
                Enumeration.Value value4 = EvalMode$.MODULE$.TRY();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    TypeCheckResult $org_scalatest_assert_macro_left = checkResult1;
                    TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"TIMESTAMP\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"BOOLEAN\"")})));
                    TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                    boxedUnit4 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
            }
            Literal dateLiteral = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)DateType$.MODULE$);
            TypeCheckResult checkResult2 = this.cast(dateLiteral, (DataType)BooleanType$.MODULE$, this.cast$default$3()).checkInputDataTypes();
            Enumeration.Value value6 = this.evalMode();
            Enumeration.Value value7 = EvalMode$.MODULE$.ANSI();
            Enumeration.Value value8 = value6;
            if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                TypeCheckResult $org_scalatest_assert_macro_left = checkResult2;
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITH_CONF_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"DATE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configVal"), (Object)"'false'")})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                boxedUnit3 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            } else {
                Enumeration.Value value9 = EvalMode$.MODULE$.TRY();
                Enumeration.Value value10 = value6;
                if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                    TypeCheckResult $org_scalatest_assert_macro_left = checkResult2;
                    TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"DATE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"BOOLEAN\"")})));
                    TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                    boxedUnit3 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
            }
            Literal booleanLiteral = new Literal((Object)BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$);
            TypeCheckResult checkResult3 = this.cast(booleanLiteral, (DataType)TimestampType$.MODULE$, this.cast$default$3()).checkInputDataTypes();
            Enumeration.Value value11 = this.evalMode();
            Enumeration.Value value12 = EvalMode$.MODULE$.ANSI();
            Enumeration.Value value13 = value11;
            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                TypeCheckResult $org_scalatest_assert_macro_left = checkResult3;
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITH_CONF_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"TIMESTAMP\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configVal"), (Object)"'false'")})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                boxedUnit2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            } else {
                Enumeration.Value value14 = EvalMode$.MODULE$.TRY();
                Enumeration.Value value15 = value11;
                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                    TypeCheckResult $org_scalatest_assert_macro_left = checkResult3;
                    TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"TIMESTAMP\"")})));
                    TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                    boxedUnit2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            }
            TypeCheckResult checkResult4 = this.cast(booleanLiteral, (DataType)DateType$.MODULE$, this.cast$default$3()).checkInputDataTypes();
            Enumeration.Value value16 = this.evalMode();
            Enumeration.Value value17 = EvalMode$.MODULE$.ANSI();
            Enumeration.Value value18 = value16;
            if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                TypeCheckResult $org_scalatest_assert_macro_left = checkResult4;
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"DATE\"")})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            } else {
                Enumeration.Value value19 = EvalMode$.MODULE$.TRY();
                Enumeration.Value value20 = value16;
                if (!(value19 != null ? !value19.equals(value20) : value20 != null)) {
                    TypeCheckResult $org_scalatest_assert_macro_left = checkResult4;
                    TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"DATE\"")})));
                    TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                    boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.test("cast from invalid string to numeric should throw NumberFormatException", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IntegralType[]{IntegerType$.MODULE$, ShortType$.MODULE$, ByteType$.MODULE$, LongType$.MODULE$})).foreach((Function1 & Serializable)dataType -> {
                CastWithAnsiOnSuite.$anonfun$new$52(this, dataType);
                return BoxedUnit.UNIT;
            });
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FractionalType[]{DoubleType$.MODULE$, FloatType$.MODULE$, DecimalType$.MODULE$.USER_DEFAULT()})).foreach((Function1 & Serializable)dataType -> {
                CastWithAnsiOnSuite.$anonfun$new$53(this, dataType);
                return BoxedUnit.UNIT;
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        this.test("cast from invalid string array to numeric array should throw NumberFormatException", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Literal array = Literal$.MODULE$.create((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"123", "true", "f", null})), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)ByteType$.MODULE$, true), (DataType)ByteType$.MODULE$, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)123)), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)ShortType$.MODULE$, true), (DataType)ShortType$.MODULE$, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)123)), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)IntegerType$.MODULE$, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)123), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)LongType$.MODULE$, true), (DataType)LongType$.MODULE$, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)123L), null, null, null})));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        this.test("Fast fail for cast string type to decimal type in ansi mode", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("12345678901234567890123456789012345678"), this.checkEvaluation$default$3());
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast("123456789012345678901234567890123456789", (DataType)new DecimalType(38, 0), this.cast$default$3()), "NUMERIC_OUT_OF_SUPPORTED_RANGE", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 1), this.cast$default$3()), "cannot be represented as Decimal(38, 1)", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("0.00000000000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 18), this.cast$default$3()), Decimal$.MODULE$.apply("0E-18"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("6E-120", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("60000000000000000000000000000000000000"), this.checkEvaluation$default$3());
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast("6E+38", (DataType)new DecimalType(38, 0), this.cast$default$3()), "NUMERIC_OUT_OF_SUPPORTED_RANGE", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 1), this.cast$default$3()), "cannot be represented as Decimal(38, 1)", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast("abcd", (DataType)new DecimalType(38, 1), this.cast$default$3()), this.castErrMsg("abcd", (DataType)new DecimalType(38, 1), this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        this.test("ANSI mode: cast string to boolean with parse error", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkCastToBooleanError(Literal$.MODULE$.apply((Object)"abc"), (DataType)BooleanType$.MODULE$, null);
            this.checkCastToBooleanError(Literal$.MODULE$.apply((Object)""), (DataType)BooleanType$.MODULE$, null);
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("cast from timestamp II", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NaN)), (DataType)TimestampType$.MODULE$);
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)), (DataType)TimestampType$.MODULE$);
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NaN)), (DataType)TimestampType$.MODULE$);
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)), (DataType)TimestampType$.MODULE$);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{Long.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE})).foreach((Function1)(JFunction1.mcVD.sp & Serializable)v -> this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)v)), (DataType)TimestampType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(SparkArithmeticException.class)));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        this.test("cast a timestamp before the epoch 1970-01-01 00:00:00Z II", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (JFunction0.mcV.sp & Serializable)() -> {
            Timestamp negativeTs = Timestamp.valueOf("1900-05-05 18:34:56.1");
            long $org_scalatest_assert_macro_left = negativeTs.getTime();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IntegralType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$})).foreach((Function1 & Serializable)dt -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(negativeTs$1, (DataType)dt, $this.cast$default$3()), this.castOverflowErrMsg(negativeTs, (DataType)TimestampType$.MODULE$, (DataType)dt), ClassTag$.MODULE$.apply(SparkArithmeticException.class));
                return BoxedUnit.UNIT;
            });
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        this.test("cast a timestamp before the epoch 1970-01-01 00:00:00Z", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (JFunction0.mcV.sp & Serializable)() -> {
            Timestamp negativeTs = Timestamp.valueOf("1900-05-05 18:34:56.1");
            long $org_scalatest_assert_macro_left = negativeTs.getTime();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IntegralType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$})).foreach((Function1 & Serializable)dt -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(negativeTs$2, (DataType)dt, $this.cast$default$3()), this.castOverflowErrMsg(negativeTs, (DataType)TimestampType$.MODULE$, (DataType)dt), ClassTag$.MODULE$.apply(SparkArithmeticException.class));
                return BoxedUnit.UNIT;
            });
            long expectedSecs = Math.floorDiv(negativeTs.getTime(), 1000L);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(negativeTs, (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)expectedSecs), this.checkEvaluation$default$3());
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        this.test("cast from array II", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            Literal array = Literal$.MODULE$.create((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"123", "true", "f", null})), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal array_notNull = Literal$.MODULE$.create((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"123", "true", "f"})), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            ArrayType to = new ArrayType((DataType)BooleanType$.MODULE$, true);
            Cast ret = this.cast(array, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
            this.checkCastToBooleanError(array, (DataType)to, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), null})));
            ArrayType to2 = new ArrayType((DataType)BooleanType$.MODULE$, true);
            Cast ret2 = this.cast(array_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
            this.checkCastToBooleanError(array_notNull, (DataType)to2, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)})));
            Enumeration.Value value = this.evalMode();
            Enumeration.Value value2 = EvalMode$.MODULE$.TRY();
            Cast ret3 = this.cast(array_notNull, (DataType)new ArrayType((DataType)BooleanType$.MODULE$, !(value != null ? !value.equals(value2) : value2 != null)), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret3, "cannot be cast to \"BOOLEAN\"", ClassTag$.MODULE$.apply(SparkRuntimeException.class));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> ret3, new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)}, this.checkEvaluation$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        this.test("cast from array III", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            ArrayType from = new ArrayType((DataType)DoubleType$.MODULE$, false);
            Literal array = Literal$.MODULE$.create((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0})), (DataType)from);
            ArrayType to = new ArrayType((DataType)IntegerType$.MODULE$, this.isTryCast());
            Object answer = Literal$.MODULE$.create((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (DataType)to).value();
            this.checkEvaluation((Function0<Expression>)((Function0 & Serializable)() -> CastWithAnsiOnSuite.$anonfun$new$85(this, array, (DataType)to)), answer, this.checkEvaluation$default$3());
            Literal overflowArray = Literal$.MODULE$.create((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{2.147483648E9})), (DataType)from);
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)((Function0 & Serializable)() -> CastWithAnsiOnSuite.$anonfun$new$86(this, overflowArray, (DataType)to)), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.checkEvaluation((Function0<Expression>)((Function0 & Serializable)() -> CastWithAnsiOnSuite.$anonfun$new$87(this, overflowArray, (DataType)to)), Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}), ClassTag$.MODULE$.Null()), this.checkEvaluation$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        this.test("cast from map II", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            Assertion assertion2;
            Assertion assertion3;
            Literal map = Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true));
            Literal map_notNull = Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f")})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false));
            this.checkNullCast((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$));
            MapType to = new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, true);
            Cast ret = this.cast(map, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
            this.checkCastToBooleanError(map, (DataType)to, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})));
            MapType to2 = new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, true);
            Cast ret2 = this.cast(map_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
            this.checkCastToBooleanError(map_notNull, (DataType)to2, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToBoolean((boolean)false))})));
            Cast ret3 = this.cast(map, (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), this.cast$default$3());
            if (!this.isTryCast()) {
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret3, this.castErrMsg("a", (DataType)IntegerType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
                assertion3 = BoxedUnit.UNIT;
            } else {
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion3 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
            }
            Cast ret4 = this.cast(map_notNull, (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, false), this.cast$default$3());
            if (!this.isTryCast()) {
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ret4.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret4, this.castErrMsg("123", (DataType)BooleanType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(SparkRuntimeException.class));
                assertion2 = BoxedUnit.UNIT;
            } else {
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ret4.resolved(), "ret.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            }
            Cast ret5 = this.cast(map_notNull, (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), this.cast$default$3());
            if (!this.isTryCast()) {
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(ret5.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret5, this.castErrMsg("a", (DataType)IntegerType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
                assertion = BoxedUnit.UNIT;
            } else {
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ret5.resolved(), "ret.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
            }
            return assertion;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        this.test("cast from map III", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            MapType from = new MapType((DataType)DoubleType$.MODULE$, (DataType)DoubleType$.MODULE$, false);
            Literal map = Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)BoxesRunTime.boxToDouble((double)2.0))})), (DataType)from);
            MapType to = new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
            Object answer = Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))})), (DataType)to).value();
            if (!this.isTryCast()) {
                this.checkEvaluation((Function0<Expression>)((Function0 & Serializable)() -> CastWithAnsiOnSuite.$anonfun$new$93(this, map, (DataType)to)), answer, this.checkEvaluation$default$3());
                package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)2.147483648E9)), (Object)BoxesRunTime.boxToDouble((double)2.0))})), (DataType)from), Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)BoxesRunTime.boxToDouble((double)-2.147483649E9))})), (DataType)from)})).foreach(arg_0 -> CastWithAnsiOnSuite.$anonfun$new$94$adapted(this, (DataType)to, arg_0));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
        this.test("cast from struct II", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            this.checkNullCast((DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))));
            Literal struct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f"), null})), (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("d", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}))));
            Literal struct_notNull = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f")})), (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))));
            StructType to = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("d", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
            Cast ret = this.cast(struct, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
            this.checkCastToBooleanError(struct, (DataType)to, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), null})));
            StructType to2 = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
            Cast ret2 = this.cast(struct_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
            this.checkCastToBooleanError(struct_notNull, (DataType)to2, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)})));
            Cast ret3 = this.cast(struct_notNull, (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)BooleanType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}))), this.cast$default$3());
            if (!this.isTryCast()) {
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret3, this.castErrMsg("123", (DataType)BooleanType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(SparkRuntimeException.class));
                assertion = BoxedUnit.UNIT;
            } else {
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
            }
            return assertion;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        this.test("cast from struct III", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            StructType from = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
            Literal struct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0)})), (DataType)from);
            StructType to = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, this.isTryCast(), StructField$.MODULE$.apply$default$4())})));
            Object answer = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (DataType)to).value();
            this.checkEvaluation((Function0<Expression>)((Function0 & Serializable)() -> CastWithAnsiOnSuite.$anonfun$new$99(this, struct, (DataType)to)), answer, this.checkEvaluation$default$3());
            Literal overflowStruct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)2.147483648E9)})), (DataType)from);
            Cast ret = this.cast(overflowStruct, (DataType)to, this.cast$default$3());
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret, "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> ret, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})), this.checkEvaluation$default$3());
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
        this.test("complex casting", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Assertion assertion;
            Literal complex = Literal$.MODULE$.create((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"123", "true", "f"})), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f")})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))})), (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("m", (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("s", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("i", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))));
            Cast ret = this.cast(complex, (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), new StructField("m", (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("s", (DataType)StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("l", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), this.cast$default$3());
            if (!this.isTryCast()) {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret, this.castErrMsg("true", (DataType)IntegerType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
                assertion = BoxedUnit.UNIT;
            } else {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
            }
            return assertion;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
        this.test("ANSI mode: cast string to timestamp with parse error", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
            CastWithAnsiOnSuite.$anonfun$new$105(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
        this.test("ANSI mode: cast string to date with parse error", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
            CastWithAnsiOnSuite.$anonfun$new$108(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
        this.test("SPARK-26218: Fix the corner case of codegen when casting float to Integer", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(this.cast(Literal$.MODULE$.apply((Object)"2147483648"), (DataType)FloatType$.MODULE$, this.cast$default$3()), (DataType)IntegerType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class)), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
        this.test("SPARK-35720: cast invalid string input to timestamp without time zone", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"00:00:00", "a", "123", "a2021-06-17", "2021-06-17abc", "2021-06-17 00:00:00ABC"})).foreach((Function1 & Serializable)invalidInput -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(invalidInput, (DataType)TimestampNTZType$.MODULE$, $this.cast$default$3()), this.castErrMsg(invalidInput, (DataType)TimestampNTZType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(DateTimeException.class));
            return BoxedUnit.UNIT;
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
        this.test("SPARK-39749: cast Decimal to string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Literal input = Literal$.MODULE$.create((Object)Decimal$.MODULE$.apply(1.23E-7), (DataType)new DecimalType(9, 9));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(input, (DataType)StringType$.MODULE$, this.cast$default$3()), "0.000000123", this.checkEvaluation$default$3());
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
    }

    public static final /* synthetic */ Object $anonfun$new$94$adapted(CastWithAnsiOnSuite $this, DataType to$5, Literal overflowMap) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(overflowMap, to$5, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        return BoxedUnit.UNIT;
    }
}

