/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JsonInferSchema;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000513A\u0001B\u0003\u0001%!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)!\t\u0001C\u0001\u0007\n!\"j]8o\u0013:4WM]*dQ\u0016l\u0017mU;ji\u0016T!AB\u0004\u0002\t)\u001cxN\u001c\u0006\u0003\u0011%\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001M9\u0002C\u0001\u000b\u0016\u001b\u0005Y\u0011B\u0001\f\f\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011\u0001dG\u0007\u00023)\u0011!dB\u0001\u0006a2\fgn]\u0005\u00039e\u0011\u0011bU)M\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005)\u0011!C2iK\u000e\\G+\u001f9f)\u0011\u0019\u0013&\u000f\u001e\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\t\u0001\raK\u0001\b_B$\u0018n\u001c8t!\u0011a3G\u000e\u001c\u000f\u00055\n\u0004C\u0001\u0018&\u001b\u0005y#B\u0001\u0019\u0012\u0003\u0019a$o\\8u}%\u0011!'J\u0001\u0007!J,G-\u001a4\n\u0005Q*$aA'ba*\u0011!'\n\t\u0003Y]J!\u0001O\u001b\u0003\rM#(/\u001b8h\u0011\u00151!\u00011\u00017\u0011\u0015Y$\u00011\u0001=\u0003\t!G\u000f\u0005\u0002>\u00016\taH\u0003\u0002@\u0013\u0005)A/\u001f9fg&\u0011\u0011I\u0010\u0002\t\t\u0006$\u0018\rV=qK\u0006\u00112\r[3dWRKW.Z:uC6\u0004H+\u001f9f)\u0011\u0019CIR$\t\u000b\u0015\u001b\u0001\u0019\u0001\u001c\u0002\u000fA\fG\u000f^3s]\")aa\u0001a\u0001m!)\u0001j\u0001a\u0001\u0013\u0006q\u0011N\u001c4feRKW.Z:uC6\u0004\bC\u0001\u0013K\u0013\tYUEA\u0004C_>dW-\u00198")
public class JsonInferSchemaSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        JsonInferSchemaSuite jsonInferSchemaSuite = this;
        synchronized (jsonInferSchemaSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public void checkType(Map<String, String> options, String json, DataType dt) {
        JSONOptions jsonOptions = new JSONOptions(options, "UTC", "");
        JsonInferSchema inferSchema = new JsonInferSchema(jsonOptions);
        JsonFactory factory = jsonOptions.buildJsonFactory();
        JsonParser parser = CreateJacksonParser$.MODULE$.string(factory, json);
        parser.nextToken();
        StructType expectedType = StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", dt, true, StructField$.MODULE$.apply$default$4())})));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(inferSchema.inferField(parser));
        StructType $org_scalatest_assert_macro_right = expectedType;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JsonInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
    }

    public void checkTimestampType(String pattern, String json, boolean inferTimestamp) {
        this.checkType((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)pattern), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inferTimestamp"), (Object)Boolean.toString(inferTimestamp))}))), json, (DataType)(inferTimestamp ? TimestampType$.MODULE$ : StringType$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$new$2(JsonInferSchemaSuite $this, boolean inferTimestamp) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"legacy", "corrected"})).foreach((Function1 & Serializable)legacyParserPolicy -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)legacyParserPolicy)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                $this.checkTimestampType("yyyy", "{\"a\": \"2018\"}", inferTimestamp$1);
                $this.checkTimestampType("yyyy=MM", "{\"a\": \"2018=12\"}", inferTimestamp$1);
                $this.checkTimestampType("yyyy MM dd", "{\"a\": \"2018 12 02\"}", inferTimestamp$1);
                $this.checkTimestampType("yyyy-MM-dd'T'HH:mm:ss.SSS", "{\"a\": \"2018-12-02T21:04:00.123\"}", inferTimestamp$1);
                $this.checkTimestampType("yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX", "{\"a\": \"2018-12-02T21:04:00.123567+01:00\"}", inferTimestamp$1);
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$9(JsonInferSchemaSuite $this, boolean inferTimestamp) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"legacy", "corrected"})).foreach((Function1 & Serializable)legacyParserPolicy -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)legacyParserPolicy)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.checkType((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prefersDecimal"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyyMMdd.HHmmssSSS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inferTimestamp"), (Object)Boolean.toString(inferTimestamp))}))), "{\"a\": \"20181202.210400123\"}", (DataType)(inferTimestamp ? TimestampType$.MODULE$ : StringType$.MODULE$)));
            return BoxedUnit.UNIT;
        });
    }

    public JsonInferSchemaSuite() {
        SQLHelper.$init$(this);
        this.test("inferring timestamp type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)inferTimestamp -> {
            JsonInferSchemaSuite.$anonfun$new$2(this, BoxesRunTime.unboxToBoolean((Object)inferTimestamp));
            return BoxedUnit.UNIT;
        }), new Position("JsonInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("prefer decimals over timestamps", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"legacy", "corrected"})).foreach((Function1 & Serializable)legacyParser -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)legacyParser)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkType((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prefersDecimal"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyyMMdd.HHmmssSSS")}))), "{\"a\": \"20181202.210400123\"}", (DataType)new DecimalType(17, 9)));
            return BoxedUnit.UNIT;
        }), new Position("JsonInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("skip decimal type inferring", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)inferTimestamp -> {
            JsonInferSchemaSuite.$anonfun$new$9(this, BoxesRunTime.unboxToBoolean((Object)inferTimestamp));
            return BoxedUnit.UNIT;
        }), new Position("JsonInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("fallback to string type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"legacy", "corrected"})).foreach((Function1 & Serializable)legacyParserPolicy -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)legacyParserPolicy)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.checkType((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy,MM,dd.HHmmssSSS")}))), "{\"a\": \"20181202.210400123\"}", (DataType)StringType$.MODULE$));
            return BoxedUnit.UNIT;
        }), new Position("JsonInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("disable timestamp inferring", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String json = "{\"a\": \"2019-01-04T21:11:10.123Z\"}";
            this.checkType((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inferTimestamp"), (Object)"true")}))), json, (DataType)TimestampType$.MODULE$);
            this.checkType((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inferTimestamp"), (Object)"false")}))), json, (DataType)StringType$.MODULE$);
        }, new Position("JsonInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("SPARK-45433: inferring the schema when timestamps do not match specified timestampFormat with only one row", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkType((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd'T'HH:mm:ss"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inferTimestamp"), (Object)"true")}))), "{\"a\": \"2884-06-24T02:45:51.138\"}", (DataType)StringType$.MODULE$), new Position("JsonInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
    }
}

