/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Elt$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(n, input1, input2, ...) - Returns the `n`-th input, e.g., returns `input2` when `n` is 2.\n    The function returns NULL if the index exceeds the length of the array\n    and `spark.sql.ansi.enabled` is set to false. If `spark.sql.ansi.enabled` is set to true,\n    it throws ArrayIndexOutOfBoundsException for invalid indices.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 'scala', 'java');\n       scala\n      > SELECT _FUNC_(2, 'a', 1);\n       1\n  ", since="2.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tma\u0001B\u0012%\u0001FB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003T\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u00159\u0006\u0001\"\u0001]\u0011!q\u0006\u0001#b\u0001\n\u0013y\u0006\u0002\u00031\u0001\u0011\u000b\u0007I\u0011B1\t\u000b\u0015\u0004A\u0011\t*\t\u000b\u0019\u0004A\u0011I4\t\u000b9\u0004A\u0011I8\t\u000bY\u0004A\u0011I<\t\u000f\u0005\r\u0001\u0001\"\u0015\u0002\u0006!9\u0011\u0011\u0005\u0001\u0005R\u0005\r\u0002bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\n\u0003\u000b\u0002\u0011\u0011!C\u0001\u0003\u000fB\u0011\"!\u0014\u0001#\u0003%\t!a\u0014\t\u0013\u0005\u0015\u0004!%A\u0005\u0002\u0005\u001d\u0004\"CA6\u0001\u0005\u0005I\u0011IA7\u0011%\ty\bAA\u0001\n\u0003\t\t\tC\u0005\u0002\n\u0002\t\t\u0011\"\u0001\u0002\f\"I\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005\u00131\u0013\u0005\n\u0003C\u0003\u0011\u0011!C\u0001\u0003GC\u0011\"a*\u0001\u0003\u0003%\t%!+\t\u0013\u00055\u0006!!A\u0005B\u0005=v!CAjI\u0005\u0005\t\u0012AAk\r!\u0019C%!A\t\u0002\u0005]\u0007BB,\u001c\t\u0003\ty\u000fC\u0005\u0002rn\t\t\u0011\"\u0012\u0002t\"I\u0011Q_\u000e\u0002\u0002\u0013\u0005\u0015q\u001f\u0005\n\u0003{\\\u0012\u0013!C\u0001\u0003OB\u0011\"a@\u001c\u0003\u0003%\tI!\u0001\t\u0013\t=1$%A\u0005\u0002\u0005\u001d\u0004\"\u0003B\t7\u0005\u0005I\u0011\u0002B\n\u0005\r)E\u000e\u001e\u0006\u0003K\u0019\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0005K\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001M)\u0001A\r\u001c:\u007fA\u00111\u0007N\u0007\u0002I%\u0011Q\u0007\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u001a8\u0013\tADEA\nTkB\u0004xN\u001d;Rk\u0016\u0014\u0018pQ8oi\u0016DH\u000f\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4HA\u0004Qe>$Wo\u0019;\u0011\u0005\u0001CeBA!G\u001d\t\u0011U)D\u0001D\u0015\t!\u0005'\u0001\u0004=e>|GOP\u0005\u0002y%\u0011qiO\u0001\ba\u0006\u001c7.Y4f\u0013\tI%J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Hw\u0005A1\r[5mIJ,g.F\u0001N!\r\u0001eJM\u0005\u0003\u001f*\u00131aU3r\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%A\u0006gC&dwJ\\#se>\u0014X#A*\u0011\u0005i\"\u0016BA+<\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtDcA-[7B\u00111\u0007\u0001\u0005\u0006\u0017\u0016\u0001\r!\u0014\u0005\b#\u0016\u0001\n\u00111\u0001T)\tIV\fC\u0003L\r\u0001\u0007Q*A\u0005j]\u0012,\u00070\u0012=qeV\t!'\u0001\u0006j]B,H/\u0012=qeN,\u0012A\u0019\t\u0004u\r\u0014\u0014B\u00013<\u0005\u0015\t%O]1z\u0003!qW\u000f\u001c7bE2,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003!\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u0015\u0002\u000bQL\b/Z:\n\u00055T'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003A\u0004\"!\u001d;\u000e\u0003IT!a\u001d\u0014\u0002\u0011\u0005t\u0017\r\\=tSNL!!\u001e:\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fA!\u001a<bYR\u0011\u0001p\u001f\t\u0003ueL!A_\u001e\u0003\u0007\u0005s\u0017\u0010C\u0004}\u0019A\u0005\t\u0019A?\u0002\u000b%t\u0007/\u001e;\u0011\u0005y|X\"\u0001\u0014\n\u0007\u0005\u0005aEA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9!a\u0005\u0002\u001eA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e\u0011\nqaY8eK\u001e,g.\u0003\u0003\u0002\u0012\u0005-!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005UQ\u00021\u0001\u0002\u0018\u0005\u00191\r\u001e=\u0011\t\u0005%\u0011\u0011D\u0005\u0005\u00037\tYA\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005}Q\u00021\u0001\u0002\b\u0005\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2!WA\u0013\u0011\u001d\t9C\u0004a\u0001\u0003S\t1B\\3x\u0007\"LG\u000e\u001a:f]B!\u0001)a\u000b3\u0013\r\tiC\u0013\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001E5oSR\fV/\u001a:z\u0007>tG/\u001a=u)\t\t\u0019\u0004E\u0003;\u0003k\tI$C\u0002\u00028m\u0012aa\u00149uS>t\u0007\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}b%A\u0003ue\u0016,7/\u0003\u0003\u0002D\u0005u\"aD*R\u0019F+XM]=D_:$X\r\u001f;\u0002\t\r|\u0007/\u001f\u000b\u00063\u0006%\u00131\n\u0005\b\u0017B\u0001\n\u00111\u0001N\u0011\u001d\t\u0006\u0003%AA\u0002M\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002R)\u001aQ*a\u0015,\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0018<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\nIFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002j)\u001a1+a\u0015\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\t1\fgn\u001a\u0006\u0003\u0003s\nAA[1wC&!\u0011QPA:\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0011\t\u0004u\u0005\u0015\u0015bAADw\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u00010!$\t\u0013\u0005=U#!AA\u0002\u0005\r\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0016B)\u0011qSAOq6\u0011\u0011\u0011\u0014\u0006\u0004\u00037[\u0014AC2pY2,7\r^5p]&!\u0011qTAM\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007M\u000b)\u000b\u0003\u0005\u0002\u0010^\t\t\u00111\u0001y\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005=\u00141\u0016\u0005\n\u0003\u001fC\u0012\u0011!a\u0001\u0003\u0007\u000ba!Z9vC2\u001cHcA*\u00022\"A\u0011qR\r\u0002\u0002\u0003\u0007\u0001\u0010K\n\u0001\u0003k\u000bY,!0\u0002B\u0006\r\u0017qYAe\u0003\u001b\fy\rE\u00024\u0003oK1!!/%\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a0\u0002\u0005OS\u0001\u0005\t\u0011!?\u001a+fjQ0)]2\u0002\u0013N\u001c9viFb\u0003%\u001b8qkR\u0014D\u0006\t\u0018/]%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0003M\u001c1.i\"\u0004\u0013N\u001c9vi2\u0002SML4/Y\u0001\u0012X\r^;s]N\u0004\u0003-\u001b8qkR\u0014\u0004\rI<iK:\u0004\u0003M\u001c1!SN\u0004#G\f\u0006!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002\u0012X\r^;s]N\u0004c*\u0016'MA%4\u0007\u0005\u001e5fA%tG-\u001a=!Kb\u001cW-\u001a3tAQDW\r\t7f]\u001e$\b\u000eI8gAQDW\rI1se\u0006L(\u0002\t\u0011!A\u0005tG\r\t1ta\u0006\u00148NL:rY:\ngn]5/K:\f'\r\\3eA\u0002J7\u000fI:fi\u0002\"x\u000e\t4bYN,g\u0006I%gA\u0001\u001c\b/\u0019:l]M\fHNL1og&tSM\\1cY\u0016$\u0007\rI5tAM,G\u000f\t;pAQ\u0014X/\u001a\u0017\u000bA\u0001\u0002\u0003%\u001b;!i\"\u0014xn^:!\u0003J\u0014\u0018-_%oI\u0016Dx*\u001e;PM\n{WO\u001c3t\u000bb\u001cW\r\u001d;j_:\u0004cm\u001c:!S:4\u0018\r\\5eA%tG-[2fg:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QY\u0001u\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nD\u0006I\u0014tG\u0006d\u0017m\n\u0017!O)\fg/Y\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a8-\u00197b\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012D\u0006I\u0014bO1\u0002\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002L\u0006)!G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011\u0011[\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\u0004\u000b2$\bCA\u001a\u001c'\u0015Y\u0012\u0011\\As!\u001d\tY.!9N'fk!!!8\u000b\u0007\u0005}7(A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0018Q\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAt\u0003[l!!!;\u000b\t\u0005-\u0018qO\u0001\u0003S>L1!SAu)\t\t).\u0001\u0005u_N#(/\u001b8h)\t\ty'A\u0003baBd\u0017\u0010F\u0003Z\u0003s\fY\u0010C\u0003L=\u0001\u0007Q\nC\u0004R=A\u0005\t\u0019A*\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0004\t-\u0001#\u0002\u001e\u00026\t\u0015\u0001#\u0002\u001e\u0003\b5\u001b\u0016b\u0001B\u0005w\t1A+\u001e9mKJB\u0001B!\u0004!\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u0016A!\u0011\u0011\u000fB\f\u0013\u0011\u0011I\"a\u001d\u0003\r=\u0013'.Z2u\u0001")
public class Elt
extends Expression
implements SupportQueryContext {
    private Expression indexExpr;
    private Expression[] inputExprs;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private Option<SQLQueryContext> queryContext;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Elt$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(Elt x$0) {
        return Elt$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Elt$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, Elt> tupled() {
        return Elt$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, Elt>> curried() {
        return Elt$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private Expression indexExpr$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.indexExpr = (Expression)this.children().head();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.indexExpr;
    }

    private Expression indexExpr() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.indexExpr$lzycompute() : this.indexExpr;
    }

    private Expression[] inputExprs$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.inputExprs = (Expression[])((IterableOnceOps)this.children().tail()).toArray(ClassTag$.MODULE$.apply(Expression.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.inputExprs;
    }

    private Expression[] inputExprs() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.inputExprs$lzycompute() : this.inputExprs;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return (DataType)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)x$10 -> x$10.dataType(), ClassTag$.MODULE$.apply(DataType.class)))).getOrElse((Function0 & Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().size() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"> 1"}))), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        Tuple2 tuple2 = new Tuple2((Object)this.indexExpr().dataType(), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)x$11 -> x$11.dataType(), ClassTag$.MODULE$.apply(DataType.class)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DataType indexType = (DataType)tuple2._1();
        DataType[] inputTypes = (DataType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)inputTypes);
        Tuple2 tuple23 = tuple22;
        DataType indexType2 = (DataType)tuple23._1();
        DataType[] inputTypes2 = (DataType[])tuple23._2();
        DataType dataType = indexType2;
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)Cast$.MODULE$.toSQLType(IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Cast$.MODULE$.toSQLExpr(this.indexExpr())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType(indexType2))}))));
        }
        if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])inputTypes2), (Function1 & Serializable)tpe -> BoxesRunTime.boxToBoolean((boolean)Elt.$anonfun$checkInputDataTypes$2(tpe)))) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2..."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)new StringBuilder(4).append(Cast$.MODULE$.toSQLType(StringType$.MODULE$)).append(" or ").append(Cast$.MODULE$.toSQLType(BinaryType$.MODULE$)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)x$13 -> Cast$.MODULE$.toSQLExpr((Expression)x$13), ClassTag$.MODULE$.apply(String.class))).mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])inputTypes2), (Function1 & Serializable)x$14 -> Cast$.MODULE$.toSQLType((AbstractDataType)x$14), ClassTag$.MODULE$.apply(String.class))).mkString(","))}))));
        }
        return TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)inputTypes2), this.prettyName());
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object indexObj = this.indexExpr().eval(input);
        if (indexObj == null) {
            object = null;
        } else {
            int index = BoxesRunTime.unboxToInt((Object)indexObj);
            if (index <= 0 || index > this.inputExprs().length) {
                if (this.failOnError()) {
                    throw QueryExecutionErrors$.MODULE$.invalidArrayIndexError(index, this.inputExprs().length, this.getContextOrNull());
                }
                object = null;
            } else {
                object = this.inputExprs()[index - 1].eval(input);
            }
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        ExprCode index = this.indexExpr().genCode(ctx);
        ExprCode[] inputs = (ExprCode[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)x$15 -> x$15.genCode(ctx), ClassTag$.MODULE$.apply(ExprCode.class));
        String indexVal = ctx.freshName("index");
        String indexMatched = ctx.freshName("eltIndexMatched");
        String inputVal = ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), "inputVal", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String[] assignInputValue = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])inputs))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExprCode eval = (ExprCode)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(124).append("\n         |if (").append(indexVal).append(" == ").append(index + 1).append(") {\n         |  ").append(eval.code()).append("\n         |  ").append(inputVal).append(" = ").append(eval.isNull()).append(" ? null : ").append(eval.value()).append(";\n         |  ").append(indexMatched).append(" = true;\n         |  continue;\n         |}\n      ").toString()));
            return string;
        }, ClassTag$.MODULE$.apply(String.class));
        Tuple2 tuple2 = new Tuple2((Object)"int", (Object)indexVal);
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)assignInputValue), "eltFunc", (Seq<Tuple2<String, String>>)package$.MODULE$.Nil().$colon$colon((Object)tuple2), "boolean", (Function1<String, String>)(Function1 & Serializable)body -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n           |").append("boolean").append(" ").append(indexMatched).append(" = false;\n           |do {\n           |  ").append((String)body).append("\n           |} while (false);\n           |return ").append(indexMatched).append(";\n         ").toString())), (Function1<Seq<String>, String>)(Function1 & Serializable)x$16 -> ((IterableOnceOps)x$16.map((Function1 & Serializable)funcCall -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(85).append("\n           |").append(indexMatched).append(" = ").append((String)funcCall).append(";\n           |if (").append(indexMatched).append(") {\n           |  continue;\n           |}\n         ").toString())))).mkString());
        if (this.failOnError()) {
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(108).append("\n         |if (!").append(indexMatched).append(") {\n         |  throw QueryExecutionErrors.invalidArrayIndexError(").append(index.value()).append(", ").append(this.inputExprs().length).append(", ").append(errorContext).append(");\n         |}\n       ").toString()));
        } else {
            string = "";
        }
        String indexOutOfBoundBranch = string;
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = ", ";\n         |", " ", " = null;\n         |if (!", ") {\n         |  final int ", " = ", ";\n         |  ", " ", " = false;\n         |  ", " = null;\n         |  do {\n         |    ", "\n         |  } while (false);\n         |  ", "\n         |  ", " = ", ";\n         |  ", " = ", " == null;\n         |}\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{index.code(), ev.isNull(), index.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), index.isNull(), indexVal, index.value(), "boolean", indexMatched, inputVal, codes, indexOutOfBoundBranch, ev.value(), inputVal, ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public Elt withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        return this.failOnError() ? new Some((Object)this.origin().context()) : None$.MODULE$;
    }

    public Elt copy(Seq<Expression> children2, boolean failOnError) {
        return new Elt(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Elt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Elt;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            case 1: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Elt)) return false;
        boolean bl = true;
        if (!bl) return false;
        Elt elt = (Elt)x$1;
        if (this.failOnError() != elt.failOnError()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = elt.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!elt.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(DataType tpe) {
        return !package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, BinaryType$.MODULE$})).contains((Object)tpe);
    }

    public Elt(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
        SupportQueryContext.$init$(this);
    }

    public Elt(Seq<Expression> children2) {
        this(children2, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

