/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function4;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, regexp, rep[, position]) - Replaces all substrings of `str` that match `regexp` with `rep`.", arguments="\n    Arguments:\n      * str - a string expression to search for a regular expression pattern match.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * rep - a string expression to replace matched substrings.\n      * position - a positive integer literal that indicates the position within `str` to begin searching.\n          The default is 1. If position is greater than the number of characters in `str`, the result is `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)', 'num');\n       num-num\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\r5a\u0001\u0002\u001d:\u0001\u001aC\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\tW\u0002\u0011\t\u0012)A\u0005Q\"AA\u000e\u0001BK\u0002\u0013\u0005q\r\u0003\u0005n\u0001\tE\t\u0015!\u0003i\u0011!q\u0007A!f\u0001\n\u00039\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00025\t\u0011A\u0004!Q3A\u0005\u0002\u001dD\u0001\"\u001d\u0001\u0003\u0012\u0003\u0006I\u0001\u001b\u0005\u0006e\u0002!\ta\u001d\u0005\u0006e\u0002!\t!\u001f\u0005\u0006{\u0002!\tE \u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0001C\u0006\u0002 \u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0002bCA\u0017\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001fA1\"a\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002:!Y\u0011q\n\u0001A\u0002\u0003\u0007I\u0011BA)\u0011-\t)\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u000f\t\u0017\u0005e\u0003\u00011AA\u0002\u0013%\u00111\f\u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0007C\u0006\u0002t\u0001\u0001\r\u0011!Q!\n\u0005u\u0003bCA<\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bA1\"!\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002|!Y\u0011q\u0010\u0001A\u0002\u0003\u0005\u000b\u0015BA\b\u0011)\t\u0019\t\u0001EC\u0002\u0013%\u0011Q\u0011\u0005\n\u0003+\u0003!\u0019!C#\u0003/C\u0001\"!3\u0001A\u00035\u0011\u0011\u0014\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011\u001d\t)\u000f\u0001C!\u0003ODq!a=\u0001\t\u0003\n)\u0010C\u0004\u0002\u0000\u0002!\t%a\u0017\t\u000f\t\u0005\u0001\u0001\"\u0015\u0003\u0004!1!q\u0004\u0001\u0005B\u001dDaA!\t\u0001\t\u0003:\u0007B\u0002B\u0012\u0001\u0011\u0005s\r\u0003\u0004\u0003&\u0001!\te\u001a\u0005\b\u0005O\u0001A\u0011\u000bB\u0015\u0011%\u0011\u0019\u0004AA\u0001\n\u0003\u0011)\u0004C\u0005\u0003@\u0001\t\n\u0011\"\u0001\u0003B!I!q\u000b\u0001\u0012\u0002\u0013\u0005!\u0011\t\u0005\n\u00053\u0002\u0011\u0013!C\u0001\u0005\u0003B\u0011Ba\u0017\u0001#\u0003%\tA!\u0011\t\u0013\tu\u0003!!A\u0005B\t}\u0003\"\u0003B3\u0001\u0005\u0005I\u0011\u0001B4\u0011%\u0011y\u0007AA\u0001\n\u0003\u0011\t\bC\u0005\u0003v\u0001\t\t\u0011\"\u0011\u0003x!I!Q\u0011\u0001\u0002\u0002\u0013\u0005!q\u0011\u0005\n\u0005#\u0003\u0011\u0011!C!\u0005'C\u0011Ba&\u0001\u0003\u0003%\tE!'\b\u000f\t\r\u0017\b#\u0001\u0003F\u001a1\u0001(\u000fE\u0001\u0005\u000fDaA\u001d\u001a\u0005\u0002\te\u0007b\u0002Bne\u0011\u0005!Q\u001c\u0005\n\u00057\u0014\u0014\u0011!CA\u0005KD\u0011Ba<3\u0003\u0003%\tI!=\t\u0013\r\r!'!A\u0005\n\r\u0015!!\u0004*fO\u0016C\bOU3qY\u0006\u001cWM\u0003\u0002;w\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taT(\u0001\u0005dCR\fG._:u\u0015\tqt(A\u0002tc2T!\u0001Q!\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001b\u0015AB1qC\u000eDWMC\u0001E\u0003\ry'oZ\u0002\u0001'\u0019\u0001qi\u0013(V7B\u0011\u0001*S\u0007\u0002s%\u0011!*\u000f\u0002\u0015#V\fG/\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005!c\u0015BA':\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA(S\u001d\tA\u0005+\u0003\u0002Rs\u00059\u0001/Y2lC\u001e,\u0017BA*U\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!!U\u001d\u0011\u0005YKV\"A,\u000b\u0003a\u000bQa]2bY\u0006L!AW,\u0003\u000fA\u0013x\u000eZ;diB\u0011Al\u0019\b\u0003;\nt!AX1\u000e\u0003}S!\u0001Y#\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0016BA)X\u0013\t!WM\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002R/\u000691/\u001e2kK\u000e$X#\u00015\u0011\u0005!K\u0017B\u00016:\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\tgV\u0014'.Z2uA\u00051!/Z4fqB\fqA]3hKb\u0004\b%A\u0002sKB\fAA]3qA\u0005\u0019\u0001o\\:\u0002\tA|7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bQ,ho\u001e=\u0011\u0005!\u0003\u0001\"\u00024\n\u0001\u0004A\u0007\"\u00027\n\u0001\u0004A\u0007\"\u00028\n\u0001\u0004A\u0007\"\u00029\n\u0001\u0004AG\u0003\u0002;{wrDQA\u001a\u0006A\u0002!DQ\u0001\u001c\u0006A\u0002!DQA\u001c\u0006A\u0002!\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u001e\u0002\u0011\u0005t\u0017\r\\=tSNLA!!\u0003\u0002\u0004\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\u0005mCN$(+Z4fqV\u0011\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0015!\u0018\u0010]3t\u0015\r\tIbP\u0001\u0007k:\u001c\u0018MZ3\n\t\u0005u\u00111\u0003\u0002\u000b+R3\u0005h\u0015;sS:<\u0017!\u00047bgR\u0014VmZ3y?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005%\u0002c\u0001,\u0002&%\u0019\u0011qE,\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003Wi\u0011\u0011!a\u0001\u0003\u001f\t1\u0001\u001f\u00132\u0003)a\u0017m\u001d;SK\u001e,\u0007\u0010\t\u0015\u0004\u001d\u0005E\u0002c\u0001,\u00024%\u0019\u0011QG,\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00029biR,'O\\\u000b\u0003\u0003w\u0001B!!\u0010\u0002L5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0003sK\u001e,\u0007P\u0003\u0003\u0002F\u0005\u001d\u0013\u0001B;uS2T!!!\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\nyDA\u0004QCR$XM\u001d8\u0002\u0017A\fG\u000f^3s]~#S-\u001d\u000b\u0005\u0003G\t\u0019\u0006C\u0005\u0002,A\t\t\u00111\u0001\u0002<\u0005A\u0001/\u0019;uKJt\u0007\u0005K\u0002\u0012\u0003c\tq\u0002\\1tiJ+\u0007\u000f\\1dK6,g\u000e^\u000b\u0003\u0003;\u0002B!a\u0018\u0002h9!\u0011\u0011MA2!\tqv+C\u0002\u0002f]\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA5\u0003W\u0012aa\u0015;sS:<'bAA3/\u0006\u0019B.Y:u%\u0016\u0004H.Y2f[\u0016tGo\u0018\u0013fcR!\u00111EA9\u0011%\tYcEA\u0001\u0002\u0004\ti&\u0001\tmCN$(+\u001a9mC\u000e,W.\u001a8uA!\u001aA#!\r\u0002+1\f7\u000f\u001e*fa2\f7-Z7f]RLe.\u0016+Gq\u0005IB.Y:u%\u0016\u0004H.Y2f[\u0016tG/\u00138V)\u001aCt\fJ3r)\u0011\t\u0019#! \t\u0013\u0005-b#!AA\u0002\u0005=\u0011A\u00067bgR\u0014V\r\u001d7bG\u0016lWM\u001c;J]V#f\t\u000f\u0011)\u0007]\t\t$\u0001\u0004sKN,H\u000e^\u000b\u0003\u0003\u000f\u0003B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000b9%\u0001\u0003mC:<\u0017\u0002BAI\u0003\u0017\u0013Ab\u0015;sS:<')\u001e4gKJD3\u0001GA\u0019\u00031qw\u000eZ3QCR$XM\u001d8t+\t\tI\nE\u0003]\u00037\u000by*C\u0002\u0002\u001e\u0016\u00141aU3r!\u0011\t\t+a1\u000f\t\u0005\r\u0016Q\u0018\b\u0005\u0003K\u000bIL\u0004\u0003\u0002(\u0006]f\u0002BAU\u0003ksA!a+\u00024:!\u0011QVAY\u001d\rq\u0016qV\u0005\u0002\t&\u0011!iQ\u0005\u0003\u0001\u0006K!AP \n\u0005qj\u0014bAA^w\u0005)AO]3fg&!\u0011qXAa\u0003-!&/Z3QCR$XM\u001d8\u000b\u0007\u0005m6(\u0003\u0003\u0002F\u0006\u001d'a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:TA!a0\u0002B\u0006ian\u001c3f!\u0006$H/\u001a:og\u0002\nAB\\;mYN\u000bg-Z#wC2$\"\"a4\u0002V\u0006e\u0017Q\\Aq!\r1\u0016\u0011[\u0005\u0004\u0003'<&aA!os\"9\u0011q[\u000eA\u0002\u0005=\u0017!A:\t\u000f\u0005m7\u00041\u0001\u0002P\u0006\t\u0001\u000fC\u0004\u0002`n\u0001\r!a4\u0002\u0003IDq!a9\u001c\u0001\u0004\ty-A\u0001j\u0003!!\u0017\r^1UsB,WCAAu!\u0011\tY/a<\u000e\u0005\u00055(bAA\u000b{%!\u0011\u0011_Aw\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\u0011\u0011q\u001f\t\u00069\u0006m\u0015\u0011 \t\u0005\u0003W\fY0\u0003\u0003\u0002~\u00065(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u0001\nI><UM\\\"pI\u0016$bA!\u0002\u0003\u0012\tm\u0001\u0003\u0002B\u0004\u0005\u001bi!A!\u0003\u000b\u0007\t-\u0011(A\u0004d_\u0012,w-\u001a8\n\t\t=!\u0011\u0002\u0002\t\u000bb\u0004(oQ8eK\"9!1C\u0010A\u0002\tU\u0011aA2uqB!!q\u0001B\f\u0013\u0011\u0011IB!\u0003\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9!QD\u0010A\u0002\t\u0015\u0011AA3w\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u00061am\\;si\"\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0013Q\u0014YC!\f\u00030\tE\u0002B\u0002B\u0010I\u0001\u0007\u0001\u000e\u0003\u0004\u0003\"\u0011\u0002\r\u0001\u001b\u0005\u0007\u0005G!\u0003\u0019\u00015\t\r\t\u0015B\u00051\u0001i\u0003\u0011\u0019w\u000e]=\u0015\u0013Q\u00149D!\u000f\u0003<\tu\u0002b\u00024&!\u0003\u0005\r\u0001\u001b\u0005\bY\u0016\u0002\n\u00111\u0001i\u0011\u001dqW\u0005%AA\u0002!Dq\u0001]\u0013\u0011\u0002\u0003\u0007\u0001.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\r#f\u00015\u0003F-\u0012!q\t\t\u0005\u0005\u0013\u0012\u0019&\u0004\u0002\u0003L)!!Q\nB(\u0003%)hn\u00195fG.,GMC\u0002\u0003R]\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Fa\u0013\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003bA!\u0011\u0011\u0012B2\u0013\u0011\tI'a#\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t%\u0004c\u0001,\u0003l%\u0019!QN,\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005='1\u000f\u0005\n\u0003Wa\u0013\u0011!a\u0001\u0005S\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005s\u0002bAa\u001f\u0003\u0002\u0006=WB\u0001B?\u0015\r\u0011yhV\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BB\u0005{\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!\u0011\u0012BH!\r1&1R\u0005\u0004\u0005\u001b;&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003Wq\u0013\u0011!a\u0001\u0003\u001f\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011\rBK\u0011%\tYcLA\u0001\u0002\u0004\u0011I'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u0013\u0013Y\nC\u0005\u0002,A\n\t\u00111\u0001\u0002P\":\u0002Aa(\u0003&\n\u001d&1\u0016BW\u0005c\u0013\u0019La.\u0003:\nu&q\u0018\t\u0004\u0011\n\u0005\u0016b\u0001BRs\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001BU\u0003\u001d|f)\u0016(D?\"\u001aHO\u001d\u0017!e\u0016<W\r\u001f9-AI,\u0007o\u0017\u0017!a>\u001c\u0018\u000e^5p]vK\u0003%\f\u0011SKBd\u0017mY3tA\u0005dG\u000eI:vEN$(/\u001b8hg\u0002zg\r\t1tiJ\u0004\u0007\u0005\u001e5bi\u0002j\u0017\r^2iA\u0001\u0014XmZ3ya\u0002\u0004s/\u001b;iA\u0001\u0014X\r\u001d1/\u0003%\t'oZ;nK:$8/\t\u0002\u00030\u00069\u0019N\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|g\u000e\t;pAM,\u0017M]2iA\u0019|'\u000fI1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|g\u000e\t9biR,'O\u001c\u0011nCR\u001c\u0007N\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!e\u0016<W\r\u001f9![\u0001\n\u0007e\u001d;sS:<\u0007E]3qe\u0016\u001cXM\u001c;j]\u001e\u0004\u0013\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:t\u0003\u0005\u00165fAI,w-\u001a=!gR\u0014\u0018N\\4!g\"|W\u000f\u001c3!E\u0016\u0004\u0013M\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A)\u000bg/\u0019\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>tg\u0006\u00102s}q\u0012'O\u0010\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001a\u0016N\\2fAM\u0003\u0018M]6!e9\u0002D\u0006I:ue&tw\r\t7ji\u0016\u0014\u0018\r\\:!Q%t7\r\\;eS:<\u0007E]3hKb\u0004\u0003/\u0019;uKJt7/\u000b\u0011be\u0016\u0004SO\\3tG\u0006\u0004X\r\u001a\u0011j]\u0002zWO\u001d\u0011T#2S\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011qCJ\u001cXM\u001d\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011u_\u0002j\u0017\r^2iA\tb\u0016MY2#Y\u0001\n\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]\u00022wN\u001d\u0011ae\u0016<W\r\u001f9aA\r\fg\u000e\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003E\t0]9\u0006\u00147\r\n\u0012/y\t\u0014h\b\u00102s})\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t+iKJ,\u0007%[:!C\u0002\u001a\u0016\u000b\u0014\u0011d_:4\u0017n\u001a\u0011(gB\f'o\u001b\u0018tc2t\u0003/\u0019:tKJtSm]2ba\u0016$7\u000b\u001e:j]\u001ed\u0015\u000e^3sC2\u001cx\u0005\t;iCR\u00043-\u00198!E\u0016\u0004So]3eAQ|'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!M\u0006dGNY1dW\u0002\"x\u000e\t;iK\u0002\u001a\u0006/\u0019:lAErc\u0007\t2fQ\u00064\u0018n\u001c:!e\u0016<\u0017M\u001d3j]\u001e\u00043\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d\u0007\u0005]1sg&twM\f\u0011G_J\u0004S\r_1na2,GF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A%4\u0007\u0005\u001e5fA\r|gNZ5hA%\u001c\b%\u001a8bE2,G\r\f\u0011uQ\u0016\u0004\u0003M]3hKb\u0004\b\r\t;iCR\u00043-\u00198![\u0006$8\r\u001b\u0011#9\u0006\u00147M\t\u0011jg\u0002\u0012c\fX1cG\u0012\u0012cF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011sKB\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t\u0007\u0005^8!e\u0016\u0004H.Y2fA5\fGo\u00195fI\u0002\u001aXOY:ue&twm\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AA|7/\u001b;j_:\u0004S\u0006I1!a>\u001c\u0018\u000e^5wK\u0002Jg\u000e^3hKJ\u0004C.\u001b;fe\u0006d\u0007\u0005\u001e5bi\u0002Jg\u000eZ5dCR,7\u000f\t;iK\u0002\u0002xn]5uS>t\u0007e^5uQ&t\u0007\u0005Y:ue\u0002\u0004Co\u001c\u0011cK\u001eLg\u000eI:fCJ\u001c\u0007.\u001b8h])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t+iK\u0002\"WMZ1vYR\u0004\u0013n\u001d\u00112]\u0001Je\r\t9pg&$\u0018n\u001c8!SN\u0004sM]3bi\u0016\u0014\b\u0005\u001e5b]\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011j]\u0002\u00027\u000f\u001e:aY\u0001\"\b.\u001a\u0011sKN,H\u000e\u001e\u0011jg\u0002\u00027\u000f\u001e:a])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011),A*\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n\u0004\u0007M\u00173aA:C\u0006I\u0014)9r#7&K\u0014-A\u001drW/\\\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001rW/\\\u0017ok6T\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0005w\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#A!1\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u001bI+w-\u0012=q%\u0016\u0004H.Y2f!\tA%gE\u00033\u0005\u0013\u0014y\rE\u0002W\u0005\u0017L1A!4X\u0005\u0019\te.\u001f*fMB!!\u0011\u001bBl\u001b\t\u0011\u0019N\u0003\u0003\u0003V\u0006\u001d\u0013AA5p\u0013\r!'1\u001b\u000b\u0003\u0005\u000b\fQ!\u00199qYf$r\u0001\u001eBp\u0005C\u0014\u0019\u000fC\u0003gi\u0001\u0007\u0001\u000eC\u0003mi\u0001\u0007\u0001\u000eC\u0003oi\u0001\u0007\u0001\u000eF\u0005u\u0005O\u0014IOa;\u0003n\")a-\u000ea\u0001Q\")A.\u000ea\u0001Q\")a.\u000ea\u0001Q\")\u0001/\u000ea\u0001Q\u00069QO\\1qa2LH\u0003\u0002Bz\u0005\u007f\u0004RA\u0016B{\u0005sL1Aa>X\u0005\u0019y\u0005\u000f^5p]B9aKa?iQ\"D\u0017b\u0001B\u007f/\n1A+\u001e9mKRB\u0001b!\u00017\u0003\u0003\u0005\r\u0001^\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAB\u0004!\u0011\tIi!\u0003\n\t\r-\u00111\u0012\u0002\u0007\u001f\nTWm\u0019;")
public class RegExpReplace
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private transient StringBuffer result;
    private final Expression subject;
    private final Expression regexp;
    private final Expression rep;
    private final Expression pos;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;
    private transient String lastReplacement;
    private transient UTF8String lastReplacementInUTF8;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(RegExpReplace x$0) {
        return RegExpReplace$.MODULE$.unapply(x$0);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression rep() {
        return this.rep;
    }

    public Expression pos() {
        return this.pos;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!this.pos().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"position"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType(this.pos().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(this.pos()))}))));
        }
        Object posEval = this.pos().eval(this.pos().eval$default$1());
        return posEval == null || BoxesRunTime.unboxToInt((Object)posEval) > 0 ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"position"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)new StringBuilder(25).append("(0, ").append(Integer.MAX_VALUE).append("]").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Cast$.MODULE$.toSQLValue(posEval, this.pos().dataType()))}))));
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    private String lastReplacement() {
        return this.lastReplacement;
    }

    private void lastReplacement_$eq(String x$1) {
        this.lastReplacement = x$1;
    }

    private UTF8String lastReplacementInUTF8() {
        return this.lastReplacementInUTF8;
    }

    private void lastReplacementInUTF8_$eq(UTF8String x$1) {
        this.lastReplacementInUTF8 = x$1;
    }

    private StringBuffer result$lzycompute() {
        RegExpReplace regExpReplace = this;
        synchronized (regExpReplace) {
            if (!this.bitmap$trans$0) {
                this.result = new StringBuffer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.result;
    }

    private StringBuffer result() {
        return !this.bitmap$trans$0 ? this.result$lzycompute() : this.result;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r, Object i) {
        Object object;
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            try {
                this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
            }
            catch (PatternSyntaxException e) {
                throw QueryExecutionErrors$.MODULE$.invalidPatternError(this.prettyName(), e.getPattern(), e);
            }
        }
        if (!r.equals(this.lastReplacementInUTF8())) {
            this.lastReplacementInUTF8_$eq(((UTF8String)r).clone());
            this.lastReplacement_$eq(this.lastReplacementInUTF8().toString());
        }
        String source = s.toString();
        int position = BoxesRunTime.unboxToInt((Object)i) - 1;
        if (position == 0 || position < source.length()) {
            Matcher m = this.pattern().matcher(source);
            m.region(position, source.length());
            this.result().delete(0, this.result().length());
            while (m.find()) {
                m.appendReplacement(this.result(), this.lastReplacement());
            }
            m.appendTail(this.result());
            object = UTF8String.fromString((String)this.result().toString());
        } else {
            object = s;
        }
        return object;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public String prettyName() {
        return "regexp_replace";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String termResult = ctx.freshName("termResult");
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameStringBuffer = StringBuffer.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String source = ctx.freshName("source");
        String position = ctx.freshName("position");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacement = ctx.addMutableState("String", "lastReplacement", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacementInUTF8 = ctx.addMutableState("UTF8String", "lastReplacementInUTF8", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable)(subject, regexp, rep, pos) -> new StringBuilder(787).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        try {\n          ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n        } catch (java.util.regex.PatternSyntaxException e) {\n          throw QueryExecutionErrors.invalidPatternError(\"").append(this.prettyName()).append("\", e.getPattern(), e);\n        }\n      }\n      if (!").append((String)rep).append(".equals(").append(termLastReplacementInUTF8).append(")) {\n        // replacement string changed\n        ").append(termLastReplacementInUTF8).append(" = ").append((String)rep).append(".clone();\n        ").append(termLastReplacement).append(" = ").append(termLastReplacementInUTF8).append(".toString();\n      }\n      String ").append(source).append(" = ").append((String)subject).append(".toString();\n      int ").append(position).append(" = ").append((String)pos).append(" - 1;\n      if (").append(position).append(" == 0 || ").append(position).append(" < ").append(source).append(".length()) {\n        ").append(classNameStringBuffer).append(" ").append(termResult).append(" = new ").append(classNameStringBuffer).append("();\n        java.util.regex.Matcher ").append(matcher).append(" = ").append(termPattern).append(".matcher(").append(source).append(");\n        ").append(matcher).append(".region(").append(position).append(", ").append(source).append(".length());\n\n        while (").append(matcher).append(".find()) {\n          ").append(matcher).append(".appendReplacement(").append(termResult).append(", ").append(termLastReplacement).append(");\n        }\n        ").append(matcher).append(".appendTail(").append(termResult).append(");\n        ").append(ev.value()).append(" = UTF8String.fromString(").append(termResult).append(".toString());\n        ").append(termResult).append(" = null;\n      } else {\n        ").append(ev.value()).append(" = ").append((String)subject).append(";\n      }\n      ").append(setEvNotNull).append("\n    ").toString());
    }

    @Override
    public Expression first() {
        return this.subject();
    }

    @Override
    public Expression second() {
        return this.regexp();
    }

    @Override
    public Expression third() {
        return this.rep();
    }

    @Override
    public Expression fourth() {
        return this.pos();
    }

    @Override
    public RegExpReplace withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public RegExpReplace copy(Expression subject, Expression regexp, Expression rep, Expression pos) {
        return new RegExpReplace(subject, regexp, rep, pos);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.rep();
    }

    public Expression copy$default$4() {
        return this.pos();
    }

    @Override
    public String productPrefix() {
        return "RegExpReplace";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.subject();
                break;
            }
            case 1: {
                object = this.regexp();
                break;
            }
            case 2: {
                object = this.rep();
                break;
            }
            case 3: {
                object = this.pos();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpReplace;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "subject";
                break;
            }
            case 1: {
                string = "regexp";
                break;
            }
            case 2: {
                string = "rep";
                break;
            }
            case 3: {
                string = "pos";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpReplace regExpReplace = (RegExpReplace)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpReplace.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpReplace.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.rep();
        Expression expression6 = regExpReplace.rep();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.pos();
        Expression expression8 = regExpReplace.pos();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!regExpReplace.canEqual(this)) return false;
        return true;
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep, Expression pos) {
        this.subject = subject;
        this.regexp = regexp;
        this.rep = rep;
        this.pos = pos;
        ExpectsInputTypes.$init$(this);
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.REGEXP_REPLACE()}));
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep) {
        this(subject, regexp, rep, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

