/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class JacksonUtils$
implements QueryErrorsBase {
    public static final JacksonUtils$ MODULE$ = new JacksonUtils$();

    static {
        QueryErrorsBase.$init$(MODULE$);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    public boolean nextUntil(JsonParser parser, JsonToken stopOn) {
        boolean bl;
        JsonToken jsonToken = parser.nextToken();
        if (jsonToken == null) {
            bl = false;
        } else {
            JsonToken jsonToken2 = jsonToken;
            JsonToken jsonToken3 = stopOn;
            bl = jsonToken2 == null ? jsonToken3 != null : !jsonToken2.equals(jsonToken3);
        }
        return bl;
    }

    public TypeCheckResult verifyType(String name, DataType dataType) {
        TypeCheckResult typeCheckResult;
        block5: {
            while (true) {
                DataType dataType2;
                boolean bl;
                if (bl = NullType$.MODULE$.equals(dataType2 = dataType) ? true : (dataType2 instanceof AtomicType ? true : CalendarIntervalType$.MODULE$.equals(dataType2))) {
                    typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                    break block5;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    typeCheckResult = structType.foldLeft(TypeCheckResult$TypeCheckSuccess$.MODULE$, (Function2 & Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        TypeCheckResult currResult = (TypeCheckResult)tuple2._1();
                        StructField field = (StructField)tuple2._2();
                        TypeCheckResult typeCheckResult = currResult.isFailure() ? currResult : MODULE$.verifyType(field.name(), field.dataType());
                        return typeCheckResult;
                    });
                    break block5;
                }
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = arrayType.elementType();
                    continue;
                }
                if (dataType2 instanceof MapType) {
                    MapType mapType = (MapType)dataType2;
                    dataType = mapType.valueType();
                    continue;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
            }
            typeCheckResult = new TypeCheckResult.DataTypeMismatch("CANNOT_CONVERT_TO_JSON", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)this.toSQLType(dataType))}))));
        }
        return typeCheckResult;
    }

    private JacksonUtils$() {
    }
}

