/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayInsert$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(x, pos, val) - Places val into index pos of array x.\n      Array indices start at 1. The maximum negative index is -1 for which the function inserts\n      new element after the current last element.\n      Index above array size appends the array, or prepends the array if index is negative,\n      with 'null' elements.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, 4), 5, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(array(5, 4, 3, 2), -1, 1);\n       [5,4,3,2,1]\n      > SELECT _FUNC_(array(5, 3, 2, 1), -4, 4);\n       [5,4,3,2,1]\n  ", group="array_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\tMe\u0001\u0002\u0017.\u0001jB\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tK\u0002\u0011\t\u0012)A\u0005E\"Aa\r\u0001BK\u0002\u0013\u0005\u0011\r\u0003\u0005h\u0001\tE\t\u0015!\u0003c\u0011!A\u0007A!f\u0001\n\u0003\t\u0007\u0002C5\u0001\u0005#\u0005\u000b\u0011\u00022\t\u0011)\u0004!Q3A\u0005\u0002-D\u0001b\u001c\u0001\u0003\u0012\u0003\u0006I\u0001\u001c\u0005\u0006a\u0002!\t!\u001d\u0005\u0006a\u0002!\ta\u001e\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!a\r\u0001\t\u0003\n)\u0004C\u0004\u0002D\u0001!\t%!\u0012\t\r\u0005\u0005\u0004\u0001\"\u0011b\u0011\u0019\t\u0019\u0007\u0001C!C\"1\u0011Q\r\u0001\u0005B\u0005Dq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002|\u0001!\t%! \t\r\u0005\u0015\u0005\u0001\"\u0011l\u0011)\t9\t\u0001EC\u0002\u0013%\u0011Q\u0010\u0005\b\u0003#\u0003A\u0011KAJ\u0011\u001d\t\t\u000b\u0001C!\u0003GC\u0011\"a.\u0001\u0003\u0003%\t!!/\t\u0013\u0005\r\u0007!%A\u0005\u0002\u0005\u0015\u0007\"CAn\u0001E\u0005I\u0011AAc\u0011%\ti\u000eAI\u0001\n\u0003\t)\rC\u0005\u0002`\u0002\t\n\u0011\"\u0001\u0002b\"I\u0011Q\u001d\u0001\u0002\u0002\u0013\u0005\u0013q\u001d\u0005\n\u0003o\u0004\u0011\u0011!C\u0001\u0003sD\u0011B!\u0001\u0001\u0003\u0003%\tAa\u0001\t\u0013\t%\u0001!!A\u0005B\t-\u0001\"\u0003B\r\u0001\u0005\u0005I\u0011\u0001B\u000e\u0011%\u0011y\u0002AA\u0001\n\u0003\u0012\t\u0003C\u0005\u0003&\u0001\t\t\u0011\"\u0011\u0003(\u001dI!1J\u0017\u0002\u0002#\u0005!Q\n\u0004\tY5\n\t\u0011#\u0001\u0003P!1\u0001O\nC\u0001\u0005OB\u0011B!\u001b'\u0003\u0003%)Ea\u001b\t\u0013\t5d%!A\u0005\u0002\n=\u0004\"\u0003B=M\u0005\u0005I\u0011\u0011B>\u0011%\u0011IIJA\u0001\n\u0013\u0011YIA\u0006BeJ\f\u00170\u00138tKJ$(B\u0001\u00180\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005A\n\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005I\u001a\u0014aA:rY*\u0011A'N\u0001\u0006gB\f'o\u001b\u0006\u0003m]\na!\u00199bG\",'\"\u0001\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0011\u0001YtHQ#L\u001dR\u0003\"\u0001P\u001f\u000e\u00035J!AP\u0017\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002=\u0001&\u0011\u0011)\f\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011AhQ\u0005\u0003\t6\u0012AdQ8na2,\u0007\u0010V=qK6+'oZ5oO\u0016C\bO]3tg&|g\u000e\u0005\u0002G\u00136\tqI\u0003\u0002Ic\u00051QM\u001d:peNL!AS$\u0003\u001fE+XM]=FeJ|'o\u001d\"bg\u0016\u0004\"\u0001\u0010'\n\u00055k#aE*vaB|'\u000f^)vKJL8i\u001c8uKb$\bCA(S\u001b\u0005\u0001&\"A)\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0003&a\u0002)s_\u0012,8\r\u001e\t\u0003+vs!AV.\u000f\u0005]SV\"\u0001-\u000b\u0005eK\u0014A\u0002\u001fs_>$h(C\u0001R\u0013\ta\u0006+A\u0004qC\u000e\\\u0017mZ3\n\u0005y{&\u0001D*fe&\fG.\u001b>bE2,'B\u0001/Q\u00031\u0019(oY!se\u0006LX\t\u001f9s+\u0005\u0011\u0007C\u0001\u001fd\u0013\t!WF\u0001\u0006FqB\u0014Xm]:j_:\fQb\u001d:d\u0003J\u0014\u0018-_#yaJ\u0004\u0013a\u00029pg\u0016C\bO]\u0001\ta>\u001cX\t\u001f9sA\u0005A\u0011\u000e^3n\u000bb\u0004(/A\u0005ji\u0016lW\t\u001f9sA\u0005\u0019B.Z4bGftUmZ1uSZ,\u0017J\u001c3fqV\tA\u000e\u0005\u0002P[&\u0011a\u000e\u0015\u0002\b\u0005>|G.Z1o\u0003QaWmZ1ds:+w-\u0019;jm\u0016Le\u000eZ3yA\u00051A(\u001b8jiz\"RA]:ukZ\u0004\"\u0001\u0010\u0001\t\u000b\u0001L\u0001\u0019\u00012\t\u000b\u0019L\u0001\u0019\u00012\t\u000b!L\u0001\u0019\u00012\t\u000b)L\u0001\u0019\u00017\u0015\tID\u0018P\u001f\u0005\u0006A*\u0001\rA\u0019\u0005\u0006M*\u0001\rA\u0019\u0005\u0006Q*\u0001\rAY\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A?\u0011\tUs\u0018\u0011A\u0005\u0003\u007f~\u00131aU3r!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004c\u0005)A/\u001f9fg&!\u00111BA\u0003\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018=\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u00037\t)BA\bUsB,7\t[3dWJ+7/\u001e7u\u0003\u0011)g/\u00197\u0015\t\u0005\u0005\u0012q\u0005\t\u0004\u001f\u0006\r\u0012bAA\u0013!\n\u0019\u0011I\\=\t\u0013\u0005%R\u0002%AA\u0002\u0005-\u0012!B5oaV$\b\u0003BA\u0017\u0003_i\u0011aL\u0005\u0004\u0003cy#aC%oi\u0016\u0014h.\u00197S_^\fAB\\;mYN\u000bg-Z#wC2$\u0002\"!\t\u00028\u0005m\u0012q\b\u0005\b\u0003sq\u0001\u0019AA\u0011\u0003\r\t'O\u001d\u0005\b\u0003{q\u0001\u0019AA\u0011\u0003\r\u0001xn\u001d\u0005\b\u0003\u0003r\u0001\u0019AA\u0011\u0003\u0011IG/Z7\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA$\u0003'\ni\u0006\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\ti%L\u0001\bG>$WmZ3o\u0013\u0011\t\t&a\u0013\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\u0016\u0010\u0001\u0004\t9&A\u0002dib\u0004B!!\u0013\u0002Z%!\u00111LA&\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\u0018\u0010\u0001\u0004\t9%\u0001\u0002fm\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\f!\u0002\u001d:fiRLh*Y7f+\t\tY\u0007\u0005\u0003\u0002n\u0005Ud\u0002BA8\u0003c\u0002\"a\u0016)\n\u0007\u0005M\u0004+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\nIH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g\u0002\u0016\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005}\u0004\u0003BA\u0002\u0003\u0003KA!a!\u0002\u0006\tAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f\u0003-)G.Z7f]R$\u0016\u0010]3)\u0007Y\tY\tE\u0002P\u0003\u001bK1!a$Q\u0005%!(/\u00198tS\u0016tG/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR9!/!&\u0002\u001a\u0006u\u0005BBAL/\u0001\u0007!-A\boK^\u001c&oY!se\u0006LX\t\u001f9s\u0011\u0019\tYj\u0006a\u0001E\u0006Qa.Z<Q_N,\u0005\u0010\u001d:\t\r\u0005}u\u00031\u0001c\u0003-qWm^%uK6,\u0005\u0010\u001d:\u0002!%t\u0017\u000e^)vKJL8i\u001c8uKb$HCAAS!\u0015y\u0015qUAV\u0013\r\tI\u000b\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u00055\u00161W\u0007\u0003\u0003_S1!!-0\u0003\u0015!(/Z3t\u0013\u0011\t),a,\u0003\u001fM\u000bF*U;fef\u001cuN\u001c;fqR\fAaY8qsRI!/a/\u0002>\u0006}\u0016\u0011\u0019\u0005\bAf\u0001\n\u00111\u0001c\u0011\u001d1\u0017\u0004%AA\u0002\tDq\u0001[\r\u0011\u0002\u0003\u0007!\rC\u0004k3A\u0005\t\u0019\u00017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0019\u0016\u0004E\u0006%7FAAf!\u0011\ti-a6\u000e\u0005\u0005='\u0002BAi\u0003'\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U\u0007+\u0001\u0006b]:|G/\u0019;j_:LA!!7\u0002P\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003GT3\u0001\\Ae\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u001e\t\u0005\u0003W\f)0\u0004\u0002\u0002n*!\u0011q^Ay\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0018\u0001\u00026bm\u0006LA!a\u001e\u0002n\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111 \t\u0004\u001f\u0006u\u0018bAA\u0000!\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011\u0005B\u0003\u0011%\u00119\u0001IA\u0001\u0002\u0004\tY0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u001b\u0001bAa\u0004\u0003\u0016\u0005\u0005RB\u0001B\t\u0015\r\u0011\u0019\u0002U\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\f\u0005#\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019AN!\b\t\u0013\t\u001d!%!AA\u0002\u0005\u0005\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!;\u0003$!I!qA\u0012\u0002\u0002\u0003\u0007\u00111`\u0001\u0007KF,\u0018\r\\:\u0015\u00071\u0014I\u0003C\u0005\u0003\b\u0011\n\t\u00111\u0001\u0002\"!\u001a\u0002A!\f\u00034\tU\"\u0011\bB\u001e\u0005\u007f\u0011\tE!\u0012\u0003HA\u0019AHa\f\n\u0007\tERFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t]\u0012Aa'\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006\u001f\u0017!a>\u001cH\u0006\t<bY&\u0002S\u0006\t)mC\u000e,7\u000f\t<bY\u0002Jg\u000e^8!S:$W\r\u001f\u0011q_N\u0004sN\u001a\u0011beJ\f\u0017\u0010\t=/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0003J\u0014\u0018-\u001f\u0011j]\u0012L7-Z:!gR\f'\u000f\u001e\u0011bi\u0002\nd\u0006\t+iK\u0002j\u0017\r_5nk6\u0004c.Z4bi&4X\rI5oI\u0016D\b%[:![E\u0002cm\u001c:!o\"L7\r\u001b\u0011uQ\u0016\u0004c-\u001e8di&|g\u000eI5og\u0016\u0014Ho\u001d\u0006!A\u0001\u0002\u0003\u0005\t8fo\u0002*G.Z7f]R\u0004\u0013M\u001a;fe\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!Y\u0006\u001cH\u000fI3mK6,g\u000e\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011J]\u0012,\u0007\u0010I1c_Z,\u0007%\u0019:sCf\u00043/\u001b>fA\u0005\u0004\b/\u001a8eg\u0002\"\b.\u001a\u0011beJ\f\u0017\u0010\f\u0011pe\u0002\u0002(/\u001a9f]\u0012\u001c\b\u0005\u001e5fA\u0005\u0014(/Y=!S\u001a\u0004\u0013N\u001c3fq\u0002J7\u000f\t8fO\u0006$\u0018N^3-\u0015\u0001\u0002\u0003\u0005\t\u0011!o&$\b\u000eI\u0014ok2dw\u0005I3mK6,g\u000e^:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tu\u0012!!/\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c1\u0002#\u0007\f\u00114Y\u0001\"\u0014\u0006\f\u00116Y\u0001*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012Df\r\u00175YUj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\u000e\u0017!i1\u00023\u0007\f\u00113S1\u0002S&\r\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u001b-i1\u001aDF\r\u00172;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"*D\u0006I\u001a-AIb\u0003%M\u0015-A5\"D\u0006\t\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001ZV\u0007\f\u001b-g1\u0012D&M/\u000bA\u0001\nQa\u001a:pkB\f#Aa\u0011\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005\u0013\nQa\r\u00185]A\n1\"\u0011:sCfLen]3siB\u0011AHJ\n\u0006M\tE#Q\f\t\n\u0005'\u0012IF\u00192cYJl!A!\u0016\u000b\u0007\t]\u0003+A\u0004sk:$\u0018.\\3\n\t\tm#Q\u000b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003\u0002B0\u0005Kj!A!\u0019\u000b\t\t\r\u0014\u0011_\u0001\u0003S>L1A\u0018B1)\t\u0011i%\u0001\u0005u_N#(/\u001b8h)\t\tI/A\u0003baBd\u0017\u0010F\u0005s\u0005c\u0012\u0019H!\u001e\u0003x!)\u0001-\u000ba\u0001E\")a-\u000ba\u0001E\")\u0001.\u000ba\u0001E\")!.\u000ba\u0001Y\u00069QO\\1qa2LH\u0003\u0002B?\u0005\u000b\u0003RaTAT\u0005\u007f\u0002ra\u0014BAE\n\u0014G.C\u0002\u0003\u0004B\u0013a\u0001V;qY\u0016$\u0004\u0002\u0003BDU\u0005\u0005\t\u0019\u0001:\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u000eB!\u00111\u001eBH\u0013\u0011\u0011\t*!<\u0003\r=\u0013'.Z2u\u0001")
public class ArrayInsert
extends TernaryExpression
implements ImplicitCastInputTypes,
ComplexTypeMergingExpression,
QueryErrorsBase,
SupportQueryContext {
    private transient DataType elementType;
    private final Expression srcArrayExpr;
    private final Expression posExpr;
    private final Expression itemExpr;
    private final boolean legacyNegativeIndex;
    private Option<SQLQueryContext> queryContext;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(ArrayInsert x$0) {
        return ArrayInsert$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, ArrayInsert> tupled() {
        return ArrayInsert$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, ArrayInsert>>>> curried() {
        return ArrayInsert$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Expression srcArrayExpr() {
        return this.srcArrayExpr;
    }

    public Expression posExpr() {
        return this.posExpr;
    }

    public Expression itemExpr() {
        return this.itemExpr;
    }

    public boolean legacyNegativeIndex() {
        return this.legacyNegativeIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple3 tuple3 = new Tuple3((Object)this.srcArrayExpr().dataType(), (Object)this.posExpr().dataType(), (Object)this.itemExpr().dataType());
        if (tuple3 != null) {
            DataType dataType = (DataType)tuple3._1();
            DataType e2 = (DataType)tuple3._2();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        Seq seq;
                        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e3);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            DataType dt = (DataType)some.value();
                            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), IntegerType$.MODULE$, dt}));
                            return seq;
                        } else {
                            seq = (Seq)package$.MODULE$.Seq().empty();
                        }
                        return seq;
                    }
                }
            }
        }
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        return (Seq)package$.MODULE$.Seq().empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var1_7;
        Tuple3 tuple3 = new Tuple3((Object)this.first().dataType(), (Object)this.second().dataType(), (Object)this.third().dataType());
        if (tuple3 != null) {
            DataType e2 = (DataType)tuple3._2();
            if (tuple3._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType(IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.second())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType(this.second().dataType()))}))));
                    return var1_7;
                }
            }
        }
        if (tuple3 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType = (DataType)tuple3._1();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType && (e1 = (arrayType = (ArrayType)dataType).elementType()).sameType(e3)) {
                TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                return var1_7;
            }
        }
        TypeCheckResult.DataTypeMismatch dataTypeMismatch = new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType(ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType(this.first().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType(this.third().dataType()))}))));
        return var1_7;
    }

    @Override
    public Object eval(InternalRow input) {
        Object value2;
        Object value1 = this.first().eval(input);
        if (value1 != null && (value2 = this.second().eval(input)) != null) {
            Object value3 = this.third().eval(input);
            return this.nullSafeEval(value1, value2, value3);
        }
        return null;
    }

    @Override
    public Object nullSafeEval(Object arr, Object pos, Object item) {
        boolean newPosExtendsArrayLeft;
        IntRef posInt = IntRef.create((int)BoxesRunTime.unboxToInt((Object)pos));
        if (posInt.elem == 0) {
            throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
        }
        ArrayData baseArr = (ArrayData)arr;
        DataType arrayElementType = ((ArrayType)this.dataType()).elementType();
        boolean bl = newPosExtendsArrayLeft = posInt.elem < 0 && -posInt.elem > baseArr.numElements();
        if (newPosExtendsArrayLeft) {
            int baseOffset = this.legacyNegativeIndex() ? 1 : 0;
            int newArrayLength = -posInt.elem + baseOffset;
            if (newArrayLength > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
            }
            Object[] newArray = new Object[newArrayLength];
            baseArr.foreach(arrayElementType, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
                ArrayInsert.$anonfun$nullSafeEval$9(baseOffset, posInt, baseArr, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            newArray[0] = item;
            return new GenericArrayData(newArray);
        }
        if (posInt.elem < 0) {
            posInt.elem = posInt.elem + baseArr.numElements() + (this.legacyNegativeIndex() ? 0 : 1);
        } else if (posInt.elem > 0) {
            --posInt.elem;
        }
        int newArrayLength = scala.math.package$.MODULE$.max(baseArr.numElements() + 1, posInt.elem + 1);
        if (newArrayLength > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
        }
        Object[] newArray = new Object[newArrayLength];
        baseArr.foreach(arrayElementType, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
            ArrayInsert.$anonfun$nullSafeEval$10(posInt, newArray, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        newArray[posInt.elem] = item;
        return new GenericArrayData(newArray);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Function3 & Serializable f = (Function3 & Serializable)(arrExpr, posExpr, itemExpr) -> {
            ExprValue arr = arrExpr.value();
            ExprValue pos = posExpr.value();
            ExprValue item = itemExpr.value();
            int baseOffset = this.legacyNegativeIndex() ? 1 : 0;
            String itemInsertionIndex = ctx.freshName("itemInsertionIndex");
            String adjustedAllocIdx = ctx.freshName("adjustedAllocIdx");
            String resLength = ctx.freshName("resLength");
            String insertedItemIsNull = ctx.freshName("insertedItemIsNull");
            String i = ctx.freshName("i");
            String j = ctx.freshName("j");
            String values = ctx.freshName("values");
            String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), resLength, new StringBuilder(8).append(this.prettyName()).append(" failed.").toString());
            String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), ExprValue$.MODULE$.exprValueToString(arr), adjustedAllocIdx, i, ((ArrayType)this.first().dataType()).containsNull());
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1580).append("\n         |int ").append(itemInsertionIndex).append(" = 0;\n         |int ").append(resLength).append(" = 0;\n         |int ").append(adjustedAllocIdx).append(" = 0;\n         |boolean ").append(insertedItemIsNull).append(" = ").append(itemExpr.isNull()).append(";\n         |\n         |if (").append(pos).append(" == 0) {\n         |  throw QueryExecutionErrors.invalidIndexOfZeroError(").append(errorContext).append(");\n         |}\n         |\n         |if (").append(pos).append(" < 0 && (java.lang.Math.abs(").append(pos).append(") > ").append(arr).append(".numElements())) {\n         |\n         |  ").append(resLength).append(" = java.lang.Math.abs(").append(pos).append(") + ").append(baseOffset).append(";\n         |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n         |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n         |  }\n         |\n         |  ").append(allocation).append("\n         |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n         |    ").append(adjustedAllocIdx).append(" = ").append(i).append(" + ").append(baseOffset).append(" + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements());\n         |    ").append(assignment).append("\n         |  }\n         |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n         |\n         |  for (int ").append(j).append(" = ").append(this.legacyNegativeIndex() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1)).append(" + ").append(pos).append(" + ").append(arr).append(".numElements(); ").append(j).append(" < 0; ").append(j).append(" ++) {\n         |    ").append(values).append(".setNullAt(").append(j).append(" + ").append(baseOffset).append(" + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements()));\n         |  }\n         |\n         |  ").append(ev.value()).append(" = ").append(values).append(";\n         |} else {\n         |\n         |  ").append(itemInsertionIndex).append(" = 0;\n         |  if (").append(pos).append(" < 0) {\n         |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" + ").append(arr).append(".numElements() + ").append(this.legacyNegativeIndex() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1)).append(";\n         |  } else if (").append(pos).append(" > 0) {\n         |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" - 1;\n         |  }\n         |\n         |  ").append(resLength).append(" = java.lang.Math.max(").append(arr).append(".numElements() + 1, ").append(itemInsertionIndex).append(" + 1);\n         |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n         |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n         |  }\n         |\n         |  ").append(allocation).append("\n         |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n         |    ").append(adjustedAllocIdx).append(" = ").append(i).append(";\n         |    if (").append(i).append(" >= ").append(itemInsertionIndex).append(") {\n         |      ").append(adjustedAllocIdx).append(" = ").append(adjustedAllocIdx).append(" + 1;\n         |    }\n         |    ").append(assignment).append("\n         |  }\n         |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n         |\n         |  for (int ").append(j).append(" = ").append(arr).append(".numElements(); ").append(j).append(" < ").append(resLength).append(" - 1; ").append(j).append(" ++) {\n         |    ").append(values).append(".setNullAt(").append(j).append(");\n         |  }\n         |\n         |  ").append(ev.value()).append(" = ").append(values).append(";\n         |}\n      ").toString()));
        };
        ExprCode leftGen = this.first().genCode(ctx);
        ExprCode midGen = this.second().genCode(ctx);
        ExprCode rightGen = this.third().genCode(ctx);
        String resultCode = (String)f.apply((Object)leftGen, (Object)midGen, (Object)rightGen);
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)leftGen.code()), ctx.nullSafeExec(this.first().nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)midGen.code()), ctx.nullSafeExec(this.second().nullable(), ExprValue$.MODULE$.exprValueToString(midGen.isNull()), new StringBuilder(67).append("\n              ").append(rightGen.code()).append("\n              ").append(ev.isNull()).append(" = false;\n              ").append(resultCode).append("\n            ").toString()))));
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        } else {
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), midGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return exprCode;
    }

    @Override
    public Expression first() {
        return this.srcArrayExpr();
    }

    @Override
    public Expression second() {
        return this.posExpr();
    }

    @Override
    public Expression third() {
        return this.itemExpr();
    }

    @Override
    public String prettyName() {
        return "array_insert";
    }

    @Override
    public DataType dataType() {
        return this.first().dataType().asNullable();
    }

    @Override
    public boolean nullable() {
        return this.first().nullable() | this.second().nullable();
    }

    private DataType elementType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.srcArrayExpr().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public ArrayInsert withNewChildrenInternal(Expression newSrcArrayExpr, Expression newPosExpr, Expression newItemExpr) {
        return this.copy(newSrcArrayExpr, newPosExpr, newItemExpr, this.copy$default$4());
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        return new Some((Object)this.origin().context());
    }

    public ArrayInsert copy(Expression srcArrayExpr, Expression posExpr, Expression itemExpr, boolean legacyNegativeIndex) {
        return new ArrayInsert(srcArrayExpr, posExpr, itemExpr, legacyNegativeIndex);
    }

    public Expression copy$default$1() {
        return this.srcArrayExpr();
    }

    public Expression copy$default$2() {
        return this.posExpr();
    }

    public Expression copy$default$3() {
        return this.itemExpr();
    }

    public boolean copy$default$4() {
        return this.legacyNegativeIndex();
    }

    @Override
    public String productPrefix() {
        return "ArrayInsert";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.srcArrayExpr();
                break;
            }
            case 1: {
                object = this.posExpr();
                break;
            }
            case 2: {
                object = this.itemExpr();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.legacyNegativeIndex());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayInsert;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "srcArrayExpr";
                break;
            }
            case 1: {
                string = "posExpr";
                break;
            }
            case 2: {
                string = "itemExpr";
                break;
            }
            case 3: {
                string = "legacyNegativeIndex";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayInsert)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayInsert arrayInsert = (ArrayInsert)x$1;
        if (this.legacyNegativeIndex() != arrayInsert.legacyNegativeIndex()) return false;
        Expression expression = this.srcArrayExpr();
        Expression expression2 = arrayInsert.srcArrayExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.posExpr();
        Expression expression4 = arrayInsert.posExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.itemExpr();
        Expression expression6 = arrayInsert.itemExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!arrayInsert.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$9(int baseOffset$1, IntRef posInt$1, ArrayData baseArr$1, Object[] newArray$2, int i, Object v) {
        int elementPosition = i + baseOffset$1 + scala.math.package$.MODULE$.abs(posInt$1.elem + baseArr$1.numElements());
        newArray$2[elementPosition] = v;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$10(IntRef posInt$1, Object[] newArray$3, int i, Object v) {
        if (i >= posInt$1.elem) {
            newArray$3[i + 1] = v;
        } else {
            newArray$3[i] = v;
        }
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr, boolean legacyNegativeIndex) {
        this.srcArrayExpr = srcArrayExpr;
        this.posExpr = posExpr;
        this.itemExpr = itemExpr;
        this.legacyNegativeIndex = legacyNegativeIndex;
        ExpectsInputTypes.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
        QueryErrorsBase.$init$(this);
        SupportQueryContext.$init$(this);
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr) {
        this(srcArrayExpr, posExpr, itemExpr, SQLConf$.MODULE$.get().legacyNegativeIndexInArrayInsert());
    }
}

