/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedAggregateWithHashMapAsBuffer;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed!B\u000b\u0017\u0003\u0003)\u0003\"\u0002\u0018\u0001\t\u0003y\u0003bB\u0019\u0001\u0005\u00045\tA\r\u0005\bm\u0001\u0011\rQ\"\u00013\u0011\u001d9\u0004A1A\u0007\u0002IBq\u0001\u000f\u0001C\u0002\u001b\u0005\u0011\bC\u0003A\u0001\u0019E\u0011\b\u0003\u0005B\u0001!\u0015\r\u0011\"\u0003:\u0011!1\u0005\u0001#b\u0001\n#9\u0005\"B(\u0001\t\u0003J\u0004\u0002\u0003)\u0001\u0011\u000b\u0007I\u0011I)\t\u000ba\u0003A\u0011I-\t\u000b%\u0004A\u0011\t6\t\u000bE\u0004A\u0011\u0003:\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u0019\u0001\u0011%\u00111\u0007\u0005\b\u0003s\u0001A\u0011BA\u001e\u0011\u001d\t\t\u0005\u0001C\t\u0003\u0007Bq!!\u0016\u0001\t#\t9F\u0001\bQKJ\u001cWM\u001c;jY\u0016\u0014\u0015m]3\u000b\u0005]A\u0012!C1hOJ,w-\u0019;f\u0015\tI\"$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000e\u001d\u0003!\u0019\u0017\r^1msN$(BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011c\u0001\u0001'UA\u0011q\u0005K\u0007\u0002-%\u0011\u0011F\u0006\u0002\")f\u0004X\rZ!hOJ,w-\u0019;f/&$\b\u000eS1tQ6\u000b\u0007/Q:Ck\u001a4WM\u001d\t\u0003W1j\u0011\u0001G\u0005\u0003[a\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"a\n\u0001\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003M\u0002\"a\u000b\u001b\n\u0005UB\"AC#yaJ,7o]5p]\u0006!\u0002/\u001a:dK:$\u0018mZ3FqB\u0014Xm]:j_:\f1C\u001a:fcV,gnY=FqB\u0014Xm]:j_:\fqA]3wKJ\u001cX-F\u0001;!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002Z5tGJ,G/Z\u0001\u0016e\u0016$XO\u001d8QKJ\u001cWM\u001c;jY\u0016\f%O]1zQ\t91\t\u0005\u0002<\t&\u0011Q\t\u0010\u0002\niJ\fgn]5f]R\f1\u0002]3sG\u0016tG/Y4fgV\t\u0001\nE\u0002<\u0013.K!A\u0013\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005mb\u0015BA'=\u0005\u0019!u.\u001e2mK\"\u0012\u0001bQ\u0001\t]VdG.\u00192mK\u0006AA-\u0019;b)f\u0004X-F\u0001S!\t\u0019f+D\u0001U\u0015\t)F$A\u0003usB,7/\u0003\u0002X)\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0017\t\u00047\u000e4gB\u0001/b\u001d\ti\u0006-D\u0001_\u0015\tyF%\u0001\u0004=e>|GOP\u0005\u0002{%\u0011!\rP\u0001\ba\u0006\u001c7.Y4f\u0013\t!WMA\u0002TKFT!A\u0019\u001f\u0011\u0005M;\u0017B\u00015U\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001l!\taw.D\u0001n\u0015\tq'$\u0001\u0005b]\u0006d\u0017p]5t\u0013\t\u0001XNA\bUsB,7\t[3dWJ+7/\u001e7u\u00035!x\u000eR8vE2,g+\u00197vKR\u00111j\u001d\u0005\u0006i6\u0001\r!^\u0001\u0002IB\u00111H^\u0005\u0003or\u00121!\u00118z\u0003\u0019)\b\u000fZ1uKR)!0!\u0005\u0002\u0016A910!\u0001\u0002\u0006\u0005-Q\"\u0001?\u000b\u0005ut\u0018AC2pY2,7\r^5p]*\u0011qPH\u0001\u0005kRLG.C\u0002\u0002\u0004q\u00141b\u00149f]\"\u000b7\u000f['baB\u00191(a\u0002\n\u0007\u0005%AH\u0001\u0004B]f\u0014VM\u001a\t\u0004w\u00055\u0011bAA\by\t!Aj\u001c8h\u0011\u0019\t\u0019B\u0004a\u0001u\u00061!-\u001e4gKJDq!a\u0006\u000f\u0001\u0004\tI\"A\u0003j]B,H\u000f\u0005\u0003\u0002\u001c\u0005uQ\"\u0001\u000e\n\u0007\u0005}!DA\u0006J]R,'O\\1m%><\u0018!B7fe\u001e,G#\u0002>\u0002&\u0005\u001d\u0002BBA\n\u001f\u0001\u0007!\u0010\u0003\u0004\u0002*=\u0001\rA_\u0001\u0006_RDWM]\u0001\u0005KZ\fG\u000eF\u0002v\u0003_Aa!a\u0005\u0011\u0001\u0004Q\u0018AD4fiB+'oY3oi&dWm\u001d\u000b\u0005\u0003k\t9\u0004E\u0002\\G.Ca!a\u0005\u0012\u0001\u0004Q\u0018AD4f]\u0016\u0014\u0018\r^3PkR\u0004X\u000f\u001e\u000b\u0004k\u0006u\u0002bBA %\u0001\u0007\u0011QG\u0001\fa\u0016\u00148-\u001a8uS2,7/A\u0007hKR\u0004VM]2f]RLG.\u001a\u000b\u0006\u0017\u0006\u0015\u0013\u0011\u000b\u0005\b\u0003\u000f\u001a\u0002\u0019AA%\u0003E\t7mY;nk2\fG/\u001a3D_VtGo\u001d\t\u00057\u000e\fY\u0005E\u0004<\u0003\u001b\n)!a\u0003\n\u0007\u0005=CH\u0001\u0004UkBdWM\r\u0005\u0007\u0003'\u001a\u0002\u0019A&\u0002\u0015A,'oY3oi&dW-A\tcS:\f'/_*fCJ\u001c\u0007nQ8v]R$\"\"!\u0017\u0002`\u0005\u0015\u0014\u0011NA7!\rY\u00141L\u0005\u0004\u0003;b$aA%oi\"9\u0011\u0011\r\u000bA\u0002\u0005\r\u0014aC2pk:$8/\u0011:sCf\u0004BaO%\u0002\f!9\u0011q\r\u000bA\u0002\u0005e\u0013!B:uCJ$\bbBA6)\u0001\u0007\u0011\u0011L\u0001\u0004K:$\u0007bBA8)\u0001\u0007\u00111B\u0001\u0006m\u0006dW/\u001a")
public abstract class PercentileBase
extends TypedAggregateWithHashMapAsBuffer
implements ImplicitCastInputTypes {
    private transient boolean returnPercentileArray;
    private transient double[] percentages;
    private DataType dataType;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    @Override
    public abstract Expression child();

    public abstract Expression percentageExpression();

    public abstract Expression frequencyExpression();

    public abstract boolean reverse();

    public abstract boolean discrete();

    private boolean returnPercentileArray$lzycompute() {
        PercentileBase percentileBase = this;
        synchronized (percentileBase) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.returnPercentileArray = this.percentageExpression().dataType() instanceof ArrayType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        PercentileBase percentileBase = this;
        synchronized (percentileBase) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                double[] dArray;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    dArray = null;
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    dArray = new double[]{d};
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    dArray = arrayData.toDoubleArray();
                } else {
                    throw new MatchError(object);
                }
                this.percentages = dArray;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.percentages;
    }

    public double[] percentages() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private DataType dataType$lzycompute() {
        PercentileBase percentileBase = this;
        synchronized (percentileBase) {
            if (!this.bitmap$0) {
                void var3_4;
                DataType dataType = this.child().dataType();
                AtomicType atomicType = dataType instanceof YearMonthIntervalType ? YearMonthIntervalType$.MODULE$.apply() : (dataType instanceof DayTimeIntervalType ? DayTimeIntervalType$.MODULE$.apply() : DoubleType$.MODULE$);
                YearMonthIntervalType resultType = atomicType;
                this.dataType = this.returnPercentileArray() ? new ArrayType(resultType, false) : var3_4;
                this.bitmap$0 = true;
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return !this.bitmap$0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        DataType dataType = this.percentageExpression().dataType();
        DataType dataType2 = dataType instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
        DoubleType$ percentageExpType = dataType2;
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.NumericAndAnsiInterval(), percentageExpType, IntegralType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() ? new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"percentage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType(this.percentageExpression().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(this.percentageExpression()))})))) : (this.percentages() == null ? new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"percentage")})))) : (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.doubleArrayOps(this.percentages()), (Function1)(JFunction1.mcZD.sp & Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"percentage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)"[0.0, 1.0]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.percentages()), (Function1 & Serializable)x$1 -> Cast$.MODULE$.toSQLValue(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$1)), DoubleType$.MODULE$), ClassTag$.MODULE$.apply(String.class))).mkString(","))})))) : TypeCheckResult$TypeCheckSuccess$.MODULE$)));
    }

    public double toDoubleValue(Object d) {
        double d2;
        Object object = d;
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            d2 = decimal.toDouble();
        } else if (object instanceof Number) {
            Number number = (Number)object;
            d2 = number.doubleValue();
        } else {
            throw new MatchError(object);
        }
        return d2;
    }

    @Override
    public OpenHashMap<Object, Object> update(OpenHashMap<Object, Object> buffer, InternalRow input) {
        Object object;
        Object key = this.child().eval(input);
        Object frqValue = this.frequencyExpression().eval(input);
        if (key != null && frqValue != null) {
            long frqLong = ((Number)frqValue).longValue();
            if (frqLong > 0L) {
                object = BoxesRunTime.boxToLong((long)buffer.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable)() -> frqLong, (Function1)(JFunction1.mcJJ.sp & Serializable)x$2 -> x$2 + frqLong));
            } else {
                if (frqLong < 0L) {
                    throw QueryExecutionErrors$.MODULE$.negativeValueUnexpectedError(this.frequencyExpression());
                }
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return buffer;
    }

    @Override
    public OpenHashMap<Object, Object> merge(OpenHashMap<Object, Object> buffer, OpenHashMap<Object, Object> other) {
        other.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToLong((long)PercentileBase.$anonfun$merge$1(buffer, x0$1)));
        return buffer;
    }

    @Override
    public Object eval(OpenHashMap<Object, Object> buffer) {
        return this.generateOutput(this.getPercentiles(buffer));
    }

    private scala.collection.immutable.Seq<Object> getPercentiles(OpenHashMap<Object, Object> buffer) {
        Object object;
        if (buffer.isEmpty()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        DataType dataType = this.child().dataType();
        if (dataType instanceof NumericType) {
            NumericType numericType = (NumericType)dataType;
            object = numericType.ordering();
        } else if (dataType instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
            object = yearMonthIntervalType.ordering();
        } else if (dataType instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
            object = dayTimeIntervalType.ordering();
        } else {
            object = QueryExecutionErrors$.MODULE$.unsupportedTypeError(dataType);
        }
        Ordering<Object> ordering = object;
        scala.collection.immutable.Seq sortedCounts = this.reverse() ? (scala.collection.immutable.Seq)buffer.toSeq().sortBy((Function1 & Serializable)x$4 -> x$4._1(), ordering.reverse()) : (scala.collection.immutable.Seq)buffer.toSeq().sortBy((Function1 & Serializable)x$5 -> x$5._1(), ordering);
        scala.collection.immutable.Seq accumulatedCounts = (scala.collection.immutable.Seq)((IterableOps)sortedCounts.scanLeft((Object)new Tuple2(((Tuple2)sortedCounts.head())._1(), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable)(x0$1, x1$1) -> {
            long count1;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    count1 = tuple23._2$mcJ$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Object key2 = tuple2._1();
            long count2 = tuple2._2$mcJ$sp();
            Tuple2 tuple24 = new Tuple2(key2, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
            return tuple24;
        })).tail();
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.percentages()), (Function1)(JFunction1.mcDD.sp & Serializable)x$6 -> this.getPercentile((scala.collection.immutable.Seq<Tuple2<Object, Object>>)accumulatedCounts, x$6), (ClassTag)ClassTag$.MODULE$.Double()));
    }

    private Object generateOutput(scala.collection.immutable.Seq<Object> percentiles) {
        DataType dataType = this.child().dataType();
        scala.collection.immutable.Seq seq = dataType instanceof YearMonthIntervalType ? (scala.collection.immutable.Seq)percentiles.map((Function1)(JFunction1.mcID.sp & Serializable)x$7 -> (int)x$7) : (dataType instanceof DayTimeIntervalType ? (scala.collection.immutable.Seq)percentiles.map((Function1)(JFunction1.mcJD.sp & Serializable)x$8 -> (long)x$8) : percentiles);
        scala.collection.immutable.Seq results = seq;
        return percentiles.isEmpty() ? null : (this.returnPercentileArray() ? new GenericArrayData((Seq<Object>)results) : results.head());
    }

    public double getPercentile(scala.collection.immutable.Seq<Tuple2<Object, Object>> accumulatedCounts, double percentile) {
        double position = (double)(((Tuple2)accumulatedCounts.last())._2$mcJ$sp() - 1L) * percentile;
        long lower = (long)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(position));
        long higher = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(position));
        long[] countsArray = (long[])((IterableOnceOps)accumulatedCounts.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9._2$mcJ$sp()))).toArray((ClassTag)ClassTag$.MODULE$.Long());
        int lowerIndex = this.binarySearchCount(countsArray, 0, accumulatedCounts.size(), lower + 1L);
        int higherIndex = this.binarySearchCount(countsArray, 0, accumulatedCounts.size(), higher + 1L);
        Object lowerKey = ((Tuple2)accumulatedCounts.apply(lowerIndex))._1();
        if (higher == lower) {
            return this.toDoubleValue(lowerKey);
        }
        Object higherKey = ((Tuple2)accumulatedCounts.apply(higherIndex))._1();
        if (BoxesRunTime.equals((Object)higherKey, (Object)lowerKey)) {
            return this.toDoubleValue(lowerKey);
        }
        return this.discrete() ? this.toDoubleValue(lowerKey) : ((double)higher - position) * this.toDoubleValue(lowerKey) + (position - (double)lower) * this.toDoubleValue(higherKey);
    }

    public int binarySearchCount(long[] countsArray, int start, int end, long value) {
        int n = Arrays.binarySearch(countsArray, 0, end, value);
        switch (n) {
            default: 
        }
        return n < 0 ? -(n + 1) : n;
    }

    public static final /* synthetic */ long $anonfun$merge$1(OpenHashMap buffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        long l = buffer$1.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable)() -> count, (Function1)(JFunction1.mcJJ.sp & Serializable)x$3 -> x$3 + count);
        return l;
    }

    public PercentileBase() {
        ExpectsInputTypes.$init$(this);
    }
}

