/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NonNullLiteral$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.optimizer.UnwrapCastInBinaryComparison$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class UnwrapCastInBinaryComparison$
extends Rule<LogicalPlan> {
    public static final UnwrapCastInBinaryComparison$ MODULE$ = new UnwrapCastInBinaryComparison$();

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return (LogicalPlan)plan2.transformWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.containsAnyPattern((Seq<Enumeration.Value>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.BINARY_COMPARISON(), TreePattern$.MODULE$.IN(), TreePattern$.MODULE$.INSET()}))), this.ruleId(), new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    object = A12.transformExpressionsUpWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.2.$anonfun$applyOrElse$1(x$2)), UnwrapCastInBinaryComparison$.MODULE$.ruleId(), (PartialFunction<Expression, Expression>)new Serializable(null){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            BinaryComparison binaryComparison;
                            Option<Tuple2<Expression, Expression>> option;
                            A1 A1 = x1;
                            boolean bl = A1 instanceof BinaryComparison && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison = (BinaryComparison)A1)).isEmpty() ? true : (A1 instanceof In ? true : A1 instanceof InSet);
                            Object object = bl ? UnwrapCastInBinaryComparison$.MODULE$.org$apache$spark$sql$catalyst$optimizer$UnwrapCastInBinaryComparison$$unwrapCast(A1) : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            BinaryComparison binaryComparison;
                            Option<Tuple2<Expression, Expression>> option;
                            Expression expression = x1;
                            boolean bl = expression instanceof BinaryComparison && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty() ? true : (expression instanceof In ? true : expression instanceof InSet);
                            boolean bl2 = bl;
                            return bl2;
                        }
                    });
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan != null;
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(TreePatternBits x$2) {
                return x$2.containsAnyPattern((Seq<Enumeration.Value>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.BINARY_COMPARISON(), TreePattern$.MODULE$.IN(), TreePattern$.MODULE$.INSET()}));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.trees.TreePatternBits )}, serializedLambda);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression org$apache$spark$sql$catalyst$optimizer$UnwrapCastInBinaryComparison$$unwrapCast(Expression exp) {
        Option<Tuple2<Expression, Expression>> option;
        boolean bl = false;
        BinaryComparison binaryComparison = null;
        Expression expression = exp;
        if (expression instanceof BinaryComparison) {
            bl = true;
            binaryComparison = (BinaryComparison)expression;
            Option<Tuple2<Expression, Expression>> option2 = BinaryComparison$.MODULE$.unapply(binaryComparison);
            if (!option2.isEmpty()) {
                Expression expression2 = (Expression)((Tuple2)option2.get())._1();
                Expression expression3 = (Expression)((Tuple2)option2.get())._2();
                if (expression2 instanceof Literal) {
                    DataType toType;
                    Cast cast;
                    Expression fromExp;
                    Literal literal = (Literal)expression2;
                    DataType literalType = literal.dataType();
                    if (expression3 instanceof Cast && this.canImplicitlyCast(fromExp = (cast = (Cast)expression3).child(), toType = cast.dataType(), literalType)) {
                        return UnwrapCastInBinaryComparison$.swap$1(this.org$apache$spark$sql$catalyst$optimizer$UnwrapCastInBinaryComparison$$unwrapCast(UnwrapCastInBinaryComparison$.swap$1(exp)));
                    }
                }
            }
        }
        if (bl && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression expression4 = (Expression)((Tuple2)option.get())._1();
            Expression expression5 = (Expression)((Tuple2)option.get())._2();
            if (expression4 instanceof Cast) {
                Cast cast = (Cast)expression4;
                Expression fromExp = cast.child();
                DataType toType = cast.dataType();
                if (toType instanceof NumericType) {
                    NumericType numericType = (NumericType)toType;
                    if (expression5 instanceof Literal) {
                        Literal literal = (Literal)expression5;
                        Object value = literal.value();
                        DataType literalType = literal.dataType();
                        if (this.canImplicitlyCast(fromExp, numericType, literalType)) {
                            return this.simplifyNumericComparison(binaryComparison, fromExp, numericType, value);
                        }
                    }
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression expression6 = in.value();
            Seq<Expression> list = in.list();
            if (expression6 instanceof Cast) {
                Cast cast = (Cast)expression6;
                Expression fromExp = cast.child();
                DataType toType = cast.dataType();
                if (toType instanceof NumericType) {
                    Expression firstLit;
                    SeqOps seqOps;
                    NumericType numericType = (NumericType)toType;
                    if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) >= 0 && this.canImplicitlyCast(fromExp, numericType, (firstLit = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)).dataType()) && in.inSetConvertible()) {
                        Function2 & Serializable buildIn = (Function2 & Serializable)(nullList, canCastList) -> {
                            ArrayBuffer newList = (ArrayBuffer)((IterableOps)nullList.map((Function1 & Serializable)lit -> new Cast((Expression)lit, fromExp.dataType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()))).$plus$plus((IterableOnce)canCastList);
                            return new In(fromExp, (Seq<Expression>)newList.toSeq());
                        };
                        return (Expression)this.simplifyIn(fromExp, numericType, list, buildIn).getOrElse((Function0 & Serializable)() -> exp);
                    }
                }
            }
        }
        if (!(expression instanceof InSet)) return exp;
        InSet inSet = (InSet)expression;
        Expression expression7 = inSet.child();
        Set<Object> hset = inSet.hset();
        if (!(expression7 instanceof Cast)) return exp;
        Cast cast = (Cast)expression7;
        Expression fromExp = cast.child();
        DataType toType = cast.dataType();
        if (!(toType instanceof NumericType)) return exp;
        NumericType numericType = (NumericType)toType;
        if (!hset.nonEmpty()) return exp;
        if (!this.canImplicitlyCast(fromExp, numericType, numericType)) return exp;
        Function2 & Serializable buildInSet = (Function2 & Serializable)(nullList, canCastList) -> new InSet(fromExp, (Set<Object>)((IterableOnceOps)((StrictOptimizedIterableOps)nullList.$plus$plus((IterableOnce)canCastList)).map((Function1 & Serializable)x$3 -> x$3.value())).toSet());
        return (Expression)this.simplifyIn(fromExp, numericType, (Seq<Expression>)((IterableOnceOps)hset.map((Function1 & Serializable)v -> Literal$.MODULE$.create(v, numericType))).toSeq(), buildInSet).getOrElse((Function0 & Serializable)() -> exp);
    }

    private Expression simplifyNumericComparison(BinaryComparison exp, Expression fromExp, NumericType toType, Object value) {
        Expression expression;
        InternalRow x$3;
        Cast qual$3;
        Object newValue;
        DataType fromType = fromExp.dataType();
        Ordering<Object> ordering = toType.ordering();
        Option<Tuple2<Object, Object>> range = this.getRange(fromType);
        if (range.isDefined()) {
            Tuple2 tuple2 = (Tuple2)range.get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object min = tuple2._1();
            Object max = tuple2._2();
            Tuple2 tuple22 = new Tuple2(min, max);
            Tuple2 tuple23 = tuple22;
            Object min2 = tuple23._1();
            Object max2 = tuple23._2();
            Cast qual$1 = new Cast(Literal$.MODULE$.apply(min2), toType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            Cast qual$2 = new Cast(Literal$.MODULE$.apply(max2), toType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            InternalRow x$2 = qual$2.eval$default$1();
            Tuple2 tuple24 = new Tuple2(qual$1.eval(x$1), qual$2.eval(x$2));
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Object minInToType = tuple24._1();
            Object maxInToType = tuple24._2();
            Tuple2 tuple25 = new Tuple2(minInToType, maxInToType);
            Tuple2 tuple26 = tuple25;
            Object minInToType2 = tuple26._1();
            Object maxInToType2 = tuple26._2();
            int minCmp = ordering.compare(value, minInToType2);
            int maxCmp = ordering.compare(value, maxInToType2);
            if (maxCmp >= 0 || minCmp <= 0) {
                Expression expression2;
                if (maxCmp > 0) {
                    Expression expression3;
                    BinaryComparison binaryComparison = exp;
                    boolean bl = binaryComparison instanceof EqualTo ? true : (binaryComparison instanceof GreaterThan ? true : binaryComparison instanceof GreaterThanOrEqual);
                    if (bl) {
                        expression3 = this.falseIfNotNull(fromExp);
                    } else {
                        boolean bl2 = binaryComparison instanceof LessThan ? true : binaryComparison instanceof LessThanOrEqual;
                        expression3 = bl2 ? this.trueIfNotNull(fromExp) : (binaryComparison instanceof EqualNullSafe && exp.deterministic() ? Literal$.MODULE$.FalseLiteral() : exp);
                    }
                    expression2 = expression3;
                } else if (maxCmp == 0) {
                    Expression expression4;
                    BinaryComparison binaryComparison = exp;
                    if (binaryComparison instanceof GreaterThan) {
                        expression4 = this.falseIfNotNull(fromExp);
                    } else if (binaryComparison instanceof LessThanOrEqual) {
                        expression4 = this.trueIfNotNull(fromExp);
                    } else if (binaryComparison instanceof LessThan) {
                        expression4 = new Not(new EqualTo(fromExp, new Literal(max2, fromType)));
                    } else {
                        boolean bl = binaryComparison instanceof GreaterThanOrEqual ? true : binaryComparison instanceof EqualTo;
                        expression4 = bl ? new EqualTo(fromExp, new Literal(max2, fromType)) : (binaryComparison instanceof EqualNullSafe ? new EqualNullSafe(fromExp, new Literal(max2, fromType)) : exp);
                    }
                    expression2 = expression4;
                } else if (minCmp < 0) {
                    Expression expression5;
                    BinaryComparison binaryComparison = exp;
                    boolean bl = binaryComparison instanceof GreaterThan ? true : binaryComparison instanceof GreaterThanOrEqual;
                    if (bl) {
                        expression5 = this.trueIfNotNull(fromExp);
                    } else {
                        boolean bl3 = binaryComparison instanceof LessThan ? true : (binaryComparison instanceof LessThanOrEqual ? true : binaryComparison instanceof EqualTo);
                        expression5 = bl3 ? this.falseIfNotNull(fromExp) : (binaryComparison instanceof EqualNullSafe && exp.deterministic() ? Literal$.MODULE$.FalseLiteral() : exp);
                    }
                    expression2 = expression5;
                } else {
                    Expression expression6;
                    BinaryComparison binaryComparison = exp;
                    if (binaryComparison instanceof LessThan) {
                        expression6 = this.falseIfNotNull(fromExp);
                    } else if (binaryComparison instanceof GreaterThanOrEqual) {
                        expression6 = this.trueIfNotNull(fromExp);
                    } else if (binaryComparison instanceof GreaterThan) {
                        expression6 = new Not(new EqualTo(fromExp, new Literal(min2, fromType)));
                    } else {
                        boolean bl = binaryComparison instanceof LessThanOrEqual ? true : binaryComparison instanceof EqualTo;
                        expression6 = bl ? new EqualTo(fromExp, new Literal(min2, fromType)) : (binaryComparison instanceof EqualNullSafe ? new EqualNullSafe(fromExp, new Literal(min2, fromType)) : exp);
                    }
                    expression2 = expression6;
                }
                return expression2;
            }
        }
        if ((newValue = (qual$3 = Cast$.MODULE$.apply(Literal$.MODULE$.apply(value), fromType, false)).eval(x$3 = qual$3.eval$default$1())) == null) {
            return exp;
        }
        Cast qual$4 = new Cast(new Literal(newValue, fromType), toType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        InternalRow x$4 = qual$4.eval$default$1();
        Object valueRoundTrip = qual$4.eval(x$4);
        Literal lit = new Literal(newValue, fromType);
        int cmp = ordering.compare(value, valueRoundTrip);
        if (cmp == 0) {
            BinaryComparison binaryComparison = exp;
            BinaryComparison binaryComparison2 = binaryComparison instanceof GreaterThan ? new GreaterThan(fromExp, lit) : (binaryComparison instanceof GreaterThanOrEqual ? new GreaterThanOrEqual(fromExp, lit) : (binaryComparison instanceof EqualTo ? new EqualTo(fromExp, lit) : (binaryComparison instanceof EqualNullSafe ? new EqualNullSafe(fromExp, lit) : (binaryComparison instanceof LessThan ? new LessThan(fromExp, lit) : (binaryComparison instanceof LessThanOrEqual ? new LessThanOrEqual(fromExp, lit) : exp)))));
            expression = binaryComparison2;
        } else if (cmp < 0) {
            Expression expression7;
            BinaryComparison binaryComparison = exp;
            if (binaryComparison instanceof EqualTo) {
                expression7 = this.falseIfNotNull(fromExp);
            } else if (binaryComparison instanceof EqualNullSafe && fromExp.deterministic()) {
                expression7 = Literal$.MODULE$.FalseLiteral();
            } else {
                boolean bl = binaryComparison instanceof GreaterThan ? true : binaryComparison instanceof GreaterThanOrEqual;
                if (bl) {
                    expression7 = new GreaterThanOrEqual(fromExp, lit);
                } else {
                    boolean bl4 = binaryComparison instanceof LessThan ? true : binaryComparison instanceof LessThanOrEqual;
                    expression7 = bl4 ? new LessThan(fromExp, lit) : exp;
                }
            }
            expression = expression7;
        } else {
            Expression expression8;
            BinaryComparison binaryComparison = exp;
            if (binaryComparison instanceof EqualTo) {
                expression8 = this.falseIfNotNull(fromExp);
            } else if (binaryComparison instanceof EqualNullSafe) {
                expression8 = Literal$.MODULE$.FalseLiteral();
            } else {
                boolean bl = binaryComparison instanceof GreaterThan ? true : binaryComparison instanceof GreaterThanOrEqual;
                if (bl) {
                    expression8 = new GreaterThan(fromExp, lit);
                } else {
                    boolean bl5 = binaryComparison instanceof LessThan ? true : binaryComparison instanceof LessThanOrEqual;
                    expression8 = bl5 ? new LessThanOrEqual(fromExp, lit) : exp;
                }
            }
            expression = expression8;
        }
        return expression;
    }

    private <IN extends Expression> Option<Expression> simplifyIn(Expression fromExp, NumericType toType, Seq<Expression> list, Function2<ArrayBuffer<Literal>, ArrayBuffer<Literal>, IN> buildExpr) {
        Option option;
        Tuple2 tuple2 = new Tuple2(ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ArrayBuffer nullList = (ArrayBuffer)tuple2._1();
        ArrayBuffer canCastList = (ArrayBuffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nullList, (Object)canCastList);
        Tuple2 tuple23 = tuple22;
        ArrayBuffer nullList2 = (ArrayBuffer)tuple23._1();
        ArrayBuffer canCastList2 = (ArrayBuffer)tuple23._2();
        DataType fromType = fromExp.dataType();
        Ordering<Object> ordering = toType.ordering();
        list.foreach((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Literal literal = null;
            Expression expression = x0$1;
            if (expression instanceof Literal) {
                bl = true;
                literal = (Literal)expression;
                Object object = literal.value();
                if (object == null) {
                    return nullList2.$plus$eq((Object)literal);
                }
            }
            if (!bl) throw new MatchError((Object)expression);
            Option<Tuple2<Object, DataType>> option = NonNullLiteral$.MODULE$.unapply(literal);
            if (option.isEmpty()) throw new MatchError((Object)expression);
            Object value = ((Tuple2)option.get())._1();
            Cast qual$1 = Cast$.MODULE$.apply(Literal$.MODULE$.apply(value), fromType, false);
            InternalRow x$1 = qual$1.eval$default$1();
            Object newValue = qual$1.eval(x$1);
            Cast qual$2 = new Cast(new Literal(newValue, fromType), toType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            InternalRow x$2 = qual$2.eval$default$1();
            Object valueRoundTrip = qual$2.eval(x$2);
            return newValue != null && ordering.compare(value, valueRoundTrip) == 0 ? canCastList2.$plus$eq((Object)new Literal(newValue, fromType)) : BoxedUnit.UNIT;
        });
        if (nullList2.isEmpty() && canCastList2.isEmpty()) {
            option = Option$.MODULE$.apply((Object)this.falseIfNotNull(fromExp));
        } else {
            Expression unwrapExpr = (Expression)buildExpr.apply((Object)nullList2, (Object)canCastList2);
            option = Option$.MODULE$.apply((Object)unwrapExpr);
        }
        return option;
    }

    private boolean canImplicitlyCast(Expression fromExp, DataType toType, DataType literalType) {
        return toType.sameType(literalType) && !fromExp.foldable() && toType instanceof NumericType && this.canUnwrapCast(fromExp.dataType(), toType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canUnwrapCast(DataType from, DataType to) {
        DataType dataType;
        Tuple2 tuple2 = new Tuple2((Object)from, (Object)to);
        if (tuple2 != null && BooleanType$.MODULE$.equals(dataType = (DataType)tuple2._1())) {
            return true;
        }
        if (tuple2 != null) {
            DataType dataType2 = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType2) && FloatType$.MODULE$.equals(dataType3)) {
                return false;
            }
        }
        if (tuple2 != null) {
            DataType dataType4 = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (LongType$.MODULE$.equals(dataType4) && FloatType$.MODULE$.equals(dataType5)) {
                return false;
            }
        }
        if (tuple2 != null) {
            DataType dataType6 = (DataType)tuple2._1();
            DataType dataType7 = (DataType)tuple2._2();
            if (LongType$.MODULE$.equals(dataType6) && DoubleType$.MODULE$.equals(dataType7)) {
                return false;
            }
        }
        if (!(from instanceof NumericType)) return false;
        return Cast$.MODULE$.canUpCast(from, to);
    }

    public Option<Tuple2<Object, Object>> getRange(DataType dt) {
        DataType dataType = dt;
        Object object = BooleanType$.MODULE$.equals(dataType) ? new Some((Object)new Tuple2.mcZZ.sp(false, true)) : (ByteType$.MODULE$.equals(dataType) ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)-128), (Object)BoxesRunTime.boxToByte((byte)127))) : (ShortType$.MODULE$.equals(dataType) ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)Short.MIN_VALUE), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE))) : (IntegerType$.MODULE$.equals(dataType) ? new Some((Object)new Tuple2.mcII.sp(Integer.MIN_VALUE, Integer.MAX_VALUE)) : (LongType$.MODULE$.equals(dataType) ? new Some((Object)new Tuple2.mcJJ.sp(Long.MIN_VALUE, Long.MAX_VALUE)) : (FloatType$.MODULE$.equals(dataType) ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY), (Object)BoxesRunTime.boxToFloat((float)Float.NaN))) : (DoubleType$.MODULE$.equals(dataType) ? new Some((Object)new Tuple2.mcDD.sp(Double.NEGATIVE_INFINITY, Double.NaN)) : None$.MODULE$))))));
        return object;
    }

    public Expression falseIfNotNull(Expression e) {
        return new And(new IsNull(e), new Literal(null, BooleanType$.MODULE$));
    }

    public Expression trueIfNotNull(Expression e) {
        return new Or(new IsNotNull(e), new Literal(null, BooleanType$.MODULE$));
    }

    private static final Expression swap$1(Expression e) {
        Expression expression;
        Expression expression2 = e;
        if (expression2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)expression2;
            Expression left = greaterThan.left();
            Expression right = greaterThan.right();
            expression = new LessThan(right, left);
        } else if (expression2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression2;
            Expression left = greaterThanOrEqual.left();
            Expression right = greaterThanOrEqual.right();
            expression = new LessThanOrEqual(right, left);
        } else if (expression2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression2;
            Expression left = equalTo.left();
            Expression right = equalTo.right();
            expression = new EqualTo(right, left);
        } else if (expression2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)expression2;
            Expression left = equalNullSafe.left();
            Expression right = equalNullSafe.right();
            expression = new EqualNullSafe(right, left);
        } else if (expression2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression2;
            Expression left = lessThanOrEqual.left();
            Expression right = lessThanOrEqual.right();
            expression = new GreaterThanOrEqual(right, left);
        } else if (expression2 instanceof LessThan) {
            LessThan lessThan = (LessThan)expression2;
            Expression left = lessThan.left();
            Expression right = lessThan.right();
            expression = new GreaterThan(right, left);
        } else {
            expression = e;
        }
        return expression;
    }

    private UnwrapCastInBinaryComparison$() {
    }
}

