/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeWriteCompatibilityBaseSuite;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DatetimeType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.source.Position;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005}2AAB\u0004\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C)7!)Q\u0006\u0001C!]!9\u0011\b\u0001b\u0001\n\u0013Q\u0004B\u0002 \u0001A\u0003%1HA\u0012B\u001dNKE)\u0019;b)f\u0004Xm\u0016:ji\u0016\u001cu.\u001c9bi&\u0014\u0017\u000e\\5usN+\u0018\u000e^3\u000b\u0005!I\u0011!\u0002;za\u0016\u001c(B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011C\u0001\u0001\u0014!\t!R#D\u0001\b\u0013\t1rAA\u0012ECR\fG+\u001f9f/JLG/Z\"p[B\fG/\u001b2jY&$\u0018PQ1tKN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000b\u0001\u0003U\u0019Ho\u001c:f\u0003N\u001c\u0018n\u001a8nK:$\bk\u001c7jGf,\u0012\u0001\b\t\u0003;\u001dr!A\b\u0013\u000f\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005J\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005\r\u0002\u0013aB*R\u0019\u000e{gNZ\u0005\u0003K\u0019\nQc\u0015;pe\u0016\f5o]5h]6,g\u000e\u001e)pY&\u001c\u0017P\u0003\u0002$A%\u0011\u0001&\u000b\u0002\u0006-\u0006dW/Z\u0005\u0003U-\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]*\tA&A\u0003tG\u0006d\u0017-A\u0004dC:\u001c\u0015m\u001d;\u0016\u0003=\u0002R\u0001M\u00194gYj\u0011aK\u0005\u0003e-\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0005Q!\u0014BA\u001b\b\u0005!!\u0015\r^1UsB,\u0007C\u0001\u00198\u0013\tA4FA\u0004C_>dW-\u00198\u0002\u0019M$(/\u001b8h!>Lg\u000e\u001e\u001a\u0016\u0003m\u0002\"\u0001\u0006\u001f\n\u0005u:!AC*ueV\u001cG\u000fV=qK\u0006i1\u000f\u001e:j]\u001e\u0004v.\u001b8ue\u0001\u0002")
public class ANSIDataTypeWriteCompatibilitySuite
extends DataTypeWriteCompatibilityBaseSuite {
    private final StructType stringPoint2;

    @Override
    public Enumeration.Value storeAssignmentPolicy() {
        return SQLConf.StoreAssignmentPolicy$.MODULE$.ANSI();
    }

    @Override
    public Function2<DataType, DataType, Object> canCast() {
        return (Function2 & Serializable)(from, to) -> BoxesRunTime.boxToBoolean((boolean)Cast$.MODULE$.canANSIStoreAssign(from, to));
    }

    private StructType stringPoint2() {
        return this.stringPoint2;
    }

    public ANSIDataTypeWriteCompatibilitySuite() {
        this.test("Check map value types: unsafe casts are not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MapType mapOfString = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$);
            MapType mapOfInt = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
            ArrayBuffer errs = new ArrayBuffer();
            AnalysisException x$1 = (AnalysisException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> DataTypeUtils$.MODULE$.canWrite("", (DataType)mapOfString, (DataType)mapOfInt, true, package$.MODULE$.caseSensitiveResolution(), "m", this.storeAssignmentPolicy(), (Function1 & Serializable)errMsg -> {
                errs.$plus$eq((Object)errMsg);
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            String x$2 = "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"``"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`m`.`value`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"STRING\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"INT\"")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST", x$4, x$3, x$5, x$6);
        }, new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.stringPoint2 = StructType$.MODULE$.apply((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("x", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
        this.test("Check struct types: unsafe casts are not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ArrayBuffer errs = new ArrayBuffer();
            AnalysisException x$7 = (AnalysisException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> DataTypeUtils$.MODULE$.canWrite("", (DataType)this.stringPoint2(), (DataType)this.point2(), true, package$.MODULE$.caseSensitiveResolution(), "t", this.storeAssignmentPolicy(), (Function1 & Serializable)errMsg -> {
                errs.$plus$eq((Object)errMsg);
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            String x$8 = "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"``"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`t`.`x`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"STRING\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"FLOAT\"")}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            QueryContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST", x$10, x$9, x$11, x$12);
        }, new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("Check array types: unsafe casts are not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ArrayType arrayOfString = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
            ArrayType arrayOfInt = ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$);
            ArrayBuffer errs = new ArrayBuffer();
            AnalysisException x$13 = (AnalysisException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> DataTypeUtils$.MODULE$.canWrite("", (DataType)arrayOfString, (DataType)arrayOfInt, true, package$.MODULE$.caseSensitiveResolution(), "arr", this.storeAssignmentPolicy(), (Function1 & Serializable)errMsg -> {
                errs.$plus$eq((Object)errMsg);
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            String x$14 = "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"``"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`arr`.`element`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"STRING\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"INT\"")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            QueryContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST", x$16, x$15, x$17, x$18);
        }, new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("Check map key types: unsafe casts are not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MapType mapKeyString = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$);
            MapType mapKeyInt = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$);
            ArrayBuffer errs = new ArrayBuffer();
            AnalysisException x$19 = (AnalysisException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> DataTypeUtils$.MODULE$.canWrite("", (DataType)mapKeyString, (DataType)mapKeyInt, true, package$.MODULE$.caseSensitiveResolution(), "arr", this.storeAssignmentPolicy(), (Function1 & Serializable)errMsg -> {
                errs.$plus$eq((Object)errMsg);
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            String x$20 = "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"``"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`arr`.`key`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"STRING\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"INT\"")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            QueryContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST", x$22, x$21, x$23, x$24);
        }, new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("Conversions between timestamp and long are not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ArrayBuffer errs = new ArrayBuffer();
            AnalysisException x$25 = (AnalysisException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> DataTypeUtils$.MODULE$.canWrite("", (DataType)LongType$.MODULE$, (DataType)TimestampType$.MODULE$, true, package$.MODULE$.caseSensitiveResolution(), "longToTimestamp", this.storeAssignmentPolicy(), (Function1 & Serializable)errMsg -> {
                errs.$plus$eq((Object)errMsg);
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            String x$26 = "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"``"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`longToTimestamp`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BIGINT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"TIMESTAMP\"")}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            QueryContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST", x$28, x$27, x$29, x$30);
            AnalysisException x$31 = (AnalysisException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> DataTypeUtils$.MODULE$.canWrite("", (DataType)TimestampType$.MODULE$, (DataType)LongType$.MODULE$, true, package$.MODULE$.caseSensitiveResolution(), "timestampToLong", this.storeAssignmentPolicy(), (Function1 & Serializable)errMsg -> {
                errs.$plus$eq((Object)errMsg);
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            String x$32 = "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)"``"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`timestampToLong`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"TIMESTAMP\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"BIGINT\"")}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            QueryContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, "INCOMPATIBLE_DATA_FOR_TABLE.CANNOT_SAFELY_CAST", x$34, x$33, x$35, x$36);
        }, new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        this.test("SPARK-37707: Check datetime types compatible with each other", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq dateTimeTypes = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DatetimeType[]{DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$}));
            dateTimeTypes.foreach((Function1 & Serializable)t1 -> {
                dateTimeTypes.foreach((Function1 & Serializable)t2 -> {
                    $this.assertAllowed((DataType)t1, (DataType)t2, "date time types", new StringBuilder(30).append("Should allow writing ").append(t1).append(" to type ").append(t2).toString(), $this.assertAllowed$default$5());
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        this.test("Check NullType is compatible with all other types", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.allNonNullTypes().foreach((Function1 & Serializable)t -> {
            this.assertAllowed((DataType)NullType$.MODULE$, t, "nulls", new StringBuilder(34).append("Should allow writing None to type ").append(t).toString(), this.assertAllowed$default$5());
            return BoxedUnit.UNIT;
        }), new Position("DataTypeWriteCompatibilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
    }
}

